<?php

namespace App\Listeners;

use App\Events\VoucherPayment;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Mailers\VoucherPaymentMailer as Mailer;

class NotifyVoucherPayment
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    protected $mailer;

    public function __construct(Mailer $mailer)
    {
        $this->mailer = $mailer;
    }

    /**
     * Handle the event.
     *
     * @param  VoucherPayment  $event
     * @return void
     */
    public function handle(VoucherPayment $event)
    {
        $this->mailer->sendVoucherToBuyer($event->buyer);
    }

}
