<?php

namespace App\Listeners;

use App\Events\SchoolAdminCreate;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Mailers\SchoolAdminMailer as Mailer;

class NotifySchoolAdminCreate
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    protected $mailer;

    public function __construct(Mailer $mailer)
    {
        $this->mailer = $mailer;
    }

    /**
     * Handle the event.
     *
     * @param  SchoolAdminCreate  $event
     * @return void
     */
    public function handle(SchoolAdminCreate $event)
    {
        $this->mailer->sendCredientialToSchoolAdmin($event->admin, $event->password);
    }
}
