<?php

namespace App\Listeners;

use App\Events\AgentRegister;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Mailers\AgencyMailer as Mailer;

class NotifyAgentRegister
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(Mailer $mailer)
    {
         $this->mailer = $mailer;
    }

    /**
     * Handle the event.
     *
     * @param  AgentRegister  $event
     * @return void
     */
    public function handle(AgentRegister $event)
    {
        $this->mailer->sendCredientialToAgent($event->agent);
    }
}
