<?php

use App\NgStates;

use App\NgStatesLGA;

use App\ClassArms;

use App\Classes;

use App\Teacher;

use App\Subject;

use App\Student;

use App\StudentResult;

use App\Admin;

use App\School;

use App\OndoLGA;

use App\StudentHouse;

use App\DebtorPenalty;

use App\SchoolIDTemplate;

use App\StudentIDCard;
use App\Grades;
use App\GradeConfig;

use Illuminate\Support\Facades\DB;

use Illuminate\Pagination\LengthAwarePaginator;

use Illuminate\Pagination\Paginator;

function getStateName($state_id){
    if($state_id > 0){
        $slgas = NgStates::where('id','=',$state_id)->first();
        return $slgas->name;
    }

    return 'State of Origin not avaiable';
}

function getStateLGAName($lga_id){
    if($lga_id > 0){
        $slgas = NgStatesLGA::where('id','=',$lga_id)->first();
        return $slgas->name;
    }

    return 'State Local Govt. Area not avaiable';
}

function getSubjectTeacherSignature($subject_id,$classarm_id,$session ){
    $subject = DB::table('classarm_subject')->select('teacher_id')->whereRaw("`classarm_id` = ".$classarm_id." AND `subject_id` = '".$subject_id."' AND `session` = ".$session )->get();
    if(!empty($subject)){
       $teacher = Teacher::find($subject[0]->teacher_id);
        if(count($teacher) > 0){
            return $teacher->signature;                   
        }        
    }
    return '';    
}

function getSchoolLGAName($school){
    $ondolga = School::find($school);

    return $ondolga->ondo_lga()->get();
}

function getSchoolName($school_id){
    if($school_id > 0){
        $school = School::where('id','=',$school_id)->first();
        return $school->name;
    }

    return 'School not avaiable';
}


function getStateLGAs($state_id){
	$slgas = NgStatesLGA::where('state_id','=',$state_id)->get();
	return $slgas;
}

function getSchoolByLGA($state_id, $lga_id){
    $schools_lga = School::whereRaw("`state_id` = $state_id AND `lga_id` = $lga_id")->get();
    return $schools_lga;
}

function getClassArms($class_id){
	$classarms = ClassArms::where('class_id','=',$class_id)->get();

	return $classarms;
}

function getClasses($school_id){
    $classes = Classes::where('school_id','=',$school_id)->get();

    return $classes;
}

function getHouses($school_id){
    $houses = StudentHouse::where('school_id','=',$school_id)->get();

    return $houses;
}

function getSchools($school_id){
    $schools = School::where('id','=',$school_id)->get();

    return $schools;
}

function getSchoolAdmins($school_id){
    $school_admins = Admin::where('school_id', $school_id)->get();

    return $school_admins;
}

function getAssocSubject($teacher_id){

	$teacher = new Teacher;

	$staff_id = $teacher->find($teacher_id);

    return $staff_id->subjects()->get();
}

function getAssocSubjectByClassArmID($classarm_id, $session){

	$classarms = new ClassArms;

	$classarm = $classarms->find($classarm_id);

    return $classarm->subjects()
                    ->wherePivot('session', $session)
                    ->get();
}

function getAssocSubjectByClassArmIDSession($classarm_id, $session){

    $classarms = new ClassArms;

    $classarm = $classarms->find($classarm_id);

    return $classarm->subjects()->wherePivot('session', '=', $session)->get();
}

function getAssocTeacherByClassArmID($classarm_id){

	$classarms = new ClassArms;

	$classarm = $classarms->find($classarm_id);

    return $classarm->teachers()->get();
}

function getAssocTeacher($subject_id){

	$subject = new Subject;

	$staff_id = $subject->find($subject_id);
    
    return $staff_id->teachers()->get();
}

function getAssocTeacherNew($subject_id){
    $teachers = [];
    $subjectTeacher = DB::table('subject_teacher')->where('subject_id', $subject_id)->get();
    if(count($subjectTeacher) > 0){
        foreach($subjectTeacher as $teacher){
            $teachers[] = Teacher::find($teacher->teacher_id);
        }
    }
    
    return $teachers;
}

function getAssocTeacherSchool($subject_id, $school_id){

    $subject = new Subject;

    $staff_id = $subject->find($subject_id);

    //return $staff_id->teachers()->wherePivot('school_id', '=', $school_id)->get();
    return $staff_id->teachers()->wherePivot('school_id', $school_id)->get();
}

function getAssocTeacherSchoolNew($subject_id, $school_id){

    $subject = new Subject;

    $staff_id = $subject->find($subject_id);

    //return $staff_id->teachers()->wherePivot('school_id', '=', $school_id)->get();
    return $staff_id->teachersNew()->wherePivot('school_id', $school_id)->get();
}

function getAssocCounsellorByClassArmID($classarm_id){

    $classarms = new ClassArms;

    $classarm = $classarms->find($classarm_id);

    return $classarm->counsellors()->get();
}

function getAdminAssocPermissions($admin_id){

    $admin = Admin::find($admin_id);

    return $admin->permissions()->get();


}

 function paginate($items,$perPage = 5)
	{
	    $pageStart = \Request::get('page', 1);

	    // Start displaying items from this number;
	    $offSet = ($pageStart * $perPage) - $perPage; 

	    // Get only the items you need using array_slice
	    $itemsForCurrentPage = array_slice($items, $offSet, $perPage, true);

	    return new LengthAwarePaginator($itemsForCurrentPage, count($items), $perPage,Paginator::resolveCurrentPage(), array('path' => Paginator::resolveCurrentPath()));
	}

function getClassNameByClassID($class_id){

	$classes = Classes::find($class_id);

    //return $classes->class_name;

    $class_name = (!empty($classes->class_name)) ? $classes->class_name: '';
    return $class_name;

}

function getClassArmNameByClassArmID($classarm_id){

    $classarm = ClassArms::find($classarm_id);

    return $classarm->class_arm;

}

function getStudenthouse($house_id){
    //return StudentHouse::find($house_id)->name;
    $house_data = StudentHouse::find($house_id);
    $student_house = (!empty($house_data)) ? $house_data->name: '';
    return $student_house;
}


function getStudentHouseMasterBySchoolID($house_id){

    $house_data = StudentHouse::find($house_id);

    return $house_data->house_masters()->get();
}

function getSubjectNameBySubjectID($subject_id){
    return Subject::find($subject_id)->subject_name;
}

function getSubjectCodeBySubjectID($subject_id){
    return Subject::find($subject_id)->subject_code;
}

function getStudentResultByStudentID($student_id, $session, $class_id, $classarm_id, $term){

    $student_id = Student::find($student_id);

    return $student_id->studentResults()
                ->where('term', $term)
                ->where('session', $session)
                ->where('class_id', $class_id)
                ->where('classarm_id', $classarm_id)
                ->get();
}



function getResultScoreGrade($mark, $class_type, $school_id = false){
    if(empty($school_id)){
        $school_id = 362;
    }
    return DB::table('grades')
            ->select('grades.name', 'grades.remark')
            ->where('grades.school_id', $school_id)
            ->where('grade_config.class_type', $class_type)
            ->where('grade_config.score_from', '<=', $mark)
            ->where('grade_config.score_to', '>=', $mark)
            ->join('grade_config', 'grade_config.grade_id', '=', 'grades.id')
            ->first(); 
}


function resultGradeJS($mark){
    if($mark >= 70){
        return 'A';
    }elseif($mark >= 60){
        return 'B';
    }elseif($mark >= 50){
        return 'C';
    }elseif($mark >= 40){
        return 'D';
    }else{
        return 'E';
    }
}

function resultRemarksJS($mark){
    if($mark >= 70){
        return 'Excellent';
    }elseif($mark >= 60){
        return 'Good';
    }elseif($mark >= 50){
        return 'Average';
    }elseif($mark >= 40){
        return 'Below Average';
    }else{
        return 'Poor';
    }
}


function resultGradeRemarksJS(){
    $grade_array = array(
                array('mark' => '70-100', 'grade' => 'A', 'remark' => 'Excellent'),
                array('mark' => '60-69', 'grade' => 'B', 'remark' => 'Good'),
                array('mark' => '50-59', 'grade' => 'C', 'remark' => 'Average'),
                array('mark' => '40-49', 'grade' => 'D', 'remark' => 'Below Average'),
                array('mark' => '0-39', 'grade' => 'E', 'remark' => 'Poor')
            );
    return $grade_array;
}


function resultGradeSS($mark){
    if($mark >= 75){
        return 'A1';
    }elseif($mark >= 70){
        return 'B2';
    }elseif($mark >= 65){
        return 'B3';
    }elseif($mark >= 60){
        return 'C4';
    }elseif($mark >= 55){
        return 'C5';
    }elseif($mark >= 50){
        return 'C6';
    }elseif($mark >= 45){
        return 'D7';
    }elseif($mark >= 40){
        return 'E8';
    }else{
        return 'F9';
    }
}

function resultRemarksSS($mark){
    if($mark >= 75){
        return 'Excellent';
    }elseif($mark >= 70){
        return 'Very Good';
    }elseif($mark >= 65){
        return 'Good';
    }elseif($mark >= 60){
        return 'Credit';
    }elseif($mark >= 55){
        return 'Credit';
    }elseif($mark >= 50){
        return 'Credit';
    }elseif($mark >= 45){
        return 'Pass';
    }elseif($mark >= 40){
        return 'Pass';
    }else{
        return 'Failed';
    }
}


function resultGradeRemarksSS(){
    $grade_array = array(
                array('mark' => '75-100', 'grade' => 'A1', 'remark' => 'Excellent'),
                array('mark' => '70-74', 'grade' => 'B2', 'remark' => 'Very Good'),
                array('mark' => '65-69', 'grade' => 'B3', 'remark' => 'Good'),
                array('mark' => '60-64', 'grade' => 'C4', 'remark' => 'Credit'),
                array('mark' => '55-59', 'grade' => 'C5', 'remark' => 'Credit'),
                array('mark' => '50-54', 'grade' => 'C6', 'remark' => 'Credit'),
                array('mark' => '45-49', 'grade' => 'D', 'remark' => 'Pass'),
                array('mark' => '40-44', 'grade' => 'D', 'remark' => 'Pass'),
                array('mark' => '0-39', 'grade' => 'E', 'remark' => 'Fail')
            );
    return $grade_array;
}


function resultGrade($mark){
    if($mark >= 70){
        return 'A';
    }elseif($mark >= 60){
        return 'B';
    }elseif($mark >= 50){
        return 'C';
    }elseif($mark >= 40){
        return 'D';
    }elseif($mark >= 35){
        return 'E';
    }else{
        return 'F';
    }
}

function resultRemarks($mark){
    if($mark >= 70){
        return 'Excellent';
    }elseif($mark >= 60){
        return 'Good';
    }elseif($mark >= 50){
        return 'Average';
    }elseif($mark >= 40){
        return 'Below Average';
    }elseif($mark >= 35){
        return 'Poor';
    }else{
        return 'Fail';
    }
}

function getStudentIDByRegNum($regnum){
    return Student::where('regnum', '=',$regnum)
                    ->first(['id']);
}

function getStudentFullnameByRegNum($regnum){
    $student =  Student::where('regnum', '=',$regnum)
                    ->first(['surname','firstname', 'middlename']);

    return trim($student->surname.' '.$student->firstname.' '.$student->middlename);
}

function getStudentFullnameByStudentID($student_id){
    $student =  Student::find($student_id);

    return trim($student->surname.' '.$student->firstname.' '.$student->middlename);
}

function getTeacherFullnameByStudentID($teacher_id){
    $teacher =  Teacher::find($teacher_id);

    return trim($teacher['surname'].' '.$teacher['firstname'].' '.$teacher['middlename']);
    //return trim($teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename);
}

function getRegNumByStudentID($student_id){
    return  Student::find($student_id)->regnum;
}


function fetchDataTable($table, $data, $perPage = 5){

	$sql = "SELECT * FROM `".$table."`";

	$sql_where = ' WHERE';

	$sql_where_clause = '';

	$all_empty = count($data) == 0 ? true : false;

	foreach ($data as $key => $value) {
		if(!empty($value)){
			if($key != 'page')
			$sql_where_clause .= " `$key` = '$value' AND";
		}
	}

	if(!$all_empty){
		$sql .= $sql_where.$sql_where_clause;
	}

	$sql = rtrim($sql, ' AND');

	$items = DB::select($sql);


    if($perPage == 0){

        return collect($items);

    }else{
       return paginate($items, $perPage);  
    }

}


function fetchDataTableWithSql($sql, $perPage = 5){

    $items = DB::select($sql);

    if($perPage == 0){

        return collect($items);

    }else{
       return paginate($items, $perPage);  
    }

}

function characterPracticalSkill($name,$value){
    return '<div class="field">
                <div class="ui fluid search selection dropdown">
                  <input type="hidden" name="'.$name.'" value="'.$value.'">
                  <i class="dropdown icon"></i>
                  <div class="default text">Rating</div>
                  <div class="menu">
                     <div class="item" data-value="0">0</div>
                     <div class="item" data-value="1">1</div>
                     <div class="item" data-value="2">2</div>
                     <div class="item" data-value="3">3</div>
                     <div class="item" data-value="4">4</div>
                     <div class="item" data-value="5">5</div>
                  </div>
                </div>
              </div>';
}

function getStudentSubjectPosition($classarm_id, $class_id, $subject_id,$term, $session, $student_score){
    $count = StudentResult::where('classarm_id', $classarm_id)
                                        ->where('class_id', $class_id)
                                        ->where('subject_id', $subject_id)
                                        ->where('session', $session)
                                        ->where('term', $term)
                                        ->where('weighted_average', '>=', $student_score)
                                        ->groupBy('weighted_average')
                                        ->count();

    $number = $count > 0 ? $count : $count + 1;
        $ends = array('th','st','nd','rd','th','th','th','th','th','th');
        if ((($number % 100) >= 11) && (($number%100) <= 13))
            return $number. 'th';
        else
            return $number. $ends[$number % 10];

}

function getSubjectsOld($school_id){
    return Subject::where('school_id', $school_id)
                        ->get();
}

function getSubjects(){
    return Subject::get();
}

function getSubjectAverageScore($classarm_id, $class_id, $subject_id,$term, $session){

    $subject_average = StudentResult::where('classarm_id', $classarm_id)
                                        ->where('class_id', $class_id)
                                        ->where('subject_id', $subject_id)
                                        ->where('session', $session)
                                        ->where('term', $term)
                                        ->get(['weighted_average']);

    return $subject_average->avg('weighted_average');

}

function getSubjectWeightedAvgScore($student_id, $classarm_id, $class_id, $subject_id,$term, $session){

    $subject_average = StudentResult::where('classarm_id', $classarm_id)
                                        ->where('class_id', $class_id)
                                        ->where('subject_id', $subject_id)
                                        ->where('student_id', $student_id)
                                        ->where('session', $session)
                                        ->where('term', $term)
                                        ->first(['weighted_average']);

    return $subject_average['weighted_average'];

}

function getStudentResultPromotion($student_id, $classarm_id, $class_id, $term, $session){

    $student_result = StudentResult::where('classarm_id', $classarm_id)
                                        ->where('class_id', $class_id)
                                        ->where('student_id', $student_id)
                                        ->where('session', $session)
                                        ->where('term', $term)
                                        ->first(['promotion']);

    return $student_result['promotion'];

}


function getTermTotalWeightedAvgScore($student_id, $classarm_id, $class_id, $term, $session){

    $weighted_average = StudentResult::where('classarm_id', $classarm_id)
                                        ->where('class_id', $class_id)
                                        ->where('student_id', $student_id)
                                        ->where('session', $session)
                                        ->where('term', $term)
                                        ->value(DB::raw("SUM(ca_score + exam_score)"));

    return $weighted_average;

}

function getTermTotalSubjectCount($student_id, $classarm_id, $class_id, $term, $session){

    $weighted_average = StudentResult::where('classarm_id', $classarm_id)
                                        ->where('class_id', $class_id)
                                        ->where('student_id', $student_id)
                                        ->where('session', $session)
                                        ->where('term', $term)
                                        ->where('ca_score', '>', 0)
                                        ->where('exam_score', '>', 0)
                                        ->count();

    return $weighted_average;

}

function getSubjectCummulative($classarm_id, $class_id, $subject_id,$term, $session, $student_id, $current){
    if($current){
        switch ($term) {
            case 'First':
                    $data = ['First'];
            break;

            case 'Second':
                    $data = ['First', 'Second'];
            break;

            case 'Third':
                    $data = ['First', 'Second', 'Third'];
            break;
        }

    }else{
        switch ($term) {
            case 'First':
                    $data = ['Not Allowed'];
            break;

            case 'Second':
                    $data = ['First'];
            break;

            case 'Third':
                    $data = ['First', 'Second'];
            break;
        }
    }
    $subject_average = StudentResult::where('classarm_id', $classarm_id)
                                        ->where('class_id', $class_id)
                                        ->where('subject_id', $subject_id)
                                        ->where('student_id', $student_id)
                                        ->where('session', $session)
                                        ->whereRaw("`term` IN ('".implode('\', \'', $data)."')")
                                        ->get(['weighted_average']);

    $weighted_average = $subject_average->avg('weighted_average');

    return ($weighted_average > 0) ? number_format($weighted_average, 1): $weighted_average;

}

// @response if ( strcasecmp($response, 'OK: 0') == 0 )

function prepareSMSGateWay($senderName, $PhoneBook, $message)
    {
                
        $SMSGateWay =   "http://www.qultext.com/http/index.aspx";
        
        $SMSGateWay .=  "?cmd=sendquickmsg&username=ogooluwao@yahoo.co.uk&password=omoreghagideonogooluwa@1982";
        
        $SMSGateWay .=  "&message=".$message."&sender=".$senderName."&sendto=".$PhoneBook."&msgtype=0";
        
        $SMSChannel = curl_init();
        
        curl_setopt($SMSChannel, CURLOPT_URL, $SMSGateWay);
        
        curl_setopt($SMSChannel, CURLOPT_HEADER, 0);
        
        curl_setopt($SMSChannel, CURLOPT_RETURNTRANSFER, 1);
        
        $response = curl_exec($SMSChannel);
        
        curl_close($SMSChannel);
        
        return $response;   
    }

function getStudentISSI($student_id){
    error_reporting(0);
    if(empty($student_id) || $student_id === NULL){
        echo "<p style='color:green'> Available</p>";
    }else{
        $student = Student::find($student_id);
    
        return $student->regnum;
    }
}

function getIssue($student_id){
    $debtor = DebtorPenalty::where('student_id', $student_id)
                            ->where('status', 0)
                            ->first();
    if($debtor === null){
        return '';
    }else{
        return $debtor->issue;
    }
}

function url_public($uri){
     return env('APP_URL').$uri;
}

    function getDynamicColorByKey($key){
    	$value = $key % 7;
    	switch ($value) {
    		case '0':
    			return 'red';
    		break;

    		case '1':
    			return 'orange';
    		break;

    		case '2':
    			return 'teal';
    		break;

    		case '3':
    			return 'blue';
    		break;

    		case '4':
    			return 'blue';
    		break;

    		case '5':
    			return 'brown';
    		break;

    		case '6':
    			return 'grey';
    		break;

    		default:
    			return 'black';
    		break;
    	}

    }

function schoolIDCardTemplate($school_logo, $school_name, $exp_date){

    $id_card_templtae = imagecreatefromjpeg(public_path().'/images/IDtemplate.jpg');

    $extension = strtolower(substr($school_logo, strrpos($school_logo, ".") + 1));

    switch ($extension)
    {
        case 'jpg':
        case 'jpeg':
            $overlay = imagecreatefromjpeg(public_path().$school_logo);
            break;
        case 'png':
            $overlay = imagecreatefrompng(public_path().$school_logo);
            break;
        case 'gif':
            $overlay = imagecreatefromgif(public_path().$school_logo);
            break;
        default:
            die("Image is of unsupported type.");
    }

    $owidth = imagesx($overlay);

    $oheight = imagesy($overlay);

    imagecopy($id_card_templtae, $overlay, 785, 10, 0, 0, $owidth, $oheight);

    $font = public_path()."/fonts/arial.ttf";

    $fontsize="15";
    
    $sch_name_fontsize="26";

    $white = imagecolorallocate($id_card_templtae, 255, 255, 255);

    $filename = '/images/school-id-template/'.time().'-'.str_slug($school_name).'.jpg';

    imagettftext($id_card_templtae, $sch_name_fontsize, 0, 40, 587, $white, $font, $school_name);

    imagettftext($id_card_templtae, $fontsize, 0,  900, 587, $white, $font, $exp_date);

    imagejpeg($id_card_templtae,public_path().$filename, 100); 

    if(file_exists(public_path().$filename)){
        return $filename;
    }

    return false;

}

function generateStudentDICard($school_id_template,$student_passport, $student_fullname, $student_ossin, $student_classarm, $gender, $blood_group, $pg_phone){

     $school_id_card = imagecreatefromjpeg(public_path().$school_id_template);

    $extension = strtolower(substr($student_passport, strrpos($student_passport, ".") + 1));

        switch ($extension)
        {
            case 'jpg':
            case 'jpeg':
                $overlay = imagecreatefromjpeg(public_path().$student_passport);
                break;
            case 'png':
                $overlay = imagecreatefrompng(public_path().$student_passport);
                break;
            case 'gif':
                $overlay = imagecreatefromgif(public_path().$student_passport);
                break;
            default:
                die("Image is of unsupported type.");
        }

        $owidth = imagesx($overlay);

        $oheight = imagesy($overlay);

        imagecopy($school_id_card, $overlay, 40, 220, 0, 0, $owidth, $oheight);

        $font = public_path()."/fonts/arial.ttf";

        $fontsize="23";

        $black = imagecolorallocate($school_id_card, 0, 0, 0);

        $filename = '/images/student-id-card/'.time().'-'.str_slug($student_fullname).'.jpg';

        imagettftext($school_id_card, $fontsize, 0, 330, 285, $black, $font, $student_fullname);

        imagettftext($school_id_card, $fontsize, 0, 330, 375, $black, $font, $student_ossin);

        imagettftext($school_id_card, $fontsize, 0, 330, 465, $black, $font, $student_classarm);

        imagettftext($school_id_card, $fontsize, 0, 500, 465, $black, $font, $gender);

        imagettftext($school_id_card, $fontsize, 0, 715, 465, $black, $font, $blood_group);

        imagettftext($school_id_card, $fontsize, 0, 580, 520, $black, $font, $pg_phone);

        imagejpeg($school_id_card,public_path().$filename, 100); 

        if(file_exists(public_path().$filename)){
            return $filename;
        }

        return false;

}


function getIDCardExpDate($school_id){
    $school_id_template = SchoolIDTemplate::where('school_id', $school_id)->first();

    if(count($school_id_template) > 0){
        return $school_id_template->exp_date;
    }

    return 'Not Available';
}

function getStudentIDCard($student_id){
    return StudentIDCard::where('student_id', $student_id)->first();
}

function getCommentCategoryField($id){
    if($id == 1){
        return 'comment_teacher';
    }elseif($id == 2){
        return 'comment_house';
    }elseif($id == 3){
        return 'comment_guard';
    }elseif($id == 4){
        return 'comment_principal';
    }else{
        return false;
    }
}

function limitLongText ($strValue, $limitDigit, $add_dot = false){       
    if(strlen($strValue) > $limitDigit){
        $getStrVal = substr($strValue, 0, $limitDigit);
        $getStrVal .= ($add_dot == 1) ? '...': '';
    }
    else{
        $getStrVal = $strValue;
    }
    return $getStrVal;
}// End function


function getTaskStatus($status){
    switch ($status) {
        case "1":
            return "Pending";
            break;
        case "2":
            return "In-progress";
            break;
        case "3":
            return "Completed";
            break;
        case "4":
            return "Abandoned";
            break;
        default:
            return false;
    }
}


function getTaskStatusWrapper($status){
    switch ($status) {
        case "1":
            return "label-default";
            break;
        case "2":
            return "label-primary";
            break;
        case "3":
            return "label-success";
            break;
        case "4":
            return "label-danger";
            break;
        default:
            return false;
    }
}
