<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class authenticateIfFormSubmitted
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {

        if (Auth::guard($guard)->user()->submitted == 1) {

            switch ($guard) {
                case 'unity_exam':
                        $dashboard = 'exam.unity.dashboard';
                break;
            }

            if ($request->ajax() || $request->wantsJson()) {
                return response('Unauthorized.', 401);
            } else {
                
                flash('Sorry, you have already registered')->error();

                return redirect()->route($dashboard);
            }
        }
        

        return $next($request);
    }
}
