<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        switch ($guard) {

                case 'super_admin':
                       if(Auth::guard($guard)->check()){

                         return redirect()->route('super_admin.dashboard');
                       }
                break;
                case 'admin':
                       if(Auth::guard($guard)->check()){
                         return redirect()->route('admin.dashboard');
                       }
                break;
                case 'student':
                        if(Auth::guard($guard)->check()){
                         return redirect()->route('student.dashboard');
                       }
                break;
                case 'teacher':
                        if(Auth::guard($guard)->check()){
                         return redirect()->route('teacher.dashboard');
                       }
                break;

                case 'unity_exam':
                        if(Auth::guard($guard)->check()){
                         return redirect()->route('exam.unity.dashboard');
                       }
                break;
                
                case 'entrance':
                        if(Auth::guard($guard)->check()){
                         return redirect()->route('exam.entrance.dashboard');
                       }
                break;
            }

        // if (Auth::guard($guard)->check()) {
        //     return redirect('/');
        // }

        return $next($request);
    }
}
