<?php

namespace App\Http\Middleware;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Carbon\Carbon;
use App\ActivityLog;
use App\School;
use App\SuperAdmin;
use App\Admin;
use App\Teacher;
use App\Student;

use Closure;

class Log
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        // record activities here
        $currentPath = Route::getCurrentRoute()->getPath();
        $method = $method = $request->method();
        $device = $request->server('HTTP_USER_AGENT');
        $ip = $request->ip();
        if(Auth::guard('super_admin')->check() || Auth::guard('admin')->check() || Auth::guard('teacher')->check() || Auth::guard('student')->check()){
            if(Auth::guard('super_admin')->check()){
                $user = auth('super_admin')->user();
                if ($request->isMethod('post')) {
                    $message = 'posted to '.$currentPath.'';
                }else{
                    $message = 'visited '.$currentPath.'';
                }
                ActivityLog::create([
                    'super_admin_id' => $user->id,
                    'message' => $message,
                    'path' => $currentPath,
                    'type' => $method,
                    'ip' => $ip,
                    'device' => $device
                ]);
            }
            
            if(Auth::guard('admin')->check()){
                $user = auth('admin')->user();
                if ($request->isMethod('post')) {
                    $message = 'posted to '.$currentPath.'';
                }else{
                    $message = 'visited '.$currentPath.'';
                }
                ActivityLog::create([
                    'admin_id' => $user->id,
                    'school_id' => $user->school->id,
                    'message' => $message,
                    'path' => $currentPath,
                    'type' => $method,
                    'ip' => $ip,
                    'device' => $device
                ]);
            }
            
            if(Auth::guard('teacher')->check()){
                $user = auth('teacher')->user();
                if ($request->isMethod('post')) {
                    $message = 'posted to '.$currentPath.'';
                }else{
                    $message = 'visited '.$currentPath.'';
                }
                ActivityLog::create([
                    'teacher_id' => $user->id,
                    'school_id' => $user->school->id,
                    'message' => $message,
                    'path' => $currentPath,
                    'type' => $method,
                    'ip' => $ip,
                    'device' => $device
                ]);
            }
            
            if(Auth::guard('student')->check()){
                $user = auth('student')->user();
                if ($request->isMethod('post')) {
                    $message = 'posted to '.$currentPath.'';
                }else{
                    $message = 'visited '.$currentPath.'';
                }
                ActivityLog::create([
                    'student_id' => $user->id,
                    'school_id' => $user->school->id,
                    'message' => $message,
                    'path' => $currentPath,
                    'type' => $method,
                    'ip' => $ip,
                    'device' => $device
                ]);
            }
        }
                
        
        return $next($request);
    }
}
