<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use Input;

use Validator;

use App\NgStates;

use Image;

use App\UnityExam;

use App\School;

use Hash;

use App\ExamsVouchers;

use App\UnityHallAllocation;

use App\UnityCenter;

class UnityExamController extends Controller
{
    public function __construct(){

        $this->middleware('auth:unity_exam');

        $this->middleware('submitted:unity_exam', ['only' => ['create', 'store','passport','passportPost','confirm','confirmPost']]);

        $this->middleware('notsubmitted:unity_exam', ['only' => ['photocard']]);

    }

    public function dashboard(){
        $title = 'Unity Examination Dashboard';
        $noAutoAd = true;
        return view('exams.unity.dashboard', compact('title', 'noAutoAd'));
    }

    public function create(){

        $title = 'Unity Examination Registration';

        $ngstates = NgStates::all();

        $ondo_lgas = NgStates::find(28)->ondo_lga;

        $unity_schools = School::where('name', 'African Church Unity Secondary School, Epinmi-Akoko')
                                ->orWhere('name', 'St John/Mary’s Unity Sec School, Owo')
                                ->orWhere('name', 'St Peters Unity Sec. School, Akure')
                                ->orWhere('name', 'St. Helens’ Ondo')
                                ->orWhere('name', 'St. Helens’ Ondo')
                                ->orWhere('name', 'Christ Unity Secondary School Ode-Aye')
                                ->get();

        return view('exams.unity.create', compact('ngstates', 'title', 'unity_schools', 'ondo_lgas'));
    }

    public function store(Request $request){


        $student = UnityExam::find(auth('unity_exam')->id());

        $validate = Validator::make($request->all(), UnityExam::$rules);

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
                if(!in_array($key, array('_token','password_confirmation', 'regnum', 'password', 'exam_area')) && !empty($value)){
                        $insert[$key] = $value;
                }
            }

           $insert['session'] = date('Y');
            
           $student_id = $student->update($insert);

           $hall_allocation = UnityHallAllocation::where('candidate_id', auth('unity_exam')->id())->first();

           $hall_allocation->update([
                    'session' => $insert['session'],
                    'exam_center_lga_id' => $request->input('exam_area'),
                    'school_center_id' => $request->input('school_center_id')
                ]);

           flash('You have Successfully Saved Candidate Information')->info();

            return redirect()->route('exam.unity.passport');

        }

        flash('Something is wrong')->error();
        return redirect()->back()
                    ->withErrors($validate)
                    ->withInput();
        

    }

    public function passport(){

         $title = 'Candidate Passport Upload';

         $student = UnityExam::find(auth('unity_exam')->id());

        return view('exams.unity.passport', compact('title', 'student'));

    }

    public function passportPost(Request $request){

        $setStudent = new UnityExam;

        if(!empty(auth('unity_exam')->user()->passport))
        {
            $setStudent::$studentPassportRule['passport'] = 'sometimes|image|mimes:jpeg,jpg,png|img_min_size:250';
        }

        $validate = Validator::make($request->all(), $setStudent::$studentPassportRule);

        if($validate->passes()){

            $student = $setStudent->find(auth('unity_exam')->id());

            if ($request->hasFile('passport'))
            {
                if ($student->passport != '/images/passports/no_img_da88a72526.gif') {
                    if(file_exists(public_path(explode('?', ltrim($student->passport, '/'))[0])))
                    {
                        @unlink( public_path(explode('?', ltrim($student->passport, '/'))[0]) );
                    }
                }
                $image = $request->file('passport');
                $passport_path = md5(time())."-".$student->surname."-".$student->firstname.".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(250,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/passports/unity/'.$passport_path);

                $student->passport = '/images/passports/unity/'.$passport_path.'?cache='.time();

                $student->save();

                flash('You have successfully updated your passport')->success();

            }

            return redirect()->route('exam.unity.confirm');
        }


    }

    public function confirm(){

        $title = 'Registration Confirmation';

        $student = UnityExam::find(auth('unity_exam')->id());

        return view('exams.unity.confirm', compact('title', 'student'));



    }

    public function confirmPost(Request $request){

        $student = UnityExam::find(auth('unity_exam')->id());

        //generate regnum
        $centerID = UnityCenter::find($student->hall_allocation()->first()->school_center_id)->id;
        $session = "$student->session";
        $studentID = str_pad($student->id, 4, '0', STR_PAD_LEFT);
        $Regnum = $centerID.$session[2].$session[3].$studentID;
        $student->submitted = 1;
        $student->regnum = $Regnum;

        $student->save();  
        
        return redirect()->route('exam.unity.photocard');      

    }

    public function photocard(){

        $title = 'Registration Confirmation';

        $student = UnityExam::find(auth('unity_exam')->id());

        return view('exams.unity.photocard', compact('title', 'student'));



    }

    // public function getCenters(Request $request){
       
    // }

    

}