<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\TransferTeacher;

use App\Teacher;

use App\School;

use Session;

use Image;

use Validator;

use Input;

use Auth;

use Gate;

use App\OndoLGA;

use Carbon\Carbon;

use DB;

use App\Repositories\TeacherRepositoryInterface;

class TransferTeacherController extends Controller
{
    protected $teacher;

    public function __construct(TeacherRepositoryInterface $teachers){

        $this->teachers = $teachers;

    }
    
	function viewTeachers(){
		
	    if(auth('admin')->user()->cannot('new-teacher-transfer')){
	        $title = 'Permission Deny';
	        return view('errors.401', compact('title'));
	    }

		//$school_id = auth('admin')->user()->school_id;
		$school_id = Session::get('admin.school');

		$teachers = Teacher::where('school_id', $school_id)
                            ->orderBy('surname', 'asc')
                            ->get();

		return view('admin.transfer-teacher.view', compact('teachers'));

	}

	function transferNewRequest($id){
		
	    if(auth('admin')->user()->cannot('new-teacher-transfer')){
	        $title = 'Permission Deny';
	        return view('errors.401', compact('title'));
	    }

		//$school_id = auth('admin')->user()->school_id;
		$school_id = Session::get('admin.school');

		$teacher = Teacher::where('id', $id)
                            ->where('school_id', $school_id)
                            ->first();

		$teacher_transfer = TransferTeacher::select('transfers_teacher.*', 'schools.name')
							->where('teacher_id', $id)
                            ->where('former_school', $school_id)
	                		->join('schools', 'schools.id', '=', 'transfers_teacher.new_school')
                            ->first();

        $current_school = School::find($school_id);

        $title = (empty($teacher_transfer)) ? 'Process Teacher Transfer': 'Teacher Transfer Awaiting Confirmation';

        $ondo_lga = OndoLGA::get();

		return view('admin.transfer-teacher.new-request', compact('teacher', 'teacher_transfer', 'ondo_lga', 'title', 'current_school'));

	}

	function transferNewRequestProcess(Request $request, $id){
		
	    if(auth('admin')->user()->cannot('new-teacher-transfer')){
	        $title = 'Permission Deny';
	        return view('errors.401', compact('title'));
	    }

		//$school_id = auth('admin')->user()->school_id;
		$current_school_id = Session::get('admin.school');
        
        $validate = Validator::make($request->all(), [
                'school_id' => 'required',
                'teacher_id' => 'required',
                'former_staff_no' => 'required',
                'former_school' => 'required',
                'session' => 'required',
                'term' => 'required',
                'reason_for_transfer' => 'required'
            ]);

        if($validate->passes()){
        	if(empty($current_school_id)){
				//flash('Error encountered while validating account login information.')->error();
	            return redirect()->route('admin.logout');
        	}
        	elseif($request->school_id == $request->former_school){
				flash('You must select a school different from the current school!')->error();
	            return redirect()->route('admin.view.transfer.new.request', ['id' => $request->teacher_id]);
        	}
        	else{
        		$dbdata = [
	                'teacher_id' => $request->teacher_id,
	                'former_staff_no' => $request->former_staff_no,
	                'new_staff_no' => '',
	                'former_school' => $request->former_school,
	                'new_school' => $request->school_id,
	                'transfer_status' => 0,
	                'session' => $request->session,
	                'term' => $request->term,
	                'reason_for_transfer' => $request->reason_for_transfer,
	                'created_at' => Carbon::now(),
	                'updated_at' => Carbon::now()
        		];

        		$transfer_id = TransferTeacher::create($dbdata)->id;

	            if($transfer_id){
	                flash('Selected Teacher transfer has been successfully processed.')->success();
	                return redirect()->route('admin.view.transfer.teachers');
	            }
	            else{
	                flash('Something went wrong while processing submission. Pls try again shortly!')->error();
	                return redirect()->route('admin.library.add.book', ['id' => $request->teacher_id]);
	            }

        	}
        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

	}

	function inwardTransferHistory(){

	    if(auth('admin')->user()->cannot('inward-teacher-transfer-history')){
	        $title = 'Permission Deny';
	        return view('errors.401', compact('title'));
	    }

		$school_id = Session::get('admin.school');

        $current_school = School::find($school_id);

		$teacher_transfers = TransferTeacher::select('transfers_teacher.*', 'schools.name', 'teachers.surname', 'teachers.firstname', 'teachers.middlename', 'teachers.staff_no')
                            ->where('new_school', $school_id)
	                		->join('schools', 'schools.id', '=', 'transfers_teacher.new_school')
	                		->join('teachers', 'teachers.id', '=', 'transfers_teacher.teacher_id')
                            ->get();

		return view('admin.transfer-teacher.inward-history', compact('teacher_transfers', 'current_school'));
	}

	function outwardTransferHistory(){

	    if(auth('admin')->user()->cannot('outward-teacher-transfer-history')){
	        $title = 'Permission Deny';
	        return view('errors.401', compact('title'));
	    }

		$school_id = Session::get('admin.school');

        $current_school = School::find($school_id);

		$teacher_transfers = TransferTeacher::select('transfers_teacher.*', 'schools.name', 'teachers.surname', 'teachers.firstname', 'teachers.middlename', 'teachers.staff_no')
                            ->where('former_school', $school_id)
	                		->join('schools', 'schools.id', '=', 'transfers_teacher.new_school')
	                		->join('teachers', 'teachers.id', '=', 'transfers_teacher.teacher_id')
                            ->get();

		return view('admin.transfer-teacher.outward-history', compact('teacher_transfers', 'current_school'));
	}


	function transferConfirmRequest($id){
		
	    if(auth('admin')->user()->cannot('confirm-teacher-transfer')){
	        $title = 'Permission Deny';
	        return view('errors.401', compact('title'));
	    }

		$school_id = Session::get('admin.school');

		$teacher_transfer = TransferTeacher::select('transfers_teacher.*', 'schools.name')
							->where('teacher_id', $id)
                            ->where('new_school', $school_id)
	                		->join('schools', 'schools.id', '=', 'transfers_teacher.new_school')
                            ->first();

        $former_school = (!empty($teacher_transfer)) ? $teacher_transfer->former_school: '';

		$teacher = Teacher::where('id', $id)
                            ->where('school_id', $former_school)
                            ->first();

        $current_school = School::find($school_id);

        $title = (empty($teacher_transfer)) ? 'Confirmed Teacher Transfer': 'Teacher Transfer Awaiting Confirmation';

		return view('admin.transfer-teacher.confirm-request', compact('teacher', 'teacher_transfer', 'title', 'current_school'));

	}

	function transferConfirmRequestProcess(Request $request, $id){
		
	    if(auth('admin')->user()->cannot('confirm-teacher-transfer')){
	        $title = 'Permission Deny';
	        return view('errors.401', compact('title'));
	    }

		$current_school_id = Session::get('admin.school');
        
        $validate = Validator::make($request->all(), [
                'transfer_id' => 'required',
                'teacher_id' => 'required',
                'session' => 'required'
            ]);

        if($validate->passes()){

        	$teacher_transfer = TransferTeacher::find($request->transfer_id);

        	$teacher_data = Teacher::find($request->teacher_id);

        	if(empty($teacher_transfer)){
				flash('Error encountered while validating transfer information.')->error();
	            return redirect()->route('admin.confirm.transfer.request', ['id' => $request->teacher_id]);
        	}
        	elseif(empty($teacher_data)){
				flash('Error encountered while validating teacher information.')->error();
	            return redirect()->route('admin.confirm.transfer.request', ['id' => $request->teacher_id]);
        	}
        	elseif($teacher_transfer->transfer_status > 0){
				flash('Selected teacher transfer request had been Confirmed!')->error();
	            return redirect()->route('admin.inward.transfer.teachers.history');
        	}
        	elseif(empty($current_school_id)){
	            return redirect()->route('admin.logout');
        	}
        	elseif($teacher_transfer->new_school != $current_school_id){
				flash('Error encountered while authenticating new school information.')->error();
	            return redirect()->route('admin.inward.transfer.teachers.history');
        	}
        	else{
        		$staff_no_digit = $this->teachers->getNextStaffDigit($request->session, $current_school_id);
            	$staff_no = 'ONDO/'.str_pad($current_school_id, 4, 0, STR_PAD_LEFT).'/STAFF/'.$request->session.'/'.str_pad($staff_no_digit, 4, 0, STR_PAD_LEFT);

        		DB::beginTransaction();

        		try{
	    			Teacher::where('id', $request->teacher_id)
	    										->update(['staff_no' => $staff_no, 'staff_no_digit' => $staff_no_digit, 'session' => $request->session, 'school_id' => $current_school_id]);

	    			TransferTeacher::where('id', $request->transfer_id)
	    												->update(['new_staff_no' => $staff_no, 'transfer_status' => 1]);

	            	$teacher_data->subjects()->detach();
	            	$teacher_data->permission_classes()->detach();
	            	$teacher_data->houses()->detach();
	            	$teacher_data->classarms()->detach();

	            	DB::commit();

	                flash('Transfer for the selected teacher has been successfully confirmed.')->success();
	                return redirect()->route('admin.inward.transfer.teachers.history');
        			
        		}catch (Exception $e) {
	            	DB::rollBack();
	                flash('Something went wrong while processing transfer confirmation. Pls try again shortly!')->error();
	                return redirect()->route('admin.inward.transfer.teachers.history');
        		}

        	}
        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

	}

}
