<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Transfer;

use Session;

use Image;

use Validator;

use Input;

use Auth;

use Gate;

class TransferController extends Controller
{

protected $classarm;

protected $students;

public function __construct(ClassArmRepositoryInterface $classarm, StudentRepositoryInterface $student){

    $this->middleware('auth:admin',['except' => ['superAdminViewTransferHistory', 'superAdminViewTransferLetter']] );

    $this->middleware('auth:super_admin',['only' => ['superAdminViewTransferHistory', 'superAdminViewTransferLetter']] );

    $this->classarm = $classarm;

    $this->students = $student;

}



function getSchoolTransferHistroy(){

    if(auth('admin')->user()->cannot('view-transfer')){
        $title = 'Permission Deny';
        return view('errors.401', compact('title'));
    }

    $title = "Admin Section: View Transfer";

    $where_clause = "`student_former_school` = ".auth('admin')->user()->school_id." OR (`student_new_school` = ".auth('admin')->user()->school_id." AND `former_school_status` = '1') ";

    $transfers = Transfer::whereRaw($where_clause)
                            ->paginate(30);

    return view('admin.transfer.view-history', compact('transfers', 'title'));
}


function schoolAdminGrantTransfer($id){
    if(auth('admin')->user()->cannot('signature-transfer')){
        $title = 'Permission Deny';
        return view('errors.401', compact('title'));
    }

    $where_clause = "`id` = ".$id." AND (`student_former_school` = ".auth('admin')->user()->school_id." OR (`student_new_school` = ".auth('admin')->user()->school_id." AND `former_school_status` = '1')) ";

    $transfer = Transfer::whereRaw($where_clause)
                        ->first();

    if(count($transfer) > 0){

        $head_teachers = $this->classarm->find($transfer->classarm_id)
                                        ->teachers()
                                        ->wherePivot('session', $transfer->session)
                                        ->get();

        return view('admin.transfer.transfer-print-sheet',compact('transfer', 'head_teachers') );

    }

    flash('Something is wrong')->error();

    return redirect()->back();
}


function schoolAdminGrantTransferPost($id, Request $request){

    if(auth('admin')->user()->cannot('signature-transfer')){
        $title = 'Permission Deny';
        return view('errors.401', compact('title'));
    }


    $where_clause = "`id` = ".$id." AND (`student_former_school` = ".auth('admin')->user()->school_id." OR (`student_new_school` = ".auth('admin')->user()->school_id." AND `former_school_status` = '1')) ";

    $transfer = Transfer::whereRaw($where_clause)
                        ->first();

    if($transfer->student_new_school == auth('admin')->user()->school_id){
        if(auth('admin')->user()->cannot('assign-transfer-student-to-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
    }

    $rules = array();

    if(count($transfer) > 0){

        $rules['signature_png'] = 'required';

        if($transfer->student_new_school == auth('admin')->user()->school_id){ //Add this rule when the principal is the transfered principal
            $rules['classarm_id'] = 'required';
            $rules['house_id'] = 'required';
            $rules['class_id'] = 'required';
            $rules['session'] = 'required|digits:4';
            $rules['term'] = ['required','regex:/(First|Second|Third)/'];
        }

        $validate = Validator::make($request->all(),$rules);

        if($validate->passes()){

            if(preg_match('/data:image/', $request->input('signature_png'))){

                // Generating a random filename
                $filename = uniqid();

                if($transfer->student_former_school == auth('admin')->user()->school_id){

                    @unlink(public_path($transfer->former_principal_signature));

                     $filepath = "/images/signatures/transfer/".$filename."-former-".$transfer->id;

                }elseif($transfer->student_new_school == auth('admin')->user()->school_id){

                    @unlink(public_path($transfer->new_principal_signature));

                    $filepath = "/images/signatures/transfer/".$filename."-new-".$transfer->id;

                }


                $src = $request->input('signature_png');

                        // get the mimetype
                        preg_match('/data:image\/(?<mime>.*?)\;/', $src, $groups);
                        $mimetype = $groups['mime'];

                        $filepath .= '.'.$mimetype;


                        // @see http://image.intervention.io/api/
                        $image = Image::make($src)
                          // resize if required
                          ->resize(350,null, function($constraint)
                            {
                                $constraint->aspectRatio();

                            })
                          ->encode($mimetype, 100)  // encode file to the specified mimetype
                          ->save(public_path($filepath));

                          if($transfer->student_former_school == auth('admin')->user()->school_id){

                                $transfer->former_principal_signature = $filepath;

                                $transfer->former_school_status = 1;

                            }elseif($transfer->student_new_school == auth('admin')->user()->school_id){

                                $transfer->new_principal_signature = $filepath;

                                $transfer->new_school_status = 1;

                                $transfer->student_new_id = $this->transferStudentToNewSchool($transfer, $request);

                            }

                          $transfer->save();
                    } // <!--endif


                flash('You have successfully granted the student transfer')->success();

                return redirect()->back();
            }

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate);
    } 

protected function transferStudentToNewSchool(Transfer $transfer, Request $request){

    if($transfer->student_new_id != NULL){
        $student_exist = $this->students->find($transfer->student_new_id);
        $student_exist->classarms()->detach();
        $student_exist->delete();
    }

    $regnum_digit = $this->students->getNextRegNum($request->session);

    $insert = [
        'regnum' => $this->students->getRegNumPrefix($request->session).str_pad($regnum_digit, 3, 0, STR_PAD_LEFT),
        'regnum_digit' => $regnum_digit,
        'surname' => $transfer->studentBeforeTransfer->surname,
        'firstname' => $transfer->studentBeforeTransfer->firstname,
        'middlename' => $transfer->studentBeforeTransfer->middlename,
        'phone' => $transfer->studentBeforeTransfer->phone,
        'gender' => $transfer->studentBeforeTransfer->gender,
        'country' => $transfer->studentBeforeTransfer->country,
        'state_id' => $transfer->studentBeforeTransfer->state_id,
        'lga_id' => $transfer->studentBeforeTransfer->lga_id,
        'dob' => $transfer->studentBeforeTransfer->dob,
        'address' => $transfer->studentBeforeTransfer->address,
        'parent_fullname' => $transfer->studentBeforeTransfer->parent_fullname,
        'parent_address' => $transfer->studentBeforeTransfer->parent_address,
        'parent_phone' => $transfer->studentBeforeTransfer->parent_phone,
        'parent_email' => $transfer->studentBeforeTransfer->parent_email,
        'password' => $transfer->studentBeforeTransfer->password,
        'religion' => $transfer->studentBeforeTransfer->religion,
        'passport' => $transfer->studentBeforeTransfer->passport,
        'session' => $request->input('session'),
        'house_id' => $request->input('house_id'),
        'school_id' => Session::get('admin.school')
     ];

    $student_id = $this->students->setStudent()->create($insert)->id;

    $classarms = $this->classarm->find($request->input('classarm_id'));

    $classarms->students()->attach($student_id, ['session' => $request->input('session'), 'term' => $request->input('term'), 'class_id' => $request->input('class_id')]);

    return $student_id;
}

function superAdminViewTransferHistory(){

    if(auth('super_admin')->user()->cannot('view-transfer')){
        $title = 'Permission Deny';
        return view('errors.401', compact('title'));
    }

    $title = 'Super Admin View Transfer History';

    $transfers = Transfer::paginate(50);

    return view('super-admin.transfer.view-history', compact('title', 'transfers'));
}

function superAdminViewTransferLetter($id){
    if(auth('super_admin')->user()->cannot('view-transfer')){
        $title = 'Permission Deny';
        return view('errors.401', compact('title'));
    }

    $transfer = Transfer::find($id);

    if(count($transfer) > 0){

        $head_teachers = $this->classarm->find($transfer->classarm_id)
                                        ->teachers()
                                        ->wherePivot('session', $transfer->session)
                                        ->get();

        return view('super-admin.transfer.transfer-print-sheet',compact('transfer', 'head_teachers') );

    }

    flash('Something is wrong')->error();

    return redirect()->back();
}

}
