<?php

namespace App\Http\Controllers;

use DB;

use Illuminate\Http\Request;

use App\Http\Requests;

use Validator;

use Carbon\Carbon;

use Input;

use Auth;

use Session;

use App\Repositories\PermissionRepositoryInterface;

use App\Repositories\TaskRepositoryInterface;


class TaskController extends Controller
{
    protected $permission;

    protected $task;

    public function __construct(TaskRepositoryInterface $task, PermissionRepositoryInterface $permission){

        $this->permission = $permission;

        $this->task = $task;
    }

    public function createTask(){
        $super_admin_id = auth('super_admin')->id();

        $super_admins = DB::table('super_admins')
                            ->where('id', '!=', $super_admin_id)
                            ->orderBy('fullname', 'asc')
                            ->get();

        return view('super-admin.task.create', compact('super_admins'));
    }// End function


    public function createTaskProcess(Request $request)
    {
        $task = $this->task->setData();

        $super_admin_id = auth('super_admin')->id();
        
        $validate = Validator::make($request->all(), [
                'title' => 'required',
                'start_date' => 'required',
                'due_date' => 'required'
            ]);

        if($validate->passes()){

            if(empty($super_admin_id)){
                flash('Super Admin account failed authentication')->error();
                return redirect()->route('super_admin.task.create.new');             
            }
            else{
                $dbData = [
                    'title' => $request->title,
                    'descrip' => $request->descrip,
                    'start_date' => $request->start_date,
                    'due_date' => $request->due_date,
                    'task_status' => 1,
                    'approval' => 1,
                    'posted_by' => $super_admin_id,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now()
                ];  

                $task_id = $task->create($dbData)->id;

                if($task_id){
                    $task_data = $this->task->find($task_id);
                    $task_data->super_admins()->attach($super_admin_id);
                    flash('Task has been created successfully.')->success();
                    return redirect()->route('super_admin.task.create.new');
                }
                else{
                    flash('Something went wrong while processing submission. Pls try again shortly!')->error();
                    return redirect()->route('super_admin.task.create.new');
                }

            }

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }// End function


    public function viewTasks()
    {        
        $super_admin_id = auth('super_admin')->id();

        $tasks = DB::table('tasks')
                    ->where('posted_by', $super_admin_id)
                    ->get();

        return view('super-admin.task.view-all', compact('tasks'));
    }//End Method


    public function viewTaskBoard($id)
    {        
        $super_admin_id = auth('super_admin')->id();

        $super_admins = DB::table('super_admins')
                            ->where('id', '!=', $super_admin_id)
                            ->orderBy('fullname', 'asc')
                            ->get();

        $assigned_admins = DB::table('tasks_members')
                ->select('tasks_members.id', 'super_admins.fullname')
                ->where('tasks_members.task_id', $id)
                ->join('super_admins', 'super_admins.id', '=', 'tasks_members.super_admin_id')
                ->get(); 

        $task = DB::table('tasks')
                    ->where('posted_by', $super_admin_id)
                    ->where('id', $id)
                    ->first(); 

        return view('super-admin.task.board', compact('task', 'super_admins', 'assigned_admins'));
    }//End Method



    public function assignMembers(Request $request){

        $validate = Validator::make($request->all(), [
          'member_ids' => 'required',
          'task_id' => 'required'
        ]);

        if($validate->passes()){

            $task_data = $this->task->find($request->task_id); 

            $member_count = count($request->member_ids);

            if($member_count > 0){

                $current_members_array = array();

                $current_admins = DB::table('tasks_members')->select('super_admin_id')
                                            ->whereRaw('`task_id` = '.$request->task_id)
                                            ->get();

                if(!empty($current_admins)){
                    foreach($current_admins as $admin){
                        $current_members_array[] = $admin->super_admin_id;
                    }
                }

                $assign_member_ids = array_diff($request->member_ids, $current_members_array);

                if(count($assign_member_ids) > 0){

                    $task_data->super_admins()->attach($assign_member_ids);

                    $html = '<ul class="task_assigned_users">';

                    $super_admins_data = DB::table('tasks_members')
                                    ->select('tasks_members.id', 'super_admins.fullname')
                                    ->where('tasks_members.task_id', $request->task_id)
                                    ->join('super_admins', 'super_admins.id', '=', 'tasks_members.super_admin_id')
                                    ->get(); 

                    foreach ($super_admins_data as $super_admin) {
                        $html .= '<li>'.$super_admin->fullname.' <span class="remove_assigned_user">x</span></li>';
                    }

                    $html .= '</ul> <div class="clear"></div>';

                    echo $html;
                }
                else{
                    echo 2;
                }

            }
            else{
                echo 1;
            }
        }
        else{
            echo 1; 
        }


    }//End Method





/*





    public function libraryBookDetails($id)
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $book = DB::table('library')
                    ->select('library.*', 'library_category.name')
                    ->where('library.school_id', $school_id)
                    ->where('library.id', $id)
                    ->join('library_category', 'library_category.id', '=', 'library.cat_id')
                    ->first(); 

        return view('admin.library.book-details', compact('book'));
    }//End Method


    public function libraryBookCopyEdit($id)
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $book = DB::table('library')
                    ->select('library.*', 'library_category.name')
                    ->where('library.school_id', $school_id)
                    ->where('library.id', $id)
                    ->join('library_category', 'library_category.id', '=', 'library.cat_id')
                    ->first(); 

        return view('admin.library.book-copy-edit', compact('book'));
    }//End Method

    
    public function libraryBookCopyEditProcess(Request $request)
    {
        $library = $this->task->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'book_id' => 'required',
                'edit_action' => 'required',
                'copy_count' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

            $verify_book =  $this->task->find($request->book_id);

            if(empty($verify_book->id)){
                flash('Request aborted! Requested Book information failed authentication')->error();
                return redirect()->route('admin.library.book.copies.edit', ['id' => $request->book_id]);                
            }
            elseif(empty($request->edit_action)){
                flash('Your Desired Inventory Action must be chosen')->error();
                return redirect()->route('admin.library.book.copies.edit', ['id' => $request->book_id]);                
            }
            else{
                if($request->edit_action == 1){
                    $copy_update    =   $verify_book->available + $request->copy_count;
                    $edit_action    =   'added to'; 
                }
                else{
                    $copy_update    =   $verify_book->available - $request->copy_count;
                    $edit_action    =   'deducted from';    
                } 

                $library_data = $library->find($verify_book->id);
                $library_data->copies = $copy_update;
                $library_data->available = $copy_update;
                $data_update    =   $library_data->save();

                if($data_update){
                    flash($request->copy_count.' copies has been successfully '.$edit_action.' the Book Inventory.')->success();
                    return redirect()->route('admin.library.book.copies.edit', ['id' => $request->book_id]); 
                }
                else{
                    flash('Something went wrong while processing submission. Pls try again shortly!')->error();
                    return redirect()->route('admin.library.book.copies.edit', ['id' => $request->book_id]); 
                }

            }

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////  END: Library  ////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   




//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////  START: LibraryIssue  ///////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   

    public function libraryBookIssue()
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $classes = $this->classes->setClass()
                                ->where('school_id', $school_id)
                                ->get();

        $categories = $this->library_category->setData()
                                ->where('school_id', $school_id)
                                ->get();

        return view('admin.library.book-issue', compact('school_id', 'classes', 'categories'));
    }//End Method

    
    public function libraryBookIssueProcess(Request $request)
    {
        $library = $this->task->setData();
        $library_issue = $this->library_issue->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'book_id' => 'required',
                'student_id' => 'required',
                'issue_date' => 'required',
                'due_date' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

            $curr_date = date("Y-m-d", strtotime(Carbon::now()));
            
            $verify_book =  $this->task->find($request->book_id);
            $verify_student = $this->students->find($request->student_id);

            $verify_book_issued = $this->library_issue->setData()
                                ->where('school_id', $school_id)
                                ->where('book_id', $request->book_id)
                                ->where('issued_to', $request->student_id)
                                ->where('return_status', '!=', 2)
                                ->first();

            if($curr_date < $request->issue_date){
                flash('Request aborted! Issue date ('.$request->issue_date.') cannot be a future date')->error();
                return redirect()->route('admin.library.issue.book');                       
            }
            elseif($request->due_date < $request->issue_date){
                flash('Request aborted! Issued date ('.$request->issue_date.') must not be ahead of Due Date ('.$request->due_date.') on the calendar')->error();
                return redirect()->route('admin.library.issue.book');                       
            }
            elseif(empty($verify_book->id)){
                flash('Request aborted! Submitted Book information failed authentication')->error();
                return redirect()->route('admin.library.issue.book');               
            }
            elseif(empty($verify_student->id)){
                flash('Request aborted! Submitted Student information failed authentication')->error();
                return redirect()->route('admin.library.issue.book');                           
            }
            elseif(!empty($verify_book_issued['id'])){
                flash('Request aborted! A copy of this book had been issued to '.$verify_student->surname.' '.$verify_student->firstname.' and yet to be returned')->error();
                return redirect()->route('admin.library.issue.book');                           
            }
            elseif($verify_book->available < 1){
                flash('Request aborted! Book cannot be issued out. '.$verify_book->available.' copy of book left in the library')->error();
                return redirect()->route('admin.library.issue.book');                       
            }
            else{
                DB::beginTransaction();

                $new_available  =   $verify_book->available - 1;

                $dbData = [
                    'school_id' => $school_id,
                    'book_id' => $request->book_id,
                    'issued_to' => $request->student_id,
                    'issue_date' => $request->issue_date,
                    'due_date' => $request->due_date,
                    'issued_by' => $admin_id,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now()
                ];  

                $book_issue_id = $library_issue->create($dbData)->id;

                $library_data = $library->find($verify_book->id);
                $library_data->available = $new_available;
                $data_update    =   $library_data->save();

                if($book_issue_id && $data_update){
                    DB::commit();
                    flash('Selected Book ('.$verify_book->title.') has been successfully Issued out to '.$verify_student->surname.' '.$verify_student->firstname.'')->success();
                    return redirect()->route('admin.library.issue.book');
                }
                else{
                    DB::rollBack();
                    flash('Something went wrong while processing submission. Pls try again shortly!')->error();
                    return redirect()->route('admin.library.issue.book');
                }

            }

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method


    public function libraryBookReturn()
    {        
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $classes = $this->classes->setClass()
                                ->where('school_id', $school_id)
                                ->get();

        $categories = $this->library_category->setData()
                                ->where('school_id', $school_id)
                                ->get();

        return view('admin.library.book-return', compact('school_id', 'classes', 'categories'));
    }//End Method



    
    public function libraryBookReturnProcess(Request $request)
    {
        $library = $this->task->setData();
        $library_issue = $this->library_issue->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $admin_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'book_id' => 'required',
                'student_id' => 'required',
                'return_date' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($admin_id)){

            $curr_date = date("Y-m-d", strtotime(Carbon::now()));
            
            $verify_book =  $this->task->find($request->book_id);
            $verify_student = $this->students->find($request->student_id);

            $verify_issued_exist = $this->library_issue->setData()
                                ->where('school_id', $school_id)
                                ->where('book_id', $request->book_id)
                                ->where('issued_to', $request->student_id)
                                ->first();

            $verify_book_issued = $this->library_issue->setData()
                                ->where('school_id', $school_id)
                                ->where('book_id', $request->book_id)
                                ->where('issued_to', $request->student_id)
                                ->where('return_status', '!=', 2)
                                ->first();

            $verify_book_returned = $this->library_issue->setData()
                                ->where('school_id', $school_id)
                                ->where('book_id', $request->book_id)
                                ->where('issued_to', $request->student_id)
                                ->where('return_status', '=', 2)
                                ->first();

            if($curr_date < $request->return_date){
                flash('Request aborted! Return date ('.$request->return_date.') cannot be a future date')->error();
                return redirect()->route('admin.library.return.book');                      
            }
            elseif(empty($verify_book->id)){
                flash('Request aborted! Submitted Book information failed authentication')->error();
                return redirect()->route('admin.library.return.book');              
            }
            elseif(empty($verify_student->id)){
                flash('Request aborted! Submitted Student information failed authentication')->error();
                return redirect()->route('admin.library.return.book');                          
            }
            elseif(empty($verify_issued_exist['id'])){
                flash('Request aborted! Selected book has never been issued to '.$verify_student->surname.' '.$verify_student->firstname.'')->error();
                return redirect()->route('admin.library.return.book');                          
            }
            elseif(empty($verify_book_issued['id'])){
                flash('Request aborted! '.$verify_student->surname.' '.$verify_student->firstname.' has returned every copy of this book issued out')->error();
                return redirect()->route('admin.library.return.book');                          
            }
            elseif(!empty($verify_book_returned['id'])){
                flash('Request aborted! '.$verify_student->surname.' '.$verify_student->firstname.' has returned all issued copy of this book')->error();
                return redirect()->route('admin.library.return.book');                          
            }
            elseif($request->return_date < $verify_issued_exist['issue_date']){
                flash('Request aborted! Return date ('.$request->return_date.') cannot be a date behind Issue Date')->error();
                return redirect()->route('admin.library.return.book');                      
            }
            else{
                DB::beginTransaction();

                $new_available  =   $verify_book->available + 1;

                //Book Issuance Update
                $library_issue_data = $library_issue->find($verify_issued_exist->id);
                $library_issue_data->return_status = 2;
                $library_issue_data->return_date = $request->return_date;
                $issue_update   =   $library_issue_data->save();

                //Book Inventory Update
                $library_data = $library->find($verify_book->id);
                $library_data->available = $new_available;
                $inventory_update   =   $library_data->save();

                if($issue_update && $inventory_update){
                    DB::commit();
                    flash('Book ('.$verify_book->title.') issued out to '.$verify_student->surname.' '.$verify_student->firstname.' has been Returned')->success();
                    return redirect()->route('admin.library.return.book');
                }
                else{
                    DB::rollBack();
                    flash('Something went wrong while processing submission. Pls try again shortly!')->error();
                    return redirect()->route('admin.library.return.book');
                }

            }

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method


    public function getStudents(Request $request){

        return DB::table('students')
            ->select('students.id', 'students.surname', 'students.firstname', 'students.middlename', 'students.regnum')
            ->where('class_arms.school_id', $request->school_id)
            ->where('classarm_student.class_id', $request->class_id)
            ->where('students.session', $request->session)
            ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
            ->join('class_arms', 'classarm_student.classarm_id', '=', 'class_arms.id')
            ->get(); 
                
    }//End Method


    public function getCategoryBooks(Request $request){

        return $this->task->setData()
                    ->where('library.school_id', $request->school_id)
                    ->where('library.cat_id', $request->cat_id)
                    ->get();
                
    }//End Method

//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////  END: LibraryIssue  ///////////////////////////////
////////////////////////////////////////////////////////////////////////////////////// 

*/

}
