<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Repositories\NgStatesRepositoryInterface;

use App\Repositories\NgStatesLGARepositoryInterface;

use App\Repositories\OndoLGARepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\AdminRepositoryInterface;

use App\Repositories\PermissionRepositoryInterface;

use App\Repositories\SuperAdminRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentHouseRepositoryInterface;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use App\Repositories\PaymentRepositoryInterface;

use App\Repositories\PaymentItemsRepositoryInterface;

use App\Repositories\PaymentRecipientRepositoryInterface;

use App\Http\Requests;

use Validator;

use Hash;

use Image;

use App\Events\SchoolAdminCreate;

use Auth;

Use Gate;

use Input;

use App\NgStates;

use Excel;

use Carbon\Carbon;

use App\Permission;

use DB;

use App\SuperAdmin;

use App\Teacher;

use App\School;

use App\SchoolSurvey;

use App\Wallet;

use App\Student;

use App\Admin;

use App\Payment;

use App\Classes;

use App\UnityCenter;

use App\UnityHall;

use App\UnityExam;

use App\UnityHallAllocation;

use App\News;

use App\SchoolIDTemplate;

use App\StudentResult;

use App\Transaction;

use App\PaymentItems;

use App\DigitalPayment;

use App\StudentIDCardRequest;

use App\Subject;

use App\OndoLGA;

use App\ActivityLog;

use Zipper;

use File;


class SuperAdminController extends Controller
{
    protected $ngstates;

    protected $ngstate_lga;

    protected $schools;

    protected $payment;

    protected $payment_recipient;

    protected $payment_items;

    protected $school_admins;

    protected $permissions;

    protected $admin;

    protected $superadmin;

    protected $ondo_lga;

    protected $students;

    protected $teachers;

    protected $house;

    protected $class_arms;

    protected $classes;

    protected $subjects;

    public function __construct(NgStatesRepositoryInterface $ngstates, NgStatesLGARepositoryInterface $ngstate_lga, SchoolRepositoryInterface $schools, AdminRepositoryInterface $school_admins, PermissionRepositoryInterface $permissions, AdminRepositoryInterface $admin, SuperAdminRepositoryInterface $superadmin, OndoLGARepositoryInterface $ondo_lga, StudentRepositoryInterface $student,TeacherRepositoryInterface $teacher,StudentHouseRepositoryInterface $house,ClassArmRepositoryInterface $class_arm, ClassRepositoryInterface $classes, SubjectRepositoryInterface $subject, PaymentRepositoryInterface $payment, PaymentRecipientRepositoryInterface $payment_recipient, PaymentItemsRepositoryInterface $payment_items){

        $this->middleware('auth:super_admin');

        $this->ngstates = $ngstates;

        $this->ngstate_lga = $ngstate_lga;

        $this->schools = $schools;

        $this->payment = $payment;

        $this->payment_recipient = $payment_recipient;

        $this->payment_items = $payment_items;

        $this->admin = $admin;

        $this->permissions = $permissions;

        $this->superadmin = $superadmin;

        $this->ondo_lga = $ondo_lga;

        $this->students = $student;

        $this->teachers = $teacher;

        $this->school_houses = $house;

        $this->class_arms = $class_arm;

        $this->classes = $classes;

        $this->subjects = $subject;


    }


    protected function permissionDeny($ability){
        Auth::shouldUse('super_admin');
        return Gate::denies($ability);
    }


    public function dashboard(){

        $title = "Super Admin Dashboard";
        $noAutoAd = true;

        $super_admin_id = auth('super_admin')->id();

        return view('super-admin.dashboard', compact('title', 'super_admin_id', 'noAutoAd'));

    }

    public function viewSchool(){
        $title = 'View School';

        $schools = $this->schools->setSchool()->paginate(20);

        //$schools = 

        return view('super-admin.school.view-school', compact('title', 'schools'));
    }

    public function createSchool(){

        $title = "Create School";

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        return view('super-admin.school.create-school', compact('title', 'ngstate', 'ngstate_lgas'));
    }

    public function registerSchool(Request $request){

        $setSchool = $this->schools->setSchool();

        $validate = Validator::make($request->all(), $setSchool::$rules);

        if($validate->passes()){

            $school = $setSchool->create([
                    'name' => $request->input('school'),
                    'state_id' => $request->input('state_id'),
                    'lga_id' => $request->input('lga_id'),
                    'school_category' => $request->input('school_category'),
                    'address' => $request->input('address')
                ]);

            if ($request->hasFile('logo'))
            {
                // if ($student->schoo != '/images/passports/no_img_da88a72526.gif') {
                //     if(file_exists(public_path(explode('?', ltrim($student->passport, '/'))[0])))
                //     {
                //         unlink( public_path(explode('?', ltrim($student->passport, '/'))[0]) );
                //     }
                // }
                $image = $request->file('logo');

                $school_name = $request->input('school');
                $school_name = str_replace("/", "-", $school_name);
                $school_name = str_replace("\"", "-", $school_name);
                
                $school_logo_path = md5(time())."-".$school_name.".".$image->getClientOriginalExtension();
                
                Image::make($image->getRealPath())->resize(300,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/school_logos/'.$school_logo_path);

                $school->logo = '/images/school_logos/'.$school_logo_path.'?cache='.time();

                $school->save();


            }

                flash('You have successfully created school')->success();

                return redirect()->route('super_admin.dashboard');
        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }

    public function editSchool($id){
        $title = 'Edit School';

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        $school = $this->schools->find($id);

        return view('super-admin.school.edit-school', compact('title', 'ngstate', 'ngstate_lgas', 'school'));

    }

    public function updateSchool($id, Request $request){

        $setSchool = $this->schools->find($id);

        $school_id_template = new SchoolIDTemplate;

        $setSchoolIdTemplate = $school_id_template->where('school_id', $id)->first();


        $validate = Validator::make($request->all(), $setSchool::$rules);

        if($validate->passes()){

            $setSchool->update([
                    'name' => $request->input('school'),
                    'state_id' => $request->input('state_id'),
                    'lga_id' => $request->input('lga_id'),
                    'school_category' => $request->input('school_category'),
                    'address' => $request->input('address')
                ]);

             if ($request->hasFile('logo'))
            {
                if ($setSchool->logo != '/images/school_logos/Nigerian-Coat-of-Arm-icon.png') {
                    if(file_exists(public_path(explode('?', ltrim($setSchool->logo, '/'))[0])))
                    {
                        unlink( public_path(explode('?', ltrim($setSchool->logo, '/'))[0]) );
                    }
                }
                $image = $request->file('logo');

                $school_logo_path = md5(time())."-".$request->input('school').".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(300,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/school_logos/'.$school_logo_path);

               $setSchool->logo = '/images/school_logos/'.$school_logo_path.'?cache='.time();

               $setSchool->save();

               // Save Logo for ID Template
                $schoolIdTemplate_logo_path = time()."-".str_slug($request->input('school')).".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(200,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/school-id-template/school-logo-new-dimension/'.$schoolIdTemplate_logo_path);

                $setSchoolIdTemplate->school_id_logo = '/images/school-id-template/school-logo-new-dimension/'.$schoolIdTemplate_logo_path;

                $setSchoolIdTemplate->save(); 

            }

            flash('You have successfully updated school')->success();

            return redirect()->route('super_admin.dashboard');
        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }


    public function deleteSchool($id){

        flash('Successfully Delete School')->success();

        $this->schools->find($id)->delete();

        return redirect()->route('super_admin.dashboard');
    }

    public function viewSchoolAdmin(){
        $title = 'View School';

        $school_admins = $this->admin->setAdmin()->paginate(10);

        //dd($schools);

        return view('super-admin.school-admin.view-school-admin', compact('title', 'school_admins'));
    }

    public function createSchoolAdmin(){

        $title = "Create School";

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        return view('super-admin.school-admin.create-school-admin', compact('title', 'ngstate', 'ngstate_lgas'));
    }

    public function registerSchoolAdmin(Request $request){

        $setSchoolAdmin = $this->admin->setAdmin();

        unset($setSchoolAdmin::$rules['permissions']);

        $validate = Validator::make($request->all(), $setSchoolAdmin::$rules);

        if($validate->passes()){

            $superadmin = $this->superadmin->setSuperAdmin();

            //dd($request->input('school'));

            $school_admin = $setSchoolAdmin->create([
                    'fullname' => $request->input('fullname'),
                    'email' => $request->input('email'),
                    'username' => $request->input('username'),
                    'school_id' => $request->input('school'),
                    'status' => 1,
                    'phone' => $request->input('phone'),
                    'password' => Hash::make($request->input('password'))
                ]);

            $school_admin->permissions()->attach($superadmin::$schoolAdminPermissions);

            $message = urlencode("School Account has been created. username = ".$request->username." and Password = ". $request->password.".Check ".$request->email." for more details");

            prepareSMSGateWay(urlencode('ODSGMOE'), urlencode($request->phone), $message);

            event(new SchoolAdminCreate($school_admin, $request->input('password')));

            flash('You have successfully created school Admin')->success();

            return redirect()->route('super_admin.dashboard');
        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }

    public function editSchoolAdmin($id){
        $title = 'Edit School';

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        $school_admin = $this->admin->find($id);

        $admin_school = $school_admin->schools;

        return view('super-admin.school-admin.edit-school-admin', compact('title', 'ngstate', 'ngstate_lgas', 'school_admin', 'admin_school'));

    }

    public function updateSchoolAdmin($id, Request $request){

        $setSchool = $this->admin->find($id);

        $setSchoolAdmin = $this->admin->setAdmin();

        unset($setSchoolAdmin::$rules['password']);

        unset($setSchoolAdmin::$rules['password_confirmation']);

        unset($setSchoolAdmin::$rules['permissions']);

        $setSchoolAdmin::$rules['email'] = 'required|email|unique:admins,email,'.$id;
        $setSchoolAdmin::$rules['username'] = 'required|min:4|unique:admins,username,'.$id;
         $setSchoolAdmin::$rules['phone'] = 'required|regex:(234?)|digits:13|unique:admins,phone,'.$id;

        $validate = Validator::make($request->all(), $setSchool::$rules);

        if($validate->passes()){

            $setSchool->update([
                    'fullname' => $request->input('fullname'),
                    'email' => $request->input('email'),
                    'username' => $request->input('username'),
                    'school_id' => $request->input('school'),
                    'phone' => $request->input('phone')
                ]);

            flash('You have successfully updated school admin')->success();

            return redirect()->route('super_admin.dashboard');
        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }


    public function deleteSchoolAdmin($id){

        flash('Successfully Delete School')->success();

        $admin = $this->admin->find($id);

        $admin->permissions()->detach();

        $admin->delete();

        return redirect()->route('super_admin.dashboard');
    }

    public function password($id){
        $title = 'School Admin Password Update';

        return view('super-admin.password', compact('title'));
    }

    public function passwordUpdate($id, Request $request){

        $setSchoolAdmin = $this->admin->setAdmin();

        $validate = Validator::make($request->all(), $setSchoolAdmin::$schoolAdminPasswordRule);

        if($validate->passes()){
            $superadmin = $this->superadmin->find($id);

            $superadmin->password = Hash::make($request->input('password'));

            $superadmin->save();

            flash('Successfully updated Ministry Admin Password')->success();

            return redirect()->route('super_admin.dashboard');

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

    }


    function viewStudent(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $title = 'View Student';

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        $data = [];

        $students = $this->students->setStudent()
                                    ->where('school_id', 0)
                                    ->paginate(20);

        return view('super-admin.students.view', compact('ngstate_lgas', 'title', 'data', 'students', 'ngstate'));
    }

    function viewStudentPage(Request $request){
        
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'school' => 'required',
                                                'class_id' => 'required',
                                                'session' => 'required',
                                                'class_arm_id' => 'required',
                                                'term' => 'required'
                                            ]);

        if($validate->passes()){

                $title = 'View Student';

                $ngstate =  $this->ngstates->find(28);

                $ngstate_lgas = $ngstate->ondo_lga;

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                    }
                }

                $session = $request->session;
                $term = $request->term;
                $classarm = $request->class_arm_id;
                $class_id = $request->class_id;
                $school = $request->school;
        
                $sql = "SELECT `s`.*, `cs`.`classarm_id`, `cs`.`session`, `cs`.`term`, `cs`.`class_id` FROM `students` as `s` LEFT JOIN `classarm_student` as `cs` ON `s`.`id` = `cs`.`student_id` WHERE `cs`.`classarm_id` = '$classarm' AND `cs`.`session` = '$session' AND `cs`.`term` = '$term' AND `cs`.`class_id` = '$class_id' AND `s`.`school_id` = '$school'";


                $students = fetchDataTableWithSql($sql, 50);
        
                Input::flash();
        
                return view('super-admin.students.view', compact('data', 'students', 'ngstate', 'ngstate_lgas'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }
    
    function createStudent(){
        
        if($this->permissionDeny('create-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $school_ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $school_ngstate->ondo_lga;

        $ngstates = NgStates::all();

        return view('super-admin.students.create', compact('ngstates', 'school_ngstate', 'ngstate_lgas', 'classes', 'class_arms', 'school_houses'));
    }

    function batchCreateStudent(){
        
        if($this->permissionDeny('create-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }


        $school_ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $school_ngstate->ondo_lga;

        return view('super-admin.students.batch-create', compact('ngstates', 'school_ngstate', 'ngstate_lgas','classes', 'class_arms', 'school_houses'));
    }

     function registerStudent(Request $request){


        if($this->permissionDeny('create-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->setStudent();

        $student::$rules['school'] = 'required';

        $validate = Validator::make($request->all(), $student::$rules);

        $session = $request->input('session');
        

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
            if(!in_array($key, array('_token','password_confirmation', 'school_state_id', 'school_lga_id')) && !empty($value)){
                    if($key == 'password'){
                        $insert[$key] = Hash::make($value);
                    }elseif($key == 'school'){
                        $insert['school_id'] = $value;
                    }elseif(in_array($key, array('term','class_id','class_arm_id'))){
                        continue;
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }

           $regnum = $this->students->getRegNumPrefix($request->session, $request->school).str_pad($this->students->getNextRegNum($request->session, $request->school), 3, 0, STR_PAD_LEFT);

            $insert['regnum'] = $regnum;
            
           $student_id = $student->create($insert);


           $student_id->classarms()->attach($request->input('class_arm_id'), ['session' => $request->input('session'), 'term' => $request->input('term'), 'class_id' => $request->input('class_id')]);

           flash('You have successfully create a student')->success();

            return redirect()->back();

        }else{

            flash('Something is wrong')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }

    function editStudent($id){


            if($this->permissionDeny('edit-student')){
                $title = 'Permission Deny';
                return view('errors.401', compact('title'));
            }
            $student = $this->students->find($id);

            $student_class =  $student->classarms()->wherePivot('session', '=',$student->session)
                ->orderBy('term', 'desc')
                ->first();

            $school_ngstate =  $this->ngstates->find(28);

            $ngstate_lgas = $school_ngstate->ondo_lga;

            $ngstates = NgStates::all();

            $classes = $this->classes->setClass()
                                ->where('school_id', $student->school_id)
                                ->get();
                                
            $class_arms = $this->class_arms->setClassArms()
                                    ->where('school_id', $student->school_id)
                                    ->get();

            $school_houses = $this->school_houses->setSchoolHouse()
                                    ->where('school_id', $student->school_id)
                                    ->get();

            return view('super-admin.students.edit', compact('ngstates', 'school_ngstate', 'ngstate_lgas', 'classes', 'class_arms','student', 'student_class', 'school_houses'));


    }

    function updateStudent(Request $request, $id){
        
        if($this->permissionDeny('edit-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student_update = $this->students->find($id);

        $student = $this->students->setStudent();

        $student::$rules['password'] = 'sometimes|alpha_num|min:6|confirmed';
        $student::$rules['password_confirmation'] = 'sometimes|alpha_num|min:6';
        $student::$rules['parent_email'] = '';

        $validate = Validator::make($request->all(), $student::$rules);

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
            if(!in_array($key, array('_token','password_confirmation', '_method', 'school_state_id', 'school_lga_id')) && !empty($value)){
                    if($key == 'password' && !empty($value)){
                        $insert[$key] = Hash::make($value);
                    }elseif($key == 'school'){
                        if($student_update->schools->id != $value ){
                            $insert['school_id'] = $value;
                            $insert['regnum'] = $this->students->getRegNumPrefix($request->session, $request->school).str_pad($this->students->getNextRegNum($request->session), 3, 0, STR_PAD_LEFT);

                        }
                    }elseif(in_array($key, array('term','class_id','class_arm_id'))){
                        continue;
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }

           

           $student_update->update($insert);

           $exit_student_class = \DB::table('classarm_student')->select('student_id')->whereRaw('`classarm_id` = '.$request->class_arm_id.' AND `student_id` = '.$id.' AND `session` = '.$request->session)
                                        ->get();

            if(collect($exit_student_class)->count() == 0){

               $student_update->classarms()->attach($request->input('class_arm_id'), ['session' => $request->input('session'), 'term' => $request->input('term'), 'class_id' => $request->input('class_id')]);
           }

           flash('You have successfully updated student info')->success();


            return redirect()->back();

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }

    function batchRegisterStudent(Request $request){


        if($this->permissionDeny('create-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->setStudent();

        $student::$ruleBatch['school'] = 'required';

        $validate = Validator::make($request->all(), $student::$ruleBatch);

        if($validate->passes()){

                if($request->hasFile('batch_file')){
                    $school_houses = $this->school_houses->setSchoolHouse()
                                    ->where('school_id', $request->school)
                                    ->get();
                    $school_houses_id = array_pluck($school_houses->toArray(), 'id');
                    $session = $request->input('session');
                    $std_count = $this->students->getNextRegNum($session, $request->school);
                    $house_count = $school_houses->count();
                    $path = $request->file('batch_file')->getRealPath();
                    $ext = $request->file('batch_file')->getClientOriginalExtension();
                    $duplicacy = array();
                    $insert = array();
                    $student_id = array();
                    $row_counter = 2;
                    $data = Excel::load($path, function($reader) {
                    })->get();

                    if(!empty($data) && $data->count()){
                        if(in_array($ext, ['xls', 'xlsx'])){
                            foreach ($data as $key => $value) {
                                   // dd($value);
                                    $check_duplicacy = $this->students->checkForDuplicacy((string)$value->parent_phone, $value->surname, $value->firstname, $session);
                                    if($check_duplicacy){
                                       if(empty($value->surname) || empty($value->firstname) || empty($value->phone)  || empty($value->password)   || empty($value->gender)   || empty($value->address)   || empty($value->country)){
                                                $duplicacy[] = 'Either student\'s surname, firstname, middlename, gender, address, country or password in row '.$row_counter.' is empty';
                                            }else{
                                                $stud_blood_group = trim($value->blood_group);
                                                if($stud_blood_group != '' || !empty($stud_blood_group)){
                                                    $bloodGroup = $stud_blood_group;
                                                }else{
                                                    $bloodGroup = "Unknown";
                                                }
                                            $insert = [
                                                'regnum' => $this->students->getRegNumPrefix($session, $request->school).str_pad($this->students->getNextRegNum($session, $request->school), 3, 0, STR_PAD_LEFT),
                                                'surname' => $value->surname,
                                                'firstname' => $value->firstname,
                                                'middlename' => $value->middlename,
                                                'phone' => $value->phone,
                                                'gender' => $value->gender,
                                                'country' => $value->country,
                                                'address' => $value->address,
                                                'parent_fullname' => $value->parent_fullname,
                                                'parent_address' => $value->parent_address,
                                                'parent_phone' => $value->parent_phone,
                                                'parent_email' => $value->parent_email,
                                                'blood_group' => $bloodGroup,
                                                'password' => Hash::make($value->password),
                                                'session' => $session,
                                                'house_id' => ($school_houses_id[($std_count % $house_count)]),
                                                'school_id' => $request->school,
                                                'created_at' => Carbon::now(),
                                                'updated_at' => Carbon::now()
                                                ];

                                                $std_count++;


                                            $student_id[] = $student->create($insert)->id;
                                        }
                                            
                                    }else{
                                        $duplicacy[] = $value->surname.' '.$value->firstname.' '.$value->middlename.' already exit';
                                    }

                                $row_counter++;
                            }
                        }

                        if((count($student_id) > 0) && empty($duplicacy)){

                            $classarms = $this->class_arms->find($request->input('class_arm_id'));

                            $classarms->students()->attach($student_id, ['session' => $request->input('session'), 'term' => $request->input('term'), 'class_id' => $request->input('class_id')]);

                            flash('Successfully inserted '.count($student_id).' Students')->success();

                            return redirect()->back();  
                        }elseif((count($student_id) > 0) && !empty($duplicacy)){

                            $classarms = $this->class_arms->find($request->input('class_arm_id'));

                            $classarms->students()->attach($student_id, ['session' => $request->input('session'), 'term' => $request->input('term')]);


                            flash($duplicacy)->error();

                            flash('Successfully inserted '.count($student_id).' Students')->success();

                            return redirect()->back()
                                             ->withInput();  
                        }else{

                            flash($duplicacy)->error();

                            return redirect()->back()
                                             ->withInput();  

                        }
                    }
                }
                
               return redirect()->back();     
        }else{
                return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }


    function deleteStudent(Request $request, $id){


        if($this->permissionDeny('delete-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->find($id);


        $fullname = $student->surname.' '.$student->firstname.' '.$student->middlename;

        $student->classarms()->detach();
        $student->delete();

            flash('You have successfully deleted '.$fullname)->success();

            return redirect()->route('admin.view.school.students');
    }




    function viewTeacher(){
        if($this->permissionDeny('view-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $title = 'View Teacher';

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        $data = [];

        $teachers = $this->teachers->setTeacher()
                                    ->where('school_id', 0)
                                    ->paginate(20);

        return view('super-admin.teachers.view', compact('ngstate_lgas', 'title', 'data', 'teachers', 'ngstate'));
    }

    function viewTeacherPage(Request $request){

        
        if($this->permissionDeny('view-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'school' => 'required'
                                            ]);

        if($validate->passes()){

        //dd($request->all());
                $title = 'View Teacher';

                $ngstate =  $this->ngstates->find(28);

                $ngstate_lgas = $ngstate->ondo_lga;

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;

                    }
                }

                $datum['school_id'] = $request->school;


                $teachers = fetchDataTable('teachers', $datum, 50);
        
                Input::flash();
        
                return view('super-admin.teachers.post-view', compact('data', 'teachers', 'ngstate', 'ngstate_lgas'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }
    
    function createTeacher(){
        
        if($this->permissionDeny('create-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $school_ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $school_ngstate->ondo_lga;

        $ngstates = NgStates::all();

        return view('super-admin.teachers.create', compact('ngstates', 'school_ngstate', 'ngstate_lgas', 'classes', 'class_arms', 'school_houses'));
    }

    function batchCreateTeacher(){
        
        if($this->permissionDeny('create-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }


        $school_ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $school_ngstate->ondo_lga;

        return view('super-admin.teachers.batch-create', compact('ngstates', 'school_ngstate', 'ngstate_lgas'));
    }


     function registerTeacher(Request $request){

        if($this->permissionDeny('create-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $teacher = $this->teachers->setTeacher();

        $teacher::$rules['school'] = 'required';

        $validate = Validator::make($request->all(), $teacher::$rules);

        $session = $request->input('session');

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
            if(!in_array($key, array('_token','password_confirmation','school_state_id', 'school_lga_id', 'subjects')) && !empty($value)){
                    if($key == 'password'){
                        $insert[$key] = Hash::make($value);
                    }elseif($key == 'school'){
                        $insert['school_id'] = $value;
                    }elseif(in_array($key, array('term','class_id','class_arm_id', ))){
                        continue;
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }

           $get_staff_no_session = $this->teachers->getNextStaffDigit($session, $request->school);

           $error_check = 0;

            $insert['staff_no'] = 'ONDO/'.str_pad($request->school, 4, 0, STR_PAD_LEFT).'/STAFF/'.$session.'/'.str_pad($get_staff_no_session, 4, 0, STR_PAD_LEFT);
            $insert['school_id'] = $request->school;
            $insert['staff_no_digit'] = $get_staff_no_session;
        
            $teacher_check_row = $this->teachers->setTeacher()
                                ->where('staff_no', $insert['staff_no'])
                                ->count();
            $error_check = ($teacher_check_row == 0) ? $error_check: $error_check++;

            $emailTeacherVerify = $this->teachers->setTeacher()
                                        ->where('school_id', $request->school)
                                        ->where('email', strtolower(trim($request->email)))
                                        ->first();
            $error_check = (empty($emailTeacherVerify->id)) ? $error_check: $error_check++;
                            
            $phoneTeacherVerify = $this->teachers->setTeacher()
                                        ->where('school_id', $request->school)
                                        ->where('phone', trim($request->phone))
                                        ->first();
            $error_check = (empty($phoneTeacherVerify->id)) ? $error_check: $error_check++;


           if($error_check == 0){                 
                $staff = $teacher->create($insert);

                $staff->subjects()->attach($request->subjects, ['school_id' => $request->school]);

                flash('You have successfully register a teacher')->success();

                return redirect()->back();
            }
            else{
                flash('Something went wrong while processing data. Pls try again shortly!')->error();
                return redirect()->back();
            }

        }else{

            flash('Something is wrong')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }

    function editTeacher($id){


            if($this->permissionDeny('edit-teacher')){
                $title = 'Permission Deny';
                return view('errors.401', compact('title'));
            }
            $teacher = $this->teachers->find($id);

            $teacher_class =  $teacher->classarms()->wherePivot('session', '=',$teacher->session)
                                            ->first();

            $school_ngstate =  $this->ngstates->find(28);

            $ngstate_lgas = $school_ngstate->ondo_lga;

            $ngstates = NgStates::all();

            $classes = $this->classes->setClass()
                                ->where('school_id', $teacher->school_id)
                                ->get();
                                
            $class_arms = $this->class_arms->setClassArms()
                                    ->where('school_id', $teacher->school_id)
                                    ->get();

            $school_houses = $this->school_houses->setSchoolHouse()
                                    ->where('school_id', $teacher->school_id)
                                    ->get();

            $subjects = $this->subjects->setSubject()
                                ->get();


            $teacher_subjects = array_pluck($teacher->subjects()->get(), 'id');

            return view('super-admin.teachers.edit', compact('ngstates', 'school_ngstate', 'ngstate_lgas', 'classes', 'class_arms','teacher', 'teacher_class', 'school_houses', 'subjects', 'teacher_subjects'));


    }

    function updateTeacher(Request $request, $id){
        
        if($this->permissionDeny('edit-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $teacher_update = $this->teachers->find($id);

        $teacher = $this->teachers->setTeacher();

        $teacher::$rules['password'] = 'sometimes|alpha_num|min:6|confirmed';

        $teacher::$rules['password_confirmation'] = 'sometimes|alpha_num|min:6';

        $teacher::$rules['parent_email'] = '';

        $validate = Validator::make($request->all(), $teacher::$rules);

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
            if(!in_array($key, array('_token','password_confirmation', '_method','school_state_id', 'school_lga_id')) && !empty($value)){
                    if($key == 'password' && !empty($value)){
                        $insert[$key] = Hash::make($value);
                    }elseif($key == 'school'){
                        if($teacher_update->schools->id != $value ){
                            $insert['school_id'] = $value;

                            $get_staff_no_session = $this->teachers->getNexStafNum($session, $request->school);

                           $insert['staff_no'] = 'ONDO/'.str_pad($request->school, 4, 0, STR_PAD_LEFT).'/STAFF/'.$session.'/'.str_pad($get_staff_no_session, 4, 0, STR_PAD_LEFT);
            

                        }
                    }elseif(in_array($key, array('term','class_id','class_arm_id'))){
                        continue;
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }

           

           $teacher_update->update($insert);

           $exit_teacher_class = \DB::table('classarm_teacher')->select('teacher_id')->whereRaw('`classarm_id` = '.$request->class_arm_id.' AND `teacher_id` = '.$id.' AND `session` = '.$request->session)
                                        ->get();

            if(collect($exit_teacher_class)->count() == 0){

               $teacher_update->classarms()->attach($request->input('class_arm_id'), ['session' => $request->input('session'), 'term' => $request->input('term'), 'class_id' => $request->input('class_id')]);
           }

           flash('You have successfully updated teacher info')->success();


            return redirect()->back();

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }


    function batchRegisterTeacher(Request $request){


        if($this->permissionDeny('create-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $teacher = $this->teachers->setTeacher();

        $teacher::$ruleBatch['school'] = 'required';

        $validate = Validator::make($request->all(), $teacher::$ruleBatch);

        if($validate->passes()){

                if($request->hasFile('batch_file')){
                    $session = $request->input('session');
                    $std_count = $this->teachers->getNextStaffDigit($session, $request->school);
                    $path = $request->file('batch_file')->getRealPath();
                    $ext = $request->file('batch_file')->getClientOriginalExtension();
                    $duplicacy = array();
                    $insert = array();
                    $email_checker = array();
                    $row_counter = 2;
                    $data = Excel::load($path, function($reader) {
                    })->get();
                                        
                    $school_id = $request->school;

                    if(!empty($data) && $data->count()){
                        if(in_array($ext, ['xls', 'xlsx', 'csv'])){
                            foreach ($data as $key => $value) {

                                    $emailTeacherVerify = Teacher::where('school_id', $school_id)
                                                    ->where('email', strtolower(trim($value->email)))
                                                    ->first();
                                                    
                                    $phoneTeacherVerify = Teacher::where('school_id', $school_id)
                                                    ->where('phone', trim($value->phone))
                                                    ->first();

                                    $emailTeacherAllVerify = Teacher::where('email', strtolower(trim($value->email)))
                                                    ->first();
                                                    
                                    $phoneTeacherAllVerify = Teacher::where('phone', trim($value->phone))
                                                    ->first();

                                     if(empty($emailTeacherVerify->id)){
                                        if(empty($phoneTeacherVerify->id)){
                                            if(empty($emailTeacherAllVerify->id)){
                                                if(empty($phoneTeacherAllVerify->id)){
                                                    ///// ALL CLEAR /////
        
                                                    if(in_array($value->email, $email_checker) || empty($value->email))
                                                    {
                                                        $duplicacy[] = 'Teacher\'s email in row '.$row_counter.' already exist in the upload file OR email field is empty';
                                                    }else{
                                                        $staff_no = 'ONDO/'.str_pad($school_id, 4, 0, STR_PAD_LEFT).'/STAFF/'.$session.'/'.str_pad($std_count, 4, 0, STR_PAD_LEFT);
                                                        $teacher_check_row = $this->teachers->setTeacher()
                                                            ->where('staff_no', $staff_no)
                                                            ->count();
                                                        
                                                        if($teacher_check_row == 0){ 
                                                            
                                                            if(empty($value->surname) || empty($value->firstname) || empty($value->phone) || empty($value->email) || empty($value->password)){
                                                                $duplicacy[] = 'Either teacher\'s surname, firstname, middlename, phone, email or password in row '.$row_counter.' is empty';
                                                            }else{
                                                                
                                                            $insert[] = [
                                                                'staff_no' => $staff_no,
                                                                'staff_no_digit' => $std_count,
                                                                'title' => $value->title,
                                                                'surname' => $value->surname,
                                                                'firstname' => $value->firstname,
                                                                'middlename' => $value->middlename,
                                                                'marital_status' => $value->marital_status,
                                                                'phone' => trim($value->phone),
                                                                'gender' => $value->gender,
                                                                'email' => strtolower(trim($value->email)),
                                                                'address' => $value->address,
                                                                'next_of_kins' => $value->next_of_kins,
                                                                'next_of_kins_address' => $value->next_of_kins_address,
                                                                'next_of_kins_phone' => $value->next_of_kins_phone,
                                                                'next_of_kins_email' => $value->next_of_kins_email,
                                                                'password' => Hash::make($value->password),
                                                                'session' => $session,
                                                                'qualification' => $value->qualification,
                                                                'health_status' => $value->health_status,
                                                                'school_id' => $school_id,
                                                                'health_status_desc' => $value->health_status_description,
                                                                'extra_curricular_activites' => $value->extra_curricular_activities,
                                                                'created_at' => Carbon::now(),
                                                                'updated_at' => Carbon::now()
                
                                                                ];
                
                                                                $email_checker[] = $value->email;
                                                                
                                                            }
                                                        }
                                                        else{
                                                            $duplicacy[] = 'Teacher\'s staff no ('.$staff_no.') in '.$row_counter.' already exist'; 
                                                        }
                                                    }//
                                                    
                                                    ///// ALL CLEAR /////
                                                }
                                                else{
                                                    $exist_school_name = getSchoolName($phoneTeacherAllVerify->school_id);
                                                    $duplicacy[] = $value->phone.' already exist in another School ('.$exist_school_name.')';
                                                }
                                            }
                                            else{
                                                $exist_school_name = getSchoolName($emailTeacherAllVerify->school_id);
                                                $duplicacy[] = $value->email.' already exist in another School ('.$exist_school_name.')';
                                            }
                                        }else{
                                         $duplicacy[] = $value->phone.' already exist, register with another phone number';
                                        }
                                            
                                     }else{
                                         $duplicacy[] = $value->email.' already exist, register with another email address';
                                     }

                                    $std_count++;

                                    $row_counter++;
                                }//end loop
                            }//end csv
                    }
                                                
                    if(!empty($insert) && empty($duplicacy)){
                        $teacher->insert($insert);

                        flash('Successfully inserted '.count($insert).' teachers')->success();

                        return redirect()->back()
                                         ->withInput(); 

                    }elseif(!empty($insert) && !empty($duplicacy)){
                        $teacher->insert($insert);

                        flash('Successfully inserted '.count($insert).' Students')->success();

                        flash($duplicacy)->error();

                        return redirect()->back()
                                         ->withInput();  
                    }else{

                        flash($duplicacy)->error();

                        return redirect()->back()
                                         ->withInput();  

                    }
                }   
                return redirect()->back();
        }else{

            flash('Something is wrong')->error();
                return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }


    function deleteTeacher(Request $request, $id){


        if($this->permissionDeny('delete-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $teacher = $this->teachers->find($id);


        $fullname = $teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename;

        $teacher->subjects()->detach();
        $teacher->delete();

            flash('You have successfully deleted '.$fullname)->success();

            return redirect()->route('super_admin.view.teacher');
    }

    public function permissionsView()
    {
        $this->validateTopMinistryUser();
        if(isset($_GET['for']) && $_GET['for'] == 'teachers'){
            $title = 'Edit Teachers Permissions';
            $ngstate =  $this->ngstates->find(28);

            $ngstate_lgas = $ngstate->ondo_lga;

            $data = [];

            $teachers = $this->teachers->setTeacher()
                                        ->where('school_id', 0)
                                        ->paginate(20);
            $teachers->setPath('edit-permissions?for=teachers');

            return view('super-admin.permissions', compact('ngstate_lgas', 'title', 'data', 'teachers', 'ngstate'));

        }elseif(isset($_GET['for']) && $_GET['for'] == 'school-admins'){
            $title = 'Edit School Adminis Permissions';

            $school_admins = $this->admin->setAdmin()->paginate(10);
            $school_admins->setPath('edit-permissions?for=school-admins');
            return view('super-admin.permissions', compact('title', 'school_admins'));

        }elseif(isset($_GET['for']) && $_GET['for'] == 'ministry-admins'){
            $title = 'Edit Ministry Adminis Permissions';

            $ministry_admins = DB::table('super_admins')->paginate(15);
            $ministry_admins->setPath('edit-permissions?for=ministry-admins');
            return view('super-admin.permissions', compact('title', 'ministry_admins'));
            
        }else{
            $title = 'Edit Permissions';
            return view('super-admin.permissions', compact('title'));
        }
    }
    function permissionViewTeacherPage(Request $request){

        
        if($this->permissionDeny('view-teacher')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'school' => 'required'
                                            ]);

        if($validate->passes()){

        //dd($request->all());
                $title = 'View Teacher';

                $ngstate =  $this->ngstates->find(28);

                $ngstate_lgas = $ngstate->ondo_lga;

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;

                    }
                }

                $datum['school_id'] = $request->school;


                $teachers = fetchDataTable('teachers', $datum, 50);
        
                Input::flash();
        
                return view('super-admin.permissions.teachers-post-view', compact('data', 'teachers', 'ngstate', 'ngstate_lgas'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }

    public function viewUserPermissions(Request $request)
    {
        $this->validateTopMinistryUser();
        $bag = array();
        $allPerms = Permission::all();
        if($request->type == 'teacher'){
            //get teachers perms
            foreach ($allPerms as $perm) {
                //check teacher permission where permission id and  teacher id exists
                $teacherPerm = DB::table('class_teacher_permission')->where('permission_id', $perm->id)->where('teacher_id', $request->id)->first();
                if($teacherPerm){
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'checked',
                    );
                }else{
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'unchecked',
                    );
                }
            }
            return $bag;

        }elseif($request->type == 'school-admin'){
            //get teachers perms
            foreach ($allPerms as $perm) {
                //check teacher permission where permission id and  teacher id exists
                $teacherPerm = DB::table('admin_permission')->where('permission_id', $perm->id)->where('admin_id', $request->id)->first();
                if($teacherPerm){
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'checked',
                    );
                }else{
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'unchecked',
                    );
                }
            }
            return $bag;

        }elseif($request->type == 'ministry-admin'){
            //get teachers perms
            foreach ($allPerms as $perm) {
                //check teacher permission where permission id and  teacher id exists
                $teacherPerm = DB::table('super_admin_permission')->where('permission_id', $perm->id)->where('super_admin_id', $request->id)->first();
                if($teacherPerm){
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'checked',
                    );
                }else{
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'unchecked',
                    );
                }
            }
            return $bag;

        }else{
            return 'Type is not specified';
        }
    }


    public function permissionUserViewPage($usertype, $id)
    {
        $this->validateTopMinistryUser();
        $bag = array();
        $allPerms = Permission::all();

        if($usertype == 'ministry-admin'){
            $title = "Edit Super Admin Permissions";

            foreach ($allPerms as $perm) {
                $userPerm = DB::table('super_admin_permission')->where('permission_id', $perm->id)->where('super_admin_id', $id)->first();
                if($userPerm){
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'checked',
                    );
                }else{
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'unchecked',
                    );
                }
            }//end loop
        }
        elseif($usertype == 'school-admin'){
            $title = "Edit Admin Permissions";

            foreach ($allPerms as $perm) {
                $userPerm = DB::table('admin_permission')->where('permission_id', $perm->id)->where('admin_id', $id)->first();
                if($userPerm){
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'checked',
                    );
                }else{
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'unchecked',
                    );
                }
            }//end loop

        }
        elseif($usertype == 'teacher'){
            $title = "Edit Teacher Permissions";

            foreach ($allPerms as $perm) {
                $userPerm = DB::table('class_teacher_permission')->where('permission_id', $perm->id)->where('teacher_id', $id)->first();
                if($userPerm){
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'checked',
                    );
                }else{
                    $bag[] = array(
                        'id' => $perm->id,
                        'permission' => $perm->permission,
                        'status' => 'unchecked',
                    );
                }
            }//end loop

        }

        $route = 'super_admin.user.permission.view';
        $user_id = $id;

        return view('super-admin.permissions.user-manage', compact('usertype', 'route', 'title', 'user_id', 'bag'));
    }

    public function updateUserPermissions(Request $request)
    {
        $validate = Validator::make($request->all(), [
                'user_id' => 'required',
                'type' => 'required',
                'permission' => 'required|array|min:1'
            ]);

        $resp = '';

        if($validate->passes()){

           if($request->type == 'teacher'){
                //update for teachers

                // have not done the updating for teacher because am waiting for mr samson to confirm something
           }elseif($request->type == 'school-admin'){
                // update for school-admins
                // first delete previous permissions
                if(DB::table('admin_permission')->where('admin_id', $request->user_id)->count() > 0){
                    if( DB::table('admin_permission')->where('admin_id', $request->user_id)->delete()){
                        //now update the new permissions
                        // if(Permission::create())
                        $userInput = $request->all();
                        foreach( $userInput['permission'] as $key=>$item){
                          // create new set permissions for the user
                            DB::table('admin_permission')->insert([
                                'admin_id' => $request->user_id,
                                'permission_id' => $item
                            ]);
                        }
                        $resp =  'Permissions has been updated successfully';
                    }else{
                        $resp =  'Could not delete previous permissions. Pls try again!';
                    }
                }else{
                    $userInput = $request->all();
                        foreach( $userInput['permission'] as $key=>$item){
                          // create new set permissions for the user
                            DB::table('admin_permission')->insert([
                                'admin_id' => $request->user_id,
                                'permission_id' => $item
                            ]);
                        }
                        $resp =  'Permissions has been updated successfully';
                }
           }elseif($request->type == 'ministry-admin'){
                // update for ministry-admins
                // first delete previous permissions
                if(DB::table('super_admin_permission')->where('super_admin_id', $request->user_id)->count() > 0){
                    if( DB::table('super_admin_permission')->where('super_admin_id', $request->user_id)->delete()){
                        //now update the new permissions
                        // if(Permission::create())
                        $userInput = $request->all();
                        if(!empty($userInput['permission'])){
                            foreach( $userInput['permission'] as $key=>$item){
                                // create new set permissions for the user
                                    DB::table('super_admin_permission')->insert([
                                        'super_admin_id' => $request->user_id,
                                        'permission_id' => $item
                                    ]);
                                }
                                $resp =  'Permissions has been updated successfully';
                        }else{
                            $resp =  'Please add or select a permission';
                        }
                    }else{
                        $resp =  'Could not delete previous permissions. Pls try again!';
                    }
                }else{
                    $userInput = $request->all();
                    if(!empty($userInput['permission'])){
                        foreach( $userInput['permission'] as $key=>$item){
                            // create new set permissions for the user
                            DB::table('super_admin_permission')->insert([
                                'super_admin_id' => $request->user_id,
                                'permission_id' => $item
                            ]);
                        }
                        $resp =  'Permissions has been updated successfully';
                    }else{
                        $resp =  'Please add or select a permission';
                    }
                }
           }

            flash($resp)->success();
            return redirect()->route('super_admin.user.permission.view', ['usertype' => $request->type, 'id' => $request->user_id]);

       }
        else{         
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }


/*    public function updateUserPermissions(Request $request)
    {
       if($request->type == 'teacher'){
            //update for teachers

            // have not done the updating for teacher because am waiting for mr samson to confirm something
       }elseif($request->type == 'school-admin'){
            // update for school-admins
            // first delete previous permissions
            if(DB::table('admin_permission')->where('admin_id', $request->user_id)->count() > 0){
                if( DB::table('admin_permission')->where('admin_id', $request->user_id)->delete()){
                    //now update the new permissions
                    // if(Permission::create())
                    $userInput = $request->all();
                    foreach( $userInput['permission'] as $key=>$item){
                      // create new set permissions for the user
                        DB::table('admin_permission')->insert([
                            'admin_id' => $request->user_id,
                            'permission_id' => $item
                        ]);
                    }
                    return 'permissions updated';
                }else{
                    return 'Could not delete previous permissions (try again)';
                }
            }else{
                $userInput = $request->all();
                    foreach( $userInput['permission'] as $key=>$item){
                      // create new set permissions for the user
                        DB::table('admin_permission')->insert([
                            'admin_id' => $request->user_id,
                            'permission_id' => $item
                        ]);
                    }
                    return 'permissions updated';
            }
       }elseif($request->type == 'ministry-admin'){
            // update for ministry-admins
            // first delete previous permissions
            if(DB::table('super_admin_permission')->where('super_admin_id', $request->user_id)->count() > 0){
                if( DB::table('super_admin_permission')->where('super_admin_id', $request->user_id)->delete()){
                    //now update the new permissions
                    // if(Permission::create())
                    $userInput = $request->all();
                    if(!empty($userInput['permission'])){
                        foreach( $userInput['permission'] as $key=>$item){
                            // create new set permissions for the user
                                DB::table('super_admin_permission')->insert([
                                    'super_admin_id' => $request->user_id,
                                    'permission_id' => $item
                                ]);
                            }
                            return 'permissions updated';
                    }else{
                        return 'Please add a permition';
                    }
                }else{
                    return 'Could not delete previous permissions (try again)';
                }
            }else{
                $userInput = $request->all();
                if(!empty($userInput['permission'])){
                    foreach( $userInput['permission'] as $key=>$item){
                        // create new set permissions for the user
                        DB::table('super_admin_permission')->insert([
                            'super_admin_id' => $request->user_id,
                            'permission_id' => $item
                        ]);
                    }
                    return 'permissions updated';
                }else{
                    return 'Please add a permition';
                }
            }
       }
    }
*/

    public function getClassarm(Request $request){
        $teachers = DB::table('class_teacher_permission')->where('teacher_id', $request->id)->get();
        $class_arms = new \App\ClassArms;
        // foreach ($teachers as $teacher) {
        //     $class_id = $teacher->classarm_id;
        //     $classarms = $class_arms->where('class_id','=',$class_id)->get();
        //     $classARMS = $class_arms->present_class_arm_for_display($classarms);
        //     return response()->json([
        //         'classARM' => $classARMS
        //     ]);
        // }
        return $teachers;
    }

    public function createUserView(){
        $super_admin_id = auth('super_admin')->id();
        if($super_admin_id != 2){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        else{
            $title = 'Create ministry user';
            return view('super-admin.create', compact('title'));
        }
    }

    public function createUser(Request $request){
        $super_admin_id = auth('super_admin')->id();
        if($super_admin_id == 2){
            if(SuperAdmin::create([
                'email' => $request->email,
                'username' => $request->username,
                'password' => bcrypt($request->password),
                'fullname' => $request->fullname,
                'status' => $request->status,
            ])){
                flash('You have successfully created the ministry user '.$request->fullname)->success();
                return redirect()->back();
            }else{
                flash('Could not create user, try again')->error();
                return redirect()->back();
            }
        }
        else{
            flash('Permission Denied')->error();
            return abort(401);
        }
    }
    


    public function schoolStatistics()
    {
        if($this->permissionDeny('view-statistics')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        
        $title = 'Schools Statistics';
        $state_id = 28;
        $state_students = $state_students_female = $state_students_male = $state_teachers = false;

        $state_stat_status = false; 

        if(isset($_GET['action']) && $_GET['action'] == 'view_all'){
            $schools = $this->schools->setSchool()->paginate(20);
            $schools->setPath('?action=view_all');
        }elseif (isset($_GET['action']) && $_GET['action'] == 'view_lga') {
            if(isset($_GET['value']) && $_GET['value'] != ''){
                $schools = $this->schools->setSchool()->where('lga_id', $_GET['value'])->paginate(10);
                $lga = DB::table('ondo_lgas')->where('id', $_GET['value'])->first();
                $schools->setPath('?action=view_lga&value='.$lga->id);
                $lga_name = $lga->name;
            }else{
                flash('Please select LGA')->error();
                return redirect()->back();
            }
        }elseif (isset($_GET['action']) && $_GET['action'] == 'table') {
            $schools = $this->schools->setSchool()->paginate(40);
            $schools->setPath('?action=table');
        }else{
            // $schools = School::each()->has('students')->orHas('teachers')->paginate(10);
            $schools = $this->schools->setSchool()->where(function($query) { 
                $query->has('schoolStudent')->orHas('schoolTeacher');
            })->paginate(10);

            $state_students = School::where('schools.state_id', $state_id)
                                        ->join('students', 'students.school_id', '=', 'schools.id')
                                        ->groupBy('students.id')
                                        ->get()
                                        ->count();

            $state_students_female = School::where('schools.state_id', $state_id)
                                        ->where('students.gender', 'Female')
                                        ->join('students', 'students.school_id', '=', 'schools.id')
                                        ->groupBy('students.id')
                                        ->get()
                                        ->count();

            $state_students_male = School::where('schools.state_id', $state_id)
                                        ->where('students.gender', 'Male')
                                        ->join('students', 'students.school_id', '=', 'schools.id')
                                        ->groupBy('students.id')
                                        ->get()
                                        ->count();

            $state_teachers = School::where('schools.state_id', $state_id)
                                        ->join('teachers', 'teachers.school_id', '=', 'schools.id')
                                        ->count();

            $subjects       = Subject::orderBy('subject_name', 'ASC')->get();

            $state_stat_status = true;

        }

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        return view('super-admin.statistics', compact('title', 'schools', 'lga_name', 'ngstate_lgas', 'state_students', 'state_students_female', 'state_students_male', 'state_teachers', 'state_stat_status', 'subjects'));
    }


    public function generateSchoolSubjectStatistics(Request $request)
    {
        $schools = $this->schools->setSchool()
                        ->where('lga_id', $request->lga_id)
                        ->get();

                
        $state_subject_teachers = DB::table('classarm_subject')
        ->select('classarm_subject.id', 'classarm_subject.classarm_id', 'classes.class_name', 'class_arms.class_arm', 'subjects.subject_name', 'classarm_subject.teacher_id', 'teachers.title', 'teachers.firstname', 'teachers.surname', 'teachers.gender')
        ->where('classarm_subject.subject_id', $request->subject_id)
        ->join('teachers', 'classarm_subject.teacher_id', '=', 'teachers.id')
        ->join('subjects', 'subjects.id', '=', 'classarm_subject.subject_id')
        ->join('class_arms', 'class_arms.id', '=', 'classarm_subject.classarm_id')
        ->join('classes', 'classes.id', '=', 'class_arms.class_id')
        ->groupBy('classarm_subject.teacher_id')
        ->get(); 

         $state_subject_teachers = count($state_subject_teachers);

        $html_header = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';

        $lga_name = $this->ondo_lga->find($request->lga_id);

        $subject_data = Subject::find($request->subject_id);

        $html_header .= '<h3>Total of <em>'.$state_subject_teachers.' '.$subject_data->subject_name.'</em> Teachers in Ondo State</h3>';

        //$html_header .= '<h3>Subject Teacher Statistics for <em>'.$subject_data->subject_name.'</em> in '.$lga_name->name.' LGA</h3>';

        //$html_header .= '<br>';

        $sn = 1;

        $total_teachers = 0;
        
        $html = '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th width="12%">School Name</th>
                        <th>'.$subject_data->subject_code.' Teacher Count</th>
                        <th>'.$subject_data->subject_code.' Teacher Names</th>
                    </tr>
                  </thead>
                  <tbody>';

        if(count($schools) > 0){
            $school_subject_html = '';
            $school_subject_teachers = 0;
            foreach($schools as $school){                
                
                $subject_teacher_list = DB::table('classarm_subject')
                ->select('classarm_subject.id', 'classarm_subject.classarm_id', 'classes.class_name', 'class_arms.class_arm', 'subjects.subject_name', 'classarm_subject.teacher_id', 'teachers.title', 'teachers.firstname', 'teachers.surname', 'teachers.gender')
                ->where('class_arms.school_id', $school->id)
                ->where('classarm_subject.subject_id', $request->subject_id)
                ->join('teachers', 'classarm_subject.teacher_id', '=', 'teachers.id')
                ->join('subjects', 'subjects.id', '=', 'classarm_subject.subject_id')
                ->join('class_arms', 'class_arms.id', '=', 'classarm_subject.classarm_id')
                ->join('classes', 'classes.id', '=', 'class_arms.class_id')
                ->groupBy('classarm_subject.teacher_id')
                ->get();            


                $html .= '<tr>';
                $html .= '<td>'.$sn.'</td>';
                $html .= '<td>'.$school->name.'</td>';

                if(!empty($subject_teacher_list)){
                    $school_subject_html .= '<div class="scrollable_content_box" style="height:100px;">';
                    foreach ($subject_teacher_list as $data_row) {
                        $school_subject_html .= '<div>'.$data_row->title.' '.$data_row->surname.' '.$data_row->firstname.'</div>';
                        $school_subject_teachers++;
                    }//end loop
                    $school_subject_html .= '</div>';
                }

                $html .= '<td>'.$school_subject_teachers.'</td>';
                $html .= '<td>'.$school_subject_html.'</td>';

                $html .= '</tr>';

                $sn++;
                $school_subject_html = '';
                $total_teachers = $total_teachers + $school_subject_teachers;
                $school_subject_teachers = 0;
            }//end loop
        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table></section>';

        $html_header .= '<h4>&bull; <strong>Total of <em>'.$total_teachers.' '.$subject_data->subject_name.'</em> Teachers in '.$lga_name->name.'</strong></h4> <br>';

        $html = $html_header.$html; 

        return $html; 

    }


    public function generateSchoolSubjectStatisticsBroad(Request $request)
    {
        $schools = $this->schools->setSchool()
                        ->where('lga_id', $request->lga_id)
                        ->get();

        $html = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';

        $lga_name = $this->ondo_lga->find($request->lga_id);

        $html .= '<h3>Subject Statistics for : <em>'.$lga_name->name.'</em> LGA</h3>';

        $html .= '<br>';

        $sn = 1;
        
        $html .= '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th width="12%">School Name</th>
                        <th>Subject Statistics</th>
                    </tr>
                  </thead>
                  <tbody>';

        if(count($schools) > 0){
            $school_subject_html = '';
            foreach($schools as $school){                
                
                $subject_teacher_list = DB::table('classarm_subject')
                ->select('classarm_subject.id', 'classarm_subject.classarm_id', 'classes.class_name', 'class_arms.class_arm', 'subjects.subject_name', 'teachers.title', 'teachers.firstname', 'teachers.surname', 'teachers.gender')
                ->where('class_arms.school_id', $school->id)
                ->join('teachers', 'classarm_subject.teacher_id', '=', 'teachers.id')
                ->join('subjects', 'subjects.id', '=', 'classarm_subject.subject_id')
                ->join('class_arms', 'class_arms.id', '=', 'classarm_subject.classarm_id')
                ->join('classes', 'classes.id', '=', 'class_arms.class_id')
                ->orderBy('subjects.subject_name', 'ASC')
                ->get();                 


                $html .= '<tr>';
                $html .= '<td>'.$sn.'</td>';
                $html .= '<td>'.$school->name.'</td>';

                if(!empty($subject_teacher_list)){
                    $school_subject_html .= '<div class="scrollable_content_box">';
                    $school_subject_html .= '<table border="0">';
                    foreach ($subject_teacher_list as $data_row) {
                        $school_subject_html .= '<tr>';
                        $school_subject_html .= '<td>'.$data_row->class_name.'</td>';
                        $school_subject_html .= '<td>'.$data_row->class_arm.'</td>';
                        $school_subject_html .= '<td>'.$data_row->subject_name.'</td>';
                        $school_subject_html .= '<td>'.$data_row->title.' '.$data_row->surname.' '.$data_row->firstname.'</td>';
                        $school_subject_html .= '</tr>';
                    }//end loop
                    $school_subject_html .= '</table>';
                    $school_subject_html .= '</div>';
                }

                $html .= '<td>'.$school_subject_html.'</td>';

                $html .= '</tr>';

                $sn++;
                $school_subject_html = '';
            }//end loop
        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table></section>';

        return $html;  

    }


    public function schoolGenerateStatTablesStudent(Request $request)
    {
        $schools = $this->schools->setSchool()
                        ->where('lga_id', $request->lga_id)
                        ->get();

        $lga_students = School::where('schools.lga_id', $request->lga_id)
                                    ->join('students', 'students.school_id', '=', 'schools.id')
                                    ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                                    ->where('classarm_student.session', $request->session)
                                    ->groupBy('classarm_student.student_id')
                                    ->get()
                                    ->count();

        $lga_students_female = School::where('schools.lga_id', $request->lga_id)
                                    ->where('students.gender', 'Female')
                                    ->join('students', 'students.school_id', '=', 'schools.id')
                                    ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                                    ->where('classarm_student.session', $request->session)
                                    ->groupBy('classarm_student.student_id')
                                    ->get()
                                    ->count();

        $lga_students_male = School::where('schools.lga_id', $request->lga_id)
                                    ->where('students.gender', 'Male')
                                    ->join('students', 'students.school_id', '=', 'schools.id')
                                    ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                                    ->where('classarm_student.session', $request->session)
                                    ->groupBy('classarm_student.student_id')
                                    ->get()
                                    ->count();

        $lga_teachers = School::where('schools.lga_id', $request->lga_id)
                                    ->join('teachers', 'teachers.school_id', '=', 'schools.id')
                                    ->join('classarm_teacher', 'classarm_teacher.teacher_id', '=', 'teachers.id')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->count();

        $html = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';

        $lga_name = $this->ondo_lga->find($request->lga_id);

        $html .= '<h3>Statistics for : <em>'.$lga_name->name.'</em> LGA</h3>';

        $html .= '<p>&bull; <strong>Students: '.$lga_students.'</strong><p>';
        $html .= '<p>&bull; <strong>Male Students: '.$lga_students_male.'</strong><p>';
        $html .= '<p>&bull; <strong>Female Students: '.$lga_students_female.'</strong><p>';

        $html .= '<br>';

        $sn = 1;
        
        $html .= '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th width="18%">School Name</th>
                        <th>Total Registered Students</th>
                        <th>Male Student</th>
                        <th>Female Student</th>
                        <th>Unknown Gender</th>
                    </tr>
                  </thead>
                  <tbody>';

        if(count($schools) > 0){
            foreach($schools as $school){             

                $students_all = count(DB::table('classarm_student')
                                    ->where('classarm_student.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_student.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('students', 'students.id', '=', 'classarm_student.student_id')
                                    ->groupBy('classarm_student.student_id')
                                    ->get());

                $students_male = count(DB::table('classarm_student')
                                    ->where('classarm_student.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_student.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('students', 'students.id', '=', 'classarm_student.student_id')
                                    ->where('students.gender', 'Male')
                                    ->groupBy('classarm_student.student_id')
                                    ->get());

                $students_female = count(DB::table('classarm_student')
                                    ->where('classarm_student.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_student.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('students', 'students.id', '=', 'classarm_student.student_id')
                                    ->where('students.gender', 'Female')
                                    ->groupBy('classarm_student.student_id')
                                    ->get());

                $students_unknown = count(DB::table('classarm_student')
                                    ->where('classarm_student.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_student.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('students', 'students.id', '=', 'classarm_student.student_id')
                                    ->where('students.gender', '=', '')
                                    ->groupBy('classarm_student.student_id')
                                    ->get());


                $html .= '<tr>';
                $html .= '<td>'.$sn.'</td>';
                $html .= '<td>'.$school->name.' '.$request->session.'</td>';

                $html .= '<td>'.$students_all.'</td>';
                $html .= '<td>'.$students_male.'</td>';
                $html .= '<td>'.$students_female.'</td>';
                $html .= '<td>'.$students_unknown.'</td>';

                $html .= '</tr>';

                $students_all = $students_male = $students_female = '';

                $sn++;
            }//end loop
        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table></section>';

        return $html;  
    }


    public function schoolGenerateStatTablesTeacher(Request $request)
    {
        $schools = $this->schools->setSchool()
                        ->where('lga_id', $request->lga_id)
                        ->get();

        $lga_teachers_female = School::where('schools.lga_id', $request->lga_id)
                                    ->where('teachers.gender', 'Female')
                                    ->join('teachers', 'teachers.school_id', '=', 'schools.id')
                                    ->join('classarm_teacher', 'classarm_teacher.teacher_id', '=', 'teachers.id')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->count();

        $lga_teachers_male = School::where('schools.lga_id', $request->lga_id)
                                    ->where('teachers.gender', 'Male')
                                    ->join('teachers', 'teachers.school_id', '=', 'schools.id')
                                    ->join('classarm_teacher', 'classarm_teacher.teacher_id', '=', 'teachers.id')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->count();

        $lga_teachers = School::where('schools.lga_id', $request->lga_id)
                                    ->join('teachers', 'teachers.school_id', '=', 'schools.id')
                                    ->join('classarm_teacher', 'classarm_teacher.teacher_id', '=', 'teachers.id')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->count();

        $html = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';

        $lga_name = $this->ondo_lga->find($request->lga_id);

        $html .= '<h3>Statistics for : <em>'.$lga_name->name.'</em> LGA</h3>';

        $html .= '<p>&bull; <strong>Teachers: '.$lga_teachers.'</strong><p>';
        $html .= '<p>&bull; <strong>Male Teachers: '.$lga_teachers_male.'</strong><p>';
        $html .= '<p>&bull; <strong>Female Teachers: '.$lga_teachers_female.'</strong><p>';

        $html .= '<br>';

        $sn = 1;
        
        $html .= '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th width="18%">School Name</th>
                        <th>Total Teachers</th>
                        <th>Class Teachers</th>
                        <th>Male Teachers</th>
                        <th>Female Teachers</th>
                        <th>Unknown Gender</th>
                        <th>Subject Teachers</th>
                        <th>Subjects</th>
                    </tr>
                  </thead>
                  <tbody>';

        if(count($schools) > 0){
            foreach($schools as $school){

                $teachers_class = DB::table('classarm_teacher')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_teacher.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('teachers', 'teachers.id', '=', 'classarm_teacher.teacher_id')
                                    ->count();

                $teachers_male = DB::table('classarm_teacher')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_teacher.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('teachers', 'teachers.id', '=', 'classarm_teacher.teacher_id')
                                    ->where('teachers.gender', 'Male')
                                    ->count();

                $teachers_female = DB::table('classarm_teacher')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_teacher.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('teachers', 'teachers.id', '=', 'classarm_teacher.teacher_id')
                                    ->where('teachers.gender', 'Female')
                                    ->count();

                $teachers_unknown = DB::table('classarm_teacher')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_teacher.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('teachers', 'teachers.id', '=', 'classarm_teacher.teacher_id')
                                    ->where('teachers.gender', '==', '')
                                    ->count();
                                    
                $teachers_subject = DB::table('subject_teacher')
                                    ->where('school_id', $school->id)
                                    ->count();
                
                $teachers_all = $teachers_subject + $teachers_class;
                                    

                                    
                // getting subjects, subject_teachers count and subject teachers
                $school_subjects = DB::table('subjects')
                                    ->select('subject_teacher.subject_id', 'subjects.subject_name', 'subjects.class_category')
                                    ->join('subject_teacher', 'subject_teacher.subject_id', '=', 'subjects.id')
                                    ->where('subject_teacher.school_id', $school->id)
                                    ->groupBy('subject_teacher.subject_id')
                                    ->get();

                $subject_list = '';
                if(!empty($school_subjects)){
                    foreach ($school_subjects as $subject) {
                        $subject_id = $subject->subject_id;

                        $teachers_count = DB::table('subject_teacher')
                                    ->where('subject_id', $subject_id)
                                    ->where('school_id', $school->id)
                                    ->count();

                        $subject_list .= '('.$subject->class_category.') '.$subject->subject_name.': '.$teachers_count.' Teacher; <br>';
                    }
                }

                $html .= '<tr>';
                $html .= '<td>'.$sn.'</td>';
                $html .= '<td>'.$school->name.'</td>';

                $html .= '<td>'.$teachers_all.'</td>';
                $html .= '<td>'.$teachers_class.'</td>';
                $html .= '<td>'.$teachers_male.'</td>';
                $html .= '<td>'.$teachers_female.'</td>';
                $html .= '<td>'.$teachers_unknown.'</td>';
                $html .= '<td>'.$teachers_subject.'</td>';

                $html .= '<td>';
                $html .= '<div class="scrollable_content_box" style="height:100px;">';
                $html .= $subject_list;
                $html .= '</div>';
                $html .= '</td>';

                $html .= '</tr>';

                $sn++;
            }//end loop
        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table></section>';

        return $html;  
    }


    public function schoolGenerateBroadStatTables(Request $request)
    {
        $schools = $this->schools->setSchool()
                        ->where('lga_id', $request->lga_id)
                        ->get();

        $lga_students = School::where('schools.lga_id', $request->lga_id)
                                    ->join('students', 'students.school_id', '=', 'schools.id')
                                    ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                                    ->where('classarm_student.session', $request->session)
                                    ->groupBy('classarm_student.student_id')
                                    ->get()
                                    ->count();

        $lga_students_female = School::where('schools.lga_id', $request->lga_id)
                                    ->where('students.gender', 'Female')
                                    ->join('students', 'students.school_id', '=', 'schools.id')
                                    ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                                    ->where('classarm_student.session', $request->session)
                                    ->groupBy('classarm_student.student_id')
                                    ->get()
                                    ->count();

        $lga_students_male = School::where('schools.lga_id', $request->lga_id)
                                    ->where('students.gender', 'Male')
                                    ->join('students', 'students.school_id', '=', 'schools.id')
                                    ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                                    ->where('classarm_student.session', $request->session)
                                    ->groupBy('classarm_student.student_id')
                                    ->get()
                                    ->count();

        $lga_teachers = School::where('schools.lga_id', $request->lga_id)
                                    ->join('teachers', 'teachers.school_id', '=', 'schools.id')
                                    ->join('classarm_teacher', 'classarm_teacher.teacher_id', '=', 'teachers.id')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->count();

        $html = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';

        $lga_name = $this->ondo_lga->find($request->lga_id);

        $html .= '<h3>Statistics for : <em>'.$lga_name->name.'</em> LGA</h3>';

        $html .= '<p>&bull; <strong>Teachers: '.$lga_teachers.'</strong><p>';
        $html .= '<p>&bull; <strong>Students: '.$lga_students.'</strong><p>';
        $html .= '<p>&bull; <strong>Male Students: '.$lga_students_male.'</strong><p>';
        $html .= '<p>&bull; <strong>Female Students: '.$lga_students_female.'</strong><p>';

        $html .= '<br>';

        $sn = 1;
        
        $html .= '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th width="18%">School Name</th>
                        <th>School Admin Name</th>
                        <th>School Admin Phone</th>
                        <th>Total Teachers</th>
                        <th>Total Registered Students</th>
                        <th width="12%">Students by Class Arm</th>
                    </tr>
                  </thead>
                  <tbody>';

        if(count($schools) > 0){
            $classes_count_html = '';
            foreach($schools as $school){

                $teachers_count = DB::table('classarm_teacher')
                                    ->where('classarm_teacher.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_teacher.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->count();
                
                $classes = $this->classes->setClass()
                                        ->where('school_id', $school->id)
                                        ->get();              

                if(!empty($classes)){
                    foreach($classes as $class){
                        $class_id = $class->id;
                        $class_name = $class->class_name;

                        $class_arms = $this->class_arms->setClassArms()
                                        ->where('school_id', $school->id)
                                        ->where('class_id', $class_id)
                                        ->get();

                        if(!empty($class_arms)){
                            foreach($class_arms as $class_arm){
                                $class_arm_id = $this->class_arms->find($class_arm->id);
                                $class_arm_students = $class_arm_id->students()
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('class_id', $class_id)
                                        ->groupBy('student_id')
                                        ->get()
                                        ->count();
                                $classes_count_html .= '<div class=""classarm_stat>'.$class_name.' '.$class_arm->class_arm.': <strong>'.$class_arm_students.'</strong></div>';
                            }
                        }

                        
                    }//end loop
                }//end if        

                $students_all = count(DB::table('classarm_student')
                                    ->where('classarm_student.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_student.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->groupBy('classarm_student.student_id')
                                    ->get());

                $students_male = count(DB::table('classarm_student')
                                    ->where('classarm_student.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_student.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('students', 'students.id', '=', 'classarm_student.student_id')
                                    ->where('students.gender', 'Male')
                                    ->groupBy('classarm_student.student_id')
                                    ->get());

                $students_female = count(DB::table('classarm_student')
                                    ->where('classarm_student.session', $request->session)
                                    ->join('class_arms', 'class_arms.id', '=', 'classarm_student.classarm_id')
                                    ->where('class_arms.school_id', $school->id)
                                    ->join('students', 'students.id', '=', 'classarm_student.student_id')
                                    ->where('students.gender', 'Female')
                                    ->groupBy('classarm_student.student_id')
                                    ->get());

                $html .= '<tr>';
                $html .= '<td>'.$sn.'</td>';
                $html .= '<td>'.$school->name.'</td>';
                    $html .= '<td><ul>';

                    if($school->schoolAdmin->count() > 0){
                        foreach($school->schoolAdmin as $schoolAdmins){
                            $html .= '<li>'.$schoolAdmins->fullname.'</li>';
                        }//end loop
                    }
                    $html .= '</ul></td>';

                    $html .= '<td><ul>';

                    if($school->schoolAdmin->count() > 0){
                        foreach($school->schoolAdmin as $schoolAdmins){
                            $html .= '<li>'.$schoolAdmins->phone.'</li>';
                        }//end loop
                    }
                    $html .= '</ul></td>';

                $html .= '<td>'.$teachers_count.'</td>';
                $html .= '<td>Total: '.$students_all.' <br> Male: '.$students_male.' <br> Female: '.$students_female.'</td>';
                $html .= '<td>'.$classes_count_html.'</td>';

                $html .= '</tr>';

                $sn++;
                $classes_count_html = '';
            }//end loop
        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table></section>';

        return $html;  
    }




    public function generateSchoolSessionResultStatistics(Request $request)
    {
        if($request->lga_id == 'all'){
            if(!isset($request->from) || $request->from == ''){
                return 'Please fill the required range fields';
            }

            if(!isset($request->to) || $request->to == ''){
                return 'Please set the max number of records to return';
            }
            if($request->with_result == 'yes'){
                $objs = DB::select('select * from schools schools 
                                        where (select COUNT(*) from student_results results where results.school_id=schools.id and results.session="'.$request->session.'" and results.term="'.$request->term.'") > 0 
                                        order by lga_id ASC 
                                        limit '.$request->from.', '.$request->to.'');
                $schools = School::hydrate($objs);
            }else{
                $schools = $this->schools->setSchool()
                                ->orderBy('lga_id', 'asc')
                                ->skip($request->from)
                                ->take($request->to)
                                ->get();
            }
            
            $session_full = $request->session.'/'.($request->session+1);

            $html = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';
            $html .= '<h3>'.$session_full.' '.strtoupper($request->term).' TERM Result Statistics for : <em>All</em> LGA</h3>';
        }else{
            $schools = $this->schools->setSchool()
                            ->where('lga_id', $request->lga_id)
                            ->get();
            
            $session_full = $request->session.'/'.($request->session+1);

            $lga_name = $this->ondo_lga->find($request->lga_id);

            $html = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';
            $html .= '<h3>'.$session_full.' '.strtoupper($request->term).' TERM Result Statistics for : <em>'.$lga_name->name.'</em> LGA</h3>';
        }

        $html .= '<p><strong>NOTE: GREEN indicate Result Available and RED indicate NO Result Available</strong><p>';

        $html .= '<br>';

        $sn = 1;
        if($request->lga_id == 'all'){
        $html .= '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th width="18%">School Name</th>
                        <th>LGA</th>
                        <th>Total Student Results</th>
                    </tr>
                  </thead>
                  <tbody>';
        }else{
            $html .= '<table class="ui celled table" id="global_datatable">
                      <thead>
                        <tr>
                            <th>S/N</th>
                            <th width="18%">School Name</th>
                            <th>School Population</th>
                            <th>Total Results (By Student)</th>
                            <th>Total Results (By Class Arm)</th>
                            <th>Released Results</th>
                            <th width="7%">Indicator</th>
                        </tr>
                      </thead>
                      <tbody>';
        }

        if(count($schools) > 0){
            $classarms_html = '';
            $released_result_html = '';
            foreach($schools as $school){
                if($request->lga_id != 'all'){
                    $students_all = $school->schoolStudent
                            ->count();
                    $students_all_s = ($students_all > 1) ? ' Students': 'Student';
                            
                    $school_session_results = StudentResult::where('school_id', $school->id)
                                                        ->where('session', $request->session)
                                                        ->where('term', $request->term)
                                                        ->get();
                    $school_session_results = count($school_session_results);
                    
                    $color_indicator = ($school_session_results > 0) ? 'result_green.gif': 'result_red.jpg';

                    $color_indicator_img = '<img src="'.url_public('/images/'.$color_indicator).'" />';
                            
                    $students_with_results = StudentResult::where('school_id', $school->id)
                                                        ->where('session', $request->session)
                                                        ->where('term', $request->term)
                                                        ->groupBy('student_id')
                                                        ->get();
                    $students_with_results_count = count($students_with_results);
                                                        
                    $classarm_with_results = StudentResult::where('school_id', $school->id)
                                                        ->where('session', $request->session)
                                                        ->where('term', $request->term)
                                                        ->groupBy('classarm_id')
                                                        ->get();
                    $classarm_with_results = count($classarm_with_results);
                                                        
                    $results_classarm_list = StudentResult::select('classarm_id', 'class_id')
                                                        ->where('school_id', $school->id)
                                                        ->where('session', $request->session)
                                                        ->where('term', $request->term)
                                                        ->groupBy('classarm_id')
                                                        ->get();           

                    if(!empty($results_classarm_list)){
                        foreach($results_classarm_list as $results_classarm){
                            $classarm_id = $results_classarm->classarm_id;
                            $class_id = $results_classarm->class_id;
                            
                            $classarm_session_results = StudentResult::where('school_id', $school->id)
                                                        ->where('session', $request->session)
                                                        ->where('term', $request->term)
                                                        ->where('classarm_id', $classarm_id)
                                                        ->groupBy('student_id')
                                                        ->get();
                            $classarm_session_results = count($classarm_session_results);
                                                    
                            $class_name = getClassNameByClassID($class_id) ;
                            $classarm_name = getClassArmNameByClassArmID($classarm_id);

                            $classarms_html .= '<div class=""classarm_stat>'.$class_name.' '.$classarm_name.': <strong>'.$classarm_session_results.' Student\'s Result</strong></div>';

                        }//end loop
                    }//end if

                    if(!empty($students_with_results)){
                        $classarm_released_array = array();
                        foreach($students_with_results as $student_results){

                            $classarm_id = $student_results->classarm_id;
                            $class_id = $student_results->class_id;
                            
                            $classarm_released_results = StudentResult::where('school_id', $school->id)
                                                        ->where('session', $request->session)
                                                        ->where('term', $request->term)
                                                        ->where('classarm_id', $classarm_id)
                                                        ->where('class_id', $class_id)
                                                        ->where('status', 1)
                                                        ->groupBy('student_id')
                                                        ->get();
                            $classarm_released_results = count($classarm_released_results);

                            $classarm_released_array[$classarm_id] = $classarm_released_results;
                        }//end loop

                        if(!empty($classarm_released_array)){
                            $classarm_released_array = array_filter($classarm_released_array);                         
                            $classarm_released_array = array_unique($classarm_released_array);

                            foreach ($classarm_released_array as $key_classarm_id => $classarm_released){
                                $key_class_arms = $this->class_arms->find($key_classarm_id);

                                $class_name = getClassNameByClassID($key_class_arms->class_id);
                                $classarm_name = getClassArmNameByClassArmID($key_class_arms->id);                         
                                $released_result_html .= '<div class=""classarm_stat>'.$class_name.' '.$classarm_name.': <strong>'.$classarm_released.' Student\'s Result</strong></div>';
                            }
                        }
                    }//end if
                }else{
                    $students_with_results_count = StudentResult::where('school_id', $school->id)
                                                        ->where('session', $request->session)
                                                        ->where('term', $request->term)
                                                        ->groupBy('student_id')
                                                        ->get()->count();
                }

                if($request->lga_id == 'all'){
                    $html .= '<tr>';
                    $html .= '<td>'.$sn.'</td>';
                    $html .= '<td>'.$school->name.'</td>';
                    $html .= '<td>'.$school->ondoLga->name.'</td>';
                    $html .= '<td>'.$students_with_results_count.' Student\'s Result</td>';
                    $html .= '</tr>';
                }else{
                    $html .= '<tr>';
                    $html .= '<td>'.$sn.'</td>';
                    $html .= '<td>'.$school->name.'</td>';
                    if($request->lga_id == 'all'){
                        $html .= '<td>'.$school->ondoLga->name.'</td>';
                    }
                    $html .= '<td>'.$students_all.' '.$students_all_s.'</td>';
                    $html .= '<td>'.$students_with_results_count.' Student\'s Result</td>';
                    $html .= '<td>'.$classarms_html.'</td>';
                    $html .= '<td>'.$released_result_html.'</td>';
                    $html .= '<td>'.$color_indicator_img.'</td>';
                    $html .= '</tr>';
                }

                $sn++;
                $classarms_html = '';
                $released_result_html = '';
            }//end loop
        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table></section>';

        return $html;  
    }


    public function schoolStatisticsGet(Request $request)
    {
        // return $request->school_id;
        $school = School::find($request->school_id);
        $bag = array();
        $teacher_count = Teacher::where('school_id', $request->school_id)->get()->count();
        $student_count = Student::where('school_id', $request->school_id)->get()->count();
        $admin_count = Admin::where('school_id', $request->school_id)->get()->count();
        $male_count = Student::where('school_id', $request->school_id)->where('gender', 'male')->get()->count();
        $female_count = Student::where('school_id', $request->school_id)->where('gender', 'female')->get()->count();

        $account = $teacher_count + $student_count + $admin_count.' Accounts';
        $location = $school->address;
        $category = $school->school_category;
        if($school->created_at != '' || !empty($school->created_at)){
            $created_at = $school->created_at->diffForHumans();
        }else{
            $created_at = 'Unavailable';
        }
        $bag[] = array(
            'teacher_count' => $teacher_count,
            'student_count' => $student_count,
            'admin_count' => $admin_count, 
            'male_count' => $male_count, 
            'female_count' => $female_count, 
            'account' => $account, 
            'location' => $location, 
            'created_at' => $created_at,
            'category' => $category
        );
        return $bag;
    }

    


    public function paymentStatistics(Request $request)
    {
        $title = 'Payments Statistics';
        if(isset($_GET['action']) && $_GET['action'] == 'view_all'){
            $schools = $this->schools->setSchool()->paginate(20);
            $schools->setPath('?action=view_all');
        }elseif (isset($_GET['action']) && $_GET['action'] == 'view_lga') {
            if(isset($_GET['value']) && $_GET['value'] != ''){
                $schools = $this->schools->setSchool()->where('lga_id', $_GET['value'])->paginate(10);
                $lga = DB::table('ondo_lgas')->where('id', $_GET['value'])->first();
                $schools->setPath('?action=view_lga&value='.$lga->id);
                $lga_name = $lga->name;
            }else{
                flash('Please select LGA')->error();
                return redirect()->back();
            }
        }else{
            // $schools = School::each()->has('students')->orHas('teachers')->paginate(10);
            $schools = $this->schools->setSchool()->where(function($query) { 
                $query->has('schoolStudent')->orHas('schoolTeacher')->orHas('schoolAdmin');
            })->paginate(10);
        }
        
        return view('super-admin.payment-statistics', compact('title', 'schools', 'lga_name'));
    }


    public function paymentStatisticsGet(Request $request)
    {
        $bag = array();
        $pay = $this->payment->setPayment();
        if($pay->all()->count() > 0){
            $payment_recipient = $this->payment_recipient->setData();
            $payments = $pay->get();
            $school = School::find($request->school_id);
            foreach ($payments as $payment) {
                $payment_recipients = $payment_recipient->where('pay_id', $payment->id)->get();
                $payment_recipients_count = $payment_recipient->where('pay_id', $payment->id)->get()->count();
                $student_id = $payment_recipient->where('pay_id', $payment->id)->first()->student_id;
                if(Student::find($student_id)->school_id == $request->school_id){
                    if($payment_recipients->count() > 0){
                        $payment_count = 0;
                        $payment_made_count = 0;
                        $payment_pending_count = 0;
                        foreach($payment_recipients as $payment_recipient){
                            $student = Student::find($payment_recipient->student_id);
                            $student_classInfo =  $student->classarms()->wherePivot('session', '=',$student->session)
                            ->orderBy('term', 'desc')
                            ->first();
                            $student_class = Classes::find($student_classInfo->class_id)->class_name;
                            $student_classarm = $student_classInfo->class_arm;
                            $payment_item = DB::table('payment_items')->where('id', $payment->item_id)->first();
                            $payment_count = $payment_count + 1;
                            if($payment->pay_status == 1){
                                $payment_status = 'Unverified';
                                $payment_pending_count = $payment_pending_count + 1;
                            }else{
                                $payment_status = 'Verified';
                                $payment_made_count = $payment_made_count + 1;
                            }
                            $bag[] = array(
                                'customer_id' => $payment->customer_id, 
                                'item' => $payment_item->item_name,
                                'student_reg' => $student->regnum, 
                                'student_name' => $student->surname.' '.$student->firstname.' '.$student->middlename, 
                                'student_class' => $student_class,
                                'student_class' => $student_class,
                                'student_classarm' => $student_classarm,
                                'session' => $student->session,
                                'order_date' => $payment->order_date,
                                'status' => $payment_status,
                                'total' => $payment->total_cost
                            );
                        }
                        $bag[] = array(
                            'empty'=> false, 
                            'payment_count' => $payment_count,
                            'payment_made_count' => $payment_made_count,
                            'payment_pending_count' => $payment_pending_count, 
                        );
                        return $bag;
                    }
                }else{
                    $bag[] = array(
                        'empty'=> true,
                        'payment_count' => 0,
                        'payment_made_count' => 0,
                        'payment_pending_count' => 0,
                    );
                    return $bag;
                }
            }
        }
    }
    
    
    

    public function searchBar(Request $request){
        if($request->type == 'search_school_admin'){
            if(isset($request->keyword)){
                $school_admins = Admin::where('fullname', 'like', '%' . $request->keyword . '%')->paginate(20);
                $school_admins->setPath('search?type=search_school_admin&keyword='.$request->keyword);
                return view('super-admin.school-admin.view-school-admin', compact('school_admins'));
            }elseif(isset($request->school)){
                $school_admins = Admin::where('school_id', $request->school)->paginate(20);
                $school_admins->setPath('search?type=search_school_admin&school='.$request->school);
                return view('super-admin.school-admin.view-school-admin', compact('school_admins'));
            }
        }elseif($request->type == 'search_school'){
            if(isset($request->keyword)){
                $schools = School::where('name', 'like', '%' . $request->keyword . '%')->paginate(20);
                $schools->setPath('search?type=search_school&keyword='.$request->keyword);
                return view('super-admin.school.view-school', compact('schools'));
            }elseif(isset($request->lga)){
                $schools = School::where('lga_id', $request->lga)->paginate(20);
                $schools->setPath('search?type=search_school&lga='.$request->lga);
                return view('super-admin.school.view-school', compact('schools'));
            }
        }else{
            return back();
        }
    }
    
    function smsView(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $title = 'View Student to mail';

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        $data = [];

        $students = $this->students->setStudent()
                                    ->where('school_id', 0)
                                    ->paginate(20);

        return view('super-admin.sms.view', compact('ngstate_lgas', 'title', 'data', 'students', 'ngstate'));
    }

    function smsPostView(Request $request){
        
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'school' => 'required',
                                                'class_id' => 'required',
                                                'session' => 'required',
                                                'class_arm_id' => 'required',
                                                'term' => 'required'
                                            ]);

        if($validate->passes()){

                $title = 'View Student';

                $ngstate =  $this->ngstates->find(28);

                $ngstate_lgas = $ngstate->ondo_lga;

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                    }
                }

                $session = $request->session;
                $term = $request->term;
                $classarm = $request->class_arm_id;
                $class_id = $request->class_id;
                $school = $request->school;
        
                $sql = "SELECT `s`.*, `cs`.`classarm_id`, `cs`.`session`, `cs`.`term`, `cs`.`class_id` FROM `students` as `s` LEFT JOIN `classarm_student` as `cs` ON `s`.`id` = `cs`.`student_id` WHERE `cs`.`classarm_id` = '$classarm' AND `cs`.`session` = '$session' AND `cs`.`term` = '$term' AND `cs`.`class_id` = '$class_id' AND `s`.`school_id` = '$school'";


                $students = fetchDataTableWithSql($sql, 50);
        
                Input::flash();
        
                return view('super-admin.sms.view', compact('data', 'students', 'ngstate', 'ngstate_lgas'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }

    function smsPost(Request $request){
        // return $request->all();
        // $this->prepareSMSGateWay('odsgmoe.com', '08025469937', strtoupper($request->subject).': '.$request->message);
        // http://www.smsblues.net/http/index.aspx?cmd=sendquickmsg&username=xxx&password=xxx&message=xxx&sender=xxx&sendto=xxx&msgtype=0
        $senderName = 'odsgmoe.com';
        $PhoneBook = '2348025469937';
        $message = strtoupper($request->subject).': '.$request->message;
        // $SMSGateWay =    "http://www.qultext.com/http/index.aspx?cmd=sendmsg&sessionid=".$sessionID."username=ogooluwao@yahoo.co.uk&password=omoreghagideonogooluwa@1982";
        // $SMSGateWay =    "http://www.qultext.com/http/index.aspx?cmd=sendquickmsg&username=ogooluwao@yahoo.co.uk&password=omoreghagideonogooluwa@1982&message=".$message."&sender=".$senderName."&sendto=".$PhoneBook."&msgtype=0&sendtime='2 Jan 2008 6:30 PM'";
        $SMSGateWay = "http://www.qultext.com/http/index.aspx?cmd=sendquickmsg&username=ogooluwao@yahoo.co.uk&password=omoreghagideonogooluwa@1982&message=lap&sender=%22gideon%22&sendto=2348025469937&msgtype=0&sendtime=%222%20Jan%202008%206:30%20PM%22";
        // $SMSChannel = curl_init();
        
        // curl_setopt($SMSChannel, CURLOPT_URL, $SMSGateWay);
        
        // curl_setopt($SMSChannel, CURLOPT_HEADER, 0);
        
        // curl_setopt($SMSChannel, CURLOPT_RETURNTRANSFER, 1);
        
        // $response = curl_exec($SMSChannel);
         
        // curl_close($SMSChannel);
        
        // return $response;
        // Get cURL resource
        $curl = curl_init();
        // Set some options - we are passing in a useragent too here
        curl_setopt_array($curl, array(
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_URL => $SMSGateWay,
            CURLOPT_USERAGENT => 'Test SMS'
        ));
        // Send the request & save response to $resp
        $resp = curl_exec($curl);
        // Close request to clear up some resources
        curl_close($curl);

        return $resp;
    }


    

    function studentblukdeleteView(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $title = 'View Student To Delete';

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        $data = [];

        $students = $this->students->setStudent()
                                    ->where('school_id', 0)
                                    ->paginate(20);

        return view('super-admin.batch-delete', compact('ngstate_lgas', 'title', 'data', 'students', 'ngstate'));
    }

    function studentblukdeletePostView(Request $request){
        
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'school' => 'required',
                                                'class_id' => 'required',
                                                'session' => 'required',
                                                'class_arm_id' => 'required',
                                                'term' => 'required'
                                            ]);

        if($validate->passes()){

                $title = 'View Student';

                $ngstate =  $this->ngstates->find(28);

                $ngstate_lgas = $ngstate->ondo_lga;

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                    }
                }

                $session = $request->session;
                $term = $request->term;
                $classarm = $request->class_arm_id;
                $class_id = $request->class_id;
                $school = $request->school;
        
                $sql = "SELECT `s`.*, `cs`.`classarm_id`, `cs`.`session`, `cs`.`term`, `cs`.`class_id` FROM `students` as `s` LEFT JOIN `classarm_student` as `cs` ON `s`.`id` = `cs`.`student_id` WHERE `cs`.`classarm_id` = '$classarm' AND `cs`.`session` = '$session' AND `cs`.`term` = '$term' AND `cs`.`class_id` = '$class_id' AND `s`.`school_id` = '$school'";


                $students = fetchDataTableWithSql($sql, 50);
        
                Input::flash();
        
                return view('super-admin.batch-delete', compact('data', 'students', 'ngstate', 'ngstate_lgas'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }

    function studentblukdeletePost(Request $request){
        // return $request->all();
        $error = array();
        $ids = $request->student_id;
        foreach ($ids as $id) {
            if(Student::find($id)){
                Student::find($id)->delete();
            }else{
                $error[] = 'Student with id'.$id.' not found';
            }
        }
        if(empty($error)){
            flash('Successfully deleted Students')->success();
            return redirect()->back();  
        }else{
            flash($error)->error();
            return redirect()->back()
                             ->withInput();  

        }
    }
    
    

    public function unityView(){
        $title = 'Unity Entrance Examination';
        return view('super-admin.unity.view', compact('title'));
    }

    public function unityCreateCenter(Request $request){
        if( UnityCenter::create($request->all()) ){
            flash('Successfully Created Center')->success();
            return redirect()->back();
        }else{
            flash('Failed to create center')->error();
            return redirect()->back()
                             ->withInput();
        }
    }

    public function unityDeleteCenter(Request $request){
        if( UnityCenter::find($request->center_id)->delete() ){
            flash('Successfully Deleted Center')->success();
            return redirect()->back();
        }else{
            flash('Failed to delete center')->error();
            return redirect()->back()
                             ->withInput();
        }
    }

    public function unityCreateHall(Request $request){
        if( UnityHall::create($request->all()) ){
            flash('Successfully Created Hall')->success();
            return redirect()->back();
        }else{
            flash('Failed to create center')->error();
            return redirect()->back()
                             ->withInput();
        }
    }

    public function unityDeleteHall(Request $request){
        if( UnityHall::find($request->hall_id)->delete() ){
            flash('Successfully Deleted Hall')->success();
            return redirect()->back();
        }else{
            flash('Failed to delete center')->error();
            return redirect()->back()
                             ->withInput();
        }
    }

    public function unityViewCenters(Request $request){
        if( !empty($request->lga_id) && $request->type == 'center' ){
            $lgaCenters = UnityCenter::where('lga_id', $request->lga_id)->get();
            $title = 'Unity Entrance Examination';
            return view('super-admin.unity.view', compact('title', 'lgaCenters'));
        }elseif( !empty($request->lga_id) && $request->type == 'student' ){
            $students = UnityHallAllocation::where('school_center_id', $request->center_id)->get();
            $title = 'Unity Entrance Examination';
            return redirect()->back()->with('lgaStudents', $students);
        }else{
            flash('Please select ')->error();
            return redirect()->back()
                             ->withInput();
        }
    }

    public function unityAssignStudents(Request $request){
        $halls = UnityHall::where('unity_centers_id', $request->unity_centers_id)->get();
        $students = UnityHallAllocation::where('school_center_id', $request->unity_centers_id)->get();
        $title = 'Assign Students To Hall';
        return view('super-admin.unity.layouts.post-assign-students', compact('title','students','halls'));
    }
    public function unityAssignStudentsPost(Request $request){
        if(!empty($request->hall_id) && !empty($request->student_id)){
            $students = $request->student_id;
            $errors = '';
            $success = '';
            foreach ($students as $student) {
                $studentAllocation = UnityHallAllocation::find($student);
                if($studentAllocation){
                    $studentAllocation->hall_id = $request->hall_id;
                    if($studentAllocation->save()){
                        $success .= 'Successfully updated hall for '.$studentAllocation->unity_exam->surname.' '.$studentAllocation->unity_exam->firstname.' '.$studentAllocation->unity_exam->middlename."<br>";
                    }else{
                        $errors .= 'Failed to update hall for '.$studentAllocation->unity_exam->surname.' '.$studentAllocation->unity_exam->firstname.' '.$studentAllocation->unity_exam->middlename."<br>";
                    }
                }else{
                    $errors .= 'Student not found'."<br>";
                }
            }
            if(!empty($errors)){
                flash($errors)->error();
            }
            if(!empty($success)){
                flash($success)->success();
            }
            // return back();
            return redirect()->route('super_admin.view.unity', ['action' => 'assign-students']);
        }else{
            flash('Please fill all required fields')->error();
            // return back();
            return redirect()->route('super_admin.view.unity', ['action' => 'assign-students']);
        }
    }



//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////  START: PAYMENT CALLS  //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   


    public function paymentAllSchools()
    {
        $title = "All Schools";

        $schools =     DB::table('schools')
                                ->select('schools.id', 'schools.name as school_name', 'schools.school_category', 'lgas.name as lga_name')
                                ->join('lgas', 'schools.lga_id', '=', 'lgas.id')
                                ->orderBy('lgas.name', 'asc')
                                ->paginate(10);

        return view('super-admin.payment.all-schools', compact('title', 'schools'));
    }//End Method


    public function paymentTransactionVerified($id)
    {
        $school_data = $this->schools->find($id);
        $title = "All Verified Transaction";

        $transactions =     DB::table('payment')
                                ->select('payment.*', 'payment_items.item_name', 'payment_items.cost')
                                ->where('pay_status', 2)
                                ->where('payment.school_id', $id)
                                ->join('payment_items', 'payment.item_id', '=', 'payment_items.id')
                                ->orderBy('order_date', 'desc')
                                ->paginate(10);


        return view('super-admin.payment.all-transaction-verified', compact('title', 'transactions', 'school_data'));
    }//End Method


    public function paymentTransactionUnverified($id)
    {
        $school_data = $this->schools->find($id);
        $title = "All Unverified Transaction";
        
        $transactions =     DB::table('payment')
                                ->select('payment.*', 'payment_items.item_name', 'payment_items.cost')
                                ->where('pay_status', 1)
                                ->where('payment.school_id', $id)
                                ->join('payment_items', 'payment.item_id', '=', 'payment_items.id')
                                ->orderBy('order_date', 'desc')
                                ->paginate(10);


        return view('super-admin.payment.all-transaction-unverified', compact('title', 'transactions', 'school_data'));
    }//End Method


    public function paymentDetails($id)
    {
        $title = "Transaction Details";

        $payment_recipients =   DB::table('payment_recipient')
                                ->select('payment_recipient.*', 'students.regnum', 'students.firstname', 'students.middlename', 'students.surname')
                                ->where('payment_recipient.pay_id', $id)
                                ->join('students', 'payment_recipient.student_id', '=', 'students.id')
                                ->get();

        $payment_data =     DB::table('payment')
                                ->select('payment.*', 'payment_items.item_name', 'payment_items.cost')
                                ->where('payment.id', $id)
                                ->join('payment_items', 'payment.item_id', '=', 'payment_items.id')
                                ->first();

        $order_date = date('M jS Y, g:i a', strtotime($payment_data->order_date));  

        $school_data = $this->schools->find($payment_data->school_id);             
        $admin_data = $this->admin->find($payment_data->payer_id);               

        return view('super-admin.payment.transaction-details', compact('title', 'payment_data', 'payment_recipients', 'order_date', 'admin_data', 'school_data'));
    }//End Method


//////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////  END: PAYMENT CALLS  //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////   



    public function newsView(){
        $title = 'News section';
        return view('super-admin.news', compact('title'));
    }

    public function newsCreate(Request $request){
        if(News::create($request->all())){
            flash('News posted')->success();
            return redirect()->back();
        }else{
            flash('Failed to post news, try again')->error();
            return redirect()->back();
        }
    }

    public function newsEdit(Request $request){
        if(News::find($request->id)->update($request->all())){
            flash('News updated')->success();
            return redirect()->back();
        }else{
            flash('Failed to update news, try again')->error();
            return redirect()->back();
        }
    }

    public function newsDelete(Request $request){
        if(News::find($request->id)->delete()){
            flash('News deleted')->success();
            return redirect()->back();
        }else{
            flash('Failed to delete news, try again')->error();
            return redirect()->back();
        }
    }

    protected function validateTopMinistryUser(){
        $super_admin_id = auth('super_admin')->id();
        if($super_admin_id != 2){
            flash('Permission Denied')->error();
            return abort(401);
        }
    }

    public function schoolsWalletView(Request $request){
        if($this->permissionDeny('edit-wallet')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $title = 'Schools Wallet';

        $schools = $this->schools->setSchool()->paginate(20);

        if(isset($request->name_keyword)){
            $schools = $this->schools->setSchool()->where('name', 'like', '%'.$request->name_keyword.'%')->paginate(20);
            $schools->setPath('?name_keyword='.$request->name_keyword);
        }elseif(isset($request->lga_keyword)){
            $schools = $this->schools->setSchool()->where('lga_id', $request->lga_keyword)->paginate(20);
            $schools->setPath('?lga_keyword='.$request->lga_keyword);
        }

        return view('super-admin.wallets.view-school', compact('title', 'schools'));
    }

    public function schoolsWalletTransactions($school_id){
        $title = 'Schools Wallet Transactions';
        $school = School::find($school_id);

        return view('super-admin.wallets.transactions', compact('title', 'school'));
    }
    
    public function schoolWalletUpdate(Request $request){
        if(isset($request->digital_amount)){
            if($request->digital_amount == ''){
                flash('Please provide an amount')->error();
            }else{
                flash('Digital payment fee was set to '.$request->digital_amount)->success();
                PaymentItems::find(1)->update([
                    'cost' => $request->digital_amount
                ]);
            }
        }else{
            $school = School::find($request->school_id);
            $school->phone = $request->phone;
            $school->save();
            $wallet = Wallet::find($school->wallet_id);
            $amount = $request->amount;
            if($amount == ''){
                flash(ucfirst($school->name)."'s phone number was updated but was not credited. Please input an amount to credit the wallet")->success(); 
                return back();
            }
            
            if($amount == '0.00' || $amount == '0'){
                $wallet->available_balance = 0.00;
                $wallet->account_balance = 0.00;
                $wallet->save();
                flash(ucfirst($school->name)."'s wallet was reset")->success();
            }else{
                $wallet->available_balance = $wallet->available_balance + $amount;
                $wallet->account_balance = $wallet->account_balance + $amount;
                $wallet->last_payment = $amount;
                $wallet->save();
                
                // save transaction
                $saved_transaction = Transaction::create([
                    'school_id' => $request->school_id,
                    'title' => 'Digital payment',
                    'description' => 'your wallet was credited with ₦'.$amount,
                    'amount' => $amount
                ]);
                
                $message = urlencode(ucfirst($school->name)."'s wallet has been credited with N".$amount.".\nvisit https://odsgmoe.com/eportal/admin/school-wallet to view wallet");
                prepareSMSGateWay(urlencode('ODSGMOE'), urlencode($request->phone), $message);
                
                // mr gideon
                $message = urlencode(ucfirst($school->name)."'s wallet has been credited with N".$amount."\n credited on ".$saved_transaction->created_at);
                prepareSMSGateWay(urlencode('ODSGMOE'), urlencode(2348053081549), $message);
                
                // mr gideon's MD
                prepareSMSGateWay(urlencode('ODSGMOE'), urlencode(2348033589938), $message);
                
                flash(ucfirst($school->name)."'s wallet was credited with ₦".$amount)->success();
            }
        }
        return redirect()->back();
    }
    
    public function schoolIdCardSchoolsView(Request $request){
        $title = 'Schools ID Cards';

        // $schools = $this->schools->setSchool()->withCount(['idCardRequest'])->paginate(20);
        // $schools = $this->schools->setSchool()->with('idCardRequest')->orderBy(function($school)
        // {
        //     return StudentIDCardRequest::where('is_verified', false)->where('school_id', $school->id)->get()->count();
        // }, true)->limit(5)->get();
        // $schools = $this->schools->setSchool()->withCount(['idCardRequest'])->with(['idCardRequest'])->orderBy('id_card_request_count', 'desc')->paginate(5);
        $schools = $this->schools->setSchool()->with('idCardRequest')
        ->select('schools.*', \DB::raw('(SELECT COUNT(is_verified) FROM student_id_card_requests WHERE student_id_card_requests.is_verified = false and student_id_card_requests.school_id = schools.id ) as sort'))
        ->orderBy('sort', 'desc')
        ->paginate(20);
        
        if(isset($request->name_keyword)){
            $schools = $this->schools->setSchool()->where('name', 'like', '%'.$request->name_keyword.'%')->with('idCardRequest')
            ->select('schools.*', \DB::raw('(SELECT COUNT(is_verified) FROM student_id_card_requests WHERE student_id_card_requests.is_verified = false and student_id_card_requests.school_id = schools.id ) as sort'))
            ->orderBy('sort', 'desc')
            ->paginate(20);
            $schools->setPath('?name_keyword='.$request->name_keyword);
        }elseif(isset($request->lga_keyword)){
            $schools = $this->schools->setSchool()->where('lga_id', $request->lga_keyword)->with('idCardRequest')
            ->select('schools.*', \DB::raw('(SELECT COUNT(is_verified) FROM student_id_card_requests WHERE student_id_card_requests.is_verified = false and student_id_card_requests.school_id = schools.id ) as sort'))
            ->orderBy('sort', 'desc')
            ->paginate(20);;
            $schools->setPath('?lga_keyword='.$request->lga_keyword);
        }

        return view('super-admin.id-cards.index', compact('title', 'schools'));
    }
    
    public function schoolIdCardRequestView($id){
        if($this->permissionDeny('edit-id-card-request')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $user =  auth('super_admin')->user();
        $classes = $this->classes->setClass()
                                ->where('school_id', $id)
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', $id)
                                ->get();
        $school = School::find($id);
        $wallet = [];
        if(count($school->wallet) > 0){
            $wallet = $school->wallet;
        }
        
        return view('super-admin.id-cards.school', compact('user', 'school', 'wallet', 'classes', 'class_arms'));
    }
    
    public function schoolIdCardRequestAction(Request $request){
       // return $request->all();
       //if students id is empty
       if(empty($request->student_id)){
           flash('Please select atleast one student')->error();
           return back();
       }
        if($request->type == 'approve'){
            $student_id = $request->student_id;
            $msg = "ID Card Requests \n \n";
            $phone = School::find($request->school_id)->phone;
            foreach($student_id as $id){
                $student =  Student::find($id);
                // check if id card is available
                if($created = StudentIDCardRequest::where('student_id', $student->id)->where('school_id', $request->school_id)->get()->first()){
                    $created->is_verified = true;
                    $created->save();
                    $msg .= $student->surname." ".$student->firstname."'s ID Card Request as been approved successfully \n";
                    flash($student->surname.' '.$student->firstname."'s ID Card Request as been approved successfully")->success();
                }else{
                    $msg .= $student->surname." ".$student->firstname."'s ID Card Request seems to be invalid. Validate payment please \n";
                    flash($student->surname." ".$student->firstname."s ID Card Request seems to be invalid. Validate payment please")->error();
                }
            }
            // send sms
            if($phone != '' || $phone != null){
                $message = urlencode($msg);
                prepareSMSGateWay(urlencode('ODSGMOE'), urlencode($phone), $message);
            }
            
            return back();
        }elseif($request->type == 'unapprove'){
            $student_id = $request->student_id;
            foreach($student_id as $id){
                $student =  Student::find($id);
                // check if id card is available
                if($created = StudentIDCardRequest::where('student_id', $student->id)->where('school_id', $request->school_id)->get()->first()){
                    $created->is_verified = false;
                    $created->save();
                    flash($student->surname.' '.$student->firstname."'s ID Card Request as been unapproved successfully")->success();
                }else{
                    flash($student->surname." ".$student->firstname."s ID Card Request seems to be invalid. Validate payment please")->error();
                }
            }
            return back();
        }elseif($request->type == 'print'){
            $students = array();
            $school = School::find($request->school_id);
            $student_id = $request->student_id;
            foreach($student_id as $id){
               $student =  Student::find($id);
                $payment = DigitalPayment::where('student_id', $student->id)->get()->first();
                if($payment){
                    $students[] = $student;
                }else{
                    flash('ID Card for '.$student->firstname.' is not available. Please Double check payment')->error();
                }
            }
           return view('super-admin.id-cards.card', compact('school', 'students'));
        }else{
            flash('Unknown action???')->error();
            return back();
        }
    }
    
    public function schoolIdCardRequestDownload($id, $school_id){
       $request = StudentIDCardRequest::where('student_id', $id)
                ->where('school_id', $school_id)
                ->where('is_verified', true)
                ->get();
       if($request->count() > 0){
           $idCard = $request->first();
           $idCard->is_downloaded = true;
           $idCard ->save();
           
            return response()->json([
                'message' => true  
            ], 200);
       }
        return response()->json([
            'message' => false  
        ], 400);
    }
    
    public function annualAssetView(Request $request){
        if($this->permissionDeny('view-annual-assessment')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $title = 'Annual Assessments';

        $schools = $this->schools->setSchool()->paginate(20);

        if(isset($request->name_keyword)){
            $schools = $this->schools->setSchool()->where('name', 'like', '%'.$request->name_keyword.'%')->paginate(20);
            $schools->setPath('?name_keyword='.$request->name_keyword);
        }elseif(isset($request->lga_keyword)){
            $schools = $this->schools->setSchool()->where('lga_id', $request->lga_keyword)->paginate(20);
            $schools->setPath('?lga_keyword='.$request->lga_keyword);
        }

        return view('super-admin.annual-asset.index', compact('title', 'schools'));
    }
    
    public function schoolAnnualAssetView($id){
        $school = School::find($id);
        $title = ucfirst($school->name)."'s Annual Assesment";
        return view('super-admin.annual-asset.school', compact('title', 'school'));
    }
    
    public function overview(){
         if($this->permissionDeny('view-annual-assessment')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        
        $title = 'ODSGMOE Overview';
        return view('super-admin.overview', compact('title'));
    }
    
    public function schoolSurvey(Request $request){
        $title = 'Schools Survey';
        if($request->type == 'search_school_admin'){
            if(isset($request->keyword)){
                $school_admins = Admin::where('fullname', 'like', '%' . $request->keyword . '%')->paginate(20);
                $school_admins->setPath('search?type=search_school_admin&keyword='.$request->keyword);
                return view('super-admin.survey.view-schools', compact('title', 'school_admins'));
            }elseif(isset($request->school)){
                $school_admins = Admin::where('school_id', $request->school)->paginate(20);
                $school_admins->setPath('search?type=search_school_admin&school='.$request->school);
                return view('super-admin.survey.view-schools', compact('title', 'school_admins'));
            }
        }elseif($request->type == 'search_school'){
            if(isset($request->keyword)){
                $schools = School::where('name', 'like', '%' . $request->keyword . '%')->paginate(20);
                $schools->setPath('search?type=search_school&keyword='.$request->keyword);
                return view('super-admin.survey.view-schools', compact('title', 'schools'));
            }elseif(isset($request->lga)){
                $schools = School::where('lga_id', $request->lga)->paginate(20);
                $schools->setPath('search?type=search_school&lga='.$request->lga);
                return view('super-admin.survey.view-schools', compact('title', 'schools'));
            }
        }else{
            $schools = School::paginate(20);
            return view('super-admin.survey.view-schools', compact('title', 'schools'));
        }
    }
    
    public function teachersSurvey(Request $request){
        $title = 'Teachers Survey';
        // if(!isset($request->action)){
        //     if(!isset($request->lga_id) || $request->lga_id == ''){
        //         flash('Please select local government area')->error();
        //         return back();
        //     }elseif(!isset($request->school) || $request->school == ''){
        //         flash('Please select school')->error();
        //         return back();
        //     }
        // }
        if($request->school == 'all'){
            $teachers = Teacher::whereHas('school', function ($query) use($request) {
                            $query->where('lga_id', $request->lga_id);
                        })->paginate(20);
        }else{
            $teachers = Teacher::where('school_id', $request->school)->paginate(20);
        }
        $teachers->setPath('?lga_id='.$request->lga_id.'&school='.$request->school);
        return view('super-admin.survey.view-teachers', compact('title', 'teachers'));
    }
    
    public function teachersSurveySort(Request $request){
        if(!isset($request->school) || $request->school == ''){
            return response()->json([
                'message' => 'Please select school'
            ], 400);
        }
        
        if($request->retirement_year == '' && $request->retirement_year_range_start == '' && $requst->retirement_year_range_end != ''){
            $teachers = Teacher::where('school_id', $request->school)
                        ->whereHas('attendanceAnalytic', function ($query) use($request) {
                            if($request->subject_specialization_major != ''){
                                $query->where('teacher_subject_specialization_major', $request->subject_specialization_major);
                            }
                            
                            if($request->subject_specialization_minor != ''){
                                $query->where('teacher_subject_specialization_minor', $request->subject_specialization_minor);
                            }
                        })
                        ->orderBy('id', 'desc')
                        ->get();
            $male_teachers = Teacher::where('school_id', $request->school)
                        ->whereHas('attendanceAnalytic', function ($query) use($request) {
                            if($request->subject_specialization_major != ''){
                                $query->where('teacher_subject_specialization_major', $request->subject_specialization_major);
                            }
                            
                            if($request->subject_specialization_minor != ''){
                                $query->where('teacher_subject_specialization_minor', $request->subject_specialization_minor);
                            }
                        })
                        ->where('gender', 'Male')
                        ->get()
                        ->count();
            $female_teachers = Teacher::where('school_id', $request->school)
                        ->whereHas('attendanceAnalytic', function ($query) use($request) {
                            if($request->subject_specialization_major != ''){
                                $query->where('teacher_subject_specialization_major', $request->subject_specialization_major);
                            }
                            
                            if($request->subject_specialization_minor != ''){
                                $query->where('teacher_subject_specialization_minor', $request->subject_specialization_minor);
                            }
                        })
                        ->where('gender', 'Female')
                        ->get()
                        ->count();
        }elseif($request->retirement_year != ''){
            $teachers = []; $male_teachers = []; $female_teachers = [];
            $allTeachers = Teacher::whereHas('attendanceAnalytic', function ($query) use($request) {
                            if($request->subject_specialization_major != ''){
                                $query->where('teacher_subject_specialization_major', $request->subject_specialization_major);
                            }
                            
                            if($request->subject_specialization_minor != ''){
                                $query->where('teacher_subject_specialization_minor', $request->subject_specialization_minor);
                            }
                        })->get();
            foreach($allTeachers as $teacher){
                $analytics = $teacher->attendanceAnalytic->first();
                $rawDOB = explode(' ', $analytics->teacher_date_of_birth);
                $rawDOA = explode(' ', $analytics->teacher_date_of_service);
                $dob = $rawDOB[2];
                $doa = $rawDOA[2];
                
                $age =  date('Y') - $dob;
                $defaultYearsOfWorking = 35;
                $defaultRetirmentAge = 60;
                $yearsOfWorking = date('Y') - $doa;
                $yearOfStopWorking = $doa + $defaultYearsOfWorking;
                if($yearsOfWorking <= $defaultYearsOfWorking){
                    $yearsOfWorkingLeft = $defaultYearsOfWorking - $yearsOfWorking;
                }else{
                    $yearsOfWorkingLeft = 0;
                }
                
                if($request->retirement_year == $yearOfStopWorking){
                    $teachers[] .= $teacher;
                }
                if($request->retirement_year == $yearOfStopWorking && $teacher->gender == 'Male'){
                    $male_teachers[] .= $teacher;
                }
                if($request->retirement_year == $yearOfStopWorking && $teacher->gender == 'Female'){
                    $female_teachers[] .= $teacher;
                }
            }
        }
        
        return response()->json([
            'message' => 'success',
            'all_count' => $teachers->count(),
            'male_count' => $male_teachers,
            'female_count' => $female_teachers,
            'data' => $teachers,
            'request' => $request->all()
        ], 200);
    }
    
    public function teachersSurveySortExport(Request $request){
        if(!isset($request->school) || $request->school == ''){
            return response()->json([
                'message' => 'Please select school'
            ], 400);
        }
        $lga = OndoLGA::find($request->lga_id);
        $school = School::find($request->school);
        $teachers = Teacher::select('title', 'surname', 'firstname', 'middlename', 'marital_status', 'staff_no', 'qualification', 'email', 'phone', 'gender', 'address', 'session')->where('school_id', $request->school)
                    ->whereHas('attendanceAnalytic', function ($query) use($request) {
                        if($request->subject_specialization_major != ''){
                            $query->where('teacher_subject_specialization_major', $request->subject_specialization_major);
                        }
                        
                        if($request->subject_specialization_minor != ''){
                            $query->where('teacher_subject_specialization_minor', $request->subject_specialization_minor);
                        }
                        
                        if($request->retirement_year != ''){
                            $query->where('teacher_date_of_service', '>', $request->retirement_year);
                        }
                        
                        if($request->retirement_year_range_start != ''){
                            $endDate = ($requst->retirement_year_range_end != '') ? $requst->retirement_year_range_end : date('Y');
                            $query->where('teacher_date_of_service', '>', $request->retirement_year_range_start)
                                    ->where('teacher_date_of_service', '<=', $endDate);
                        }
                    })
                    ->orderBy('id', 'desc')
                    ->get();

        Excel::create(ucwords($school->name)." Teachers Survey", function($excel) use ($school, $lga, $teachers){
            $excel->setTitle(ucwords($school)." Teachers Survey");
            $excel->sheet(ucwords($lga->name), function($sheet) use ($school, $lga, $teachers){
                $sheet->fromArray($teachers);
            });
        })->download('xlsx');
    }
    
    public function schoolSurveyStats(Request $request, $session){
        $title = 'Schools Survey Statistics';
        $surveys = SchoolSurvey::where('session', $session)->groupBy('school_id')->orderBy('created_at', 'desc')->get();
        return view('super-admin.survey.view-schools-stats', compact('title', 'surveys', 'session'));
    }
    
    public function schoolSurveyStatsExport(Request $request){
        if(!isset($request->lga) || $request->lga == ''){
            flash('Please select LGA')->error();
            return back();
        }
        
        $lga = $request->lga;
        $session = $request->session;

        $schools = School::where('lga_id', $lga)->get();
        if($schools->count() <= 0){
            flash('Schools in selected LGA not found')->error();
            return back();
        }

        $types = ['enrolment', 'teaching', 'non teaching', 'facilities', 'furniture', 'summary'];
        if($request->type == 'all'){
            Excel::create($session." ".ucwords(OndoLGA::find($lga)->name)."'s Schools Survey", function($excel) use ($lga, $types, $session){
                $excel->setTitle($session." ".ucwords(OndoLGA::find($lga)->name)."'s Schools Survey");
                foreach($types as $type){
                    $excel->sheet(ucwords($type), function($sheet) use ($type, $lga, $session){
                        $this->getExcelSchoolsSurveyStyles($type, $sheet);
                        $sheet->fromArray($this->getExcelSchoolsSurveyData($type, $lga, $session));
                    });
                }
            })->download('xlsx');
        }elseif(in_array($request->type, $types)){
            $type = $request->type;
            Excel::create($session." ".ucwords($type)." School's Survey", function($excel) use ($lga, $type, $session){
                $excel->setTitle($session." ".ucwords(OndoLGA::find($lga))."'s ".ucwords($type)." Survey");
                $excel->sheet(ucwords($type), function($sheet) use ($type, $lga, $session){
                    $this->getExcelSchoolsSurveyStyles($type, $sheet);
                    $sheet->fromArray($this->getExcelSchoolsSurveyData($type, $lga, $session));
                });
            })->download('xlsx');
        }else{
            flash('unknown type')->error();
            return back();
        }
    }

    public function getExcelSchoolsSurveyStyles($type, $sheet){
        $sheet->setStyle(array(
            'font' => array(
                'name'      =>  'Calibri'
            )
        ));

        // merge header cells
        $sheet->mergeCells('A1:Z1');
        $sheet->cell('A1', function($cell) {
            $cell->setValue('.');
        });

        if($type == 'enrolment'){
            // headings
            $sheet->cell('A2:Z2', function ($cells) {
                $cells->setFontSize(15);
                $cells->setFontWeight('bold');
            });
            $sheet->cell('A3:Z3', function ($cells) {
                $cells->setFontSize(15);
                $cells->setFontWeight('bold');
            });
            $sheet->cell('A4:Z4', function ($cells) {
                $cells->setFontSize(15);
                $cells->setFontWeight('bold');
            });
            $sheet->cell('B5:Z5', function ($cells) {
                $cells->setFontSize(14);
                $cells->setFontWeight('bold');
            });
            $sheet->mergeCells('A2:Z2');
            $sheet->mergeCells('A3:Z3');
            $sheet->mergeCells('A4:Z4');
            $sheet->mergeCells('B5:Z5');

            // merge cells content
            $sheet->mergeCells('C6:D6');
            $sheet->mergeCells('E6:F6');
            $sheet->mergeCells('G6:H6');
            $sheet->mergeCells('I6:J6');
            $sheet->mergeCells('K6:L6');
            $sheet->mergeCells('M6:N6');
            $sheet->mergeCells('O6:P6');

            // Disable auto size for sheet
            $sheet->setAutoSize(false);
            $sheet->setSize('B6', 65, null);
            $style = array(
                'alignment' => array(
                    'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                )
            );

            $sheet->getStyle("A2:Z2")->applyFromArray($style);
            $sheet->getStyle("A3:Z3")->applyFromArray($style);
            $sheet->getStyle("A4:Z4")->applyFromArray($style);
        }elseif($type == 'teaching'){
            // headings
            $sheet->cell('A2:Z2', function ($cells) {
                $cells->setFontSize(15);
                $cells->setFontWeight('bold');
            });
            $sheet->cell('A3:Z3', function ($cells) {
                $cells->setFontSize(15);
                $cells->setFontWeight('bold');
            });
            $sheet->cell('B4:Z4', function ($cells) {
                $cells->setFontSize(14);
                $cells->setFontWeight('bold');
            });
            $sheet->mergeCells('A2:Z2');
            $sheet->mergeCells('A3:Z3');
            $sheet->mergeCells('B4:Z4');

            // merge cells content
            $sheet->mergeCells('C5:D5');
            $sheet->mergeCells('E5:F5');
            $sheet->mergeCells('G5:H5');
            $sheet->mergeCells('I5:J5');
            $sheet->mergeCells('K5:L5');

            // Disable auto size for sheet
            $sheet->setAutoSize(false);
            $sheet->setSize('B5', 65, 20);
            $style = array(
                'alignment' => array(
                    'horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                )
            );

            $sheet->getStyle("A2:Z2")->applyFromArray($style);
            $sheet->getStyle("A3:Z3")->applyFromArray($style);
        }
        return $sheet;
    }
    
    public function getExcelSchoolsSurveyData($type, $lga, $session){
        $ondoLga = OndoLGA::find($lga);
        if($type == 'enrolment'){
            $enrolementArray = array(
                1 => array('', '', '', '', 'MINISTRY OF EDUCATION, SCIENCE AND TECHNOLOGY', '', '', '', '', '', '','', '', '', '', '', ''),
                2 => array('', '', '', '', 'PLANNING, RESEARCH AND STATISTICS DEPARTMENT', '', '', '', '', '', '','', '', '', '', '', ''),
                3 => array('', '', '', '', 'ENROLMENT OF PUBLIC SECONDARY SCHOOLS F', '', '', '', '', '', '', '', '', '', '', '', ''),
                4 => array('', $ondoLga->id.'. L.G.A.:-  '.strtoupper($ondoLga->name), '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                5 => array('S/N', 'SCHOOLS', 'JSS I', '', 'JSS II', '', 'JSS III', '', 'SSS I', '', 'SSS II', '', 'SSS III', '', 'TOTAL', '', 'GRAND TOTAL'),
                6 => array('', '', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', ''),
            );
            $counter = 1;
            $total_jss1_male = 0;
            $total_jss1_female = 0;
            $total_jss2_male = 0;
            $total_jss2_female = 0;
            $total_jss3_male = 0;
            $total_jss3_female = 0;
            $total_sss1_male = 0;
            $total_sss1_female = 0;
            $total_sss2_male = 0;
            $total_sss2_female = 0;
            $total_sss3_male = 0;
            $total_sss3_female = 0;
            $total_total_male = 0;
            $total_total_female = 0;
            $total_number_of_students = 0;
            foreach (School::where('lga_id', $lga)->get() as $school) {
                $schoolSurvey = SchoolSurvey::where('school_id', $school->id)->where('session', $session)->get()->first();
                $jss1_male = ($schoolSurvey) ? $schoolSurvey->jss1_male : '';
                $jss1_female = ($schoolSurvey) ? $schoolSurvey->jss1_female : '';
                $jss2_male = ($schoolSurvey) ? $schoolSurvey->jss2_male : '';
                $jss2_female = ($schoolSurvey) ? $schoolSurvey->jss2_female : '';
                $jss3_male = ($schoolSurvey) ? $schoolSurvey->jss3_male : '';
                $jss3_female = ($schoolSurvey) ? $schoolSurvey->jss3_female : '';
                $sss1_male = ($schoolSurvey) ? $schoolSurvey->sss1_male : '';
                $sss1_female = ($schoolSurvey) ? $schoolSurvey->sss1_female : '';
                $sss2_male = ($schoolSurvey) ? $schoolSurvey->sss2_male : '';
                $sss2_female = ($schoolSurvey) ? $schoolSurvey->sss2_female : '';
                $sss3_male = ($schoolSurvey) ? $schoolSurvey->sss3_male : '';
                $sss3_female = ($schoolSurvey) ? $schoolSurvey->sss3_female : '';
                $total_male = ($schoolSurvey) ? $schoolSurvey->total_male : '';
                $total_female = ($schoolSurvey) ? $schoolSurvey->total_female : '';
                $number_of_students = ($schoolSurvey) ? $schoolSurvey->number_of_students : '';

                // totals
                $total_jss1_male = $total_jss1_male + $jss1_male;
                $total_jss1_female = $total_jss1_female + $jss1_female;
                $total_jss2_male = $total_jss2_male + $jss2_male;
                $total_jss2_female = $total_jss2_female + $jss2_female;
                $total_jss3_male = $total_jss3_male + $jss3_male;
                $total_jss3_female = $total_jss3_female + $jss3_female;
                $total_sss1_male = $total_sss1_male + $sss1_male;
                $total_sss1_female = $total_sss1_female + $sss1_female;
                $total_sss2_male = $total_sss2_male + $sss2_male;
                $total_sss2_female = $total_sss2_female + $sss2_female;
                $total_sss3_male = $total_sss3_male + $sss3_male;
                $total_sss3_female = $total_sss3_female + $sss3_female;
                $total_total_male = $total_total_male + $total_male;
                $total_total_female = $total_total_female + $total_female;
                $total_number_of_students = $total_number_of_students + $number_of_students;

                $enrolementArray[] = array(
                    $counter, 
                    strtoupper($school->name), 
                    $jss1_male, 
                    $jss1_female, 
                    $jss2_male,
                    $jss2_female,
                    $jss3_male,
                    $jss3_female,
                    $sss1_male,
                    $sss1_female,
                    $sss2_male, 
                    $sss2_female,
                    $sss3_male,
                    $sss3_female,
                    $total_male,
                    $total_female,
                    $number_of_students
                );
                $counter++;
            }
            $enrolementArray[] = array(
                '', 
                'TOTAL:',
                $total_jss1_male,
                $total_jss1_female,
                $total_jss2_male,
                $total_jss2_female,
                $total_jss3_male,
                $total_jss3_female,
                $total_sss1_male,
                $total_sss1_female,
                $total_sss2_male,
                $total_sss2_female,
                $total_sss3_male,
                $total_sss3_female,
                $total_total_male,
                $total_total_female,
                $total_number_of_students
            );
            return $enrolementArray;
        }elseif($type == 'teaching'){
            $teachingArray = array(
                1 => array('', '', '', '', '', 'MINISTRY OF EDUCATION', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                2 => array('', '', '', '', '', 'PUBLIC SECONDARY SCHOOLS TEACHERS\' QUALIFICATIONS', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                3 => array('', $ondoLga->id.'. L.G.A.:-  '.strtoupper($ondoLga->name), '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                4 => array('S/N', 'SCHOOLS', 'Master Deg with TQ', '', 'Graduate with TQ', '', 'Graduate without TQ', '', 'NCE', '', 'Total', '', 'GRAND', '', '', '', '', '', '', '', '', '', '', '', ''),
                5 => array('', '', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'TOTAL', '', '', '', '', '', '', '', '', '', '', '', ''),
            );
            $counter = 1;
            foreach (School::where('lga_id', $lga)->get() as $school) {
                $schoolSurvey = SchoolSurvey::where('school_id', $school->id)->where('session', $session)->get()->first();
                $master_degree_with_tq_male = ($schoolSurvey) ? $schoolSurvey->master_degree_with_tq_male : '';
                $master_degree_with_tq_female = ($schoolSurvey) ? $schoolSurvey->master_degree_with_tq_female : '';
                $graduate_with_tq_male = ($schoolSurvey) ? $schoolSurvey->graduate_with_tq_male : '';
                $graduate_with_tq_female = ($schoolSurvey) ? $schoolSurvey->graduate_with_tq_female : '';
                $graduate_without_tq_male = ($schoolSurvey) ? $schoolSurvey->graduate_without_tq_male : '';
                $graduate_without_tq_female = ($schoolSurvey) ? $schoolSurvey->graduate_without_tq_female : '';
                $nce_male = ($schoolSurvey) ? $schoolSurvey->nce_male : '';
                $nce_female = ($schoolSurvey) ? $schoolSurvey->nce_female : '';
                $qualification_male = ($schoolSurvey) ? $schoolSurvey->qualification_male : '';
                $qualification_female = ($schoolSurvey) ? $schoolSurvey->qualification_female : '';
                $qualification_total = ($schoolSurvey) ? $schoolSurvey->qualification_total : '';
                $teachingArray[] = array(
                    $counter, 
                    strtoupper($school->name), 
                    $master_degree_with_tq_male, 
                    $master_degree_with_tq_female, 
                    $graduate_with_tq_male, 
                    $graduate_with_tq_female, 
                    $graduate_without_tq_male, 
                    $graduate_without_tq_female, 
                    $nce_male, 
                    $nce_female, 
                    $qualification_male, 
                    $qualification_female, 
                    $qualification_total, '', '', '', '', '', '', '', '', '', '', '', ''
                );
                $counter++;
            }
            return $teachingArray;
        }elseif($type == 'non teaching'){
            $nonteachingArray = array(
                1 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                2 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                3 => array('', 'MINISTRY OF EDUCATION', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                4 => array('', 'ENROLMENT OF PUBLIC SECONDARY SCHOOLS', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                5 => array('', $ondoLga->id.'. L.G.A.:-  '.strtoupper($ondoLga->name), '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                6 => array('S/N', 'SCHOOLS', 'ACCT STAFF', '', 'CLERICAL OFF', '', 'LAB ASST', '', 'LIBRARY', '', 'DATA CLERKS', '', 'TYPIST', '', 'MESSANGERS', '', 'GARDENERS', '', 'DAY/NIGHT GD', '', 'OTHERS', '', 'TOTAL', '', '', ''),
                7 => array('', '', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', 'M', 'F', '', '', '', ''),
            );

            $counter = 1;
            foreach (School::where('lga_id', $lga)->get() as $school) {
                $schoolSurvey = SchoolSurvey::where('school_id', $school->id)->where('session', $session)->get()->first();
                $account_staff_male = ($schoolSurvey) ? $schoolSurvey->account_staff_male : '';
                $account_staff_female = ($schoolSurvey) ? $schoolSurvey->account_staff_female : '';
                $clerical_staff_male = ($schoolSurvey) ? $schoolSurvey->clerical_staff_male : '';
                $clerical_staff_female = ($schoolSurvey) ? $schoolSurvey->clerical_staff_female : '';
                $laboratory_assistant_male = ($schoolSurvey) ? $schoolSurvey->laboratory_assistant_male : '';
                $laboratory_assistant_female = ($schoolSurvey) ? $schoolSurvey->laboratory_assistant_female : '';
                $library_assistant_male = ($schoolSurvey) ? $schoolSurvey->library_assistant_male : '';
                $library_assistant_female = ($schoolSurvey) ? $schoolSurvey->library_assistant_female : '';
                $data_clerk_male = ($schoolSurvey) ? $schoolSurvey->data_clerk_male : '';
                $data_clerk_female = ($schoolSurvey) ? $schoolSurvey->data_clerk_female : '';
                $typist_male = ($schoolSurvey) ? $schoolSurvey->typist_male : '';
                $typist_female = ($schoolSurvey) ? $schoolSurvey->typist_female : '';
                $messangers_male = ($schoolSurvey) ? $schoolSurvey->messangers_male : '';
                $messangers_female = ($schoolSurvey) ? $schoolSurvey->messangers_female : '';
                $gardeners_male = ($schoolSurvey) ? $schoolSurvey->gardeners_male : '';
                $gardeners_female = ($schoolSurvey) ? $schoolSurvey->gardeners_female : '';
                $guard_male = ($schoolSurvey) ? $schoolSurvey->guard_male : '';
                $guard_female = ($schoolSurvey) ? $schoolSurvey->guard_female : '';
                $category_other_male = ($schoolSurvey) ? $schoolSurvey->category_other_male : '';
                $category_other_female = ($schoolSurvey) ? $schoolSurvey->category_other_female : '';
                $category_total_total = ($schoolSurvey) ? $schoolSurvey->category_total_total : '';
                $nonteachingArray[] = array(
                    $counter, 
                    strtoupper($school->name), 
                    $account_staff_male, 
                    $account_staff_female, 
                    $clerical_staff_male, 
                    $clerical_staff_female, 
                    $laboratory_assistant_male, 
                    $laboratory_assistant_female, 
                    $library_assistant_male, 
                    $library_assistant_female, 
                    $data_clerk_male, 
                    $data_clerk_female, 
                    $typist_male, 
                    $typist_female, 
                    $messangers_male, 
                    $messangers_female, 
                    $gardeners_male, 
                    $gardeners_female, 
                    $guard_male, 
                    $guard_female, 
                    $category_other_male, 
                    $category_other_female, 
                    $category_total_total, '', '', ''
                );
                $counter++;
            }
            return $nonteachingArray;
        }elseif($type == 'facilities'){
            $facilitiesArray = array(
                1 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                2 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                3 => array('', '', '', '', 'infrastrutural facilities in scools', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                4 => array('', $ondoLga->id.'. L.G.A.:-  '.strtoupper($ondoLga->name), '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                5 => array('S/N', 'SCHOOLS', 'CLASSROOMS', '', '', 'LABORATORIES', '', '', 'COMPUTER ROOMS', '', '', 'TECHNICAL WORKSHOP', '', '', 'LIBRARY', '', '', 'TOILETS', '', '', 'SCHOOL FENCE', '', '', '', '', ''),
                6 => array('', '', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'AV', 'PA', 'NOT AV', '', '', ''),
            );

            $counter = 1;
            foreach (School::where('lga_id', $lga)->get() as $school) {
                $schoolSurvey = SchoolSurvey::where('school_id', $school->id)->where('session', $session)->get()->first();
                $classrooms_available = ($schoolSurvey) ? $schoolSurvey->classrooms_available : '';
                $classrooms_in_good_condition = ($schoolSurvey) ? $schoolSurvey->classrooms_in_good_condition : '';
                $classrooms_needed = ($schoolSurvey) ? $schoolSurvey->classrooms_needed : '';
                $laboratories_available = ($schoolSurvey) ? $schoolSurvey->laboratories_available : '';
                $laboratories_in_good_condition = ($schoolSurvey) ? $schoolSurvey->laboratories_in_good_condition : '';
                $laboratories_needed = ($schoolSurvey) ? $schoolSurvey->laboratories_needed : '';
                $computerroom_available = ($schoolSurvey) ? $schoolSurvey->computerroom_available : '';
                $computerroom_in_good_condition = ($schoolSurvey) ? $schoolSurvey->computerroom_in_good_condition : '';
                $computerroom_needed = ($schoolSurvey) ? $schoolSurvey->computerroom_needed : '';
                $technical_workshop_available = ($schoolSurvey) ? $schoolSurvey->technical_workshop_available : '';
                $technical_workshop_in_good_condition = ($schoolSurvey) ? $schoolSurvey->technical_workshop_in_good_condition : '';
                $technical_workshop_needed = ($schoolSurvey) ? $schoolSurvey->technical_workshop_needed : '';
                $library_available = ($schoolSurvey) ? $schoolSurvey->library_available : '';
                $library_in_good_condition = ($schoolSurvey) ? $schoolSurvey->library_in_good_condition : '';
                $library_workshop = ($schoolSurvey) ? $schoolSurvey->library_workshop : '';
                $toilet = ($schoolSurvey) ? $schoolSurvey->toilet : '';
                $school_fence = ($schoolSurvey) ? $schoolSurvey->school_fence : '';
                $facilitiesArray[] = array(
                    $counter, 
                    strtoupper($school->name), 
                    $classrooms_available, 
                    $classrooms_in_good_condition, 
                    $classrooms_needed, 
                    $laboratories_available, 
                    $laboratories_in_good_condition, 
                    $laboratories_needed, 
                    $computerroom_available, 
                    $computerroom_in_good_condition, 
                    $computerroom_needed, 
                    $technical_workshop_available, 
                    $technical_workshop_in_good_condition, 
                    $technical_workshop_needed, 
                    $library_available, 
                    $library_in_good_condition, 
                    $library_workshop, 
                    $toilet, '', '', 
                    $school_fence, '', '', '', '', '');
                $counter++;
            }
            return $facilitiesArray;
        }elseif($type == 'furniture'){
            $furnitureArray = array(
                1 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                2 => array('', 'student furniture in scools', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                3 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                4 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                5 => array('S/N', 'LOCAL GOVERNMENT AREAS', 'STUDENTS\' SEAT', '', '', 'STUDENTS\' DESKS', '', '', 'STAFF CHAIRS', '', '', 'STAFF TABLE', '', '', 'OTHERS', '', '', '', '', '', '', '', '', '', '', ''),
                6 => array('', '', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', '', '', '', '', '', '', '', '', ''),
            );
            $counter = 1;
            foreach (OndoLGA::all() as $lga) {
                $sumSurvey = SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                $student_seat_available = ($sumSurvey->sum('student_seat_available')) ? $sumSurvey->sum('student_seat_available') : '';
                $student_seat_in_good_condition = ($sumSurvey->sum('student_seat_in_good_condition')) ? $sumSurvey->sum('student_seat_in_good_condition') : '';
                $student_seat_needed = ($sumSurvey->sum('student_seat_needed')) ? $sumSurvey->sum('student_seat_needed') : '';
                $student_desk_available = ($sumSurvey->sum('student_desk_available')) ? $sumSurvey->sum('student_desk_available') : '';
                $student_desk_in_good_condition = ($sumSurvey->sum('student_desk_in_good_condition')) ? $sumSurvey->sum('student_desk_in_good_condition') : '';
                $student_desk_needed = ($sumSurvey->sum('student_desk_needed')) ? $sumSurvey->sum('student_desk_needed') : '';
                $staff_chairs_available = ($sumSurvey->sum('staff_chairs_available')) ? $sumSurvey->sum('staff_chairs_available') : '';
                $staff_chairs_in_good_condition = ($sumSurvey->sum('staff_chairs_in_good_condition')) ? $sumSurvey->sum('staff_chairs_in_good_condition') : '';
                $staff_chairs_desk_needed = ($sumSurvey->sum('staff_chairs_desk_needed')) ? $sumSurvey->sum('staff_chairs_desk_needed') : '';
                $staff_table_available = ($sumSurvey->sum('staff_table_available')) ? $sumSurvey->sum('staff_table_available') : '';
                $staff_table_in_good_condition = ($sumSurvey->sum('staff_table_in_good_condition')) ? $sumSurvey->sum('staff_table_in_good_condition') : '';
                $staff_table_desk_needed = ($sumSurvey->sum('staff_table_desk_needed')) ? $sumSurvey->sum('staff_table_desk_needed') : '';
                $other_furniture_available = ($sumSurvey->sum('other_furniture_available')) ? $sumSurvey->sum('other_furniture_available') : '';
                $other_furniture_in_good_condition = ($sumSurvey->sum('other_furniture_in_good_condition')) ? $sumSurvey->sum('other_furniture_in_good_condition') : '';
                $other_furniture_needed = ($sumSurvey->sum('other_furniture_needed')) ? $sumSurvey->sum('other_furniture_needed') : '';
                $furnitureArray[] = array(
                    $counter, 
                    strtoupper($lga->name), 
                    $student_seat_available, 
                    $student_seat_in_good_condition, 
                    $student_seat_needed, 
                    $student_desk_available, 
                    $student_desk_in_good_condition, 
                    $student_desk_needed, 
                    $staff_chairs_available, 
                    $staff_chairs_in_good_condition, 
                    $staff_chairs_desk_needed, 
                    $staff_table_available, 
                    $staff_table_in_good_condition, 
                    $staff_table_desk_needed, 
                    $other_furniture_available, 
                    $other_furniture_in_good_condition, 
                    $other_furniture_needed, '', '', '', '', '', '', '', '', ''
                );
                $counter++;
            }
            return $furnitureArray;
        }elseif($type == 'summary'){
            $summaryArray = array(
                1 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                2 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                3 => array('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
                4 => array('S/N', 'SCHOOLS', 'STUDENTS', 'CLASSROOMS', '', '', 'LABORATORIES', '', '', 'COMPUTER ROOMS', '', '', 'TECHNICAL WORKSHOP', '', '', 'LIBRARY', '', '', 'TOILETS', '', '', 'SCHOOL FENCE', '', '', 'CLASSROOM:STUDENTS', ''),
                5 => array('', '', 'ENROLMENT', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'NO AV', 'NO IN GC', 'NO ND', 'AV', 'PA', 'NOT AV', 'RATIO', ''),
            );
            $counter = 1;
            foreach (OndoLGA::all() as $lga) {
                $sumSurvey = SchoolSurvey::where('local_government_area', $lga->name)->where('session', $session);
                $student_seat_available = ($sumSurvey->sum('student_seat_available')) ? $sumSurvey->sum('student_seat_available') : '';
                $number_of_students = ($sumSurvey->sum('number_of_students')) ? $sumSurvey->sum('number_of_students') : '';
                $classrooms_available = ($sumSurvey->sum('classrooms_available')) ? $sumSurvey->sum('classrooms_available') : '';
                $classrooms_in_good_condition = ($sumSurvey->sum('classrooms_in_good_condition')) ? $sumSurvey->sum('classrooms_in_good_condition') : '';
                $classrooms_needed = ($sumSurvey->sum('classrooms_needed')) ? $sumSurvey->sum('classrooms_needed') : '';
                $laboratories_available = ($sumSurvey->sum('laboratories_available')) ? $sumSurvey->sum('laboratories_available') : '';
                $laboratories_in_good_condition = ($sumSurvey->sum('laboratories_in_good_condition')) ? $sumSurvey->sum('laboratories_in_good_condition') : '';
                $laboratories_needed = ($sumSurvey->sum('laboratories_needed')) ? $sumSurvey->sum('laboratories_needed') : '';
                $computerroom_available = ($sumSurvey->sum('computerroom_available')) ? $sumSurvey->sum('computerroom_available') : '';
                $computerroom_in_good_condition = ($sumSurvey->sum('computerroom_in_good_condition')) ? $sumSurvey->sum('computerroom_in_good_condition') : '';
                $computerroom_needed = ($sumSurvey->sum('computerroom_needed')) ? $sumSurvey->sum('computerroom_needed') : '';
                $technical_workshop_available = ($sumSurvey->sum('technical_workshop_available')) ? $sumSurvey->sum('technical_workshop_available') : '';
                $technical_workshop_in_good_condition = ($sumSurvey->sum('technical_workshop_in_good_condition')) ? $sumSurvey->sum('technical_workshop_in_good_condition') : '';
                $technical_workshop_needed = ($sumSurvey->sum('technical_workshop_needed')) ? $sumSurvey->sum('technical_workshop_needed') : '';
                $library_available = ($sumSurvey->sum('library_available')) ? $sumSurvey->sum('library_available') : '';
                $library_in_good_condition = ($sumSurvey->sum('library_in_good_condition')) ? $sumSurvey->sum('library_in_good_condition') : '';
                $library_workshop = ($sumSurvey->sum('library_workshop')) ? $sumSurvey->sum('library_workshop') : '';
                $toilet = ($sumSurvey->sum('toilet')) ? $sumSurvey->sum('toilet') : '';
                $school_fence = ($sumSurvey->sum('school_fence')) ? $sumSurvey->sum('school_fence') : '';
                $classroom_ratio_students = ($sumSurvey->sum('classrooms_available') && $sumSurvey->sum('number_of_students')) ? $sumSurvey->sum('classrooms_available').':'.$sumSurvey->sum('number_of_students') : '';
                $summaryArray[] = array(
                    $counter, 
                    strtoupper($lga->name), 
                    $number_of_students, 
                    $classrooms_available, 
                    $classrooms_in_good_condition, 
                    $classrooms_needed, 
                    $laboratories_available, 
                    $laboratories_in_good_condition, 
                    $laboratories_needed, 
                    $computerroom_available, 
                    $computerroom_in_good_condition, 
                    $computerroom_needed, 
                    $technical_workshop_available, 
                    $technical_workshop_in_good_condition, 
                    $technical_workshop_needed, 
                    $library_available, 
                    $library_in_good_condition, 
                    $library_workshop, 
                    $toilet, '', '', 
                    $school_fence, '', '', 
                    $classroom_ratio_students, '');
                $counter++;
            }
            return $summaryArray;
        }else{
            return [];
        }
    }
    
    public function random_color_part() {
        return str_pad( dechex( mt_rand( 0, 255 ) ), 2, '0', STR_PAD_LEFT);
    }
    
    public function random_color() {
        return $this->random_color_part() . $this->random_color_part() . $this->random_color_part();
    }
    
    public function schoolSurveyStatsData($session){
        $adminCount = Admin::all()->count();
        $teacherCount = SchoolSurvey::where('session', $session)->groupBy('school_id')->sum('total_number_of_teachers_in_post');
        $studentCount = SchoolSurvey::where('session', $session)->groupBy('school_id')->sum('number_of_students');
        
        $juniorOne = SchoolSurvey::where('session', $session)->groupBy('school_id')->sum('jss1_total');
        $juniorTwo = SchoolSurvey::where('session', $session)->groupBy('school_id')->sum('jss2_total');
        $juniorThree = SchoolSurvey::where('session', $session)->groupBy('school_id')->sum('jss3_total');
        
        $seniorOne = SchoolSurvey::where('session', $session)->groupBy('school_id')->sum('sss1_total');
        $seniorTwo = SchoolSurvey::where('session', $session)->groupBy('school_id')->sum('sss2_total');
        $seniorThree = SchoolSurvey::where('session', $session)->groupBy('school_id')->sum('sss3_total');
        
        $states_data =  OndoLGA::all();
        $states_name = [];
        $states_school_counts = [];
        $states_colors = [];
        $states_border_colors = [];
        
        foreach($states_data as $data){
            $states_name[] = $data->name;
            $states_school_counts[] = $data->schools->count();
            // $states_colors[] = '#'.$this->random_color();
            $states_colors[] = '#f2711c';
            $states_border_colors = '#da6213';
        }
        
        return response()->json([
            'message' => 'success',
            'general_chart' => [
                'admin_count' => $adminCount,
                'teacher_count' => $teacherCount,
                'student_count' => $studentCount
            ],
            'lga_chart' => [
                'states_name' => $states_name,
                'states_school_counts' => $states_school_counts,
                'colors' => $states_colors,
                'border_colors' => $states_border_colors
            ],
            'junior_chart' => [
                'jss_one' => $juniorOne,
                'jss_two' => $juniorTwo,
                'jss_three' => $juniorThree
            ],
            'senior_chart' => [
                'ss_one' => $seniorOne,
                'ss_two' => $seniorTwo,
                'ss_three' => $seniorThree
            ]
        ], 200);
    }
    
    public function schoolSurveyStatsDataSummary($session){
        $lgasData = OndoLGA::all();
        $lgas = [];
        
        foreach($lgasData as $data){
            $schoolsData = $data->schools;
            $schools = [];
            
            foreach($schoolsData as $s){
                $survey = SchoolSurvey::where('school_id', $s->id)->where('session', $session)->get()->first();
                if(!$survey){
                    $survey = [];
                }
                $schools[] = [
                    'id' => $s->id,
                    'name' => $s->name,
                    'survey' => $survey
                ];
            }
            
            $lgas[] = [
                'id' => $data->id,
                'name' => $data->name,
                'schools' => $schools
            ];
        }
        
        return response()->json([
            'message' => 'success',
            'data' => $lgas
        ], 200);
    }
    
    public function schoolSurveyView($id, $session){
        $school = School::find($id);
        if(!$school){
            flash('Unknow school!')->error();
            return back();
        }
        $survey = SchoolSurvey::where('school_id', $school->id)->where('session', $session)->get()->first();
        if(!$survey){
            flash("School's survey is not available")->error();
            return back();
        }
        $title = ucwords($school->name)."'s Survey";
        return view('super-admin.survey.school', compact('title', 'school', 'survey', 'session'));
    }
    
    public function schoolSurveyExport(Request $request){
        $data = SchoolSurvey::where('id', $request->id)->where('session', $request->session)->get();
        $data->makeHidden(['id', 'school_id', 'created_at', 'updated_at']);
        // $data->toArray();
        
        if($data->count() <= 0){
            flash('Survey not found')->error();
            return back();
        }
        
        Excel::create(ucwords($request->name)."'s Survey", function($excel) use ($data, $request){
            $excel->setTitle(ucwords($request->name)."'s Survey");
            $excel->sheet('General Survey', function($sheet) use ($data){
                $sheet->fromArray($data);
            });
        })->download('xlsx');
    }
    
    public function activityLog(Request $request){
        $title = 'All Activities';
        $sortType = 'school';
        if(isset($request->school) && $request->school != ''){
            $activities = ActivityLog::where('school_id', $request->school)->orderBy('id', 'desc')->paginate(30);
        }elseif(isset($request->date) && $request->date != ''){
            $time = Carbon::parse($request->date)->format('Y-m-d');
            $activities = ActivityLog::whereDate('created_at', '<', $time)->orderBy('created_at', 'asc')->paginate(30);
        }else{
            $activities = ActivityLog::orderBy('id', 'desc')->paginate(30);
        }
        
        return view('super-admin.activity-log.index', compact('title', 'activities', 'sortType'));
    }
    
    public function superAdminsActivityLog(Request $request){
        $title = 'Super Administrators Activities';
        $sortType = 'super-admin';
        if(isset($request->super_admin_id) && $request->super_admin_id != ''){
            $activities = ActivityLog::where('super_admin_id', $request->super_admin_id)->orderBy('id', 'desc')->paginate(30);
        }elseif(isset($request->date) && $request->date != ''){
            $time = Carbon::parse($request->date)->format('Y-m-d');
            $activities = ActivityLog::where('super_admin_id', '!=', 0)->whereDate('created_at', '<', $time)->orderBy('created_at', 'asc')->paginate(30);
        }else{
            $activities = ActivityLog::where('super_admin_id', '!=', 0)->orderBy('id', 'desc')->paginate(30);
        }
        
        return view('super-admin.activity-log.index', compact('title', 'activities', 'sortType'));
    }
    
    public function superAdminActivityLog($id){
        $user = SuperAdmin::find($id);
        
        if(!$user){
            flash('User not found')->error();
            return back();
        }
        
        $title = ucwords($user->fullname)."'s Activities";
        $activities = ActivityLog::where('super_admin_id', $user->id)->orderBy('id', 'desc')->paginate(30);
        
        return view('super-admin.activity-log.super-admin', compact('title', 'activities'));
    }
    
    public function adminsActivityLog(Request $request){
        $title = 'School Administrators Activities';
        $sortType = 'school';
        if(isset($request->school) && $request->school != ''){
            $activities = ActivityLog::where('admin_id', '!=', 0)->where('school_id', $request->school)->orderBy('id', 'desc')->paginate(30);
        }elseif(isset($request->date) && $request->date != ''){
            $time = Carbon::parse($request->date)->format('Y-m-d');
            $activities = ActivityLog::where('admin_id', '!=', 0)->whereDate('created_at', '<', $time)->orderBy('created_at', 'asc')->paginate(30);
        }else{
            $activities = ActivityLog::where('admin_id', '!=', 0)->orderBy('id', 'desc')->paginate(30);
        }
        
        return view('super-admin.activity-log.index', compact('title', 'activities', 'sortType'));
    }
    
    public function adminActivityLog($id){
        $user = Admin::find($id);
        
        if(!$user){
            flash('User not found')->error();
            return back();
        }
        
        $title = ucwords($user->fullname)."'s Activities";
        $activities = ActivityLog::where('admin_id', $user->id)->orderBy('id', 'desc')->paginate(30);
        
        return view('super-admin.activity-log.admin', compact('title', 'activities'));
    }
    
    public function teachersActivityLog(){
        $title = 'School Teachers Activities';
        $activities = ActivityLog::where('teacher_id', '!=', 0)->orderBy('id', 'desc')->paginate(30);
        $sortType = 'school';
        if(isset($request->school) && $request->school != ''){
            $activities = ActivityLog::where('teacher_id', '!=', 0)->where('school_id', $request->school)->orderBy('id', 'desc')->paginate(30);
        }elseif(isset($request->date) && $request->date != ''){
            $time = Carbon::parse($request->date)->format('Y-m-d');
            $activities = ActivityLog::where('teacher_id', '!=', 0)->whereDate('created_at', '<', $time)->orderBy('created_at', 'asc')->paginate(30);
        }else{
            $activities = ActivityLog::where('teacher_id', '!=', 0)->orderBy('id', 'desc')->paginate(30);
        }
        
        return view('super-admin.activity-log.index', compact('title', 'activities', 'sortType'));
    }
    
    public function teacherActivityLog($id){
        $user = Teacher::find($id);
        
        if(!$user){
            flash('User not found')->error();
            return back();
        }
        
        $title = ucwords($user->surname)."'s Activities";
        $activities = ActivityLog::where('teacher_id', $user->id)->orderBy('id', 'desc')->paginate(30);
        
        return view('super-admin.activity-log.teacher', compact('title', 'activities'));
    }
    
    public function studentsActivityLog(){
        $title = 'Students Activities';
        $activities = ActivityLog::where('student_id', '!=', 0)->orderBy('id', 'desc')->paginate(30);
        $sortType = 'school';
        if(isset($request->school) && $request->school != ''){
            $activities = ActivityLog::where('student_id', '!=', 0)->where('school_id', $request->school)->orderBy('id', 'desc')->paginate(30);
        }elseif(isset($request->date) && $request->date != ''){
            $time = Carbon::parse($request->date)->format('Y-m-d');
            $activities = ActivityLog::where('student_id', '!=', 0)->whereDate('created_at', '<', $time)->orderBy('created_at', 'asc')->paginate(30);
        }else{
            $activities = ActivityLog::where('student_id', '!=', 0)->orderBy('id', 'desc')->paginate(30);
        }
        
        return view('super-admin.activity-log.index', compact('title', 'activities', 'sortType'));
    }
    
    public function studentActivityLog($id){
        $user = Student::find($id);
        
        if(!$user){
            flash('User not found')->error();
            return back();
        }
        
        $title = ucwords($user->surname)."'s Activities";
        $activities = ActivityLog::where('student_id', $user->id)->orderBy('id', 'desc')->paginate(30);
        
        return view('super-admin.activity-log.student', compact('title', 'activities'));
    }
    
    public function quickUpdate(Request $request){
        $user = auth('super_admin')->user();
        $validator = Validator::make($request->all(), [
            'password' => ['confirmed'],
        ]);
        
        if($validator->fails()) {
        	flash('Password confirmation failed')->error();
            return redirect()->back()->withInput();
        }
        
        $user->update([
            'phone' => $request->phone,
            'password' => Hash::make($request->password),
            'update_level' => 1
        ]);
        
        flash('Profile updated successfully. Login to continue exploring us')->success();
        
        Auth::guard('super_admin')->logout();
        return redirect()->route('super_admin.login');
    }
    public function downloadPassports(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $title = 'Batch Passport Download';

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

        return view('super-admin.passport-download.view', compact('ngstate_lgas', 'title', 'ngstate'));
    }

    public function downloadPassportsPage(Request $request){
        if(!isset($request->lga_id) || $request->lga_id == ''){
            flash('Please select Local Government Area')->error();
            return back();
        }
        $lgaId = $request->lga_id;
        $amount = (isset($request->amount) && $request->amount != 'all') ? $request->amount : '100000000000000000000000000000000000';
        $students = Student::whereHas('school', function ($query) use($lgaId) {
                                $query->where('lga_id', $lgaId);
                            })->limit($amount)->get();
        File::cleanDirectory(public_path().'/images/zip-passports');

    	$pathname = 'images/zip-passports/'.OndoLGA::find($lgaId)->name.'.zip';
    	$zipper = Zipper::make(public_path($pathname));
    	foreach($students as $student){
    	    error_reporting(0);
    	    $image = explode('?', public_path().$student->passport)[0];
    	    $hash = bin2hex(mcrypt_create_iv(22, MCRYPT_DEV_URANDOM));
    	    $zipper->add($image, $hash.'.png');
    	}
    	$zipper->close();
        
        return response()->download(public_path($pathname));
    }
    
    public function loginReset(){
        $title = 'Login Attempt Reset';
        $admins = SuperAdmin::paginate(20);
        
        return view('super-admin.login-reset', compact('title', 'admins'));
    }
    
    public function loginResetPost(Request $request){
        if(!empty($request->admin_id)  && $request->admin_id != [] && $request->admin_id != ''){
            foreach($request->admin_id as $id){
                $admin = SuperAdmin::find($id);
                
                if($admin){
                    $admin->login_count = 0;
                    $admin->save();
                }
            }
        
            flash('Login attempt reset for selected users was successful')->success();
            return back();
        }
        
        flash('Please select at least one user')->error();
        return back();
    }
}