<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\NgStates;

use Validator;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentHouseRepositoryInterface;

use Hash;

use Excel;

use Carbon\Carbon;

use Input;

use Gate;

use DB;

use Auth;

use Session;

use App\Student;

use App\School;

use PDF;

class StudentsController extends Controller
{
    protected $students;

    protected $classes;

    protected $class_arms;

    protected $school_houses;

    public function __construct(StudentRepositoryInterface $students,ClassRepositoryInterface $classes,ClassArmRepositoryInterface $class_arms, StudentHouseRepositoryInterface $school_houses){

        $this->middleware('auth:admin', ['except' => ['state_lga']]);

        $this->students = $students;

        $this->classes = $classes;

        $this->class_arms = $class_arms;

        $this->school_houses = $school_houses;


    }

    protected function permissionDeny($ability){
        Auth::shouldUse('admin');
        return Gate::denies($ability);
    }

    function adminViewSchoolStudents(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
        $students = $this->students->setStudent()
                            ->where('school_id', Session::get('admin.school'))
                            ->orderBy('surname', 'asc')
                            //->paginate(5);
                            ->get();

        $school_houses = $this->school_houses->setSchoolHouse()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

        return view('admin.students.view', compact('classes', 'class_arms', 'students', 'school_houses'));
    }

    function adminViewSchoolStudentsPage(Request $request){
        
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'class_id' => 'required',
                                                'session' => 'required',
                                                'class_arm_id' => 'required',
                                                'term' => 'required'
                                            ]);

        if($validate->passes()){

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                    }
                }
        
                $data['school_id'] = Session::get('admin.school');
        
                $classes = $this->classes->setClass()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $class_arms = $this->class_arms->setClassArms()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $school_houses = $this->school_houses->setSchoolHouse()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $class_arm_id = $this->class_arms->find($request->input('class_arm_id'));

                $students = $class_arm_id->students()
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)
                                        //->paginate(5);
                                        ->get();
        
                Input::flash();
        
                return view('admin.students.post-view', compact('classes', 'class_arms', 'students', 'data', 'school_houses'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }



    function adminViewFloatingStudents(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        return view('admin.students.view-floating');
    }


    public function adminFetchFloatingStudents(Request $request)
    {
        $school_id = Session::get('admin.school');

        $classarm_students_list = DB::table('class_arms')
            ->where('class_arms.school_id', $school_id)
            ->join('classarm_student', 'classarm_student.classarm_id', '=', 'class_arms.id')
            ->distinct()
            ->pluck('classarm_student.student_id');

        $students = $this->students->setStudent()
                            ->where('school_id', $school_id)
                            ->whereNotIn('students.id', $classarm_students_list)
                            ->orderBy('surname', 'asc')
                            ->get();

        $html = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';

        $html .= '<h3>Student Total Count : <em>'.count($students).'</em> </h3>';

        $html .= '<br>';

        $sn = 1;
        
        $html .= '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th>S/N</th>
                        <th>Student Fullname</th>
                        <th>OSSI Number</th>
                        <th>Student Passport</th>
                        <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>';

        if(count($students) > 0){
            foreach($students as $student){ 

                $student_name = $student->surname.' '.$student->firstname.' '.$student->middlename;
                $student_ossi = $student->regnum;
                $student_passport = '<img src="'.url_public($student->passport).'" class="ui small image">';

                $html .= '<tr>';
                $html .= '<td>'.$sn.'</td>';
                $html .= '<td>'.$student_name.'</td>';
                $html .= '<td>'.$student_ossi.'</td>';
                $html .= '<td>'.$student_passport.'</td>';

                $route = route('admin.move.student.to.classarm', ['id' => $student->id]);

                $html .= '<td><a href="'.$route.'"> Move Student </a></td>';
                $html .= '</tr>';

                $sn++;
            }//end loop
        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table></section>';

        return $html; 

    }


    function adminFloatingStudentToClassArm($student_id){

        if($this->permissionDeny('assign-student-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->find($student_id);

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->class_arms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.move.student.to.classarm.submit';
        

        return view('admin.students.move-to-classarm', compact('classes', 'classarms', 'route', 'student'));
    }

    function adminFloatingStudentToClassArmSubmit(Request $request){

        if($this->permissionDeny('assign-student-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $rules['next_classarm_id'] = 'required|integer';

        $rules['next_class_id'] = 'required|integer';

        $rules['next_session'] = 'required|digits:4';

        $rules['student_id'] = 'required|integer';

        $rules['next_term'] = ['required','regex:/(First|Second|Third)/'];

        Input::flash();

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            $session = $request->input('next_session');
            $session_next = $session+1;

            $term = $request->input('next_term');

            $classarm_id = $request->input('next_classarm_id');

            $class_id = $request->input('next_class_id');

            $student_id = $request->input('student_id');

            $verify_student_exist = \DB::table('classarm_student')
                                ->select('student_id')
                                //->where('classarm_id', '=', $classarm_id)
                                //->where('term', '=', $term)
                                //->where('session', '=', $session)
                                ->where('student_id', '=', $student_id)
                                ->first();

            if(empty($verify_student_exist)){

                $classarm_get =  $this->class_arms->find($classarm_id);

                $classarm_get->students()->attach($student_id, ['session' => $session, 'term' => $term, 'class_id' => $class_id]);

                flash('You have successfully assigned selected Student to '.getClassNameByClassID($class_id).' '.getClassArmNameByClassArmID($classarm_id).'')->success();

                return redirect()->back(); 

            }
            else{
                //flash('Student already exist in a Class Arm for '.$term.' Term '.$session.'/'.$session_next.' Session')->error();
                flash('Student already exist in a Class Arm')->error();

                return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();                
            }


        }else{
            flash('Something is wrong')->error();

            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }



    function adminStudentsDeregisterSubjectsSearch(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
        $students = $this->students->setStudent()
                            ->where('school_id', Session::get('admin.school'))
                            ->orderBy('surname', 'asc')
                            ->paginate(5);

        $school_houses = $this->school_houses->setSchoolHouse()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

        return view('admin.students.student-subjects-search', compact('classes', 'class_arms', 'students', 'school_houses'));
    }


    function adminStudentsDeregisterSubjectsList(Request $request){
        
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'class_id' => 'required',
                                                'session' => 'required',
                                                'class_arm_id' => 'required',
                                                'term' => 'required'
                                            ]);

        if($validate->passes()){

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                    }
                }
        
                $data['school_id'] = Session::get('admin.school');
        
                $classes = $this->classes->setClass()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $class_arms = $this->class_arms->setClassArms()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $school_houses = $this->school_houses->setSchoolHouse()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $class_arm_id = $this->class_arms->find($request->input('class_arm_id'));

                $students = $class_arm_id->students()
                                        ->wherePivot('session', $request->session)
                                        ->wherePivot('term', $request->term)
                                        ->wherePivot('class_id', $request->class_id)
                                        ->get();

                $classarm_id = $request->input('class_arm_id');

                $session = $request->session;
                $term = $request->term;
        
                Input::flash();
        
                return view('admin.students.student-subjects-list', compact('classes', 'session', 'term', 'class_arms', 'classarm_id', 'students', 'data', 'school_houses'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }

    
    function adminCreateSchoolStudents(){
        
        if($this->permissionDeny('create-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $ngstates = NgStates::all();
        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
                                
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

        $school_houses = $this->school_houses->setSchoolHouse()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

        return view('admin.students.create', compact('ngstates', 'classes', 'class_arms', 'school_houses'));
    }

    function adminBatchCreateSchoolStudents(){
        
        if($this->permissionDeny('create-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }


        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
                                
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

        $school_houses = $this->school_houses->setSchoolHouse()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

        return view('admin.students.batch-create', compact('classes', 'class_arms', 'school_houses'));
    }

    function state_lga(Request $request){
        $NgStatesLGA = new \App\NgStatesLGA;
         if( $request->ajax() ) {
            $state_LGAS = '';
            $state_id = $request->input('state');
            $slgas = $NgStatesLGA->where('state_id','=',$state_id)->get();
            $state_LGAS = $NgStatesLGA->present_lgs_for_display($slgas);
            return response()->json([
                'stateLGAS' => $state_LGAS
            ]);
        }
    }

    function adminRegisterSchoolStudents(Request $request){


        if($this->permissionDeny('create-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->setStudent();

        $validate = Validator::make($request->all(), $student::$rules);

        $session = $request->input('session');

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
            if(!in_array($key, array('_token','password_confirmation')) && !empty($value)){
                    if($key == 'password'){
                        $insert[$key] = Hash::make($value);
                    }elseif(in_array($key, array('term','class_id','class_arm_id'))){
                        continue;
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }

            $regnum_digit = $this->students->getNextRegNum($session);

            $regnum = $this->students->getRegNumPrefix($session).str_pad($regnum_digit, 3, 0, STR_PAD_LEFT);

            $insert['regnum'] = $regnum;
            $insert['regnum_digit'] = $regnum_digit;

            $insert['school_id'] = Session::get('admin.school');
            
           $student_id = $student->create($insert);


           $student_id->classarms()->attach($request->input('class_arm_id'), ['session' => $request->input('session'), 'term' => $request->input('term'), 'class_id' => $request->input('class_id')]);

           flash('You have successfully create a student')->success();

            return redirect()->back();

        }else{

            flash('Something is wrong')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }

    function adminEditSchoolStudent($id){


            if($this->permissionDeny('edit-student')){
                $title = 'Permission Deny';
                return view('errors.401', compact('title'));
            }
            $student = $this->students->find($id);

            $student_class =  $student->classarms()->wherePivot('session', '=',$student->session)
                ->orderBy('term', 'desc')
                ->first();

            $ngstates = NgStates::all();

            $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
                                
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

        $school_houses = $this->school_houses->setSchoolHouse()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

            return view('admin.students.edit', compact('ngstates', 'classes', 'class_arms','student', 'student_class', 'school_houses'));


    }

    function adminUpdateSchoolStudent(Request $request, $id){
        
        if($this->permissionDeny('edit-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->setStudent();

        $student::$rules['password'] = 'sometimes|alpha_num|min:6|confirmed';
        $student::$rules['password_confirmation'] = 'sometimes|alpha_num|min:6';
        $student::$rules['parent_email'] = '';

        $validate = Validator::make($request->all(), $student::$rules);

        if($validate->passes()){

        foreach ($request->all() as $key => $value) {
            if(!in_array($key, array('_token','password_confirmation', '_method')) && !empty($value)){
                    if($key == 'password' && !empty($value)){
                        $insert[$key] = Hash::make($value);
                    }elseif(in_array($key, array('term','class_id','class_arm_id'))){
                        continue;
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }

           $student_update = $this->students->find($id);

           $student_update->update($insert);

           $exit_student_class = \DB::table('classarm_student')->select('student_id')->whereRaw('`classarm_id` = '.$request->class_arm_id.' AND `student_id` = '.$id.' AND `session` = '.$request->session)
                                        ->get();

            if(collect($exit_student_class)->count() == 0){

               $student_update->classarms()->attach($request->input('class_arm_id'), ['session' => $request->input('session'), 'term' => $request->input('term'), 'class_id' => $request->input('class_id')]);
           }

           flash('You have successfully updated student info')->success();


            return redirect()->back();

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }


    function quickEditStudentView($id){

        if($this->permissionDeny('edit-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $student = $this->students->find($id);
                            
        $school_houses = $this->school_houses->setSchoolHouse()
                            ->where('school_id', Session::get('admin.school'))
                            ->get();

        $route = 'quick-edit/student/'.$id;

        return view('admin.students.quick-edit', compact('student', 'school_houses', 'route'));

    }

    function quickEditStudentSubmit(Request $request, $id){
      //dd($request->all());
    
        if($this->permissionDeny('edit-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->setStudent();
        
        $validate = Validator::make($request->all(), [
                'surname' => 'required|min:3',
                'firstname' => 'required|min:3',
                'dob' => 'sometimes|date',
                'gender' => ['sometimes','regex:/(Male|Female)/'],
                'house_id' => 'sometimes|integer|not_in:0',
                'password' => 'sometimes|alpha_num|min:6|confirmed',
                'password_confirmation' => 'sometimes|alpha_num|min:6',
                'blood_group' => ['sometimes','regex:/(A+|A-|B+|B-|AB+|AB-|O+|O-)/'],
            ]);

        if($validate->passes()){

            foreach ($request->all() as $key => $value) {
                if(!in_array($key, array('_token','password_confirmation', '_method')) && !empty($value)){
                    if($key == 'password' && !empty($value)){
                        $insert[$key] = Hash::make($value);
                    }elseif(in_array($key, array('term','class_id','class_arm_id'))){
                        continue;
                    }else{
                        $insert[$key] = $value;
                    }
                }
            }

           $student_update = $this->students->find($id);

           $student_update->update($insert);

           flash('You have successfully updated student information')->success();

            return redirect()->route('admin.dashboard');

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
        
    }


    function adminBatchRegisterSchoolStudents(Request $request){

        if($this->permissionDeny('create-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->setStudent();

        $validate = Validator::make($request->all(), $student::$ruleBatch);

        if($validate->passes()){

			$school_houses = $this->school_houses->setSchoolHouse()
								->where('school_id', Session::get('admin.school'))
								->get();

			$sch_house = array_pluck($school_houses->toArray(), 'id');

				if($request->hasFile('batch_file')){
					$session = $request->input('session');
					$std_count = $this->students->getNextRegNum($session);
					$path = $request->file('batch_file')->getRealPath();
					$ext = $request->file('batch_file')->getClientOriginalExtension();
					$duplicacy = array();
					$insert = array();
					$student_id = array();
					$row_counter = 2;
					$data = Excel::load($path, function($reader) {
					})->get();
					if(!empty($data) && $data->count()){
						if(in_array($ext, ['xls', 'xlsx'])){
							foreach ($data as $key => $value) {

								// delete the record if exisit
									//$studentNew = Student::where('surname', $value->surname)->where('firstname', $value->firstname)->first();
									$studentNew = Student::where('surname', $value->surname)	
													->where('firstname', $value->firstname)
													->where('gender', $value->gender)
													->where('parent_fullname', $value->parent_fullname)
													->where('school_id', Session::get('admin.school'))
													->get();
									if($studentNew){
										foreach($studentNew as $studentNewRow){
										//delete form class
										DB::table('classarm_student')->where('student_id', $studentNewRow->id)->delete();
										//delete form cstudent
										$studentNewRow->delete();
										}
									}
									
									 $new_regnum = $this->students->getRegNumPrefix($session).str_pad($this->students->getNextRegNum($session), 3, 0, STR_PAD_LEFT);
								
									$verify_regnum = $this->students->setStudent()
													->where('regnum', $new_regnum)
													->count();
													
									/*$verify_stud_data = $this->students->setStudent()
													->where('surname', $value->surname)
													->where('firstname', $value->firstname)
													->where('gender', $value->gender)
													->where('parent_fullname', $value->parent_fullname)
													->where('school_id', Session::get('admin.school'))
													->first();*/
									
									if(empty($value->surname) || empty($value->firstname)  || empty($value->password)   || empty($value->gender)   || empty($value->address) || empty($value->country) || empty($value->parent_phone)){
											$duplicacy[] = 'Either student\'s surname, firstname, middlename, gender, address, country or password in row '.$row_counter.' is empty';
									 }else{		
									 	if($verify_regnum == 0){							
												$stud_blood_group = trim($value->blood_group);
												if($stud_blood_group != '' || !empty($stud_blood_group)){
													$bloodGroup = $stud_blood_group;
												}else{
													$bloodGroup = "Unknown";
												}
												$insert = [
													'regnum' => $new_regnum,
                                                    'regnum_digit' => $std_count,
													'surname' => $value->surname,
													'firstname' => $value->firstname,
													'middlename' => $value->middlename,
													'phone' => $value->phone,
													'gender' => $value->gender,
													'country' => $value->country,
													'address' => $value->address,
													'parent_fullname' => $value->parent_fullname,
													'parent_address' => $value->parent_address,
													'parent_phone' => $value->parent_phone,
													'parent_email' => $value->parent_email,
													'blood_group' => $bloodGroup,
													'password' => Hash::make($value->password),
													'session' => $session,
													'house_id' => $sch_house[($std_count % $school_houses->count())],
													'school_id' => Session::get('admin.school'),
													'created_at' => Carbon::now(),
													'updated_at' => Carbon::now()
													];

												$std_count++;

											$student_id[] = $student->create($insert)->id;
										}
										else{
											$duplicacy[] = $verify_regnum.' Duplicate student data ('.$new_regnum.') entry on row '.$row_counter;
										}
									 }
									 
									unset($new_regnum);
									 
								  $row_counter++;
								  
							}//End loop
						//dd($duplicacy);
						if((count($student_id) > 0) && empty($duplicacy)){

							$classarms = $this->class_arms->find($request->input('class_arm_id'));

							$classarms->students()->attach($student_id, ['session' => $request->input('session'), 'term' => $request->input('term'), 'class_id' => $request->input('class_id')]);

							flash('Successfully inserted '.count($student_id).' Students')->success();

							return redirect()->back();  
						}elseif((count($student_id) > 0) && !empty($duplicacy)){

							$classarms = $this->class_arms->find($request->input('class_arm_id'));

							$classarms->students()->attach($student_id, ['session' => $request->input('session'), 'term' => $request->input('term')]);

							flash('Successfully inserted '.count($student_id).' Students')->success();

							flash($duplicacy)->error();
							//flash(''.count($duplicacy).' Duplicate data removed from Insertion')->error();

							return redirect()->back()
											 ->withInput();  
						}else{

							flash($duplicacy)->error();
							//flash(''.count($duplicacy).' Duplicate data removed from Insertion')->error();

							return redirect()->back()
											 ->withInput();  

						}
					}
				}
				
			   return redirect()->back();     
		}else{
				return redirect()->back()
						->withErrors($validate)
						->withInput();
		}

		}
	
	}


    function adminDeleteSchoolStudent(Request $request, $id){


        if($this->permissionDeny('delete-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $student = $this->students->find($id);


        $fullname = $student->surname.' '.$student->firstname.' '.$student->middlename;

        $student->classarms()->detach();
        Student::find($id)->delete();

            flash('You have successfully deleted '.$fullname)->success();

            return redirect()->route('admin.view.school.students');
    }



    public function studentVerificationView(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
        $students = $this->students->setStudent()
                            ->where('school_id', Session::get('admin.school'))
                            ->orderBy('surname', 'asc')
                            ->paginate(5);

        $school_houses = $this->school_houses->setSchoolHouse()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();

        return view('admin.students.verification.view', compact('classes', 'class_arms', 'students', 'school_houses'));
    }

    public function studentVerification(Request $request){
        
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'class_id' => 'required',
                                                'session' => 'required',
                                                'class_arm_id' => 'required',
                                                'term' => 'required'
                                            ]);

        if($validate->passes()){

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                    }
                }
        
                $data['school_id'] = Session::get('admin.school');
        
                $classes = $this->classes->setClass()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $class_arms = $this->class_arms->setClassArms()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $school_houses = $this->school_houses->setSchoolHouse()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $class_arm_id = $this->class_arms->find($request->input('class_arm_id'));

               if($request->view_type == 'view paginated'){
                    $students = $class_arm_id->students()
                    ->wherePivot('session', $request->session)
                    ->wherePivot('term', $request->term)
                    ->wherePivot('class_id', $request->class_id)
                    ->paginate(10);
               }else{
                $students = $class_arm_id->students()
                    ->wherePivot('session', $request->session)
                    ->wherePivot('term', $request->term)
                    ->wherePivot('class_id', $request->class_id)
                    ->paginate(50000);
               }
        
                Input::flash();
                // $class = Class::find(1)->class_name;
                return view('admin.students.verification.post-view', compact('classes', 'class_arms', 'students', 'data', 'school_houses'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }




    


    

    function studentblukdeleteView(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }else{
            $title = 'View Student To Delete';
        }
        
        $classes = $this->classes->setClass()
        ->where('school_id', Session::get('admin.school'))
        ->get();
        $class_arms = $this->class_arms->setClassArms()
                ->where('school_id', Session::get('admin.school'))
                ->get();
        $students = $this->students->setStudent()
            ->where('school_id', Session::get('admin.school'))
            ->orderBy('surname', 'asc')
            ->paginate(0);

        $school_houses = $this->school_houses->setSchoolHouse()
                ->where('school_id', Session::get('admin.school'))
                ->get();

        return view('admin.batch-delete', compact('title', 'classes', 'class_arms', 'students', 'school_houses'));
    }

    function studentblukdeletePostView(Request $request){
        
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                                                'class_id' => 'required',
                                                'session' => 'required',
                                                'class_arm_id' => 'required',
                                                'term' => 'required'
                                            ]);

        if($validate->passes()){

                $data = [];

                foreach($request->all() as $key => $value){
                    if(!in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                    }
                }
        
                $data['school_id'] = Session::get('admin.school');
        
                $classes = $this->classes->setClass()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $class_arms = $this->class_arms->setClassArms()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $school_houses = $this->school_houses->setSchoolHouse()
                                        ->where('school_id', Session::get('admin.school'))
                                        ->get();
        
                $class_arm_id = $this->class_arms->find($request->input('class_arm_id'));

                $students = $class_arm_id->students()
                    ->wherePivot('session', $request->session)
                    ->wherePivot('term', $request->term)
                    ->wherePivot('class_id', $request->class_id)
                    ->paginate(5000000);
        
                Input::flash();
        
                return view('admin.batch-delete', compact('classes', 'class_arms', 'students', 'data', 'school_houses'));
            }

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
    }

    function studentblukdeletePost(Request $request){
        // return $request->all();
        $error = array();
        $ids = $request->student_id;
        foreach ($ids as $id) {
            if(Student::find($id)){
                Student::find($id)->delete();
            }else{
                $error[] = 'Student with id'.$id.' not found';
            }
        }
        if(empty($error)){
            flash('Successfully deleted Students')->success();
            return back()->withInput();  
        }else{
            flash($error)->error();
            return back()->withInput();  

        }
    }



    function nominalRollStudent(){

        $title = 'Student Nominal Roll';

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->class_arms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.student.nominal.roll.process';

        return view('admin.students.nominal-roll-student-form', compact('classes', 'classarms', 'title', 'route'));
    }


    function nominalRollStudentSubmit(Request $request){

        $validate = Validator::make($request->all(), [
                'session' => 'required',
                'class_id' => 'required',
                'classarm_id' => 'required',
                'term' => 'required'
            ]);

        if($validate->passes()){

            $school_id = Session::get('admin.school');
            
            $class_arms = $this->class_arms->setClassArms()
                                    ->where('school_id', Session::get('admin.school'))
                                    ->get();
            
            $class_arm_data = $this->class_arms->find($request->classarm_id);

            $class_arm_students = $class_arm_data->students()
                                    ->wherePivot('session', $request->session)
                                    ->wherePivot('term', $request->term)
                                    ->wherePivot('class_id', $request->class_id)
                                    ->get();

            $class_data = $this->classes->find($request->class_id);
            $class_name = $class_data->class_name;
            $class_name_char = strtoupper(substr($class_name, 0, 1));    

            $class_arm_name = $class_arm_data->class_arm;

            //$sch_lga = getSchoolLGAName($school_id);
            //$sch_lga_name = $sch_lga[0]->name;

            $sch_data = getSchools($school_id);
            $sch_name = $sch_data[0]->name;

            view()->share('class_arm_students',$class_arm_students);

            view()->share('logo', url_public('/images/logo-bg.png'));
            view()->share('class_name_char',$class_name_char);
            view()->share('class_name',$class_name);
            view()->share('class_arm_name',$class_arm_name);
            view()->share('term',$request->term);

            view()->share('session', $request->session);
            view()->share('session_full', $request->session.'/'.($request->session + 1));
            view()->share('sch_name', $sch_name);


            flash('Student list will be display in PDF format')->success();

            $pdf = PDF::loadView('admin.students.nominal-roll-student-pdf');

            return $pdf->stream('nominalrollpdfview.pdf');

        }

        flash('Something is wrong')->error();

        return $this->back()
                ->withErrors($validate)
                ->withInput();

    }
    
    


}