<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\School;

use DB;

use Validator;

use Input;

use Excel;

use Session;

use Auth;

use Gate;

use PDF;

use Carbon\Carbon;

class StudentResultController extends Controller
{

    protected $students;

    protected $classes;

    protected $classarms;

    protected $subjects;

    protected $student_results;

    function __construct(StudentRepositoryInterface $students,ClassRepositoryInterface $classes, ClassArmRepositoryInterface $classarms, SubjectRepositoryInterface $subjects, StudentResultRepositoryInterface $student_results){

        $this->middleware('auth:admin');

        $this->students = $students;

        $this->classes = $classes;

        $this->classarms = $classarms;

        $this->subjects = $subjects;

        $this->student_results = $student_results;


    }


    protected function permissionDeny($ability){
        Auth::shouldUse('admin');
        return Gate::denies($ability);
    }

    function adminViewResultByClassCategory(){

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

        return view('admin.results.view-result-form', compact('classes'));

    } 

    function adminViewResultByClassCategorySubmit(Request $request){
        $student_results = $this->student_results->setStudentResult();

        $student = $this->students->setStudent();

        $rules = $student_results::$ruleForSubjects;

        $rules['classarm_id'] = 'required|integer';

        unset($rules['class_arm_id']);

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            $session = $request->session;

            $class_id = $request->class_id;
            
           $class_data = $this->classes->find($request->class_id);
           $class_name = $class_data->class_name;
           $class_name_char = strtoupper(substr($class_name, 0, 1));

            $term = $request->term;

            $classarm_id_get = $request->classarm_id;

            $data = array();

            foreach($request->all() as $key => $value){
                if(!empty($key) && !in_array($key, ['_method', '_token'])){
                        $data[$key] = $value;
                }
            }

            $classarm_id = $this->classarms->find($request->input('classarm_id'));

            $students = $classarm_id->students()
                                    ->wherePivot('session',$request->session)
                                    ->wherePivot('term',$request->term)
                                    ->wherePivot('class_id',$request->class_id)
                                    ->get();

            Input::flash();

            $result_records = array();

            foreach($students as $student){

                $data['student_id'] = $student->id;

                $results = fetchDataTable('student_results', $data,200);

                $result_records[$student->id] = $results->toArray();

            }

            $students_results_info = collect($result_records);
            
            $listGradeRemark = array();
            
            if($class_name_char == "J"){
                $listGradeRemark = resultGradeRemarksJS();
            }
            else{
                $listGradeRemark = resultGradeRemarksSS();
            }

            return view('admin.results.result-view', compact('students_results_info', 'class_id', 'session', 'term', 'classarm_id_get', 'class_name_char', 'listGradeRemark'));
        }

        flash('Something is wrong')->error();

        return $this->back()
                ->withErrors($validate)
                ->withInput();


    }


    function adminViewBatchUploadResultBySubject(){

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

        return view('admin.results.subject-batch-upload', compact('classes'));

    }

    function adminResultBroadSheetViewForm(){

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

        return view('admin.results.view-broadsheet-form', compact('classes'));

    } 


    function adminResultBroadSheetViewFormSubmit(Request $request){

        $student_results = $this->student_results->setStudentResult();

        $validate = Validator::make($request->all(), [
                'session' => 'required',
                'class_id' => 'required',
                'classarm_id' => 'required',
                'term' => 'required'
            ]);

        if($validate->passes()){
            return $this->viewResultBroadsheet($request);
        }

        flash('Something is wrong')->error();

        return $this->back()
                ->withErrors($validate)
                ->withInput();

    }

    function adminResultSessionBroadSheetViewForm(){

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

        return view('admin.results.view-session-broadsheet-form', compact('classes'));

    } 

    function adminResultSessionBroadSheetViewFormSubmit(Request $request){

        $student_results = $this->student_results->setStudentResult();

        $validate = Validator::make($request->all(), [
                'session' => 'required',
                'class_id' => 'required',
                'classarm_id' => 'required',
                'term' => 'required',
                'request_type' => 'required'
            ]);

        if($validate->passes()){
            return $this->viewResultBroadsheet($request);
        }

        flash('Something is wrong')->error();

        return $this->back()
                ->withErrors($validate)
                ->withInput();

    }

    protected function viewResultBroadsheet(Request $request){

        $school_id = Session::get('admin.school');
        $request_type = $request->request_type;

        $class_arm_data = $this->classarms->find($request->classarm_id);

        $class_arm_students = $class_arm_data->students()
                            ->wherePivot('session', $request->session)
                            ->wherePivot('term', $request->term)
                            ->wherePivot('class_id', $request->class_id)
                            ->get(['students.id','surname','firstname','middlename', 'regnum'])->toArray();

        $class_arm_students_count = count($class_arm_students);
            
        $class_data = $this->classes->find($request->class_id);
        $class_name = $class_data->class_name;
        $class_name_char = strtoupper(substr($class_name, 0, 1));    

        $class_arm_name = $class_arm_data->class_arm;

        $sch_lga = getSchoolLGAName($school_id);
        $sch_lga_name = $sch_lga[0]->name;

        $sch_data = getSchools($school_id);
        $sch_name = $sch_data[0]->name;
        $sch_address = $sch_data[0]->address;
        $sch_logo = $sch_data[0]->logo;

        $class_arm_subjects = getAssocSubjectByClassArmID($request->classarm_id, $request->session);
        $class_arm_subjects_count = count($class_arm_subjects);

        view()->share('class_arm_students',$class_arm_students);
        view()->share('class_arm_students_count',$class_arm_students_count);
        view()->share('class_arm_subjects',$class_arm_subjects);
        view()->share('class_arm_subjects_count',$class_arm_subjects_count);

        view()->share('logo', url_public('/images/logo-bg.png'));
        view()->share('class_name_char',$class_name_char);
        view()->share('class_name',$class_name);
        view()->share('class_arm_name',$class_arm_name);
        view()->share('term',$request->term);
        view()->share('school_id', $school_id);
        view()->share('class_id', $request->class_id);
        view()->share('class_arm_id', $request->classarm_id);
        view()->share('session', $request->session);
        view()->share('session_full', $request->session.'/'.($request->session + 1));

        view()->share('sch_lga_name', $sch_lga_name);
        view()->share('sch_name', $sch_name);
        view()->share('sch_address', $sch_address);
        view()->share('sch_logo', $sch_logo);


        flash('Your result will be display in PDF format')->success();

        if($request_type == 1){
            $pdf = PDF::loadView('admin.results.result-broadsheet-pdf')->setPaper('a4', 'landscape');
        }
        else{
            $pdf = PDF::loadView('admin.results.result-broadsheet-session-pdf')->setPaper('a4', 'landscape');            
        }

        return $pdf->stream('broadsheetpdfview.pdf');

    }



    function adminViewBatchUploadResultAllSubject(){

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

        return view('admin.results.subject-all-batch-upload', compact('classes'));

    }

    function adminViewClassResultTemplate(Request $request){

        $student_result = $this->student_results->setStudentResult();

        $validate = Validator::make($request->all(), $student_result::$ruleForSubjects);

        if($validate->passes()){

            Input::flash();

            return $this->errorReturnForTemplate($request);

        }else{
            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }
    }

    function adminViewClassAllResultTemplate(Request $request){

        $student_result = $this->student_results->setStudentResult();

        $validate = Validator::make($request->all(), $student_result::$ruleForSubjects);

        if($validate->passes()){

            Input::flash();

            return $this->errorReturnForTemplateAllSubject($request);

        }else{
            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }
    }



    function adminDownloadClassResultFormatBySubject(Request $request){
        $classarm_id = $this->classarms->find($request->input('classarm_id'));

        $students = $classarm_id->students()
                            ->wherePivot('session', $request->session)
                            ->wherePivot('term', $request->term)
                            ->wherePivot('class_id', $request->class_id)
                            ->orderBy('surname', 'asc')
                            ->get(['surname','firstname','middlename', 'regnum'])->toArray();
        if(count($students) > 0){
            foreach ($students as  $value) {
                $data[] = [
                                'fullname' => trim($value['surname'].' '.$value['firstname'].' '.$value['middlename']),
                                'regnum' => $value['regnum'],
                                'ca' => '',
                                'exam' => ''
                                ];
            }
        }else{
            $data = array();
        }
        if(count($data) > 0){
            $filename = public_path('exceluploads/studentResultBySubject.xls');

            return Excel::load($filename, function($excel) use ($data) {
                $excel->sheet('mySheet', function($sheet) use ($data)
                {
                    $sheet->fromArray($data);
                });
            })->download('xls');
            
        }else{
            flash('Sorry, No student has been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1))->error();

            return $this->errorReturnForTemplate($request);
        }
        
    }


    function adminDownloadClassResultFormatAllSubject(Request $request){
        $classarm_id = $this->classarms->find($request->input('classarm_id'));

        $students = $classarm_id->students()
                            ->wherePivot('session', $request->session)
                            ->wherePivot('term', $request->term)
                            ->wherePivot('class_id', $request->class_id)
                            ->orderBy('surname', 'asc')
                            ->get(['surname','firstname','middlename', 'regnum'])->toArray();
        if(count($students) > 0 && count(getAssocSubjectByClassArmID($request->input('classarm_id'), $request->session)) > 0){

            $array_key = 0;

            foreach ($students as  $value) {
    
                $data[$array_key]['fullname'] = trim($value['surname'].' '.$value['firstname'].' '.$value['middlename']);
                $data[$array_key]['regnum'] =  $value['regnum'];

                foreach(getAssocSubjectByClassArmID($request->input('classarm_id'), $request->session) as $subject){
                    //$subject = strtolower(preg_replace('/\s*/m', '', $subject->subject_code));
                    $subject = str_replace('-', '_', $subject->subject_code);
                    $subject = strtolower($subject);
                    $data[$array_key]['ca_'.$subject] =  '';
                    $data[$array_key]['exam_'.$subject] =  '';
                }

                $array_key++;
            }//end loop

        }else{
            $data = array();
        }
        if(count($data) > 0){
           return Excel::create('student_result_all_subject_'.time(), function($excel) use ($data) {
                $excel->sheet('mySheet', function($sheet) use ($data)
                {
                    $sheet->fromArray($data);
                });
            })->download('xls'); 
            
        }else{
            flash('Sorry, No student has been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1))->error();

            return $this->errorReturnForTemplateAllSubject($request);
        }
        
    }


    function adminUploadStudentResultAllSubject(Request $request){

        $student_results = $this->student_results->setStudentResult();

        $rules = $student_results::$ruleForSubjects;

        $rules['pseudo_batch_file_name'] = ['required','allowexts:xls,xlsx,csv'];
        $rules['classarm_id'] = 'required|integer';

        unset($rules['class_arm_id']);

        $validate = Validator::make($request->all(), $rules);

        $classarm_id = $this->classarms->find($request->input('classarm_id'));
        $class_students = $classarm_id->students()
                            ->wherePivot('session', $request->session)
                            ->wherePivot('term', $request->term)
                            ->wherePivot('class_id', $request->class_id)
                            ->get(['surname','firstname','middlename', 'regnum'])->toArray();

        if(count(getAssocSubjectByClassArmID($request->classarm_id, $request->session)) < 1) {
            flash('Sorry, No subject was found for the Chosen Class Arm')->error();
            return $this->errorReturnForTemplateAllSubject($request);
        }
        else{

        if($validate->passes()){
            if($request->hasFile('batch_file')){

                $path = $request->file('batch_file')->getRealPath();

                $ext = $request->file('batch_file')->getClientOriginalExtension();

                $data = Excel::load($path, function($reader) {
                })->get();

                $sheet_counter=0;
                Excel::load($path, function($sheet) use(&$sheet_counter) {
                    $sheet->each(function($sheet) use(&$sheet_counter) {
                        $sheet_counter++;
                    });
                });

                $insert = array();

                $duplicacy = array();

                $count_students = 0;

                $duplicacy_update_data = array();

                $duplicacy_update_id = array();
                
               $class_data = $this->classes->find($request->class_id);
               $class_name = $class_data->class_name;
               $class_name_char = strtoupper(substr($class_name, 0, 1));
               
               if(count($class_students) == $sheet_counter){
                
                if(!empty($data) && $data->count() > 0){

                    if(in_array($ext, ['xls', 'xlsx'])){

                        foreach ($data as $key => $value) {

                                //check id the regnum exit

                                    $student_id = getStudentIDByRegNum(trim($value->regnum));
                                    $student_name = getStudentFullnameByRegNum($value->regnum);

                                    if(null === $student_id){
                                        $duplicacy[] = 'Student Regisration Number <strong>'.$value->regnum.'</strong> does not exist ';
                                    }else{

                                        $check_students = $student_id->classarms()->wherePivot('session',$request->input('session'))
                                            ->wherePivot('term', $request->term)
                                            ->wherePivot('class_id', $request->class_id)
                                            ->get();

                                        if($check_students->count() == 0){

                                            $duplicacy[] = $student_name.' has not been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);

                                        }
                                        else{
                                            $count_students++;
                                            
                                            foreach(getAssocSubjectByClassArmID($request->classarm_id, $request->session) as $this_subject){
                                                
                                                $subj_unoffered = DB::table('student_subject_unoffered')
                                                                                ->where('student_id', $student_id->id)
                                                                                ->where('classarm_id', $request->classarm_id)
                                                                                ->where('subject_id', $this_subject->id)
                                                                                ->first();
                                                                                
                                                if(empty($subj_unoffered)){
                                                    
                                                    $subject_code = str_replace('-', '_', $this_subject->subject_code);
                                                    $subject_code = strtolower($subject_code);
                                                    $subject_id = $this_subject->id;
    
                                                    $this_subject_ca = "ca_".$subject_code;
                                                    $this_subject_exam = "exam_".$subject_code;
    
                                                    if(!empty($subject_id)){
    
                                                        if(empty($value->$this_subject_ca) || empty($value->$this_subject_exam))
                                                        {
                                                            $duplicacy[] = $student_name.'\'s '.getSubjectNameBySubjectID($subject_id).' CA or EXAM has not be inputted for  '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
                                                        }
                                                        else{
                                                        /////// ALL CLEAR: SAVE INPUT ////// 
                                                                                                                
                                                            $notDuplicate = $this->student_results->checkResultDuplicacy($student_id->id, $subject_id,$request->input('classarm_id'),$request->input('session'),$request->input('term'));
    
    
                                                            if($notDuplicate){
                                                                $this_subject_ca = (strtolower($value->$this_subject_ca) != 'nil') ? $value->$this_subject_ca: 0;

                                                                $this_subject_exam = (strtolower($value->$this_subject_exam) != 'nil') ? $value->$this_subject_exam: 0;

                                                                $mark = $this_subject_ca + $this_subject_exam;
                                                                
                                                                if($class_name_char == "J"){
                                                                    $resultGrade = resultGradeJS($mark);
                                                                    $resultRemarks = resultRemarksJS($mark);
                                                                }
                                                                else{
                                                                    $resultGrade = resultGradeSS($mark);
                                                                    $resultRemarks = resultRemarksSS($mark);                                                                    
                                                                }
                                                                
                                                                $insert[] = [
                                                                'student_id' => $student_id->id,
                                                                 'subject_id' => $subject_id,
                                                                 'ca_score' => $this_subject_ca,
                                                                 'exam_score' => $this_subject_exam,
                                                                 'weighted_average' => $mark,
                                                                 'grade' => $resultGrade,
                                                                 'remarks' => $resultRemarks,
                                                                 'session' => $request->input('session'),
                                                                 'term' => $request->input('term'),
                                                                 'class_id' => $request->input('class_id'),
                                                                 'classarm_id' => $request->input('classarm_id'),
                                                                 'school_id' => Session::get('admin.school')
                                                                ];
    
                                                            }else{
                                                                $duplicateResultId = $this->student_results->getResultDuplicacyId($student_id->id, $subject_id, Session::get('admin.school'), $request->input('classarm_id'),$request->input('session'),$request->input('term'));

                                                                $this_subject_ca = (strtolower($value->$this_subject_ca) != 'nil') ? $value->$this_subject_ca: 0;

                                                                $this_subject_exam = (strtolower($value->$this_subject_exam) != 'nil') ? $value->$this_subject_exam: 0;
    
                                                                if((int)$this_subject_ca != (int)$duplicateResultId['ca_score'] && (int)$this_subject_exam != (int)$duplicateResultId['exam_score']){
    
                                                                    $mark = $this_subject_ca + $this_subject_exam;
                                                                
                                                                    if($class_name_char == "J"){
                                                                        $resultGrade = resultGradeJS($mark);
                                                                        $resultRemarks = resultRemarksJS($mark);
                                                                    }
                                                                    else{
                                                                        $resultGrade = resultGradeSS($mark);
                                                                        $resultRemarks = resultRemarksSS($mark);                                                                    
                                                                    }
    
                                                                    $duplicacy_update_data[$duplicateResultId['id']][] = [
                                                                     'ca_score' => $this_subject_ca,
                                                                     'exam_score' => $this_subject_exam,
                                                                     'weighted_average' => $mark,
                                                                     'grade' => $resultGrade,
                                                                     'remarks' => $resultRemarks
                                                                    ];
    
                                                                    $duplicacy_update_id[] = [
                                                                     'id' => $duplicateResultId['id']
                                                                    ];
    
                                                                }
                                                                
                                                            }   
                                                         
    
                                                        /////// ALL CLEAR: SAVE INPUT ////// 
                                                        }
    
                                                    }
                                                
                                                }/// end if
        
                                            }//End loop
                                            
                                        }
                                    }
                                    
                        }//End loop
                    }

                                                        //dd($notDuplicate);

                    if((count($insert) > 0) && empty($duplicacy)){

                            $student_results->insert($insert);

                            if(!empty($duplicacy_update_id)){
                                $d_i = 0;
                                foreach ($duplicacy_update_id as $data_row) {
                                    $data_id = $data_row['id'];

                                    $student_results_data = $student_results->find($data_id);
                                    $student_results_data->ca_score = $duplicacy_update_data[$data_id][$d_i]['ca_score'];
                                    $student_results_data->exam_score = $duplicacy_update_data[$data_id][$d_i]['exam_score'];
                                    $student_results_data->weighted_average = $duplicacy_update_data[$data_id][$d_i]['weighted_average'];
                                    $student_results_data->grade = $duplicacy_update_data[$data_id][$d_i]['grade'];
                                    $student_results_data->remarks = $duplicacy_update_data[$data_id][$d_i]['remarks'];
                                    $data_update    =   $student_results_data->save();
                                }//end loop

                            flash('Successfully updated '.count($duplicacy_update_id).' result for '.$count_students.' Students')->success();
                            }

                            flash('Successfully inserted '.count($insert).' result for '.$count_students.' Students')->success();

                            return $this->errorReturnForTemplateAllSubject($request); 
                      }elseif((count($insert) > 0) && !empty($duplicacy)){

                            $student_results->insert($insert);

                            if(!empty($duplicacy_update_id)){
                                $d_i = 0;
                                foreach ($duplicacy_update_id as $data_row) {
                                    $data_id = $data_row['id'];

                                    $student_results_data = $student_results->find($data_id);
                                    $student_results_data->ca_score = $duplicacy_update_data[$data_id][$d_i]['ca_score'];
                                    $student_results_data->exam_score = $duplicacy_update_data[$data_id][$d_i]['exam_score'];
                                    $student_results_data->weighted_average = $duplicacy_update_data[$data_id][$d_i]['weighted_average'];
                                    $student_results_data->grade = $duplicacy_update_data[$data_id][$d_i]['grade'];
                                    $student_results_data->remarks = $duplicacy_update_data[$data_id][$d_i]['remarks'];
                                    $data_update    =   $student_results_data->save();
                                }

                            flash('Successfully updated '.count($duplicacy_update_id).' result for '.$count_students.' Students')->success();
                            }

                            flash('Successfully inserted '.count($insert).' result for '.$count_students.' Students')->success();

                            flash($duplicacy)->error();

                            return $this->errorReturnForTemplateAllSubject($request); 
                       }else{
                            if(!empty($duplicacy_update_id)){
                                $d_i = 0;
                                foreach ($duplicacy_update_id as $data_row) {
                                    $data_id = $data_row['id'];

                                    $student_results_data = $student_results->find($data_id);
                                    $student_results_data->ca_score = $duplicacy_update_data[$data_id][$d_i]['ca_score'];
                                    $student_results_data->exam_score = $duplicacy_update_data[$data_id][$d_i]['exam_score'];
                                    $student_results_data->weighted_average = $duplicacy_update_data[$data_id][$d_i]['weighted_average'];
                                    $student_results_data->grade = $duplicacy_update_data[$data_id][$d_i]['grade'];
                                    $student_results_data->remarks = $duplicacy_update_data[$data_id][$d_i]['remarks'];
                                    $data_update    =   $student_results_data->save();
                                }

                            flash('Successfully updated '.count($duplicacy_update_id).' result for '.$count_students.' Students')->success();
                            }
                            else{
                                flash('No fresh result data was submitted.')->error();
                            }

                            if(!empty($duplicacy)){
                             flash($duplicacy)->error();
                            }
                            
                            return $this->errorReturnForTemplateAllSubject($request); 

                        }
                }else{
                    flash('Sorry, the file is empty')->error();
                    return $this->errorReturnForTemplateAllSubject($request);
                }
               }else{
                    flash('Sorry, the Excel file is not the Same as the Result Upload Format. '.count($class_students).' result rows expected on a Single Excel Sheet.')->error();
                    return $this->errorReturnForTemplateAllSubject($request);
                }//endif
                
            }else{
                flash('Sorry, You have not choosen any file')->error();

            return $this->errorReturnForTemplateAllSubject($request);
            }
        }else{
            return $this->errorReturnForTemplateAllSubject($request)->withErrors($validate);
        }

        }

    }


    function adminUploadStudentResultBySubject(Request $request){

        $student_results = $this->student_results->setStudentResult();

        $rules = $student_results::$ruleForSubjects;

        $rules['pseudo_batch_file_name'] = ['required','allowexts:xls,xlsx,csv', 'excelFormatAllowed:4'];
        $rules['classarm_id'] = 'required|integer';

        unset($rules['class_arm_id']);

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){
            if($request->hasFile('batch_file')){

                $path = $request->file('batch_file')->getRealPath();

                $ext = $request->file('batch_file')->getClientOriginalExtension();

                $data = Excel::load($path, function($reader) {
                })->get();

                $insert = array();

                $duplicacy = array();
                
               $class_data = $this->classes->find($request->class_id);
               $class_name = $class_data->class_name;
               $class_name_char = strtoupper(substr($class_name, 0, 1));
                

                if(!empty($data) && $data->count() > 0){

                    if(in_array($ext, ['xls', 'xlsx'])){

                        foreach ($data as $key => $value) {

                                //check id the regnum exit

                                    $student_id = getStudentIDByRegNum($value->regnum);

                                    if(null === $student_id){
                                        $duplicacy[] = 'Student Regisration Numbe <strong>'.$value->regnum.'</strong> does not exit ';
                                    }else{

                                        $check_students = $student_id->classarms()->wherePivot('session',$request->input('session'))
                                            ->wherePivot('term', $request->term)
                                            ->wherePivot('class_id', $request->class_id)
                                            ->get();

                                        if($check_students->count() == 0){

                                            $duplicacy[] = getStudentFullnameByRegNum($value->regnum).' has not been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);

                                        }elseif(empty($value->ca) || empty($value->exam))
                                        {
                                            $duplicacy[] = getStudentFullnameByRegNum($value->regnum).'\'s '.getSubjectNameBySubjectID($request->input('subject_id')).' CA or EXAM has not be inputted for  '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
                                        }else{
                                            $subject_id = $request->input('subject_id');                                                
                                            $subj_unoffered = DB::table('student_subject_unoffered')
                                                                            ->where('student_id', $student_id->id)
                                                                            ->where('classarm_id', $request->classarm_id)
                                                                            ->where('subject_id', $subject_id)
                                                                            ->first();
                                                                            
                                            if(empty($subj_unoffered)){
    
                                                $notDuplicate = $this->student_results->checkResultDuplicacy($student_id->id, $request->input('subject_id'),$request->input('classarm_id'),$request->input('session'),$request->input('term'));
    
                                                //dd($notDuplicate);
    
                                                if($notDuplicate){
                                                    $mark = $value->ca + $value->exam;  
                                                                
                                                    if($class_name_char == "J"){
                                                        $resultGrade = resultGradeJS($mark);
                                                        $resultRemarks = resultRemarksJS($mark);
                                                    }
                                                    else{
                                                        $resultGrade = resultGradeSS($mark);
                                                        $resultRemarks = resultRemarksSS($mark);                                                                    
                                                    }
                                                    
                                                    $insert[] = [
                                                    'student_id' => $student_id->id,
                                                     'subject_id' => $request->input('subject_id'),
                                                     'ca_score' => $value->ca,
                                                     'exam_score' => $value->exam,
                                                     'weighted_average' => $mark,
                                                     'grade' => $resultGrade,
                                                     'remarks' => $resultRemarks,
                                                     'session' => $request->input('session'),
                                                     'term' => $request->input('term'),
                                                     'class_id' => $request->input('class_id'),
                                                     'classarm_id' => $request->input('classarm_id'),
                                                     'school_id' => Session::get('admin.school')
                                                    ];
    
                                                }else{
                                                    $duplicacy[] = getStudentFullnameByRegNum($value->regnum).'\'s '.getSubjectNameBySubjectID($request->input('subject_id')).' has already been uploaded for '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
                                                }
                                            
                                            }//end if
                                        }
                                    }
                        }
                    }


                    if((count($insert) > 0) && empty($duplicacy)){

                            $student_results->insert($insert);

                            flash('Successfully inserted '.count($insert).' Students')->success();

                            return $this->errorReturnForTemplate($request); 
                      }elseif((count($insert) > 0) && !empty($duplicacy)){

                            $student_results->insert($insert);

                            flash('Successfully inserted '.count($insert).' Students')->success();

                            flash($duplicacy)->error();

                            return $this->errorReturnForTemplate($request); 
                       }else{

                             flash($duplicacy)->error();
                            
                            return $this->errorReturnForTemplate($request); 

                        }
                }else{
                    flash('Sorry, the file is empty')->error();
                    return $this->errorReturnForTemplate($request);
                }
            }else{
                flash('Sorry, You have not choosen any file')->error();

            return $this->errorReturnForTemplate($request);
            }
        }else{
            return $this->errorReturnForTemplate($request)->withErrors($validate);
        }

    }


    function adminEditStudentResult($id, $session, $class_id, $classarm_id, $term){

        $student = $this->students->find($id);

        $student_results = $student->studentResults()
                            ->where('session', $session)
                            ->where('class_id', $class_id)
                            ->where('classarm_id', $classarm_id)
                            ->where('term', $term)
                            ->where('school_id', Session::get('admin.school'))
                            ->get();

        return view('admin.results.student-result-edit', compact('student_results', 'session', 'class_id', 'classarm_id', 'term', 'id'));
    }

    function adminUpdateStudentResult(Request $request){
        $student_result = $this->student_results->setStudentResult();

        $validate = Validator::make($request->all(), $student_result::$ruleForResultUpdate);


        if($validate->passes()){
            $ca_score = '';
            $exam_score = '';
            $weighted_average = '';
            $grade = '';
            $remarks = '';
            
           $class_data = $this->classes->find($request->class_id);
           $class_name = $class_data->class_name;
           $class_name_char = strtoupper(substr($class_name, 0, 1));
            
            foreach($request->subject_id as $subject_id){
                
                if($class_name_char == "J"){
                    $resultGrade = resultGradeJS($request->ca[$subject_id] + $request->exam[$subject_id]);
                    $resultRemarks = resultRemarksJS($request->ca[$subject_id] + $request->exam[$subject_id]);
                }
                else{
                    $resultGrade = resultGradeSS($request->ca[$subject_id] + $request->exam[$subject_id]);
                    $resultRemarks = resultRemarksSS($request->ca[$subject_id] + $request->exam[$subject_id]);                                                                  
                }
                
                $ca_score .= ' WHEN `student_id` = '.$request->student_id.' AND `session` = '.$request->session.' AND `class_id` = '.$request->class_id.' AND `classarm_id` = '.$request->classarm_id.' AND `session` = '.$request->session.' AND `term` = \''.$request->term.'\' AND `subject_id` = '.$subject_id.' THEN '.$request->ca[$subject_id];
                $exam_score .= ' WHEN `student_id` = '.$request->student_id.' AND `session` = '.$request->session.' AND `class_id` = '.$request->class_id.' AND `classarm_id` = '.$request->classarm_id.' AND `session` = '.$request->session.' AND `term` = \''.$request->term.'\' AND `subject_id` = '.$subject_id.' THEN '.$request->exam[$subject_id];
                $weighted_average .= ' WHEN `student_id` = '.$request->student_id.' AND `session` = '.$request->session.' AND `class_id` = '.$request->class_id.' AND `classarm_id` = '.$request->classarm_id.' AND `session` = '.$request->session.' AND `term` = \''.$request->term.'\' AND `subject_id` = '.$subject_id.' THEN '.($request->ca[$subject_id] + $request->exam[$subject_id]);
                $grade .= ' WHEN `student_id` = '.$request->student_id.' AND `session` = '.$request->session.' AND `class_id` = '.$request->class_id.' AND `classarm_id` = '.$request->classarm_id.' AND `session` = '.$request->session.' AND `term` = \''.$request->term.'\' AND `subject_id` = '.$subject_id.' THEN \''.$resultGrade.'\'';
                $remarks .= ' WHEN `student_id` = '.$request->student_id.' AND `session` = '.$request->session.' AND `class_id` = '.$request->class_id.' AND `classarm_id` = '.$request->classarm_id.' AND `session` = '.$request->session.' AND `term` = \''.$request->term.'\' AND `subject_id` = '.$subject_id.' THEN \''.$resultRemarks.'\'';
            }

            $statement = 'UPDATE `student_results` SET `ca_score` = (CASE '.$ca_score.' END), `exam_score` = (CASE '.$exam_score.' END), `weighted_average` = (CASE '.$weighted_average.' END), `grade` = (CASE '.$grade.' END), `remarks` = (CASE '.$remarks.' END), `updated_at` = now() WHERE `student_id` = '.$request->student_id.' AND `class_id` = '.$request->class_id.' AND `classarm_id` = '.$request->classarm_id.' AND `session` = '.$request->session.' AND `term` = \''.$request->term.'\' AND `subject_id` IN ('.implode(', ', $request->subject_id).')';

            \DB::statement($statement);

            flash('Student Result successfully updated')->success();

            return $this->adminEditStudentResult($request->student_id, $request->session, $request->class_id, $request->classarm_id, $request->term)->withErrors($validate);
        }

        flash('Something is wrong')->error();
        return $this->adminEditStudentResult($request->student_id, $request->session, $request->class_id, $request->classarm_id, $request->term)->withErrors($validate);
    }


    function adminPromotionStampViewStudent(){

       if($this->permissionDeny('lock-and-release-student-result')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $title = 'Student Result Promotion Stamp';

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.post.promotion.stamp.view.student';

        return view('admin.results.promotion-get-student', compact('classes', 'classarms', 'title', 'route'));
    }


    function adminPromotionStampViewStudentPost(Request $request){

        if($this->permissionDeny('lock-and-release-student-result')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $stdresult = $this->student_results->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            if($request->input('term') != 'Third'){
                flash('You can only process Promotion Stamp on Third Term Result')->error();

                return redirect()->back();
            }
            else{
                $session = $request->input('session');

                $term = $request->input('term');

                $classarm_id = $request->input('classarm_id');

                $class_id = $request->input('class_id');

                $classarms = $this->classarms->find($request->input('classarm_id'));

                $classes = $this->classes->setClass()
                                        ->where('school_id', '=', Session::get('admin.school'))
                                        ->get();

                $classarm_students =  $classarms->students()
                                                ->wherePivot('session','=', $session)
                                                ->wherePivot('term','=', $term)
                                                ->get();

                $route = 'admin.promotion.stamp.student.result';

                return view('admin.results.promotion-view-students', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'route'));
            }

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate);
        }

    }


    function adminPromotionStampStudentResultProcess(Request $request){

        if($this->permissionDeny('lock-and-release-student-result')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $stdresult = $this->student_results->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $rules['student_id'] = 'required|array|min:1';

        $rules['stamp_type'] = 'required';

        Input::flash();

        $validate = Validator::make($request->all(), $rules);

        if(count($request->student_id) > 0){
            $where_clause = '('.implode(', ', $request->student_id ).')';
        }

        $session = $request->session;

        $classarm_id = $request->classarm_id;

        $class_id = $request->class_id;

        $term = $request->term;
        $stamp_type = $request->stamp_type;
        $stamp_type_val = 1;

        if($stamp_type == 'Promoted'){
            $stamp_type_val = 2;
        }
        elseif($stamp_type == 'Repeated'){
            $stamp_type_val = 3;
        }
        elseif($stamp_type == 'Withdraw'){
            $stamp_type_val = 4;            
        }

        if($validate->passes()){

            $statement = "UPDATE `student_results` SET `promotion` = $stamp_type_val WHERE `session` = $session AND `classarm_id` = $classarm_id AND `term` = '$term' AND `class_id` = $class_id AND `student_id` IN $where_clause";

            \DB::statement($statement);

            flash('You have successfully Stamped student result as '.$stamp_type)->success();

            return $this->adminPromotionStampViewStudentPost($request);

        }else{

            flash('All field are mandatory')->error();

            return $this->adminViewStudentReleaseOrLockResult($request);

        }


    }


    function adminReleaseOrLockResult(){

       if($this->permissionDeny('lock-and-release-student-result')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $title = 'Lock and Release Student Result';

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.post.view.lock.release.student.result';

        return view('admin.classarms.pre-assign-student', compact('classes', 'classarms', 'title', 'route'));
    }

    function adminViewStudentReleaseOrLockResult(Request $request){

        if($this->permissionDeny('lock-and-release-student-result')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $stdresult = $this->student_results->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            $session = $request->input('session');

            $term = $request->input('term');

            $classarm_id = $request->input('classarm_id');

            $class_id = $request->input('class_id');

            $classarms = $this->classarms->find($request->input('classarm_id'));

            $classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

            $classarm_students =  $classarms->students()
                                            ->wherePivot('session','=', $session)
                                            ->wherePivot('term','=', $term)
                                            ->get();

            $route = 'admin.lock.release.student.result';

            $release_lock = 'Edit';

            return view('admin.classarms.post-view-students', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'route', 'release_lock'));

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate);
        }

    }


    function adminReleaseLockFinalResult(Request $request){

        if($this->permissionDeny('lock-and-release-student-result')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $stdresult = $this->student_results->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $rules['student_id'] = 'required|array|min:1';

        Input::flash();

        $setSchool = School::find(Session::get('admin.school'));

        $principal_sign = $setSchool->principal_sign;
        $next_session_date = $setSchool->next_session_date;

        $validate = Validator::make($request->all(), $rules);

        if(count($request->student_id) > 0){
            $where_clause = '('.implode(', ', $request->student_id ).')';
        }

        $session = $request->session;

        $classarm_id = $request->classarm_id;

        $class_id = $request->class_id;

        $term = $request->term;

        $curr_date =Carbon::now()->format('Y-m-d');

       /* if(!empty($next_session_date) && $next_session_date > $curr_date){ */

            if($validate->passes()){

                $statement = "UPDATE `student_results` SET `status` = 1 WHERE `session` = $session AND `classarm_id` = $classarm_id AND `term` = '$term' AND `class_id` = class_id AND `student_id` IN $where_clause";

                \DB::statement($statement);

                flash('You have successfully Release student Results')->success();

                return $this->adminViewStudentReleaseOrLockResult($request);

            }else{

                $statement = "UPDATE `student_results` SET `status` = 0 WHERE `session` = $session AND `classarm_id` = $classarm_id AND `term` = '$term' AND `class_id` = class_id";

                \DB::statement($statement);

                flash('You have successfully Lock all student results')->success();

                return $this->adminViewStudentReleaseOrLockResult($request);

            }
       /* }
        else{            
            flash('You must set a valid Resumption Date for Next Term before releasing result.')->error();
            return redirect()->back();
        }
		*/


    }



    function adminDeleteStudentResult($id, Request $request){
        $this->student_results->setStudentResult()
                            ->where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('term', $request->term)
                            ->where('student_id', $id)
                            ->delete();
        flash('You have success delete '.getStudentFullnameByStudentID($id).'\'s result')->success();

        return redirect()->back();
    }


   protected function errorReturnForTemplate(Request $request){
        $inputs = array();

            foreach($request->all() as $key => $value){
                if(!empty($key) && !in_array($key, ['_method', '_token', 'pseudo_batch_file_name','subject_id','batch_file'])){

                    if($key == 'classarm_id' || $key == 'class_arm_id'){
                        $inputs['class arm'] = $value;
                    }elseif($key == 'class_id'){
                        $inputs['class'] = $value;
                    }else{
                        $inputs[$key] = $value;
                    }

                }
            }

            return view('admin.results.subject-batch-template', compact('inputs'));
    }


   protected function errorReturnForTemplateAllSubject(Request $request){
        $inputs = array();

            foreach($request->all() as $key => $value){
                if(!empty($key) && !in_array($key, ['_method', '_token', 'pseudo_batch_file_name','subject_id','batch_file'])){

                    if($key == 'classarm_id' || $key == 'class_arm_id'){
                        $inputs['class arm'] = $value;
                    }elseif($key == 'class_id'){
                        $inputs['class'] = $value;
                    }else{
                        $inputs[$key] = $value;
                    }

                }
            }

            return view('admin.results.subject-all-batch-template', compact('inputs'));
    }




}
