<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\Repositories\PracticalSkillRepositoryInterface;

use App\Repositories\CharacterAttitudeRepositoryInterface;

use Validator;

use Input;

use Excel;

use Session;

class StudentPracticalAttitudeController extends Controller
{
    protected $students;

	protected $classes;

	protected $classarms;

	protected $subjects;

	protected $student_results;

	protected $practical_skill;

	protected $characters;

    function __construct(StudentRepositoryInterface $students,ClassRepositoryInterface $classes, ClassArmRepositoryInterface $classarms, SubjectRepositoryInterface $subjects, StudentResultRepositoryInterface $student_results, PracticalSkillRepositoryInterface $practical_skill, CharacterAttitudeRepositoryInterface $characters){

    	$this->middleware('auth:admin');

    	$this->students = $students;

    	$this->classes = $classes;

    	$this->classarms = $classarms;

    	$this->subjects = $subjects;

    	$this->student_results = $student_results;

    	$this->practical_skill = $practical_skill;

    	$this->characters = $characters;


    }

	function adminViewPraticalCharacterByClassCategory(){

		$classes = $this->classes->setClass()
								->where('school_id', '=', Session::get('admin.school'))
								->get();

    	return view('admin.practical-skill.view-practical-form', compact('classes'));

	} 

	function adminViewPraticalCharacterByClassCategorySubmit(Request $request){
		$student_results = $this->student_results->setStudentResult();

		$student = $this->students->setStudent();

		$practical_skill = $this->practical_skill->setPracticalSkill();

		$characters = $this->characters->setCharacterAttitude();

		$rules = $student_results::$ruleForSubjects;

    	$rules['classarm_id'] = 'required|integer';

    	unset($rules['class_arm_id']);

    	$validate = Validator::make($request->all(), $rules);

    	if($validate->passes()){

    		$session = $request->session;

    		$class_id = $request->class_id;

    		$term = $request->term;

    		$classarm_id_get = $request->classarm_id;

    		$data = array();

    		foreach($request->all() as $key => $value){
    			if(!empty($key) && !in_array($key, ['_method', '_token'])){
    					$data[$key] = $value;
    			}
    		}

	    	$classarm_id = $this->classarms->find($request->input('classarm_id'));

	    	$students = $classarm_id->students()
	    							->wherePivot('session',$request->session)
	    							->wherePivot('term',$request->term)
	    							->wherePivot('class_id',$request->class_id)
	    							->get();

	    	Input::flash();

	    	$result_records = array();

	    	foreach($students as $student){

	    		$data['student_id'] = $student->id;

	    		$student_practical_skills = fetchDataTable('practical_skills', $data,30);

	    		$student_characters = fetchDataTable('character_attitudes', $data,30);

	    		$result_records[$student->id]['practical_skill'] = $student_practical_skills->toArray();

	    		$result_records[$student->id]['characters'] = $student_characters->toArray();

	    	}

	    	$students_practical_character_info = collect($result_records);

	    	return view('admin.practical-skill.practical-view', compact('students_practical_character_info', 'class_id', 'session', 'term', 'classarm_id_get'));
    	}

    	flash('Something is wrong')->error();

    	return $this->back()
    			->withErrors($validate)
    			->withInput();


	}


    function adminViewBatchUploadPracticalCharacter(){

    	$classes = $this->classes->setClass()
								->where('school_id', '=', Session::get('admin.school'))
								->get();

    	return view('admin.practical-skill.batch-upload', compact('classes'));

    }

    function adminViewClassPraticalCharacterTemplate(Request $request){

    	$student_result = $this->student_results->setStudentResult();

    	$validate = Validator::make($request->all(), $student_result::$ruleForSubjects);

    	if($validate->passes()){

    		Input::flash();

    		return $this->errorReturnForTemplate($request);

    	}else{
    		return redirect()->back()
    						->withErrors($validate)
    						->withInput();
    	}
    }



    function adminDownloadClassPraticalCharacterFormat(Request $request){
    	$classarm_id = $this->classarms->find($request->input('classarm_id'));

    	$students = $classarm_id->students()
    						->wherePivot('session', $request->session)
    						->wherePivot('term', $request->term)
    						->wherePivot('class_id', $request->class_id)
    						->get(['surname','firstname','middlename', 'regnum'])->toArray();
    	if(count($students) > 0){
	    	foreach ($students as  $value) {
	    		$data[] = [
	    						'fullname' => trim($value['surname'].' '.$value['firstname'].' '.$value['middlename']),
	    						'regnum' => $value['regnum']
	    						];
	    	}
    	}else{
    		$data = array();
    	}
    	if(count($data) > 0){
	    	$filename = public_path('exceluploads/studentBatchUploadPracticalSkillAndAttitudeFormat.xls');

	    	return Excel::load($filename, function($excel) use ($data) {
				$excel->sheet('Sheet1', function($sheet) use ($data)
		        {
					$sheet->fromArray($data);
		        });
			})->download('xls');
    		
    	}else{
    		flash('Sorry, No student has been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1))->error();

    		return $this->errorReturnForTemplate($request);
    	}
    	
    }

    function adminUploadStudentPracticalCharacter(Request $request){

    	$student_results = $this->student_results->setStudentResult();

    	$practical_skill = $this->practical_skill->setPracticalSkill();

    	$characters = $this->characters->setCharacterAttitude();

    	$rules = $student_results::$ruleForSubjects;

    	$rules['pseudo_batch_file_name'] = ['required','allowexts:xls,xlsx,csv', 'excelFormatAllowed:15'];
    	$rules['classarm_id'] = 'required|integer';

    	unset($rules['class_arm_id']);

    	$validate = Validator::make($request->all(), $rules);

    	if($validate->passes()){
    		if($request->hasFile('batch_file')){

				$path = $request->file('batch_file')->getRealPath();

				$ext = $request->file('batch_file')->getClientOriginalExtension();

				$data = Excel::load($path, function($reader) {
				})->get();

				$insertPracticalSkill = array();

				$insertCharacters = array();

				$duplicacy = array();

				if(!empty($data) && $data->count()){

					if(in_array($ext, ['xls', 'xlsx'])){

						foreach ($data as $key => $result_info) {

									//Consider the last column in the excel file

								//check id the regnum exit

									$student_id = getStudentIDByRegNum($result_info->regnum);

									if(null === $student_id){
										$duplicacy[] = 'Student Regisration Number <strong>'.$result_info->regnum.'</strong> does not exit ';
									}else{

										$check_students = $student_id->classarms()->wherePivot('session',$request->input('session'))
											->wherePivot('term', $request->term)
		    								->wherePivot('class_id', $request->class_id)
		    								->get();

										if($check_students->count() == 0){

											$duplicacy[] = getStudentFullnameByRegNum($result_info->regnum).' has not been assigned to '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);

										}else{

											$notDuplicatePracticalSkill = $this->practical_skill->checkResultDuplicacy($student_id->id, $request->input('classarm_id'),$request->input('session'),$request->input('term'));

											$notDuplicateCharacters = $this->characters->checkResultDuplicacy($student_id->id, $request->input('classarm_id'),$request->input('session'),$request->input('term'));

											//dd($notDuplicate);

											if($notDuplicatePracticalSkill){
												$insertPracticalSkill[] = [
												'student_id' => $student_id->id,
												 'hand_writing' => (int)$result_info->hand_writing,
												 'music' => (int)$result_info->music,
												 'hand_writing' => (int)$result_info->hand_writing,
												 'drama' => (int)$result_info->drama,
												 'craft' => (int)$result_info->craft,
												 'club_societies' => (int)$result_info->club_societies,
												 'hobbies' => (int)$result_info->hobbies,
												 'sports' => (int)$result_info->sports,
												 'session' => $request->input('session'),
												 'term' => $request->input('term'),
												 'class_id' => $request->input('class_id'),
												 'classarm_id' => $request->input('classarm_id'),
												 'school_id' => Session::get('admin.school')
												];

											}else{
												$duplicacy[] = getStudentFullnameByRegNum($result_info->regnum).'\'s Practical Skills has already been uploaded for '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
											}

											if($notDuplicateCharacters){
												$insertCharacters[] = [
												'student_id' => $student_id->id,
												 'attentive_class' => (int)$result_info->attentive_class,
												 'neatness' => (int)$result_info->neatness,
												 'self_control' => (int)$result_info->self_control,
												 'punctuality' => (int)$result_info->punctuality,
												 'politeness' => (int)$result_info->politeness,
												 'relationship_others' => (int)$result_info->relationship_others,
												 'session' => $request->input('session'),
												 'term' => $request->input('term'),
												 'class_id' => $request->input('class_id'),
												 'classarm_id' => $request->input('classarm_id'),
												 'school_id' => Session::get('admin.school')
												];

											}else{
												$duplicacy[] = getStudentFullnameByRegNum($result_info->regnum).'\'s Character Development has already been uploaded for '.getClassNameByClassID($request->class_id).' '.getClassArmNameByClassArmID($request->classarm_id).' '.$request->session.'/'.($request->session + 1);
											}
										}
									}
						}
					}

					if(((count($insertCharacters) > 0) || (count($insertPracticalSkill) > 0)) && empty($duplicacy)){
							if(count($insertCharacters) > 0){
                            	$characters->insert($insertCharacters);
								
							}

							if(count($insertPracticalSkill) > 0){
                            	$practical_skill->insert($insertPracticalSkill);
								
							}

                            flash('Successfully inserted '.count($insertPracticalSkill).' Students')->success();

                            return $this->errorReturnForTemplate($request); 
                      }elseif(((count($insertCharacters) > 0) || (count($insertPracticalSkill) > 0)) && !empty($duplicacy)){

                            if(count($insertCharacters) > 0){
                            	$characters->insert($insertCharacters);
								
							}

							if(count($insertPracticalSkill) > 0){
                            	$practical_skill->insert($insertPracticalSkill);
								
							}

                            flash('Successfully inserted '.count($insertPracticalSkill).' Students')->success();

                            flash($duplicacy)->error();

                            return $this->errorReturnForTemplate($request); 
                       }else{

                             flash($duplicacy)->error();
                            
                            return $this->errorReturnForTemplate($request); 

                        }
				}else{
					flash('Sorry, the file is empty')->error();
	    			return $this->errorReturnForTemplate($request);
				}
			}else{
				flash('Sorry, You have not choosen any file')->error();

    		return $this->errorReturnForTemplate($request);
			}
    	}else{
    		return $this->errorReturnForTemplate($request)->withErrors($validate);
    	}

    }

    function adminEditStudentPracticalAttitude($id, $session, $class_id, $classarm_id, $term){

    	$student = $this->students->find($id);

    	$student_practical_skills = $student->studentPracticalSkills()
    						->where('session', $session)
    						->where('class_id', $class_id)
    						->where('classarm_id', $classarm_id)
    						->where('term', $term)
    						->where('school_id', Session::get('admin.school'))
    						->get();

    	$student_character_attitude = $student->studentCharacterAttitudes()
    						->where('session', $session)
    						->where('class_id', $class_id)
    						->where('classarm_id', $classarm_id)
    						->where('term', $term)
    						->where('school_id', Session::get('admin.school'))
    						->get();

		return view('admin.practical-skill.student-practical-edit', compact('student_practical_skills', 'student_character_attitude', 'session', 'class_id', 'classarm_id', 'term', 'id'));
    }

    function adminUpdateStudentPracticalCharacter(Request $request){
    	$student_result = $this->student_results->setStudentResult();

    	unset($student_result::$ruleForResultUpdate['ca']);
    	unset($student_result::$ruleForResultUpdate['exam']);
    	unset($student_result::$ruleForResultUpdate['subject_id']);


    	$validate = Validator::make($request->all(), $student_result::$ruleForResultUpdate);


    	if($validate->passes()){

    		$student_practical_skills = $this->practical_skill->setPracticalSkill()
    						->where('session', $request->session)
    						->where('class_id', $request->class_id)
    						->where('classarm_id', $request->classarm_id)
    						->where('term', $request->term)
    						->where('school_id', Session::get('admin.school'))
    						->where('student_id', $request->student_id)
    						->first();
    		$student_practical_skills->hand_writing = $request->hand_writing;
    		$student_practical_skills->music = $request->music;
    		$student_practical_skills->drama = $request->drama;
    		$student_practical_skills->craft = $request->craft;
    		$student_practical_skills->club_societies = $request->club_societies;
    		$student_practical_skills->hobbies = $request->hobbies;
    		$student_practical_skills->sports = $request->sports;
    		$student_practical_skills->save();

    	$student_character_attitude = $this->characters->setCharacterAttitude()
    						->where('session', $request->session)
    						->where('class_id', $request->class_id)
    						->where('classarm_id', $request->classarm_id)
    						->where('term', $request->term)
    						->where('school_id', Session::get('admin.school'))
    						->where('student_id', $request->student_id)
    						->first();

    		$student_character_attitude->attentive_class = $request->attentive_class;
    		$student_character_attitude->neatness = $request->neatness;
    		$student_character_attitude->self_control = $request->self_control;
    		$student_character_attitude->punctuality = $request->punctuality;
    		$student_character_attitude->politeness = $request->politeness;
    		$student_character_attitude->relationship_others = $request->relationship_others;

    		$student_character_attitude->save();
    		

	    	flash('Student Result successfully updated')->success();

	    	return $this->adminEditStudentPracticalAttitude($request->student_id, $request->session, $request->class_id, $request->classarm_id, $request->term)->withErrors($validate);
    	}

    	flash('Something is wrong')->error();
    	return $this->adminEditStudentResult($request->student_id, $request->session, $request->class_id, $request->classarm_id, $request->term)->withErrors($validate);
    }

    function adminDeleteStudentPracticalCharacter($id, Request $request){
    	$this->student_results->setStudentResult()
    						->where('session', $request->session)
    						->where('class_id', $request->class_id)
    						->where('classarm_id', $request->classarm_id)
    						->where('term', $request->term)
    						->where('student_id', $id)
    						->delete();
    	flash('You have success delete '.getStudentFullnameByStudentID($id).'\'s result')->success();

    	return redirect()->back();
    }

   protected function errorReturnForTemplate(Request $request){
    	$inputs = array();

    		foreach($request->all() as $key => $value){
    			if(!empty($key) && !in_array($key, ['_method', '_token', 'pseudo_batch_file_name','subject_id','batch_file'])){

    				if($key == 'classarm_id' || $key == 'class_arm_id'){
    					$inputs['class arm'] = $value;
    				}elseif($key == 'class_id'){
    					$inputs['class'] = $value;
    				}else{
    					$inputs[$key] = $value;
    				}

    			}
    		}

    		return view('admin.practical-skill.batch-template', compact('inputs'));
    }
}
