<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\StudentHouseRepositoryInterface;

use App\Repositories\TeacherRepositoryInterface;

use Session;

use Validator;

use Auth;

use Gate;

class StudentHouseController extends Controller
{
    protected $school_house;

    protected $teachers;

    public function __construct(StudentHouseRepositoryInterface $school_house, TeacherRepositoryInterface $teachers){

    	$this->school_house = $school_house;

            $this->teachers = $teachers;

    	$this->middleware('auth:admin');

    }

    protected function permissionDeny($ability){
        Auth::shouldUse('admin');
        return Gate::denies($ability);
    }

    public function adminViewSchoolHouse(){

        if($this->permissionDeny('view-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$title = "View School House";
    	$school_houses_statement = $this->school_house->setSchoolHouse()
    							->where('school_id', Session::get('admin.school'));
    	$all_school_houses = $school_houses_statement->get();
    	$school_houses = $school_houses_statement->paginate(40);
    	return view('admin.school-house.view', compact('all_school_houses', 'school_houses'));
    }

    public function adminViewSearchSchoolHouse(Request $request){

        if($this->permissionDeny('view-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$title = "View School House";
    	$all_school_houses = $this->school_house->setSchoolHouse()
    							->where('school_id', Session::get('admin.school'))->get();
    	$school_houses = $this->school_house->setSchoolHouse()
    							->where('school_id', Session::get('admin.school'))
    							->where('id', $request->house_id)
    							->paginate(40);

    	return view('admin.school-house.view', compact('all_school_houses', 'school_houses'));
    }

    public function adminCreateSchoolHouse(){

        if($this->permissionDeny('create-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$all_school_houses = $this->school_house->setSchoolHouse()
    							->where('school_id', Session::get('admin.school'))
    							->get();


    	return view('admin.school-house.create', compact('all_school_houses'));

    }

    public function adminStoreSchoolHouse(Request $request){

        if($this->permissionDeny('create-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		$school_houses = $this->school_house->setSchoolHouse();

		$validate = Validator::make($request->all(), $school_houses::$rule);

		if($validate->passes()){
			$school_houses->create([
					'name' => $request->input('school_house'),
					'school_id' => Session::get('admin.school')
				]);

			flash('You have successfully created school houes')->success();

			return redirect()->back();
		}

		return redirect()->back()
						->withErrors($validate)
						->withInput();

    }

    public function adminEditSchoolHouse($id){

        if($this->permissionDeny('edit-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }


    	$school_house = $this->school_house->find($id);
    	$all_school_houses = $this->school_house->setSchoolHouse()
    							->where('school_id', Session::get('admin.school'))
    							->get();


        $all_teachers = $this->teachers->setTeacher()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $house_master =  $school_house->house_masters()->first();

    	return view('admin.school-house.edit', compact('all_school_houses', 'school_house', 'all_teachers', 'house_master'));
    }


    public function adminUpdateSchoolHouse($id, Request $request){

        if($this->permissionDeny('edit-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$setSchoolHouse = $this->school_house->setSchoolHouse();

    	$setSchoolHouse::$rule['school_house'] = 'required|school_house_check:'.$id;

    	$validate = Validator::make($request->all(), $setSchoolHouse::$rule);
    	if($validate->passes()){

    		$school_house = $this->school_house->find($id);

            if(!empty($request->teacher)){
                $school_house->house_masters()->sync([$request->teacher => ['school_id' => $school_house->school_id, 'session' => date('Y')]]);
            }

    		$school_house->name = $request->input('school_house');

    		$school_house->save();

    		flash('You have successfully updated School House')->success();

    		return redirect()->back();
    	}

    	return redirect()->back()
						->withErrors($validate)
						->withInput();



    }

    public function adminDeleteSchoolHouse($id){

        if($this->permissionDeny('delete-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$school_house = $this->school_house->find($id);

    	$school_house->delete();

    	flash('You have successfully delete the school house')->success();

    	return redirect()->back();

    }


    public function adminAssignSchoolHouseMaster(Request $request){

        if($this->permissionDeny('assign-student-to-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$request;

    }

    public function adminRemoveSchoolHouseMaster(Request $request){

        if($this->permissionDeny('remove-assign-student-from-school-house')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $request;

    }
}
