<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\ResultVoucherRepositoryInterface;

use Auth;

use Gate;

use Validator;

class ScratchCardController extends Controller
{
    protected $student_voucher;

    public function __construct(ResultVoucherRepositoryInterface $student_voucher){

    	$this->student_voucher = $student_voucher;

    	$this->middleware('auth:super_admin');
    }

    protected function permissionDeny($ability){
        Auth::shouldUse('super_admin');
        return Gate::denies($ability);
    }


     public function viewScratchCard()
     {
     	if($this->permissionDeny('view-scratch-card')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

         $title = "Vouchers";
         
         
         if (\Request::ajax())
         {
             return \Response::json($this->student_voucher->setResultVoucher()->getAll());
         }
         
         $vouchers = $this->student_voucher->setResultVoucher()->paginate(800);

         $iterations = array(50, 100, 200, 500, 1000);

         
         
         return view('super-admin.voucher', compact('title','vouchers', 'iterations'));
     }
     
     /**
      * Create Vouchers
      * @params Request
      * @return Response
      */ 
     public function generateScratchCard(Request $request)
     {
     	if($this->permissionDeny('create-scratch-card')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $voucher = $this->student_voucher->setResultVoucher();

         $validator = Validator::make($request->all(), $voucher::$rules);
         
         if ($validator->passes())
         {
             
            $iteration = $request->input('iteration');

            $insert = array();

            for ($i=1; $i <= $iteration; $i++)
            {                 
                list($pin1, $pin2, $pin3, $pin4) = $this->getRandomVoucher($iteration);

                $insert[] = array(
                    'pin1' => $pin1,
                    'pin2' => $pin2,
                    'pin3' => $pin3,
                    'pin4' => $pin4,
                    'pin' => $pin1 . $pin2 . $pin3 . $pin4,
                   'serial' => $this->getSerialNumber()
                );
            }
            $voucher->insert($insert);
             
            flash('Scratch Cards generated!')->success();
            return redirect()->back();
         }
         
         flash()->warning('Something went wrong');
         return redirect()->back()
                           ->withErrors($validator)
                           ->withInput();
     }

     public function deleteScratchCard(Request $request){

     	if($this->permissionDeny('delete-scratch-card')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

     	$validate = Validator::make($request->all(), [
     						'scratch_cards' => 'required|array'
     		]);

     	if($validate->passes()){

     		$vouchers_to_delete = '('.implode(', ', $request->scratch_cards).')';

     			$vouchers = $this->student_voucher->setResultVoucher()
     						->whereRaw('`id` IN '.$vouchers_to_delete)
     						->delete();

     			flash('You have successfully deleted the selected scratch cards')->success();

     			return redirect()->back();
     	}

     	flash('Something is wrong')->error();

     	return redirect()->back()
     					->withErrors($validate)
     					->withInput();

     }
     
     /**
      * Generates Random Vouchers
      * @params int $iteration
      * @params int $amount
      * @return Array Vouchers
      */ 
     private function getRandomVoucher($iteration)
     {
         $pin1 = rand(1111,9999);
         $pin2 = rand(1111,9999);
         $pin3 = rand(1111,9999);
         $pin4 = rand(1111,9999);
         
         
         $usedPins = $this->student_voucher->setResultVoucher()->where('pin1', $pin1)
                                ->where('pin2', $pin2)
                                ->where('pin3', $pin3)
                                ->where('pin4', $pin4)->get();
                                
         if ($usedPins->count() > 0)
         {
             return $this->getRandomVoucher($iteration);
             
         }
         else
         { 
            return array($pin1, $pin2, $pin3, $pin4);
         }
           
     }

     private function getSerialNumber(){
     	$serial = 'SN'.rand(11111111, 99999999);

     	$usedPins = $this->student_voucher->setResultVoucher()
                                ->where('serial', $serial)->get();
                                
         if ($usedPins->count() > 0)
         {
             return $this->getSerialNumber();
             
         }
         else
         { 
            return $serial;
         }
     }
}
