<?php

namespace App\Http\Controllers\ResultApp;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Http\Controllers\Controller;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\ResultVoucherRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\Repositories\PracticalSkillRepositoryInterface;

use App\Repositories\CharacterAttitudeRepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\StudentCommentsRepositoryInterface;

use App\Teacher;

use App\DebtorPenalty;

use App\Transfer;

use Validator;

use DB;

use Image;

use Hash;

use Session;

use PDF;

use Input;

use App\DigitalPayment;

use App\School;

use App\Student;


use App\Classes;
use App\ClassArms;
use App\OndoLGA;
use App\StudentHouse;
use App\ResultVoucher;
use App\StudentResult;
use App\PracticalSkill;
use App\CharacterAttitude;
use App\StudentComments;

use Carbon\Carbon;

use App\ClassAttendanceAnalyticLog;

use App\ClassAttendanceAnalyticTeacher;

use App\SubjectAttendanceAnalyticLog;

use App\SubjectAttendanceAnalyticTeacher;

class StudentController extends Controller
{
	protected  $student;

    protected $classes;

    protected $result_voucher;

    protected $school;

    protected $classarm;

    protected $student_comments;

    function __construct(StudentRepositoryInterface $student,ClassRepositoryInterface $classes, ResultVoucherRepositoryInterface $result_voucher, SchoolRepositoryInterface $school, ClassArmRepositoryInterface $classarm, StudentCommentsRepositoryInterface $student_comments){

    	$this->middleware('auth:student');

    	$this->student = $student;

        $this->classes = $classes;

        $this->result_voucher = $result_voucher;

        $this->school = $school;

        $this->classarm = $classarm;

        $this->student_comments = $student_comments;

    }

    public function dashboard(){
    	$title = 'Student Dashboard';
    	$noAutoAd = true;
    	$student = auth('student')->user();
    	$class = getClassNameByClassID($student->classarms[0]->pivot->class_id);
    	$classarm = getClassArmNameByClassArmID($student->classarms[0]->pivot->classarm_id);
    	$session = date('Y');
    	$today_class_attendance = ClassAttendanceAnalyticLog::where('student_id', $student->id)
    	                                                    ->where('school_id',  $student->school_id)
    	                                                    ->where('class_id', $student->classarms[0]->pivot->class_id)
    	                                                    ->whereDate('created_at', '>', Carbon::yesterday())
    	                                                    ->get();
		$digitalRecord = DigitalPayment::where('student_id', $student->id)
												->where('is_verified', true)
												->where('session', $session)
												->get()->first();

    	return view('result-app.student.dashboard', compact('title', 'student', 'noAutoAd', 'class', 'classarm', 'today_class_attendance', 'digitalRecord'));
    }
    
    public function digitalCard($session){
        $title = $session.' Digital Payment Reciept';
    	$noAutoAd = true;
    	$student = auth('student')->user();
		$digitalRecord = DigitalPayment::where('student_id', $student->id)
												->where('is_verified', true)
												->where('session', $session)
												->get()->first();

    	return view('result-app.student.reciept', compact('title', 'student', 'noAutoAd', 'digitalRecord', 'session'));
    }

    public function results($pin, $session){
        $title = 'My Results';
        $student = auth('student')->user();
        return view('result-app.student.results', compact('title', 'pin', 'session', 'student'));
    }
    
    public function resultsSearch(Request $request){
        $title = "Attendance";
        $student = auth('student')->user();
        $school_id = $student->school_id;
        $date = $request->date;
        $session = $request->session;
        $term = $request->term;
        $class_id = $request->class_id;
        $subject_id = $request->subject_id;
        
        $validate = Validator::make($request->all(), [
                'school_id' => 'required',
                'class_id' => 'required',
                'classarm_id' => 'required',
                'session' => 'required',
                'term' => 'required',
                'regnum' => 'required',
                'card_pin' => 'required',
                'request_type' => 'required'
            ]);

        if($validate->passes()){
            $student_data = Student::where('regnum', $request->regnum)
                                ->first();

            if(!empty($student_data)){
                $student_name = $student_data->firstname.' '.$student_data->surname;
                $student_id = $student_data->id;
				
				// check if a digital payment for session is active
												//->whereYear('created_at', '=', $request->session + 1)
												
				$digitalRecord = DigitalPayment::where('student_id', $student_id)
												->where('is_verified', true)
												->where('session', $request->session)
												->get()->first();
												
				if(!$digitalRecord){
					flash('Digital payment for the session has not been made for this student.')->error();
					return redirect()->back()
									->withInput();
				}
				else{	
					$student_results = StudentResult::where('session', $request->session)
												->where('class_id', $request->class_id)
												->where('classarm_id', $request->classarm_id)
												->where('term', $request->term)
												->where('school_id', $request->school_id)
												->where('student_id', $student_id)
												->first();
					
					if(!empty($student_results)){
						$student_result_status = $student_results->status;
					
						if($student_result_status > 0){
							if($request->request_type == 1){
									$error = 0;
									$error_msg = '';
			
								if(empty($request->card_pin_retype) && (empty($request->card_pin_replace_lost) && empty($request->card_serial_replace_lost)) ){
									$error++;
									$error_msg = 'Result Scratch Card must be retyped to confirm authenticity.';
								}
			
								if((!empty($request->card_pin_retype) && $request->card_pin != $request->card_pin_retype) && (empty($request->card_pin_replace_lost) && empty($request->card_serial_replace_lost)) ){
									flash("Request Aborted! You must retype the Correct Card Pin to proceed")->error();
									return redirect()->back()
													->withInput();
								}
								elseif((empty($request->card_pin_retype)) && (empty($request->card_pin_replace_lost) || empty($request->card_serial_replace_lost)) ){
									flash("Request Aborted! You must either retype the Correct Card Pin OR Enter a New Card to proceed")->error();
									return redirect()->back()
													->withInput();
								}
								else{
									$student_voucher = ResultVoucher::where('student_id', $student_data->id)
																	->where('session', $request->session)
								  //->where('term', $request->term) PIN to be used for WHOLE SESSION
																	->where('class_id', $request->class_id)
																	->where('classarm_id', $request->classarm_id)
																	->first();
			
									$student_debtor = DebtorPenalty::where('student_id', $student_data->id)
																	->where('school_id', $request->school_id)
																	->first();
			
									if(empty($student_voucher)){
										$error++;
										$error_msg = 'Request Aborted! Student Result Voucher failed authentication';
									}
			
									if(count($student_debtor) > 0){
										if($student_debtor->status == 0){
											$error++;  
											$error_msg = 'Result Request Aborted! Student ('.$student_name.') is on the School Debtor List';
										}
									}
			
									if($error > 0){
										flash($error_msg)->error();
										return redirect()->back()
														->withInput();
									}
									else{
										if((!empty($request->card_pin_retype) && $request->card_pin == $request->card_pin_retype) && (empty($request->card_pin_replace_lost) && empty($request->card_serial_replace_lost)) ){
											return $this->studentResultViewer($request);
										}
										elseif((empty($request->card_pin_retype)) && (!empty($request->card_pin_replace_lost) && !empty($request->card_serial_replace_lost)) ){
	
											$card_pin_data = ResultVoucher::where('pin', $request->card_pin_replace_lost)
																	->where('serial', $request->card_serial_replace_lost)
																	->first();
											if(!empty($card_pin_data)){
												if(empty($card_pin_data->student_id)){
													$result_vouchers = ResultVoucher::find($card_pin_data->id);
					
													$result_vouchers->student_id = $student_data->id;
													$result_vouchers->classarm_id = $request->classarm_id;
													$result_vouchers->class_id = $request->class_id;
													$result_vouchers->session = $request->session;
													$result_vouchers->term = $request->term;
													$result_vouchers->save();
					
													return $this->studentResultViewer($request);
												}
												else{
													flash('Used Card Pin is invalid')->error();
													return redirect()->back()
															->withInput();
												}
											}
											else{
												flash('Invalid Card Pin')->error();
												return redirect()->back()
														->withInput();
											}
										}
									}
			
								}
			
							}
							elseif($request->request_type == 2){
									$error = 0;
									$error_msg = '';
								$student_debtor = DebtorPenalty::where('student_id', $student_data->id)
															->where('school_id', $request->school_id)
															->first();
			
								if(count($student_debtor) > 0){
									if($student_debtor->status == 0){
										$error++;  
										$error_msg = 'Result Request Aborted! Student ('.$student_name.') is on the School Debtor List';
										flash($error_msg)->error();
										return redirect()->back()
												->withInput();
									}
								}
			
								if($error > 0){
									flash($error_msg)->error();
									return redirect()->back()
													->withInput();
								}
								else{
									$card_pin_data = ResultVoucher::where('pin', $request->card_pin)
															->where('serial', $request->card_serial)
															->first();
									if(!empty($card_pin_data)){
										if(empty($card_pin_data->student_id)){
											$result_vouchers = ResultVoucher::find($card_pin_data->id);
			
											$result_vouchers->student_id = $student_data->id;
											$result_vouchers->classarm_id = $request->classarm_id;
											$result_vouchers->class_id = $request->class_id;
											$result_vouchers->session = $request->session;
											$result_vouchers->term = $request->term;
											$result_vouchers->save();
			
											return $this->studentResultViewer($request);
										}
										else{
											flash('Invalid Result Card Pin')->error();
											return redirect()->back()
													->withInput();
										}
									}
									else{
										flash('Invalid Result Card Pin')->error();
										return redirect()->back()
												->withInput();
									}
								}
							}
							else{
								flash('Invalid Request Type')->error();
								return redirect()->back()
											->withInput();
							}                   
						}
						else{
							flash('Student Result has not been released. Contact School Administrator!')->error();
							return redirect()->back()
											->withInput();                  
						}
					
					}
					else{
						flash('No Result for selected Session was found for this student')->error();
						return redirect()->back()
										->withInput();                  
					}
				}
            }
            else{
                flash('Invalid Student OSSI Number')->error();
                return redirect()->back()
                                ->withInput();
            }

        }
        else{
            flash('Incomplete request data')->error();
                return redirect()->back()
                                ->withInput();
        }
    }

    public function attendance(){
        $title = 'My Attendance';
        $student = auth('student')->user();
        $school_id = $student->school_id;
        $date = '';
        $session = 0;
        $term = '';
        $class_id = 0;
        $subject_id = 0;
        $attendance = ClassAttendanceAnalyticLog::where('student_id', $student->id)
                                                ->whereDate('created_at', '<', Carbon::today())
                                                ->paginate(20);
        $attendance_count = ClassAttendanceAnalyticLog::where('student_id', $student->id)
                                                    ->whereDate('created_at', '<', Carbon::today())
                                                    ->get()
                                                    ->count();
        return view('result-app.student.attendance', compact('title', 'attendance', 'attendance_count', 'school_id', 'date', 'session', 'term', 'class_id', 'subject_id', 'student'));
    }
    
    public function attendanceSearch(Request $request){
        $title = "Attendance";
        $student = auth('student')->user();
        $school_id = $student->school_id;
        $date = $request->date;
        $session = $request->session;
        $term = $request->term;
        $class_id = $request->class_id;
        $subject_id = $request->subject_id;
        if($date == 'today'){
            $time = Carbon::yesterday();
        }elseif($date == 'yesterday'){
            $time = date("Y-m-d", strtotime( '-2 days' ) );
        }elseif($date == 'this_week'){
            $time = date("Y-m-d", strtotime( '-8 days' ) );
        }elseif($date == 'this_month'){
            $currentMonth = date('m');
            $time = Carbon::now()->subMonth()->month;
        }else{
            $time = '';
        }
        
        if($subject_id != '' && $subject_id != 0){
            $attendance = SubjectAttendanceAnalyticLog::where('student_id', $student->id)
                                                ->where('school_id', $school_id)
                                                ->where('subject_id', $subject_id)
                                                ->where('session', $session)
                                                ->where('term', $term)
                                                ->whereDate('created_at', '>', $time)
                                                ->orderBy('created_at', 'desc')
                                                ->paginate(20);
            $attendance_count = SubjectAttendanceAnalyticLog::where('student_id', $student->id)
                                                        ->where('subject_id', $subject_id)
                                                        ->where('school_id', $school_id)
                                                        ->where('session', $session)
                                                        ->where('term', $term)
                                                        ->whereDate('created_at', '>', $time)
                                                        ->get()
                                                        ->count();
        }else{
            $attendance = ClassAttendanceAnalyticLog::where('student_id', $student->id)
                                                ->where('class_id', $class_id)
                                                ->where('school_id', $school_id)
                                                ->where('session', $session)
                                                ->where('term', $term)
                                                ->whereDate('created_at', '>', $time)
                                                ->orderBy('created_at', 'desc')
                                                ->paginate(20);
            $attendance_count = ClassAttendanceAnalyticLog::where('student_id', $student->id)
                                                        ->where('class_id', $class_id)
                                                        ->where('school_id', $school_id)
                                                        ->where('session', $session)
                                                        ->where('term', $term)
                                                        ->whereDate('created_at', '>', $time)
                                                        ->get()
                                                        ->count();
        }
        
        return view('result-app.student.attendance', compact('title', 'attendance', 'attendance_count', 'student', 'date', 'school_id', 'session', 'term', 'class_id', 'subject_id', 'time'));
    }

    public function profile(){
        $title = 'Profile';
        $student = auth('student')->user();

        return view('overview.student.profile', compact('title', 'student'));
    }
}