<?php


namespace App\Http\Controllers;

use DB;

use App\Quotation;

use Illuminate\Http\Request;

use App\Http\Requests;

use Validator;

use App\Repositories\AdminRepositoryInterface;

use App\Repositories\PermissionRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\PaymentRepositoryInterface;

use App\Repositories\PaymentItemsRepositoryInterface;

use App\Repositories\PaymentRecipientRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use Carbon\Carbon;

use App\PaymentItems;

use Input;

use Auth;

use Session;

use App\School;

use App\Student;

use App\Admin;

class PaymentController extends Controller
{

    protected $admin;

    protected $permission;

    protected $students;

    protected $teacher;

    protected $schools;

    protected $payment;

    protected $payment_recipient;

    protected $payment_items;

    protected $terminalid;

    protected $secretkey;

    protected $classes;

    protected $class_arms;

    protected $demo_terminalid;

    protected $demo_secretkey;

    public function __construct(Request $request, AdminRepositoryInterface $admin, PermissionRepositoryInterface $permission,SchoolRepositoryInterface $schools,StudentRepositoryInterface $students, TeacherRepositoryInterface $teacher, PaymentRepositoryInterface $payment, PaymentRecipientRepositoryInterface $payment_recipient, PaymentItemsRepositoryInterface $payment_items, ClassRepositoryInterface $classes, ClassArmRepositoryInterface $class_arms){

        if($request->path() == 'ministry/payment/offline-search-invoice'){
            $this->middleware('auth:super_admin');
        }else{
            $this->middleware('auth:admin');
        }

        $this->admin = $admin;

        $this->permission = $permission;

        $this->schools = $schools;

        $this->students = $students;

        $this->payment = $payment;

        $this->payment_recipient = $payment_recipient;

        $this->payment_items = $payment_items;

        $this->classes = $classes;

        $this->class_arms = $class_arms;

        $this->terminalid = DB::table('paygate_credential')->where('merchant', 'public')->where('data_type', 'ID')->first();

        $this->secretkey = DB::table('paygate_credential')->where('merchant', 'public')->where('data_type', 'KEY')->first();

        $this->demo_terminalid = "0000000001";

        $this->demo_secretkey = "DEMO_KEY";

    }
    

    public function paymentOption()
    {
        $title = "Payment Option";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $school = School::find($school_id);

        $c_data = $this->padData();
        $schoolid = $this->padData($school_id);
        $adminid = $this->padData($admin->id);

        return view('admin.payment.option', compact('title', 'admin', 'school_id', 'school', 'c_data', 'schoolid', 'adminid'));
    }//End Method
    


    public function paymentBankItData()
    {
        $title = "Bank Account Payment Data Selection";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $school_data = School::find($school_id);

        $students = $this->students->setStudent()
                            ->where('school_id', $school_id)
                            ->orderBy('surname', 'asc')
                            ->get();

        $payment_items = $this->payment_items->setData()
                            ->orderBy('item_name', 'asc')
                            ->get();

        $classes = $this->classes->setClass()
                                ->where('school_id', $school_id)
                                ->get();
        
        return view('admin.payment.set-data-bankit', compact('title', 'admin', 'classes', 'school_id', 'school_data', 'students', 'payment_items'));
                
    }//End Method   


    public function paymentBankItAjaxDataProcess(Request $request)
    {
        $payment = $this->payment->setPayment();
        $payment_recipient = $this->payment_recipient->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $hash = md5(time());
        $rand_char = strtoupper(substr($hash, 0, 5));
        $customer_id = $rand_char.time();

        $payer_id = auth('admin')->id();

        $error = 0;
        $error_msg = '\n\n';
        
        $student_cart =  Session::get('student_payment_cart');
        if(empty($student_cart)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Choice of Student(s) to make payment is empty';
            $error_msg .= '\n';
        }

        if(empty($request->item_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Item to make payment is empty';
            $error_msg .= '\n';
        }

        if(empty($request->session)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Session must not be blank';
            $error_msg .= '\n';
        }

        if(empty($school_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': School information failed authentication';
            $error_msg .= '\n';
        }

        if(empty($payer_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Admin account information failed authentication';
            $error_msg .= '\n';
        }

        if($error == 0){
            $recipient_count = count($student_cart);

            $payment_items_data = $this->payment_items->find($request->item_id);

            $item_code = $payment_items_data->item_code;

            $total_cost = $payment_items_data->cost * $recipient_count;

            $dbData = [
                'school_id' => $school_id,
                'payer_id' => $payer_id,
                'customer_id' => $customer_id,
                'item_id' => $request->item_id,
                'session' => $request->session,
                'payment_type' => 'Batch',
                'total_cost' => $total_cost,
                'recipient_count' => $recipient_count,
                'pay_channel' => 'Bankit',
                'pay_status' => 1,
                'order_date' => Carbon::now(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ];  

            $pay_id = $payment->create($dbData)->id;

            $saved_payment_recipient = 0;

            if($pay_id){
                foreach ($student_cart as $key => $student_id) {
                    $verify_payment_recipient =  DB::table('payment_recipient')
                                  ->where('pay_id', $pay_id)
                                  ->where('student_id', $student_id)
                                  ->count();

                    if($verify_payment_recipient == 0){
                        $dbRecipientData = [
                            'pay_id' => $pay_id,
                            'student_id' => $student_id
                        ];  
                        $payment_recipient->create($dbRecipientData);
                        $saved_payment_recipient++;
                        unset($student_cart[$key]);
                    }
                }//End loop
                Session::put('student_payment_cart', $student_cart);
            }

            if($saved_payment_recipient > 0){
                return '{"value" : "'.$pay_id.'", "type" : "okay"}';
            }
            else{
                return '{"value" : "Something went wrong while processing the payment data. Pls try again shortly!", "type" : "error"}';
            }

        }
        else{   
            return '{"value" : "All fields are mandatory. Fix the following to continue: '.$error_msg.'", "type" : "error"}';
        }

    }//End Method


    public function paymentBankItDataProcess(Request $request)
    {
         $payment = $this->payment->setPayment();
         $payment_recipient = $this->payment_recipient->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $hash = md5(time());
        $rand_char = strtoupper(substr($hash, 0, 5));
        $customer_id = $rand_char.time();

        $payer_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'item_id' => 'required',
                'session' => 'required',
                'student_id' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($payer_id)){

            $recipient_count = count($request->student_id);

            $payment_items_data = $this->payment_items->find($request->item_id);

            $item_code = $payment_items_data->item_code;

            $total_cost = $payment_items_data->cost * $recipient_count;

            $dbData = [
                'school_id' => $school_id,
                'payer_id' => $payer_id,
                'customer_id' => $customer_id,
                'item_id' => $request->item_id,
                'session' => $request->session,
                'payment_type' => 'Batch',
                'total_cost' => $total_cost,
                'recipient_count' => $recipient_count,
                'pay_channel' => 'Bankit',
                'pay_status' => 1,
                'order_date' => Carbon::now(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ];  

            $pay_id = $payment->create($dbData)->id;

            $saved_payment_recipient = 0;

            if($pay_id){
                foreach ($request->student_id as $student_id) {

                    $verify_payment_recipient =  DB::table('payment_recipient')
                                  ->where('pay_id', $pay_id)
                                  ->where('student_id', $student_id)
                                  ->count();

                    if($verify_payment_recipient == 0){

                        $dbRecipientData = [
                            'pay_id' => $pay_id,
                            'student_id' => $student_id
                        ];  

                        $payment_recipient->create($dbRecipientData);

                        $saved_payment_recipient++;
                    }

                }//End loop

            }

            if($saved_payment_recipient > 0){
                flash('Payment Data has been saved successfully.')->success();
                return redirect()->route('admin.payment.gateway.data.bankit', ['id' => $pay_id]);
            }
            else{
                flash('Something went wrong while processing the payment data. Pls try again shortly!')->error();
                return redirect()->route('admin.payment.data.bankit');
            }

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method


    public function paymentGatewayBankItDataReady($id)
    {
        $title = "Begin Bank Account Payment";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $payment = $this->payment->setPayment();
        $payment_items = $this->payment_items->setData();

        $payment_data = $payment->find($id);

        $payment_items_data = $payment_items->find($payment_data->item_id);
            
        $amount = (int)$payment_data->total_cost;
        $item_code = $payment_items_data->item_code;
        //$terminalid = $this->demo_terminalid;
        //$secretkey = $this->demo_secretkey;

        $terminalid = $this->terminalid->$item_code;
        $secretkey = $this->secretkey->$item_code;

        $description = 'Payment for '.$payment_items_data->item_name;
        $trx_id = $payment_data->customer_id;

        $response_url = route('admin.payment.gateway.return.data.bankit');
        $logo_url = url_public('/images/header-logo.png');

        //$checksum = md5($amount.$terminalid.$trx_id.$response_url.$secretkey);

        $checksum = strtoupper(hash("sha256", $amount.$terminalid.$trx_id.$response_url.$secretkey));

        $form_url = "https://www.etranzact.net/bankIT/";
        //$form_url = "https://demo.etranzact.com/bankIT/";

        return view('admin.payment.set-gateway-data-bankit', compact('title', 'admin', 'school_id', 'payment_data', 'payment_items_data', 'amount', 'terminalid', 'secretkey', 'description', 'trx_id', 'checksum', 'form_url', 'response_url', 'logo_url'));
    }//End Method   


    public function paymentGatewayReturnBankItData()
    {
        $title = "BankIT Transaction Status";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $payment = $this->payment->setPayment();
        $payment_items = $this->payment_items->setData();

        return view('admin.payment.get-gateway-return-data-bankit', compact('title', 'admin', 'school_id', 'request_all'));

    }//End Method


    public function paymentGatewayReturnBankItDataProcess(Request $request)
    {
        $pay_id = 0;

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $payment = $this->payment->setPayment();
        $payment_items = $this->payment_items->setData();

        $valid_request = 0;
        $paygate_resp = 0;
        $paygate_resp_val = 0;
        $paygate_id = 0;

        $transaction_id  = ($request->TRANSACTION_ID) ? $request->TRANSACTION_ID: 0;
        $paygate_id = ($request->TRANSACTION_REF) ? $request->TRANSACTION_REF: 0;   
        $success = $request->SUCCESS;
        $final_checksum = ($request->FINAL_CHECKSUM) ? $request->FINAL_CHECKSUM: 0;

        $success_desc = $this->getResponseCode($request->SUCCESS);

        if(!empty($transaction_id)){
            $payment_data = $payment->where('customer_id', $transaction_id)->first();

            if(!empty($payment_data->id) && $payment_data->customer_id == $transaction_id){ 
                $pay_id = $payment_data->id;            

                $payment_items_data = $payment_items->find($payment_data->item_id);
                
                $item_code = $payment_items_data->item_code;

                $v_amount   = (int)$payment_data->total_cost;
                $v_terminalid = $this->terminalid->$item_code;
                $v_secretkey = $this->secretkey->$item_code;
                //$v_terminalid = $this->demo_terminalid;
                //$v_secretkey = $this->demo_secretkey;
                $v_trx_id = $payment_data->customer_id;

                $v_response_url = route('admin.payment.gateway.return.data.bankit');

                $verify_checksum = hash("sha256", $success.$v_amount.$v_terminalid.$v_trx_id.$v_response_url.$v_secretkey);

                if($verify_checksum == $final_checksum){
                    $valid_request = 1;

                    if($success == 0){
                        $paygate_resp = 1;
                        $paygate_resp_val = $success_desc;

                        if($payment_data->pay_status != 2){
                            $payment_data = $payment->find($payment_data->id);
                            $payment_data->pay_status = 2;
                            $payment_data->paygate_status_code = $paygate_id;
                            $payment_data->paygate_status_msg = $success_desc;
                            $payment_data->save();
                        }
                    }
                    else{
                        $paygate_resp = 0;
                        $paygate_resp_val = $success_desc;

                        if(empty($payment_data->paygate_status_code)){
                            $payment_data = $payment->find($payment_data->id);
                            $payment_data->paygate_status_code = $paygate_id;
                            $payment_data->paygate_status_msg = $success_desc;
                            $payment_data->save();
                        }
                    }
                }
                else{
                    $valid_request = -1;
                }
            }

        }   

        //flash('Bank Account Payment')->success();

        return redirect()->route('admin.payment.view.return.data.bankit', ['id' => $pay_id, 'valid_request' => $valid_request, 'paygate_resp_val' => $paygate_resp_val, 'paygate_id' => $paygate_id, 'transaction_id' => $transaction_id, 'success' => $success, 'final_checksum' => $final_checksum]);

    }//End Method


    public function paymentViewReturnBankItData(Request $request, $id)
    {
        $title = "Bank Account Payment : Transaction Status";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $valid_request = $request->valid_request;   
        $paygate_resp_val = $request->paygate_resp_val; 
        $paygate_id = $request->paygate_id; 

        $transaction_id = $request->transaction_id; 
        $success = $request->success;   
        $final_checksum = $request->final_checksum; 


        return view('admin.payment.view-gateway-return-data-bankit', compact('title', 'admin', 'school_id', 'valid_request', 'paygate_resp_val', 'paygate_id', 'transaction_id', 'success'));
    }//End Method



    public function paymentData()
    {
        $title = "Online Card Payment Data Selection";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $school_data = School::find($school_id);

        $payer_id = auth('admin')->id();

        $students = $this->students->setStudent()
                            ->where('school_id', $school_id)
                            ->orderBy('surname', 'asc')
                            ->get();

        $payment_items = $this->payment_items->setData()
                            ->orderBy('item_name', 'asc')
                            ->get();

        $classes = $this->classes->setClass()
                                ->where('school_id', $school_id)
                                ->get();

        return view('admin.payment.set-data', compact('title', 'admin', 'classes', 'school_data', 'payer_id', 'school_id', 'students', 'payment_items'));
                
    }//End Method   



    public function addStudentToCart(Request $request){

        $student_id     =  $request->student_id;

        $cart = Session::get('student_payment_cart');
        $cart[] = $student_id;

        Session::put('student_payment_cart', $cart);        

        return '{"value" : "Student has been successfully added to list.", "type" : "okay"}';

    }//End Method


    public function deleteStudentFromCart(Request $request){

        $student_id     =  $request->student_id;

        $cart = Session::get('student_payment_cart');

        foreach ($cart as $key => $value)
        {
            if ($value == $student_id) 
            {        
                unset($cart[$key]);            
            }
        }

        Session::put('student_payment_cart', $cart);

        return '{"value" : "Student has been successfully removed from list.", "type" : "okay"}';

    }//End Method


    public function onlinePaymentGetStudent(Request $request){

        $paid_students_list = DB::table('payment')
            ->where('payment.pay_status', 2)
            ->where('payment.session', $request->session)
            ->join('payment_recipient', 'payment_recipient.pay_id', '=', 'payment.id')
            ->distinct()
            ->pluck('payment_recipient.student_id');

        $student_cart =  Session::get('student_payment_cart');

        if(!empty($student_cart)){
            $student_cart =  array_filter($student_cart);
            return DB::table('students')
                ->select('students.id', 'students.surname', 'students.firstname', 'students.middlename', 'students.regnum')
                ->where('class_arms.school_id', $request->school_id)
                ->where('classarm_student.class_id', $request->class_id)
                ->where('students.session', $request->session)
                ->whereNotIn('students.id', $paid_students_list)
                ->whereNotIn('students.id', $student_cart)
                ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                ->join('class_arms', 'classarm_student.classarm_id', '=', 'class_arms.id')
                ->get();    
        }
        else{
            return DB::table('students')
                ->select('students.id', 'students.surname', 'students.firstname', 'students.middlename', 'students.regnum')
                ->where('class_arms.school_id', $request->school_id)
                ->where('classarm_student.class_id', $request->class_id)
                ->where('students.session', $request->session)
                ->whereNotIn('students.id', $paid_students_list)
                ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                ->join('class_arms', 'classarm_student.classarm_id', '=', 'class_arms.id')
                ->get();    
        }
                        
    }//End Method


    public function loadCartStudent(Request $request){

        $student_cart =  Session::get('student_payment_cart');

        if(!empty($student_cart)){
            $student_cart =  array_filter($student_cart);
            return DB::table('students')
                ->select('students.id', 'students.surname', 'students.firstname', 'students.middlename', 'students.regnum', 'classes.class_name', 'class_arms.class_arm')
                ->whereIn('students.id', $student_cart)
                ->join('classarm_student', 'classarm_student.student_id', '=', 'students.id')
                ->join('class_arms', 'classarm_student.classarm_id', '=', 'class_arms.id')
                ->join('classes', 'classes.id', '=', 'class_arms.class_id')
                ->get();    
        }

    }//End Method



    public function paymentAjaxDataProcess(Request $request)
    {
        $payment = $this->payment->setPayment();
        $payment_recipient = $this->payment_recipient->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $hash = md5(time());
        $rand_char = strtoupper(substr($hash, 0, 5));
        $customer_id = $rand_char.time();

        $payer_id = auth('admin')->id();

        $error = 0;
        $error_msg = '\n\n';
        
        $student_cart =  Session::get('student_payment_cart');
        if(empty($student_cart)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Choice of Student(s) to make payment is empty';
            $error_msg .= '\n';
        }

        if(empty($request->item_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Item to make payment is empty';
            $error_msg .= '\n';
        }

        if(empty($request->session)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Session must not be blank';
            $error_msg .= '\n';
        }

        if(empty($school_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': School information failed authentication';
            $error_msg .= '\n';
        }

        if(empty($payer_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Admin account information failed authentication';
            $error_msg .= '\n';
        }

        if($error == 0){
            $recipient_count = count($student_cart);

            $payment_items_data = $this->payment_items->find($request->item_id);

            $item_code = $payment_items_data->item_code;

            $total_cost = $payment_items_data->cost * $recipient_count;

            $dbData = [
                'school_id' => $school_id,
                'payer_id' => $payer_id,
                'customer_id' => $customer_id,
                'item_id' => $request->item_id,
                'session' => $request->session,
                'payment_type' => 'Batch',
                'total_cost' => $total_cost,
                'recipient_count' => $recipient_count,
                'pay_channel' => 'Webconnect',
                'pay_status' => 1,
                'order_date' => Carbon::now(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ];  

            $pay_id = $payment->create($dbData)->id;

            $saved_payment_recipient = 0;

            if($pay_id){
                foreach ($student_cart as $key => $student_id) {
                    $verify_payment_recipient =  DB::table('payment_recipient')
                                  ->where('pay_id', $pay_id)
                                  ->where('student_id', $student_id)
                                  ->count();

                    if($verify_payment_recipient == 0){
                        $dbRecipientData = [
                            'pay_id' => $pay_id,
                            'student_id' => $student_id
                        ];  
                        $payment_recipient->create($dbRecipientData);
                        $saved_payment_recipient++;
                        unset($student_cart[$key]);
                    }
                }//End loop
                Session::put('student_payment_cart', $student_cart);
            }

            if($saved_payment_recipient > 0){
                return '{"value" : "'.$pay_id.'", "type" : "okay"}';
            }
            else{
                return '{"value" : "Something went wrong while processing the payment data. Pls try again shortly!", "type" : "error"}';
            }

        }
        else{   
            return '{"value" : "All fields are mandatory. Fix the following to continue: '.$error_msg.'", "type" : "error"}';
        }

    }//End Method


    public function paymentDataProcess(Request $request)
    {
         $payment = $this->payment->setPayment();
         $payment_recipient = $this->payment_recipient->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $hash = md5(time());
        $rand_char = strtoupper(substr($hash, 0, 5));
        $customer_id = $rand_char.time();

        $payer_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'item_id' => 'required',
                'session' => 'required',
                'student_id' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($payer_id)){

            $recipient_count = count($request->student_id);

            $payment_items_data = $this->payment_items->find($request->item_id);

            $item_code = $payment_items_data->item_code;

            $total_cost = $payment_items_data->cost * $recipient_count;

            $dbData = [
                'school_id' => $school_id,
                'payer_id' => $payer_id,
                'customer_id' => $customer_id,
                'item_id' => $request->item_id,
                'session' => $request->session,
                'payment_type' => 'Batch',
                'total_cost' => $total_cost,
                'recipient_count' => $recipient_count,
                'pay_channel' => 'Webconnect',
                'pay_status' => 1,
                'order_date' => Carbon::now(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ];  

            $pay_id = $payment->create($dbData)->id;

            $saved_payment_recipient = 0;

            if($pay_id){

                foreach ($request->student_id as $student_id) {

                    $verify_payment_recipient =  DB::table('payment_recipient')
                                  ->where('pay_id', $pay_id)
                                  ->where('student_id', $student_id)
                                  ->count();

                    if($verify_payment_recipient == 0){

                        $dbRecipientData = [
                            'pay_id' => $pay_id,
                            'student_id' => $student_id
                        ];  

                        $payment_recipient->create($dbRecipientData);

                        $saved_payment_recipient++;
                    }

                }//End loop

            }

            if($saved_payment_recipient > 0){
                flash('Payment Data has been saved successfully.')->success();
                return redirect()->route('admin.payment.gateway.data', ['id' => $pay_id]);
            }
            else{
                flash('Something went wrong while processing the payment data. Pls try again shortly!')->error();
                return redirect()->route('admin.payment.data');
            }

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method


    public function paymentGatewayDataReady($id)
    {
        $title = "Begin Online Card Payment";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $payment = $this->payment->setPayment();
        $payment_items = $this->payment_items->setData();

        $payment_data = $payment->find($id);

        $payment_items_data = $payment_items->find($payment_data->item_id);
            
        $amount = (int)$payment_data->total_cost;
        $item_code = $payment_items_data->item_code;
        $terminalid = $this->terminalid->$item_code;
        $secretkey = $this->secretkey->$item_code;
        $description = 'Payment for '.$payment_items_data->item_name;
        $trx_id = $payment_data->customer_id;

        $response_url = route('admin.payment.gateway.return.data');
        $notice_url = route('admin.payment.gateway.notification');

        $checksum = md5($amount.$terminalid.$trx_id.$response_url.$secretkey);

        $form_url = "https://www.etranzact.net/WebConnectPlus/caller.jsp";
        //$form_url = "https://demo.etranzact.com/WebConnectPlus/caller.jsp";

        return view('admin.payment.set-gateway-data', compact('title', 'admin', 'school_id', 'payment_data', 'payment_items_data', 'amount', 'terminalid', 'secretkey', 'description', 'trx_id', 'checksum', 'form_url', 'response_url', 'notice_url'));
    }//End Method   


    public function paymentGatewayReturnData(Request $request)
    {
        $title = "Transaction Status";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $payment = $this->payment->setPayment();
        $payment_items = $this->payment_items->setData();

        $valid_request = 0;
        $paygate_resp = 0;
        $paygate_resp_val = 0;
        $paygate_id = 0;

        $transaction_id  = ($request->input('ECHODATA')) ? $request->input('ECHODATA'): 0;
        $paygate_id = ($request->input('TRANS_NUM')) ? $request->input('TRANS_NUM'): 0; 
        $success = $request->input('SUCCESS');
        $final_checksum = ($request->input('FINAL_CHECKSUM')) ? $request->input('FINAL_CHECKSUM'): 0;

        $success_desc = $this->getResponseCode($request->input('SUCCESS'));

        if(!empty($transaction_id)){
            $payment_data = $payment->where('customer_id', $transaction_id)->first();

            if(!empty($payment_data->id) && $payment_data->customer_id == $transaction_id){             

                $payment_items_data = $payment_items->find($payment_data->item_id);
                
                $item_code = $payment_items_data->item_code;

                $v_amount   = (int)$payment_data->total_cost;
                $v_terminalid = $this->terminalid->$item_code;
                $v_secretkey = $this->secretkey->$item_code;
                $v_trx_id = $payment_data->customer_id;

                $v_response_url = route('admin.payment.gateway.return.data');

                $verify_checksum = strtoupper(md5($success.$v_amount.$v_terminalid.$v_trx_id.$v_response_url.$v_secretkey));

                if($verify_checksum == $final_checksum){
                    $valid_request = 1;

                    if($success == 0){
                        $paygate_resp = 1;
                        $paygate_resp_val = $success_desc;

                        if($payment_data->pay_status != 2){
                            $payment_data = $payment->find($payment_data->id);
                            $payment_data->pay_status = 2;
                            $payment_data->paygate_status_code = $paygate_id;
                            $payment_data->paygate_status_msg = $success_desc;
                            $payment_data->save();
                        }
                    }
                    else{
                        $paygate_resp = 0;
                        $paygate_resp_val = $success_desc;

                        if(empty($payment_data->paygate_status_code)){
                            $payment_data = $payment->find($payment_data->id);
                            $payment_data->paygate_status_code = $paygate_id;
                            $payment_data->paygate_status_msg = $success_desc;
                            $payment_data->save();
                        }
                    }
                }
            }

        }   

        return view('admin.payment.get-gateway-return-data', compact('title', 'admin', 'school_id', 'paygate_resp', 'paygate_resp_val', 'paygate_id', 'valid_request', 'transaction_id'));

    }//End Method


    public function paymentGatewayNotification()
    {
        $title = "Transaction Notification Response";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        
        return view('admin.payment.get-gateway-notification', compact('title', 'admin', 'school_id'));
    }//End Method


    public function paymentTransactionVerified()
    {
        $title = "All Verified Transaction";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        

        $students = $this->students->setStudent()
                            ->where('school_id', $school_id)
                            ->orderBy('surname', 'asc')
                            ->get();

        $payment_items = $this->payment_items->setData()
                            ->orderBy('item_name', 'asc')
                            ->get();

        $transactions =     DB::table('payment')
                                ->select('payment.*', 'payment_items.item_name', 'payment_items.cost')
                                ->where('school_id', $school_id)
                                ->where('pay_status', 2)
                                ->join('payment_items', 'payment.item_id', '=', 'payment_items.id')
                                ->orderBy('order_date', 'desc')
                                ->paginate(10);


        return view('admin.payment.all-transaction-verified', compact('title', 'admin', 'school_id', 'transactions'));
    }//End Method


    public function paymentTransactionUnverified()
    {
        $title = "All Unverified Transaction";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        
        $students = $this->students->setStudent()
                            ->where('school_id', $school_id)
                            ->orderBy('surname', 'asc')
                            ->get();

        $payment_items = $this->payment_items->setData()
                            ->orderBy('item_name', 'asc')
                            ->get();

        $transactions =     DB::table('payment')
                                ->select('payment.*', 'payment_items.item_name', 'payment_items.cost')
                                ->where('school_id', $school_id)
                                ->where('pay_status', 1)
                                ->join('payment_items', 'payment.item_id', '=', 'payment_items.id')
                                ->orderBy('order_date', 'desc')
                                ->paginate(10);


        return view('admin.payment.all-transaction-unverified', compact('title', 'admin', 'school_id', 'transactions'));
    }//End Method


    public function paymentDetails($id)
    {
        $title = "Transaction Details";
        $admin =  $this->admin->find(auth('admin')->id());

        $school = School::find($admin->school_id);

        $payment_recipients =   DB::table('payment_recipient')
                                ->select('payment_recipient.*', 'students.regnum', 'students.firstname', 'students.middlename', 'students.surname')
                                ->where('payment_recipient.pay_id', $id)
                                ->join('students', 'payment_recipient.student_id', '=', 'students.id')
                                ->get();

        $payment_data =     DB::table('payment')
                                ->select('payment.*', 'payment_items.item_name', 'payment_items.cost')
                                ->where('payment.id', $id)
                                ->join('payment_items', 'payment.item_id', '=', 'payment_items.id')
                                ->first();

        $order_date = date('M jS Y, g:i a', strtotime($payment_data->order_date));                  

        return view('admin.payment.transaction-details', compact('title', 'admin', 'school', 'payment_data', 'payment_recipients', 'order_date'));
    }//End Method


    public function paymentFetchDataStatus($id)
    {
        $title = "Transaction Status Query";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $payment_data = $this->payment->find($id);

        $payment_items_data = $this->payment_items->find($payment_data->item_id);

        $item_code = $payment_items_data->item_code;
        
        $amount = (int)$payment_data->total_cost;
        $terminalid = $this->terminalid->$item_code;
        $secretkey = $this->secretkey->$item_code;
        $description = 'Payment for '.$payment_items_data->item_name;
        $trx_id = $payment_data->customer_id;
        $check_pay_status = $payment_data->pay_status;

        if($payment_data->pay_status == 2){
            $paygate_resp = 1;
            $paygate_resp_val = $payment_data->paygate_status_msg;
        }
        else{
            $response_url = route('admin.payment.gateway.data.status', ['id' => $id]);
            
            $url = "https://www.etranzact.net/WebConnectPlus/query.jsp?TERMINAL_ID=".$terminalid."&TRANSACTION_ID=".$trx_id."";
            //$url = "https://demo.etranzact.com/WebConnectPlus/query.jsp?TERMINAL_ID=0000000001&TRANSACTION_ID=2519867ddf7cDC17";

            $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_HTTPHEADER,   array("Content-type: text/plain"));
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
            $curl_response = curl_exec($curl); 
            $http = curl_getinfo($curl, CURLINFO_HTTP_CODE);

            curl_close($curl);

            if(empty($curl_response)){
                    $paygate_resp = 0;
                    $paygate_resp_val = 'could not be fetched from the gateway. Try again shortly!';
            }
            else{
                $curl_response_array = $this->responseStringToArray($curl_response);

                if(array_key_exists('SUCCESS', $curl_response_array)) {
                    $success_status = $curl_response_array['SUCCESS'];
                    $success_desc = $this->getResponseCode($success_status);

                    if($success_status == 0){
                        $paygate_resp = 1;
                        $paygate_resp_val = $success_desc;

                        if($payment_data->pay_status != 2){
                            $payment_data = $this->payment->find($id);
                            $payment_data->pay_status = 2;
                            $payment_data->paygate_status_code = $success_status;
                            $payment_data->paygate_status_msg = $success_desc;
                            $payment_data->save();
                        }
                    }
                    else{
                        $paygate_resp = 0;
                        $paygate_resp_val = $success_desc;

                        if(empty($payment_data->paygate_status_code)){
                            $payment_data = $this->payment->find($id);
                            $payment_data->paygate_status_code = $success_status;
                            $payment_data->paygate_status_msg = $success_desc;
                            $payment_data->save();
                        }
                    }
                }
                elseif(array_key_exists('-3', $curl_response_array)) {
                    $success_status = $curl_response_array['-3'];
                    $success_desc = "Wrong Setup";
                    $paygate_resp = 0;
                    $paygate_resp_val = $success_desc;
                }

            }
        }

        return view('admin.payment.fetch-gateway-data-status', compact('title', 'admin', 'school_id', 'paygate_resp', 'paygate_resp_val', 'amount', 'transaction_id', 'payment_items_data', 'payment_data'));

    }//End Method

 
    
    public function responseStringToArray($curl_response){

        $char_find = "&";
        $prepared_array = array();
        if( strpos($curl_response, $char_find ) !== false) {
            $curl_response_array = explode('&', $curl_response);
            foreach($curl_response_array as $response_value){
                $response_array = explode('=', $response_value);
                $element = trim($response_array[0]);
                $value = trim($response_array[1]);
                $prepared_array[$element] = $value;             
            }
        }
        else{
            if( strpos($curl_response, "=" ) !== false){
                $response_array = explode('=', $curl_response);
                $element = trim($response_array[0]);
                $value = trim($response_array[1]);
                $prepared_array[$element] = $value;
            } 
            elseif( strpos($curl_response, ":" ) !== false){
                $response_array = explode(':', $curl_response);
                $element = trim($response_array[0]);
                $value = trim($response_array[1]);
                $prepared_array[$element] = $value;
            } 
        }

        return $prepared_array;

    }//End Method



    public function postUnverifiedPaymentData()
    {
        $title = "Post Unverified Payment Data";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $school_data = School::find($school_id);

        $payer_id = auth('admin')->id();

        $students = $this->students->setStudent()
                            ->where('school_id', $school_id)
                            ->orderBy('surname', 'asc')
                            ->get();

        $payment_items = $this->payment_items->setData()
                            ->orderBy('item_name', 'asc')
                            ->get();
        
        return view('admin.payment.unverified-set-data', compact('title', 'admin', 'school_data', 'payer_id', 'school_id', 'students', 'payment_items'));
                
    }//End Method


    public function postUnverifiedPaymentDataProcess(Request $request)
    {
        $payment = $this->payment->setPayment();
        $payment_recipient = $this->payment_recipient->setData();

        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;

        $hash = md5(time());
        $rand_char = strtoupper(substr($hash, 0, 5));
        $customer_id = $rand_char.time();

        $payer_id = auth('admin')->id();
        
        $validate = Validator::make($request->all(), [
                'item_id' => 'required',
                'session' => 'required',
                'student_id' => 'required',
                'pay_channel' => 'required'
            ]);

        if($validate->passes() && !empty($school_id) && !empty($payer_id)){

            $recipient_count = count($request->student_id);

            $payment_items_data = $this->payment_items->find($request->item_id);

            $item_code = $payment_items_data->item_code;

            $total_cost = $payment_items_data->cost * $recipient_count;

            $dbData = [
                'school_id' => $school_id,
                'payer_id' => $payer_id,
                'customer_id' => $customer_id,
                'item_id' => $request->item_id,
                'session' => $request->session,
                'payment_type' => 'Batch',
                'total_cost' => $total_cost,
                'recipient_count' => $recipient_count,
                'pay_channel' => $request->pay_channel,
                'pay_status' => 1,
                'order_date' => Carbon::now(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ];  

            $pay_id = $payment->create($dbData)->id;

            $saved_payment_recipient = 0;

            if($pay_id){

                foreach ($request->student_id as $student_id) {

                    $verify_payment_recipient =  DB::table('payment_recipient')
                                  ->where('pay_id', $pay_id)
                                  ->where('student_id', $student_id)
                                  ->count();

                    if($verify_payment_recipient == 0){

                        $dbRecipientData = [
                            'pay_id' => $pay_id,
                            'student_id' => $student_id
                        ];  

                        $payment_recipient->create($dbRecipientData);

                        $saved_payment_recipient++;
                    }

                }//End loop

            }

            if($saved_payment_recipient > 0){
                flash('Payment Data has been posted successfully.')->success();
                return redirect()->route('admin.payment.transaction.details', ['id' => $pay_id]);
            }
            else{
                flash('Something went wrong while processing data posting. Pls try again shortly!')->error();
                return redirect()->route('admin.payment.data');
            }

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

    }//End Method

    
    public function getResponseCode($response_code){

        switch ($response_code) {
                    case "0":
                        $status_desc = "Transaction successful. Payment accepted";
                        break;
                    case "-1":
                        $status_desc = "Transaction timeout or invalid parameters or unsuccessful transaction in the case of Query History";
                        break;
                    case "1":
                        $status_desc = "Destination Card Not Found";
                        break;
                    case "2":
                        $status_desc = "Card Number Not Found";
                        break;
                    case "3":
                        $status_desc = "Invalid Card PIN";
                        break;
                    case "4":
                        $status_desc = "Card Expiration Incorrect";
                        break;
                    case "5":
                        $status_desc = "Insufficient balance";
                        break;
                    case "6":
                        $status_desc = "Spending Limit Exceeded";
                        break;
                    case "7":
                        $status_desc = "Internal System Error Occurred, please contact the service provider";
                        break;
                    case "8":
                        $status_desc = "Financial Institution cannot authorize transaction, Please try later";
                        break;
                    case "9":
                        $status_desc = "PIN tries Exceeded";
                        break;
                    case "10":
                        $status_desc = "Card has been locked";
                        break;
                    case "11":
                        $status_desc = "Invalid Terminal Id";
                        break;
                    case "12":
                        $status_desc = "Payment Timeout";
                        break;
                    case "13":
                        $status_desc = "Destination card has been locked";
                        break;
                    case "14":
                        $status_desc = "Card has expired";
                        break;
                    case "15":
                        $status_desc = "PIN change required";
                        break;
                    case "16":
                        $status_desc = "Invalid Amount";
                        break;
                    case "17":
                        $status_desc = "Card has been disabled";
                        break;
                    case "18":
                        $status_desc = "Unable to credit this account immediately, credit will be done later";
                        break;
                    case "19":
                        $status_desc = "Transaction not permitted on terminal";
                        break;
                    case "20":
                        $status_desc = "Exceeds withdrawal frequency";
                        break;
                    case "21":
                        $status_desc = "Destination Card has expired";
                        break;
                    case "22":
                        $status_desc = "Destination Card Disabled";
                        break;
                    case "23":
                        $status_desc = "Source Card Disabled";
                        break;
                    case "24":
                        $status_desc = "Invalid Bank Account";
                        break;
                    case "25":
                        $status_desc = "Insufficient Balance";
                        break;
                    case "26":
                        $status_desc = "CHECKSUM/FINAL_CHECKSUM error";
                        break;
                    default:
                        $status_desc = "Your Transaction was not Successful. No amount was debited from your account.";
                        break;
                }

        return $status_desc;

    }// End function

    
    public function createPayItemCode($id){

        $payment_items_data = $this->payment_items->find($id);
        $item_name = trim($payment_items_data->item_name);

        $item_name_array = preg_split("/\s+/", $item_name);
        //$acronym = explode(" ", $item_name);
        $acronym = "";

        foreach ($item_name_array as $w) {
          $acronym .= substr($w, 0,1);
        }

        return strtoupper($acronym);

    }// End function
    
    
    
    public function padData($data = 0){

        $gen_lt_code = substr(rand(0, 100000000), 0, 7 );
        $gen_rt_code = substr(rand(0, 100000000), 0, 7 );

        $data = (!empty($data)) ? $data: '118937';

        $pData = $gen_lt_code;
        $pData .= $data;
        $pData .= $gen_rt_code;
        $paddedData = $pData;

        return $paddedData;

    }// End function


    public function offlinePayment(){

        $title = "Payment Selection";
        $admin =  $this->admin->find(auth('admin')->id());
        $school_id = $admin->school_id;
        $school_data = School::find($school_id);

        return view('admin.payment.offline-payment', compact('title', 'admin', 'school_id', 'school_data'));
    }

    public function offlinePaymentSave(Request $request){
        $payment = $this->payment->setPayment();
         $payment_recipient = $this->payment_recipient->setData();
        
        $validate = Validator::make($request->all(), [
                'item_id' => 'required',
                'session' => 'required',
                'student_id' => 'required',
                'school_id' => 'required',
                'payer_id' => 'required'
            ]);

        if($validate->passes()){

            $recipient_count = count($request->student_id);

            $payment_items_data = $this->payment_items->find($request->item_id);

            $total_cost = $payment_items_data->cost * $recipient_count;
            $hash = md5(time());
            $customer_id = substr($hash, 0, 10).'-'.$request->payer_id.'-'.$request->school_id;
            $dbData = [
                'school_id' => $request->school_id,
                'payer_id' => $request->payer_id,
                'customer_id' => $customer_id,
                'item_id' => $request->item_id,
                'session' => $request->session,
                'payment_type' => 'Batch',
                'total_cost' => $total_cost,
                'recipient_count' => $recipient_count,
                'pay_channel' => 'Payoutlet',
                'pay_status' => 1,
                'order_date' => Carbon::now(),
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ];  

            $pay_id = $payment->create($dbData)->id;

            $saved_payment_recipient = 0;

            if($pay_id){

                foreach ($request->student_id as $student_id) {

                    $verify_payment_recipient =  DB::table('payment_recipient')
                                  //->whereRaw("`pay_id` = ".$pay_id." AND `student_id` = ".$student_id."")
                                  ->where('pay_id', $pay_id)
                                  ->where('student_id', $student_id)
                                  ->count();

                    if($verify_payment_recipient == 0){

                        $dbRecipientData = [
                            'pay_id' => $pay_id,
                            'student_id' => $student_id
                        ];  

                        $payment_recipient->create($dbRecipientData);

                        $saved_payment_recipient++;
                    }

                }//End loop

            }

            if($saved_payment_recipient > 0){
                flash('Payment Data has been saved successfully.')->success();
                flash('Please print reciept befor closing this page')->warning();
                $payment = $payment->find($pay_id);
                $school = School::find($request->school_id);
                $payer = Admin::find($request->payer_id);
                $payment_recipients = $payment_recipient->where('pay_id', $pay_id)->get();
                $payment_recipients_count = $payment_recipient->where('pay_id', $pay_id)->get()->count();
                return view('admin.payment.receipt', compact('payment', 'school', 'payer', 'payment_recipients', 'payment_recipients_count'));
            }
            else{
                flash('Something went wrong while processing the payment data. Pls try again shortly!')->error();
                return redirect()->route('admin.payment.data');
            }

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }
    }

    public function offlinePaymentGetStudent(Request $request){
        return Student::where('school_id', $request->school_id)->where('session', $request->session)->get();
    }

    public function offlinePaymentSearchInvoice(Request $request){
        if(isset($request->invoice_id) && $request->invoice_id != ''){
            $pay = $this->payment->setPayment();
            if($pay->where('customer_id', $request->invoice_id)->first()){
                flash('Please print reciept befor closing this page')->warning();
                $payment_recipient = $this->payment_recipient->setData();
                $payment = $pay->where('customer_id', $request->invoice_id)->first();
                $school = School::find($payment->school_id);
                $payer = Admin::find($payment->payer_id);
                $payment_recipients = $payment_recipient->where('pay_id', $payment->id)->get();
                $payment_recipients_count = $payment_recipient->where('pay_id', $payment->id)->get()->count();
                $student_id = $payment_recipient->where('pay_id', $payment->id)->first()->student_id;
                if($payment->school_id == $request->school_id){
                    return view('admin.payment.receipt', compact('payment', 'school', 'payer', 'payment_recipients', 'payment_recipients_count'));
                }elseif($request->school_id == 'ministry'){
                    return view('admin.payment.receipt', compact('payment', 'school', 'payer', 'payment_recipients', 'payment_recipients_count'));
                }else{
                    flash('Sorry invoice dosent belong to this school')->error();
                    return redirect()->back()
                                ->withInput();
                }
            }else{
                flash('Payment with invoice ID '.$request->invoice_id.' not found')->error();
                return redirect()->back()
                            ->withInput();
            }
        }elseif((isset($request->regnum) && $request->regnum != '') && (isset($request->item_id) && $request->item_id != '')){
            
            $student = Student::where('regnum', $request->regnum)->first();
            if($student){
                $pay = $this->payment->setPayment();
                $payment_recipient = $this->payment_recipient->setData();
                $student_payment = $payment_recipient->where('student_id', $student->id)->get();
                foreach ($student_payment as $pay_recipient) {
                    //get payments data
                    $payment = $pay->where('id', $pay_recipient->pay_id)->where('item_id', $request->item_id)->first();
                }
                if($payment != ''){
                    $school = School::find($payment->school_id);
                    $payer = Admin::find($payment->payer_id);
                    $payment_recipients = $payment_recipient->where('pay_id', $payment->id)->get();
                    $payment_recipients_count = $payment_recipient->where('pay_id', $payment->id)->get()->count();
                    $student_id = $payment_recipient->where('pay_id', $payment->id)->first()->student_id;
                    if($payment->school_id == $request->school_id){
                        return view('admin.payment.receipt', compact('payment', 'school', 'payer', 'payment_recipients', 'payment_recipients_count'));
                    }else{
                        flash('Sorry invoice dosent belong to this school')->error();
                        return redirect()->back()
                                    ->withInput();
                    }
                }else{
                    flash('No payment data found for student with registration number '.$request->regnum.' and payment type '.strtoupper(DB::table('payment_items')->where('id', $request->item_id)->first()->item_name))->error();
                    return redirect()->back()
                                ->withInput();
                }
            }else{
                flash('Student with registration number '.$request->regnum.' not found')->error();
                return redirect()->back()
                            ->withInput();
            }

        }else{
            flash('Please fill in fields befor submitting')->error();
            return redirect()->back()
                        ->withInput();
        }
    }

    public function offlinePaymentConfirmPayment(Request $request){
       // slow network
        error_reporting(0);
        $validate = Validator::make($request->all(), [
                'invoice_id' => 'required',
                'confirmation_no' => 'required',
                'school_id' => 'required'
            ]);

        if($validate->passes()){
            $pay = $this->payment->setPayment();
            if($pay->find($request->invoice_id)){
                $payment_recipient = $this->payment_recipient->setData();
                $payment = $pay->find($request->invoice_id);
                $school = School::find($request->school_id);
                $payment_recipients = $payment_recipient->where('pay_id', $request->invoice_id)->get();
                $payment_recipients_count = $payment_recipient->where('pay_id', $request->invoice_id)->get()->count();
                $student_id = $payment_recipient->where('pay_id', $request->invoice_id)->first()->student_id;
                if(Student::find($student_id)->school_id == $request->school_id){
                    //curl request
                    // check if request is comming form our url 41.58.109.187
                    if($_SERVER['REMOTE_ADDR'] != '41.58.109.187'){
                        // CRUL
                        $url = "https://www.etranzact.net/WebConnectPlus/query.jsp?TERMINAL_ID=000000001&CONFIRMATION_NO=".$request->confirmation_no."&RESPONSE_URL=".$request->response_url;
                        // $url = "http://demo.etranzact.com/WebConnectPlus/query.jsp?TERMINAL_ID=0000000001&CONFIRMATION_NO=".$request->confirmation_no;
                        $curl = curl_init($url);
                        curl_setopt($curl, CURLOPT_HTTPHEADER,   array("Content-type: application/json"));
                        curl_setopt($curl, CURLOPT_HEADER, false);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($curl, CURLOPT_POST, true);
                        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
                        $json_response = curl_exec($curl); 
                        $http = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                        curl_close($curl); 
                        
                        $response_array = $json_response;
                        return $response_array;
                    }else{
                        return 'Opps...API is secure. Please consume within our plateform';
                    }
                }else{
                    flash('Sorry invoice dosent belong to this school')->error();
                    return redirect()->back()
                                ->withInput();
                }
            }else{
                flash('Payment with invoice ID '.$request->invoice_id.' not found')->error();
                return redirect()->back()
                            ->withInput();
            }
        }else{
            flash('Please fill in fields befor submitting')->error();
            return redirect()->back()
                        ->withInput();
        }
    }

    public function offlinePaymentConfirmPaymentResponse(Request $request){
        return $request->SUCCESS;
    }
    

    public function apiOfflinePaymentSearch($id){
        $pay = $this->payment->setPayment();
        if($pay->where('customer_id', $id)->first()){
            $payment = $pay->where('customer_id', $id)->first();
            $payment_recipient = $this->payment_recipient->setData();
            $pay_recipients = $payment_recipient->where('pay_id', $payment->id)->get();
            $students = array();
            $result = array();
            foreach ($pay_recipients as $pay_recipient) {
                $student = Student::find($pay_recipient->student_id);
                $students[] = array(
                    'student_name'=> strtolower($student->surname).' '.strtolower($student->firstname).' '.strtolower($student->middlename),
                    'student_registration_number' => $student->regnum ,
                    'student_gender' => $student->gender,
                    'student_country' => $student->country,
                    'student_phone' => $student->parent_phone,
                    'student_email' => $student->parent_email,
                    'student_address' => $student->address,
                );
            }
            $owner_id = explode('-', $id);
            $admin =  $this->admin->find($owner_id[1]);
            $payment_type = DB::table('payment_items')->find($payment->item_id);
            return dd(array(
                'payee_id' => $admin->id,
                'payee_name' => $admin->fullname,
                'payee_email' => $admin->email,
                'payee_school' => School::find($admin->school_id)->name,
                'payment_type' => $payment_type->item_name,
                'payment_details' => $students
            ));
        }else{
            return 'There is no payment record with the PAYEE ID "'.$id.'"';
        }
    }

}