<?php

namespace App\Http\Controllers\Overview;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Http\Controllers\Controller;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\ResultVoucherRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\Repositories\PracticalSkillRepositoryInterface;

use App\Repositories\CharacterAttitudeRepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use App\Repositories\StudentCommentsRepositoryInterface;

use App\Teacher;

use App\DebtorPenalty;

use App\Transfer;

use Validator;

use DB;

use Image;

use Hash;

use Session;

use PDF;

use Input;

use App\DigitalPayment;

use App\School;

use App\Student;

use Carbon\Carbon;

use App\ClassAttendanceAnalyticLog;

use App\ClassAttendanceAnalyticTeacher;

use App\SubjectAttendanceAnalyticLog;

use App\SubjectAttendanceAnalyticTeacher;

class StudentController extends Controller
{
	protected  $student;

    protected $classes;

    protected $result_voucher;

    protected $school;

    protected $classarm;

    protected $student_comments;

    function __construct(StudentRepositoryInterface $student,ClassRepositoryInterface $classes, ResultVoucherRepositoryInterface $result_voucher, SchoolRepositoryInterface $school, ClassArmRepositoryInterface $classarm, StudentCommentsRepositoryInterface $student_comments){

    	$this->middleware('auth:student');

    	$this->student = $student;

        $this->classes = $classes;

        $this->result_voucher = $result_voucher;

        $this->school = $school;

        $this->classarm = $classarm;

        $this->student_comments = $student_comments;

    }

    public function dashboard(){
    	$title = 'Student Dashboard';
    	$noAutoAd = true;
    	$student = auth('student')->user();
    	$class = getClassNameByClassID($student->classarms[0]->pivot->class_id);
    	$classarm = getClassArmNameByClassArmID($student->classarms[0]->pivot->classarm_id);
    	$today_class_attendance = ClassAttendanceAnalyticLog::where('student_id', $student->id)
    	                                                    ->where('school_id',  $student->school_id)
    	                                                    ->where('class_id', $student->classarms[0]->pivot->class_id)
    	                                                    ->whereDate('created_at', '>', Carbon::yesterday())
    	                                                    ->get();
        $today_subject_attendance = SubjectAttendanceAnalyticLog::where('student_id', $student->id)
    	                                                    ->where('school_id',  $student->school_id)
    	                                                    ->whereDate('created_at', '>', Carbon::yesterday())
    	                                                    ->get();

    	return view('overview.student.dashboard', compact('title', 'student', 'noAutoAd', 'class', 'classarm', 'today_class_attendance', 'today_subject_attendance'));
    }

    public function attendance(){
        $title = 'My Attendance';
        $student = auth('student')->user();
        $school_id = $student->school_id;
        $date = '';
        $session = 0;
        $term = '';
        $class_id = 0;
        $subject_id = 0;
        $attendance = ClassAttendanceAnalyticLog::where('student_id', $student->id)
                                                ->whereDate('created_at', '<', Carbon::today())
                                                ->paginate(20);
        $attendance_count = ClassAttendanceAnalyticLog::where('student_id', $student->id)
                                                    ->whereDate('created_at', '<', Carbon::today())
                                                    ->get()
                                                    ->count();
        return view('overview.student.attendance', compact('title', 'attendance', 'attendance_count', 'school_id', 'date', 'session', 'term', 'class_id', 'subject_id', 'student'));
    }
    
    public function attendanceSearch(Request $request){
        $title = "Attendance";
        $student = auth('student')->user();
        $school_id = $student->school_id;
        $date = $request->date;
        $session = $request->session;
        $term = $request->term;
        $class_id = $request->class_id;
        $subject_id = $request->subject_id;
        if($date == 'today'){
            $time = Carbon::yesterday();
        }elseif($date == 'yesterday'){
            $time = date("Y-m-d", strtotime( '-2 days' ) );
        }elseif($date == 'this_week'){
            $time = date("Y-m-d", strtotime( '-8 days' ) );
        }elseif($date == 'this_month'){
            $currentMonth = date('m');
            $time = Carbon::now()->subMonth()->month;
        }else{
            $time = '';
        }
        
        if($subject_id != '' && $subject_id != 0){
            $attendance = SubjectAttendanceAnalyticLog::where('student_id', $student->id)
                                                ->where('school_id', $school_id)
                                                ->where('subject_id', $subject_id)
                                                ->where('session', $session)
                                                ->where('term', $term)
                                                ->whereDate('created_at', '>', $time)
                                                ->orderBy('created_at', 'desc')
                                                ->paginate(20);
            $attendance_count = SubjectAttendanceAnalyticLog::where('student_id', $student->id)
                                                        ->where('subject_id', $subject_id)
                                                        ->where('school_id', $school_id)
                                                        ->where('session', $session)
                                                        ->where('term', $term)
                                                        ->whereDate('created_at', '>', $time)
                                                        ->get()
                                                        ->count();
        }else{
            $attendance = ClassAttendanceAnalyticLog::where('student_id', $student->id)
                                                ->where('class_id', $class_id)
                                                ->where('school_id', $school_id)
                                                ->where('session', $session)
                                                ->where('term', $term)
                                                ->whereDate('created_at', '>', $time)
                                                ->orderBy('created_at', 'desc')
                                                ->paginate(20);
            $attendance_count = ClassAttendanceAnalyticLog::where('student_id', $student->id)
                                                        ->where('class_id', $class_id)
                                                        ->where('school_id', $school_id)
                                                        ->where('session', $session)
                                                        ->where('term', $term)
                                                        ->whereDate('created_at', '>', $time)
                                                        ->get()
                                                        ->count();
        }
        
        return view('overview.student.attendance', compact('title', 'attendance', 'attendance_count', 'student', 'date', 'school_id', 'session', 'term', 'class_id', 'subject_id', 'time'));
    }

    public function profile(){
        $title = 'Profile';
        $student = auth('student')->user();

        return view('overview.student.profile', compact('title', 'student'));
    }
}