<?php

namespace App\Http\Controllers\Overview\Auth;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use Validator;
use Auth;
use App\SuperAdmin;

class SuperAdminAuthController extends Controller
{
     use AuthenticatesAndRegistersUsers, ThrottlesLogins;


     protected $redirectTo = '/overview-app/ministry/dashboard';

     protected $redirectAfterLogout = '/overview-app';

     public function __construct(){
     	$this->middleware('guest:super_admin', ['except' => ['logout']]);
     }


     public function showLoginForm(){
     	return view('overview.super-admin.login');
     }

      protected function validateLogin(Request $request)
    {
        $this->validate($request, SuperAdmin::$rulesLogin);
    }


     public function login(Request $request){

     	$this->validateLogin($request);

     	$throttles = $this->isUsingThrottlesLoginsTrait();

        if ($throttles && $lockedOut = $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if (Auth::guard('super_admin')->attempt(['username' => $request->input('username'), 'password' => $request->input('password')])) {
            flash('Welcome back '.strtolower($request->input('username')))->success();
            return $this->handleUserWasAuthenticated($request, $throttles);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        if ($throttles && ! $lockedOut) {
            $this->incrementLoginAttempts($request);
        }

        flash('Opps! credentials not found')->error();

        return $this->sendFailedLoginResponse($request)->withInput();

     }

     public function logout()
    {
        Auth::guard('super_admin')->logout();

        return redirect('/overview-app');
    }

}
