<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;

use App\Classes;
use App\ClassArms;
use App\OndoLGA;
use App\School;
use App\Student;
use App\StudentHouse;
use App\ResultVoucher;
use App\DebtorPenalty;
use App\StudentResult;
use App\PracticalSkill;
use App\CharacterAttitude;
use App\StudentComments;
use App\Teacher;

use App\DigitalPayment;

use PDF;
use DB;
use Image;
use Validator;

class HomeController extends Controller
{
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('home');
    }

    public function getStudentData()
    {
        $ondo_lga = OndoLGA::get();
        return view('student-data-request', compact('ondo_lga'));
    }


    public function getStudentDataProcess(Request $request)
    {
        $students = Student::where('firstname', $request->firstname)
                        	->where('surname', $request->surname)
                        	->where('school_id', $request->school_id)
                            ->get();


        $html_header = '<section class="ui raised segment" style="max-width: 1200px; margin: 30px auto;">';

        $sn = 1;
        
        $html = '<table class="ui celled table" id="global_datatable">
                  <thead>
                    <tr>
                        <th width="6%">S/N</th>
                        <th>Surname</th>
                        <th>First Name</th>
                        <th width="20%">OSSI</th>
                        <th width="20%">Gender</th>
                    </tr>
                  </thead>
                  <tbody>';

        if(count($students) > 0){

            foreach($students as $student){            

                $html .= '<tr>';
                $html .= '<td>'.$sn.'</td>';
                $html .= '<td>'.$student->surname.'</td>';
                $html .= '<td>'.$student->firstname.'</td>';
                $html .= '<td><strong>'.$student->regnum.'</strong></td>';
                $html .= '<td>'.$student->gender.'</td>';

                $html .= '</tr>';

                $sn++;
            }//end loop

        }
        else{
            $html .= '<tr>';
            $html .= '<td></td>';
            $html .= '<td>Sorry, No Record was found</td>';
            $html .= '<td></td>';
            $html .= '</tr>';
        }

        $html .= '</tbody></table></section>';

        $html = $html_header.$html; 

        return $html; 

    }                    

    public function requestStudentResult()
    {
        $ondo_lga = OndoLGA::get();
        return view('result-request', compact('ondo_lga'));
    }

    public function requestStudentResultAccess(Request $request)
    {
        $validate = Validator::make($request->all(), [
                'school_id' => 'required',
                'class_id' => 'required',
                'classarm_id' => 'required',
                'session' => 'required',
                'term' => 'required',
                'regnum' => 'required',
                'card_pin' => 'required',
                'request_type' => 'required'
            ]);

        if($validate->passes()){
            $student_data = Student::where('regnum', $request->regnum)
                                ->first();

            if(!empty($student_data)){
                $student_name = $student_data->firstname.' '.$student_data->surname;
                $student_id = $student_data->id;

				$grace_session_limit = 2019;
				$grace_sessions = array(2018, 2019);

				$dr_error = 0;
				$dr_error_msg = '';
																
				$digitalRecord = DigitalPayment::where('student_id', $student_id)
												->where('is_verified', true)
												->where('session', $request->session)
												->get()->first();

				if(!$digitalRecord){
					if($request->session > $grace_session_limit){
						$dr_error++;
						$dr_error_msg = 'Digital pin payment for the session has not been made for this student.';
					}
					elseif(!in_array($request->session, $grace_sessions)){
						$dr_error++;
						$dr_error_msg = 'Digital pin payment for the session must be made for this student.';
					}
				}
												
				if($dr_error > 0){
					flash($dr_error_msg)->error();
					return redirect()->back()
									->withInput();
				}
				else{	
					$student_results = StudentResult::where('session', $request->session)
												->where('class_id', $request->class_id)
												->where('classarm_id', $request->classarm_id)
												->where('term', $request->term)
												->where('school_id', $request->school_id)
												->where('student_id', $student_id)
												->first();
					
					if(!empty($student_results)){
						$student_result_status = $student_results->status;
					
						if($student_result_status > 0){
							if($request->request_type == 1){
									$error = 0;
									$error_msg = '';
			
								if(empty($request->card_pin_retype) && (empty($request->card_pin_replace_lost) && empty($request->card_serial_replace_lost)) ){
									$error++;
									$error_msg = 'Result Scratch Card must be retyped to confirm authenticity.';
								}
			
								if((!empty($request->card_pin_retype) && $request->card_pin != $request->card_pin_retype) && (empty($request->card_pin_replace_lost) && empty($request->card_serial_replace_lost)) ){
									flash("Request Aborted! You must retype the Correct Card Pin to proceed")->error();
									return redirect()->back()
													->withInput();
								}
								elseif((empty($request->card_pin_retype)) && (empty($request->card_pin_replace_lost) || empty($request->card_serial_replace_lost)) ){
									flash("Request Aborted! You must either retype the Correct Card Pin OR Enter a New Card to proceed")->error();
									return redirect()->back()
													->withInput();
								}
								else{
									$student_voucher = ResultVoucher::where('student_id', $student_data->id)
																	->where('session', $request->session)
								  //->where('term', $request->term) PIN to be used for WHOLE SESSION
																	->where('class_id', $request->class_id)
																	->where('classarm_id', $request->classarm_id)
																	->first();
			
									$student_debtor = DebtorPenalty::where('student_id', $student_data->id)
																	->where('school_id', $request->school_id)
																	->first();
			
									if(empty($student_voucher)){
										$error++;
										$error_msg = 'Request Aborted! Student Result Voucher failed authentication';
									}
			
									if(count($student_debtor) > 0){
										if($student_debtor->status == 0){
											$error++;  
											$error_msg = 'Result Request Aborted! Student ('.$student_name.') is on the School Debtor List';
										}
									}
			
									if($error > 0){
										flash($error_msg)->error();
										return redirect()->back()
														->withInput();
									}
									else{
										if((!empty($request->card_pin_retype) && $request->card_pin == $request->card_pin_retype) && (empty($request->card_pin_replace_lost) && empty($request->card_serial_replace_lost)) ){
											return $this->studentResultViewer($request);
										}
										elseif((empty($request->card_pin_retype)) && (!empty($request->card_pin_replace_lost) && !empty($request->card_serial_replace_lost)) ){
	
											$card_pin_data = ResultVoucher::where('pin', $request->card_pin_replace_lost)
																	->where('serial', $request->card_serial_replace_lost)
																	->first();
											if(!empty($card_pin_data)){
												if(empty($card_pin_data->student_id)){
													$result_vouchers = ResultVoucher::find($card_pin_data->id);
					
													$result_vouchers->student_id = $student_data->id;
													$result_vouchers->classarm_id = $request->classarm_id;
													$result_vouchers->class_id = $request->class_id;
													$result_vouchers->session = $request->session;
													$result_vouchers->term = $request->term;
													$result_vouchers->save();
					
													return $this->studentResultViewer($request);
												}
												else{
													flash('Used Card Pin is invalid')->error();
													return redirect()->back()
															->withInput();
												}
											}
											else{
												flash('Invalid Card Pin')->error();
												return redirect()->back()
														->withInput();
											}
										}
									}
			
								}
			
							}
							elseif($request->request_type == 2){
									$error = 0;
									$error_msg = '';
								$student_debtor = DebtorPenalty::where('student_id', $student_data->id)
															->where('school_id', $request->school_id)
															->first();
			
								if(count($student_debtor) > 0){
									if($student_debtor->status == 0){
										$error++;  
										$error_msg = 'Result Request Aborted! Student ('.$student_name.') is on the School Debtor List';
										flash($error_msg)->error();
										return redirect()->back()
												->withInput();
									}
								}
			
								if($error > 0){
									flash($error_msg)->error();
									return redirect()->back()
													->withInput();
								}
								else{
									$card_pin_data = ResultVoucher::where('pin', $request->card_pin)
															->where('serial', $request->card_serial)
															->first();
									if(!empty($card_pin_data)){
										if(empty($card_pin_data->student_id)){
											$result_vouchers = ResultVoucher::find($card_pin_data->id);
			
											$result_vouchers->student_id = $student_data->id;
											$result_vouchers->classarm_id = $request->classarm_id;
											$result_vouchers->class_id = $request->class_id;
											$result_vouchers->session = $request->session;
											$result_vouchers->term = $request->term;
											$result_vouchers->save();
			
											return $this->studentResultViewer($request);
										}
										else{
											flash('Invalid Result Card Pin')->error();
											return redirect()->back()
													->withInput();
										}
									}
									else{
										flash('Invalid Result Card Pin')->error();
										return redirect()->back()
												->withInput();
									}
								}
							}
							else{
								flash('Invalid Request Type')->error();
								return redirect()->back()
											->withInput();
							}                   
						}
						else{
							flash('Student Result has not been released. Contact School Administrator!')->error();
							return redirect()->back()
											->withInput();                  
						}
					
					}
					else{
						flash('No Result for selected Session was found for this student')->error();
						return redirect()->back()
										->withInput();                  
					}
				}
            }
            else{
                flash('Invalid Student OSSI Number')->error();
                return redirect()->back()
                                ->withInput();
            }

        }
        else{
            flash('Incomplete request data')->error();
                return redirect()->back()
                                ->withInput();
        }        
    }

    protected function studentResultViewer(Request $request){

        $student_data = Student::where('regnum', $request->regnum)
                                ->first();

        if(empty($student_data)){
            return redirect()->route('student.result');
        }

        $student = Student::find($student_data->id);
        $student_id = $student_data->id;

        $student_results = StudentResult::where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('term', $request->term)
                            ->where('school_id', $request->school_id)
                            ->where('student_id', $student_id)
                            ->get();

        $student_practical_skill = PracticalSkill::where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('term', $request->term)
                            ->where('school_id', $request->school_id)
                            ->where('student_id', $student_id)
                            ->get();

        $student_character_development = CharacterAttitude::where('session', $request->session)
                            ->where('class_id', $request->class_id)
                            ->where('classarm_id', $request->classarm_id)
                            ->where('term', $request->term)
                            ->where('school_id', $request->school_id)
                            ->where('student_id', $student_id)
                            ->get();
            
       $class_data = Classes::find($request->class_id);
       $class_name = $class_data->class_name;
       $class_name_char = strtoupper(substr($class_name, 0, 1)); 

       $classarm_data = ClassArms::find($request->classarm_id);
       $class_arm_name = $classarm_data->class_arm;

       $classarm_teacher_data = $classarm_data->teachers()
                            ->where('classarm_teacher.classarm_id', $request->classarm_id)
                            ->first();
        $teacher_signature = $classarm_teacher_data['signature'];

       $classarm_counsellor_data = $classarm_data->counsellors()
                            ->where('classarm_counsellor.classarm_id', $request->classarm_id)
                            ->first();
        $counsellor_signature = $classarm_counsellor_data['signature']; 

        $house_master_signature = '';         

        if(!empty($student->house_id)){
            $school_house = StudentHouse::find($student->house_id);
            if(!empty($school_house)){
            	$house_master =  $school_house->house_masters()->first();
            	if(!empty($house_master)){
            		$house_master_signature = $house_master['signature'];
            	}
        	}
        }                                             

       $schoolData = School::find($request->school_id);

        $student_comments = StudentComments::where('student_id', $student->id)
                                ->where('school_id', $student->school_id)
                                ->where('classarm_id', $request->classarm_id)
                                ->where('session', $request->session)
                                ->where('term', $request->term)
                                ->first();

        $comment_teacher = (!empty($student_comments->comment_teacher)) ? $student_comments->comment_teacher: ''; 
        $comment_house = (!empty($student_comments->comment_house)) ? $student_comments->comment_house: ''; 
        $comment_guard = (!empty($student_comments->comment_guard)) ? $student_comments->comment_guard: ''; 
        $comment_principal = (!empty($student_comments->comment_principal)) ? $student_comments->comment_principal: '';                    

        $promotion = getStudentResultPromotion($student->id, $request->classarm_id, $request->class_id, $request->term, $request->session);      

        //$promotion = 0;
        $promotion_text = $promotion_img = '';

        if($promotion == 1){
            $promotion_text = 'REPEAT Current Class';
            $promotion_img = 'promotion-repeat-stamp.jpg';
        }
        elseif($promotion == 2){
            $promotion_text = 'PROMOTED to Next Class';
            $promotion_img = 'promotion-stamp.jpg';
        }
        elseif($promotion == 3){
            $promotion_text = 'REPEAT Current Class';
            $promotion_img = 'promotion-repeat-stamp.jpg';
        } 
        elseif($promotion == 4){
            $promotion_text = 'WITHDRAW from School';
            $promotion_img = 'withdraw-stamp.jpg';
        } 

        view()->share('school_id',$request->school_id);
        view()->share('student',$student);
        view()->share('student_id',$student->id);
        view()->share('student_results',$student_results);
        view()->share('student_practical_skill',$student_practical_skill);
        view()->share('student_character_development',$student_character_development);
        view()->share('logo', url_public('/images/logo-bg.png'));
        view()->share('class_name_char',$class_name_char);
        view()->share('comment_teacher',$comment_teacher);
        view()->share('comment_house',$comment_house);
        view()->share('comment_guard',$comment_guard);
        view()->share('comment_principal',$comment_principal);
        view()->share('class_id',$request->class_id);
        view()->share('class_name',$class_name);
        view()->share('class_arm_name',$class_arm_name);

        view()->share('promotion_text',$promotion_text);
        view()->share('promotion_img', '/images/'.$promotion_img);

        view()->share('principal_sign',$schoolData->principal_sign);
        view()->share('counsellor_sign',$counsellor_signature);
        view()->share('teacher_signature',$teacher_signature);
        view()->share('house_master_signature',$house_master_signature);
        view()->share('next_session_date',$schoolData->next_session_date);

        view()->share('session_full', $request->session.'/'.($request->session + 1));
        view()->share('term',$request->term);

        $pdf = PDF::loadView('result-pane');
        return $pdf->stream($student->regnum.'_pdfview.pdf');

    }


    public function lgaSchools(Request $request)
    {
        $html = '';
        if(!empty($request->lga_id)){
            $lga_data = OndoLGA::where('id', $request->lga_id)
                                ->first();
            $lga_schools = School::where('lga_id', $request->lga_id)
                                ->get();
            if(!empty($lga_schools)){
                $html .= '<label>Schools In '.$lga_data->name.'</label>';
                $html .= '<div class="ui">';
                $html .= '<select name="school_id" id="school_id" required="required">';
                $html .= '<option value="">Select School</option>
                      <option value=""></option>';
                foreach ($lga_schools as $school) {
                    $html .= '<option value="'.$school->id.'">'.ucwords(strtolower($school->name)).'</option>';
                }//end loop
                $html .= '</select>';
                $html .= '</div>';
            }
        }
        return $html;
    }

    public function schoolClasses(Request $request)
    {
        $html = '';
        if(!empty($request->school_id)){
            $classes = Classes::where('school_id', $request->school_id)
                                ->get();

            if(!empty($classes)){
                $html .= '<label>Classes</label>';
                $html .= '<div class="ui">';
                $html .= '<select name="class_id" id="class_id" required="required">';
                $html .= '<option value="">Select Class</option>
                      <option value=""></option>';
                foreach ($classes as $class) {
                    $html .= '<option value="'.$class->id.'">'.$class->class_name.'</option>';
                }//end loop
                $html .= '</select>';
                $html .= '</div>';
            }
        }
        return $html;
    }

    public function getRegnumSchoolClasses(Request $request)
    {
        $html = '';
        if(!empty($request->regnum)){
            $student_data = Student::where('regnum', $request->regnum)
                                ->first();

            if(!empty($student_data)){
                $school_id    = $student_data->school_id;

                $school_data = School::find($school_id);
                      
                $classes = Classes::where('school_id', $school_id)
                                    ->get();

                if(!empty($classes) && !empty($school_data)){
                    $html .= '<div class="field">';
                    $html .= '<label>School</label>';
                    $html .= '<div class="ui">';
                    $html .= '<strong>'.$school_data->name.'</strong>';
                    $html .= '<input type="hidden" value="'.$school_id.'" name="school_id" id="school_id" />';
                    $html .= '</div>';    
                    $html .= '</div>'; 

                    $html .= '<div class="field">';
                    $html .= '<label>Classes</label>';
                    $html .= '<div class="ui">';
                    $html .= '<select name="class_id" id="class_id" required="required">';
                    $html .= '<option value="">Select Class</option>
                          <option value=""></option>';
                    foreach ($classes as $class) {
                        $html .= '<option value="'.$class->id.'">'.$class->class_name.'</option>';
                    }//end loop
                    $html .= '</select>';
                    $html .= '</div>';
                    $html .= '</div>';
                }
            }
        }
        return $html;
    }

    public function schoolClassArms(Request $request)
    {
        $html = '';
        if(!empty($request->school_id) && !empty($request->class_id)){
            $classarms = ClassArms::where('school_id', $request->school_id)
                                ->where('class_id', $request->class_id)
                                ->get();

            if(!empty($classarms)){
                $html .= '<label>Class Arm</label>';
                $html .= '<div class="ui">';
                $html .= '<select name="classarm_id" id="classarm_id" required="required">';
                $html .= '<option value="">Select Class Arm</option>
                      <option value=""></option>';
                foreach ($classarms as $classarm) {
                    $html .= '<option value="'.$classarm->id.'">'.$classarm->class_arm.'</option>';
                }//end loop
                $html .= '</select>';
                $html .= '</div>';
            }
        }
        return $html;
    }

    public function verifyStudentScratchCard(Request $request)
    {
        if(!empty($request->school_id) && !empty($request->class_id) && !empty($request->classarm_id) && !empty($request->session_val) && !empty($request->term) && !empty($request->regnum)){

            $student_data = Student::where('regnum', $request->regnum)
                                ->first();

            if(!empty($student_data)){
                $student_voucher = ResultVoucher::where('student_id', $student_data->id)
                                                ->where('session', $request->session_val)
                                                //->where('term', $request->term)
                                                ->where('class_id', $request->class_id)
                                                ->where('classarm_id', $request->classarm_id)
                                                ->first();

                $student_name = $student_data->firstname.' '.$student_data->surname;

                if(!empty($student_voucher)){
                    $pin_masked = $student_voucher->pin1.'-****-****-****-';

                    $serial_no_masked = substr($student_voucher->serial, 0, -4);
                    $serial_no_masked = $serial_no_masked.'-****';

                    echo '{"value" : "Student Result Scratch Card Found", "pin_no" : "'.$student_voucher->pin.'", "pin_no_masked" : "'.$pin_masked.'", "serial_no" : "'.$student_voucher->serial.'", "serial_no_masked" : "'.$serial_no_masked.'", "student_name" : "'.$student_name.'", "student_id" : "'.$student_data->id.'", "type" : "okay"}';
                }
                else{
                    echo '{"value" : "", "pin_no" : "", "pin_no_masked" : "", "serial_no" : "", "serial_no_masked" : "", "student_name" : "'.$student_name.'", "student_id" : "'.$student_data->id.'", "type" : "null"}';
                }
            }
            else{
                echo '{"value" : "Invalid Student OSSI", "pin_no" : "", "pin_no_masked" : "", "serial_no" : "", "serial_no_masked" : "", "student_name" : "", "student_id" : "", "type" : "error"}';
            }

        }
    }


}//end class
