<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests;

use App\Faq;

use Carbon\Carbon;

use Validator;

use Image;

use File;

use Auth;

Use Gate;

class FaqController extends Controller
{

    protected function permissionDeny($ability){
        Auth::shouldUse('super_admin');
        return Gate::denies($ability);
    }
	
    public function newPost(){

        if($this->permissionDeny('post-faq')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	return view('super-admin.faq.new-post');
    }

    public function newPostProcess(Request $request){

        if($this->permissionDeny('post-faq')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        
        $validate = Validator::make($request->all(), [
                'title' => 'required',
                'content' => 'required',
                'image' => 'image|mimes:jpeg,png,jpg,gif|max:154000'
            ]);

        if($validate->passes()){

        	$verify_exist =  Faq::where('title', $request->title)
                            ->first();

            if($verify_exist['id']){
	            flash('Specified title ('.$request->title.') already exist. You must specify a unique title')->error();
	            return redirect()->route('super_admin.faq.new');            	
            }
            else{
            	$slug = str_slug($request->title, "-");

            	$images = $request->file('images');

            	$uploadcount = 0;

	            $dbData = [
	                'title' => $request->title,
	                'content' => $request->content,
	                'slug' => $slug,
	                'created_at' => Carbon::now(),
	                'updated_at' => Carbon::now()
	            ];  

            	if($request->hasFile('images')){
            		foreach ($images as $image) {
            			if($image){
							$destinationPath = public_path() . '/images';
							//$filename = $image->getClientOriginalName();
							$fileext = $image->getClientOriginalExtension();
							$new_filename  = 'FAQ_'.substr(md5(rand(0, 1000000)), 0, 12);
							$new_filename .= '.'.strtolower($fileext);
							$upload_success = $image->move($destinationPath, $new_filename);
							$uploadcount ++;
							if($upload_success){
								$dbData['image'.$uploadcount] = $new_filename;
							}
            			}
            		}
            	}

	            $data_id = Faq::create($dbData)->id;

	            if($data_id){
	                flash('FAQ content has been successfully posted.')->success();
	                return redirect()->route('super_admin.faq.new');
	            }
	            else{
	                flash('Something went wrong while processing submission. Pls try again shortly!')->error();
	                return redirect()->route('super_admin.faq.new');
	            }

        	}

        }
        else{   
            flash('Something went wrong...')->error();
            return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
        }

	}// End function


    public function allPost()
    {      
        $data_list = Faq::orderBy('id', 'desc')
        				->get();

        return view('super-admin.faq.post-all', compact('data_list'));
    }//End Method


    public function allPostAdmin()
    {      
        $data_list = Faq::orderBy('id', 'desc')
                        ->get();

        return view('admin.faq.post-all', compact('data_list'));
    }//End Method


    public function postDelete(Request $request, $id)
    {  
        if($this->permissionDeny('delete-faq')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		$verify_data =  Faq::where('id', $id)
			                  ->first();
        
        $destinationPath = public_path() . '/images/';
        $images = array();  	
    	if(!empty($verify_data['image1'])){
    		$images[] = $destinationPath.$verify_data['image1'];
    	}
    	if(!empty($verify_data['image2'])){
    		$images[] = $destinationPath.$verify_data['image2'];
    	}
    	if(!empty($verify_data['image3'])){
    		$images[] = $destinationPath.$verify_data['image3'];
    	}

        if(empty($verify_data)){
            flash('Request aborted! Selected content does not exist')->error();
            return redirect()->route('super_admin.faq.view');            	
        }
        else{
    		$faq_data = Faq::find($id);
    		$data_delete	=	$faq_data->delete();

            if($data_delete){
            	File::delete($images);
                flash('FAQ content has been deleted successfully.')->success();
            	return redirect()->route('super_admin.faq.view');            	         	
            }
            else{
                flash('Something went wrong while processing request. Pls try again shortly!')->error();
            	return redirect()->route('super_admin.faq.view');            	
            }

    	}

    }//End Method


    public function postRead(Request $request, $id)
    {      
        $data =  Faq::find($id);

        $title = (!empty($data)) ? $data->title: 'FAQ - Content not available';

        $path = public_path().'\images\\';

        return view('super-admin.faq.read', compact('data', 'title', 'path'));
    }//End Method


}
