<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use Input;

use Validator;

use App\NgStates;

use Image;

use App\EntranceExam;

use App\School;

use Hash;

use App\ExamsVouchers;

use App\EntranceHallAllocation;

use Session;

class EntranceExamController extends Controller
{
     public function __construct(){

        $this->middleware('auth:entrance');

        $this->middleware('slotAvailable:entrance', ['only' => ['create', 'store']]);

    }

    public function dashboard(){
        $title = 'Entrance Examination Dashboard';
        $noAutoAd = true;
        return view('exams.entrance.dashboard', compact('title', 'noAutoAd'));
    }

    public function create(){

        $title = 'Entrance Examination Registration';


        $ngstates = NgStates::all();

        $ondo_lgas = NgStates::find(28)->ondo_lga;

        $entrance_schools = School::where('school_category', 'non_unity')
                                ->get();

        return view('exams.entrance.create', compact('ngstates', 'title', 'entrance_schools', 'ondo_lgas'));
    }

    public function store(Request $request){

        $validate = Validator::make($request->all(), EntranceExam::$rules);

        if($validate->passes()){
            
        $student = new EntranceExam;

        $voucher = new ExamsVouchers;

        foreach ($request->all() as $key => $value) {
                if(!in_array($key, array('_token','password_confirmation', 'regnum', 'password', 'exam_area')) && !empty($value)){
                        $insert[$key] = $value;
                }
            }

           $insert['session'] = date('Y');

           $insert['regnum'] = $this->getRegNum();
            
           $student_id = $student->create($insert);

            list($pin1, $pin2, $pin3, $pin4) = $this->getRandomVoucher();

            $voucher->pin1 = $pin1;
            $voucher->pin2 = $pin2;
            $voucher->pin3 = $pin3;
            $voucher->pin4 = $pin4;
            $voucher->pin = $pin1 . $pin2 . $pin3 . $pin4;
            $voucher->serial = $this->getSerialNumber();
            $voucher->multiple = 1;
            $voucher->exam_type = 'entrance';
            $voucher->school_id = auth('entrance')->id();
            $voucher->regnum = $insert['regnum'];

            $voucher->save();

            $student_info = $student->find($student_id->id);

            $student_info->card_id = $voucher->id;

            $student_info->school_id = auth('entrance')->id();

            $student_info->save();


           $hall_allocation = new EntranceHallAllocation;

           $hall_allocation->create([
                    'session' => $insert['session'],
                    'candidate_id' => $student_info->id
                ]);

            flash('You have successfully Candidate Information')->info();

            return redirect()->route('exam.entrance.passport')->with('student_id' , $student_id->id);

        }

        flash('Something is wrong')->error();
        return redirect()->back()
                    ->withErrors($validate)
                    ->withInput();
        

    }

    public function passport(){

         $title = 'Candidate Passport Upload';

         if(!Session::has('student_id')){

            flash('Something is wrong')->error();

            return redirect()->route('exam.entrance.students');
         }

         $student = EntranceExam::find(Session::get('student_id'));

        return view('exams.entrance.passport', compact('title', 'student'));

    }

    public function passportPost(Request $request){

        $setStudent = new EntranceExam;

        $validate = Validator::make($request->all(), $setStudent::$studentPassportRule);

        if($validate->passes()){

            $student = $setStudent->find($request->input('student_id'));

            if ($request->hasFile('passport'))
            {
                if ($student->passport != '/images/passports/no_img_da88a72526.gif') {
                    if(file_exists(public_path(explode('?', ltrim($student->passport, '/'))[0])))
                    {
                        @unlink( public_path(explode('?', ltrim($student->passport, '/'))[0]) );
                    }
                }

                $image = $request->file('passport');

                $passport_path = md5(time())."-".$student->surname."-".$student->firstname.".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(250,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/passports/entrance/'.$passport_path);

                $student->passport = '/images/passports/entrance/'.$passport_path.'?cache='.time();

                $student->save();

                flash('You have successfully updated your passport')->success();

            }

            return redirect()->route('exam.entrance.confirm')->with('student_id' , $student->id);
        }


    }

    public function edit($id){
        $title = 'Edit Student Information';

        $setStudent = new EntranceExam;

        $student = $setStudent->find($id);

        $ngstates = NgStates::all();

        $ondo_lgas = NgStates::find(28)->ondo_lga;

        $entrance_schools = School::where('school_category', 'non_unity')
                                ->get();

        return view('exams.entrance.edit', compact('title', 'student', 'ngstates', 'ondo_lgas', 'entrance_schools'));
    }

    public function update($id, Request $request){

        $validate = Validator::make($request->all(), EntranceExam::$rules);

        if($validate->passes()){
            
        $student = EntranceExam::find($id);

        foreach ($request->all() as $key => $value) {
                if(!in_array($key, array('_token','password_confirmation', 'regnum', 'password', 'exam_area')) && !empty($value)){
                        $insert[$key] = $value;
                }
            }
          $student_id = $student->update($insert);

           flash('You have successfully updated Candidate Information')->info();

           if($student->submitted == 1){
                return redirect()->route('exam.entrance.students');
            }

            return redirect()->route('exam.entrance.edit.student.passport', ['id' => $id]);
        }
    }

    public function editPassport($id){
        $title = 'Edit Student Passport';

        $setStudent = new EntranceExam;

        $student = $setStudent->find($id);

        return view('exams.entrance.edit-passport', compact('title', 'student'));

    }

    public function updatePassport($id, Request $request){
        $setStudent = new EntranceExam;
        $student = $setStudent->find($id);

        if($student->passport != NULL){
            $rules = array('passport' => 'sometimes|image|mimes:jpeg,jpg,png|img_min_size:250');
        }else{
            $rules = array('passport' => 'required|image|mimes:jpeg,jpg,png|img_min_size:250');
        }

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){


            if ($request->hasFile('passport'))
            {
                if ($student->passport != '/images/passports/no_img_da88a72526.gif') {
                    if(file_exists(public_path(explode('?', ltrim($student->passport, '/'))[0])))
                    {
                        @unlink( public_path(explode('?', ltrim($student->passport, '/'))[0]) );
                    }
                }
                $image = $request->file('passport');
                $passport_path = md5(time())."-".$student->surname."-".$student->firstname.".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(250,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/passports/entrance/'.$passport_path);

                $student->passport = '/images/passports/entrance/'.$passport_path.'?cache='.time();

                $student->save();

                flash('You have successfully updated your passport')->success();

                if($student->submitted == 1){
                    return redirect()->route('exam.entrance.students');
                }

            }

            return redirect()->route('exam.entrance.confirm')->with('student_id', $id);
        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
    }

    public function confirm(){

        $title = 'Registration Confirmation';

        if(!Session::has('student_id')){
            flash('Something is wrong')->error();
            return redirect()->route('exam.entrance.students');
         }

        $student = EntranceExam::find(Session::get('student_id'));

        Session::keep('student_id');

        return view('exams.entrance.confirm', compact('title', 'student'));

    }

    public function confirmPost(Request $request){

        $validate = Validator::make($request->all(), [
                'student_id' => 'required|integer|not_in:0'
            ]);

        if($validate->fails()){
            flash('Something is wrong')->error();

            return redirect()->route('exam.entrance.students');
        }

        $student = EntranceExam::find($request->input('student_id'));

        $student->submitted = 1;

        $student->save();  
        
        return redirect()->route('exam.entrance.photocard')->with('student_id', $student->id);      

    }

    public function photocard(){

        $title = 'Registration Confirmation';

        if(!Session::has('student_id')){
            flash('Something is wrong')->error();
            return redirect()->route('exam.entrance.students');
         }


        $student = EntranceExam::find(Session::get('student_id'));

        if($student->submitted == 0){
            flash('Sorry, you need to complete your registration')->error();

            return redirect()->route('exams.entrance.students');
        }

         Session::keep('student_id');

        return view('exams.entrance.photocard', compact('title', 'student'));



    }

     public function photocardID($id){

        $title = 'Registration Confirmation';

        $student = EntranceExam::find($id);

        if($student->submitted == 0){
            flash('Sorry, you need to complete your registration')->error();

            return redirect()->route('exams.entrance.students');
        }

        return view('exams.entrance.photocard', compact('title', 'student'));



    }

    public function viewStudent(){
        $title = "View Entrance Examination Students";

        $students = EntranceExam::orderBy('regnum', 'asc')
                                ->paginate(50);

        return view('exams.entrance.view-students', compact('title', 'students'));
    }


    public function addMoreSlot(){

        $title = 'Add More Slot';

        return view('exams.entrance.add-more', compact('title'));

    }

    public function addMoreSlotPost(Request $request){

        $validate = Validator::make($request->all(), [
            'exam_type' => 'in:entrance',
            'serial_no' => 'required',
            'pin' => 'required|card_validation'
        ]);

        if($validate->passes()){

            $exam_voucher = ExamsVouchers::where('serial', '=',  $request->input('serial_no'))
                                        ->where('pin', '=',  $request->input('pin'))
                                        ->where('exam_type', '=',  $request->input('exam_type'))
                                        ->first();

            $exam_voucher->school_id = auth('entrance')->id();

            $exam_voucher->save();

            flash('You have successfully added more slots for the Common Entrance Exam')->success();

            return redirect()->route('exam.entrance.students');
        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();
    }

    private function getRegNum(){
        $regnum = '16'.rand(11111111, 99999999);

        $count = EntranceExam::where('regnum', '=', $regnum)
                            ->count();

        if($count > 0){
            return $this->getRegNum();
        }else{
            return $regnum;
        }
    }

    private function getRandomVoucher()
     {
         $pin1 = rand(1111,9999);
         $pin2 = rand(1111,9999);
         $pin3 = rand(1111,9999);
         $pin4 = rand(1111,9999);
         
         
         $usedPins = ExamsVouchers::where('pin1', $pin1)
                                ->where('pin2', $pin2)
                                ->where('pin3', $pin3)
                                ->where('pin4', $pin4)->get();
                                
         if ($usedPins->count() > 0)
         {
             return $this->getRandomVoucher();
             
         }
         else
         { 
            return array($pin1, $pin2, $pin3, $pin4);
         }
           
     }

     private function getSerialNumber(){
        $serial = 'SN'.rand(11111111, 99999999);

        $usedPins = ExamsVouchers::where('serial', $serial)->get();
                                
         if ($usedPins->count() > 0)
         {
             return $this->getSerialNumber();
             
         }
         else
         { 
            return $serial;
         }
     }



}
