<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\DebtorPenalty;

use Auth;

use Gate;

use Session;

use Validator;

class DebtorPenaltyController extends Controller
{

	protected $classes;

	protected $classarms;

	protected $student_results;

    function __construct(ClassRepositoryInterface $classes, ClassArmRepositoryInterface $classarms, StudentResultRepositoryInterface $student_results){

    	$this->middleware('auth:admin');

    	$this->classes = $classes;

    	$this->classarms = $classarms;

    	$this->student_results = $student_results;

    }

    protected function permissionDeny($ability){
        Auth::shouldUse('admin');
        return Gate::denies($ability);
    }

    function getStudentByClassArmPage(){

       if($this->permissionDeny('create-debtor-penalty')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $title = 'View Student For Debt or Penalty';

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.view.student.for.debtor.penalty';

        return view('admin.classarms.pre-assign-student', compact('classes', 'classarms', 'title', 'route'));
    }


    function adminViewStudentForDebtorPenalty(Request $request){

       if($this->permissionDeny('create-debtor-penalty')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }


        $stdresult = $this->student_results->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                ->get();

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            $session = $request->input('session');

            $term = $request->input('term');

            $classarm_id = $request->input('classarm_id');

            $class_id = $request->input('class_id');

            $classarms = $this->classarms->find($request->input('classarm_id'));

            $classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

            $classarm_students =  $classarms->students()
                                            ->wherePivot('session','=', $session)
                                            ->wherePivot('term','=', $term)
                                            ->get();

            $route = 'admin.view.student.for.debtor.penalty.submit';

            return view('admin.debtorpenalty.post-view-students', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'route'));

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate);
        }

    }

    function adminViewStudentForDebtorPenaltySubmit(Request $request){

        if($this->permissionDeny('create-debtor-penalty')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$insert = array();

    	$counter = 0;

    	$debtor = new DebtorPenalty;

    	foreach($request->issue as $stdid => $issue) {

    		if(!empty($issue)){

                $former_debtor = $debtor->where('student_id', $stdid)->first();
                if(count($former_debtor) > 0){

                    $former_debtor->issue = $issue;
                    $former_debtor->save();

                }else{
    	    		$insert[] = array(
    	    					'school_id' => Session::get('admin.school'),
    	    					'issue' => $issue,
    	    					'student_id' => $stdid
    	    			);
                }
    			$counter++;
    		}
    	}


    	if($counter > 0){
    		flash('You have successfully update student issue')->success();
            if(count($insert) > 0){
        		$debtor->insert($insert);
            }
    	}else{
    		flash('You have not insert any issue for any student')->error();
    	}

    	return $this->adminViewStudentForDebtorPenalty($request);
    }

    function adminViewDebtors(){

        if($this->permissionDeny('view-debtor-penalty')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $debtors = DebtorPenalty::where('school_id', Session::get('admin.school'))
                                ->paginate(50);

        $counter = 0;

        return view('admin.debtorpenalty.view-debtors', compact('debtors', 'counter'));
    }

    function adminViewDebtorsSubmit(Request $request){

        if($this->permissionDeny('view-debtor-penalty')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $debtor = new DebtorPenalty;

        if($request->status == null){
            $request->status = array();
        }

        foreach ($request->student_id as $student_id) {
            $debtor_status = $debtor->where('student_id', $student_id)->first();

            $debtor_status->status = in_array($student_id, $request->status) ? 1 : 0;

            $debtor_status->save();
        }
        
        flash('You have successfully updated student status')->success();

        return redirect()->back();


    }
}
