<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\ClassRepositoryInterface;

use Validator;

use Session;

use Input;

use Auth;

use Gate;

class ClassesController extends Controller
{
	protected $classes;

    function __construct(ClassRepositoryInterface $classes){

        $this->middleware('auth:admin');

    	$this->classes = $classes;

    }

    protected function permissionDeny($ability){
        Auth::shouldUse('admin');
        return Gate::denies($ability);
    }

    function adminViewSchoolClasses(){

        if($this->permissionDeny('view-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $all_classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                            ->get();

    	$classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
    							->orderBy('class_name', 'desc')
    							->paginate(10);

    	return view('admin.classes.view', compact('classes', 'all_classes'));
    }

    function adminViewSchoolClassesPage(Request $request){

        if($this->permissionDeny('view-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $data = array(
            'id' => $request->input('class_id'),
            'school_id' => Session::get('admin.school')
        );
        
        $all_classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                            ->get();

        $classes =  fetchDataTable('classes', $data, 10);

        Input::flash();

        return view('admin.classes.view',  compact( 'classes','all_classes'));
    }

    function adminCreateSchoolClasses(){

        if($this->permissionDeny('create-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$all_classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                            ->get();

    	return view('admin.classes.create', compact('all_classes'));

    }

    function adminRegisterSchoolClasses(Request $request){

        if($this->permissionDeny('create-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    		$classes = $this->classes->setClass();

    		$validate = Validator::make($request->all(),$classes::$rules);

    		if($validate->passes()){

    			$insert = [
    						'class_name' => $request->input('class_name'),
                            'school_id' => Session::get('admin.school')
    						];

    			$classes->create($insert);

                flash('You have successfully created '.$request->input('class_name').' Class')->success();

    			return redirect()->back();

    		}else{
                flash('Something is wrong')->error();
    			return redirect()->back()
    							->withErrors($validate)
    							->withInput();
    		}

    }

    function adminBatchCreateSchoolClasses(){
        
    }

    function adminEditSchoolClasses($id){

        if($this->permissionDeny('edit-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$classes = $this->classes->find($id);

    	$all_classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                            ->get();

    	return view('admin.classes.edit', compact('all_classes', 'classes'));

    }


    function adminUpdateSchoolClasses($id, Request $request){

        if($this->permissionDeny('edit-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    		$classes = $this->classes->setClass();

    		$validate = Validator::make($request->all(),$classes::$rules);

    		if($validate->passes()){
				$class = $this->classes->find($id);
				
				$class->class_name = $request->input('class_name');

    			$class->save();

                flash('You have successfully updated '.$request->input('class_name').' Class')->success();

    			return redirect()->route('admin.view.school.classes');

    		}else{

                flash('Something is wrong')->error();

    			return redirect()->back()
    							->withErrors($validate)
    							->withInput();
    		}
    }

    function adminDeleteSchoolClasses($id){

        if($this->permissionDeny('delete-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

				$class = $this->classes->find($id);

				$class_name = $class->class_name;

    			$class->delete();

                flash('You have successfully deleted '.$class_name.' Class')->success();

    			return redirect()->route('admin.view.school.classes');
    }
}
