<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use Validator;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\SubjectRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use Input;

use Auth;

use Gate;

use Session;

use DB;

class ClassArmsController extends Controller
{
    protected $classarms;

    protected $classes;

    protected $teachers;

    protected $students;

    protected $studentResult;

    protected $subjects;

    function __construct(ClassArmRepositoryInterface $classarms, ClassRepositoryInterface $classes, TeacherRepositoryInterface $teachers,StudentRepositoryInterface $students,StudentResultRepositoryInterface $studentResult, SubjectRepositoryInterface $subjects){

            $this->middleware('auth:admin');

    		$this->classarms = $classarms;

    		$this->classes = $classes;

            $this->teachers = $teachers;

            $this->students = $students;

            $this->studentResult = $studentResult;

            $this->subjects = $subjects;

    }

    protected function permissionDeny($ability){
        Auth::shouldUse('admin');
        return Gate::denies($ability);
    }

    function adminViewSchoolClassarms(){
        if($this->permissionDeny('view-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        return view('admin.classarms.pre-view');

    }

    function adminViewSchoolClassarmsPage(Request $request){
        if($this->permissionDeny('view-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $validate = Validator::make($request->all(), [
                'session' => 'required|digits:4'
            ]);

        if($validate->passes()){

        	$classarms = $this->classarms->setClassArms()
                                        ->where('school_id', '=', Session::get('admin.school'))
        								->orderBy('class_id', 'desc')
        								->paginate(50);
            $session = $request->session;

        	return view('admin.classarms.view', compact('classarms', 'session'));

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();


    }

    function adminCreateSchoolClassarms(){
        if($this->permissionDeny('create-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

    	$all_classarms = $this->classarms->setClassArms()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();
									
									$c = Session::get('admin.school');

    	return view('admin.classarms.create', compact('classes', 'all_classarms', 'c'));
    	
    }

    function adminRegisterSchoolClassarms(Request $request){
        if($this->permissionDeny('create-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$classarms = $this->classarms->setClassArms();

    	$validate = Validator::make($request->all(), $classarms::$rules);

    	if ($validate->passes()) {
    		
    		$insert = [
    					'class_arm' => $request->input('class_arm_name'),
    					'class_id' => $request->input('class_id'),
                        'school_id' => Session::get('admin.school')
    				];

    		$classarms->create($insert);

            flash('You have successfully created Class Arm for '.getClassNameByClassID($request->class_id))->success();

    		return redirect()->back();

    	}else{

            flash('Something is wrong')->error();

    		return redirect()->back()
    						->withErrors($validate)
    						->withInput();

    	}
    	
    }

    function adminEditSchoolClassarm($id){

        if($this->permissionDeny('edit-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$classarm = $this->classarms->find($id);

    	$classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

    	$all_classarms = $this->classarms->setClassArms()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();
                                    
        $subjects = $this->subjects->setSubject()->get();

    	return view('admin.classarms.edit', compact('classes', 'all_classarms', 'classarm', 'subjects'));

    	
    }

    function adminUpdateSchoolClassarms(Request $request, $id){

        if($this->permissionDeny('edit-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

    	$classarms = $this->classarms->setClassArms();

        //$classarms::$rules['class_arm_name'] = 'required|unique:class_arms,class_arm,'.$id;

    	$validate = Validator::make($request->all(), $classarms::$rules);

    	if ($validate->passes()) {
    		
    		$classarm = $this->classarms->find($id);

    		$classarm->class_arm = $request->input('class_arm_name');

    		$classarm->save();

            flash('You have successfully updated Class Arm for '.getClassNameByClassID($request->class_id))->success();

    		return redirect()->back();

    	}else{

            flash('Something id wrong')->error();

    		return redirect()->back()
    						->withErrors($validate)
    						->withInput();

    	}
    	
    }

    function adminDeleteSchoolClassarms($id, Request $request){

        if($this->permissionDeny('delete-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
    	
    	$classarm = $this->classarms->find($id);

    	$classarm_name = $classarm->class_arm;

    	$class_id = $classarm->class_id;

        $classarm->delete();

        flash('You have successfully deleted '.$classarm_name.' from '.getClassNameByClassID($class_id))->success();

        return $this->adminViewSchoolClassarmsPage($request);
    }


    function adminAssignTeacherToClass(){

        if($this->permissionDeny('assign-teacher-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $all_teachers = $this->teachers->setTeacher()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->orderBy('class_id', 'desc')
                                    ->paginate(20);

        return view('admin.classarms.assign-teacher', compact('classes', 'classarms', 'all_teachers'));
    }

    function adminAssignTeacherToClassSubmit(Request $request){

        if($this->permissionDeny('assign-teacher-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $all_teachers = $this->teachers->setTeacher()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms();

        $validate = Validator::make($request->all(), $classarms::$ruleTeacherAssign);

        if($validate->passes()){

            $classarm = $this->classarms->find($request->class_arm_id);

            $exit_teachers_array = array();

            $exit_teachers = \DB::table('classarm_teacher')->select('teacher_id')
                                        ->whereRaw('`classarm_id` = '.$request->class_arm_id)
                                        ->get();

            foreach($exit_teachers as $teacher){
                $exit_teachers_array[] = $teacher->teacher_id;
            }

            $assign_teachers = array_diff($request->teachers, $exit_teachers_array);

            if(count($assign_teachers) > 0){

                $classarm->teachers()->attach($assign_teachers, ['session' => date('Y')]);

                foreach($assign_teachers as $teacher){
                    $this->teachers->find($teacher)->permission_classes()->attach([38,39,40,41,42,43,44,45,46,47], ['classarm_id' => $request->class_arm_id]);
                }
                flash('You have successfully assign teachers to Class Arm')->success();

                return redirect()->back(); 
            }

            flash('Sorry, you have already assign the teacher to the class')->error();

            return redirect()->back()
                            ->withInput();


        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }

    } 


    function adminUpdateAssignTeacherToClass(Request $request, $id){

        if($this->permissionDeny('edit-assign-teacher-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $classarms = $this->classarms->setClassArms();

        $validate = Validator::make($request->all(), $classarms::$ruleTeacherAssign);

        if($validate->passes()){

            $classarm = $this->classarms->find($id);

            $classarm->teachers()->sync($request->teachers);

            \DB::table('class_teacher_permission')->whereRaw("`classarm_id` = $id AND `permission_id` IN (38,39,40,41,42,43,44,45,46,47)")
                                                ->delete();

            foreach($request->teachers as $teacher){
                $this->teachers->find($teacher)->permission_classes()->attach([38,39,40,41,42,43,44,45,46,47], ['classarm_id' => $id]);
            }

            flash('You have successfully updated teachers assign to Class Arm')->success();

            return redirect()->route('admin.assign.teacher.to.class');   
            
        }else{
            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }

    }


    function deleteTeacherAssignToClass($id){

        if($this->permissionDeny('remove-assign-teacher-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        $classarm = $this->classarms->find($id);

        $classarm->teachers()->detach();

        \DB::table('class_teacher_permission')->where('classarm_id', $id)
                                                ->delete();

        flash('You have successfully deleted subjects assign to '.getClassNameByClassID($classarm->class_id).' '.$classarm->class_arm)->success();

        return redirect()->route('teacherassign');
    }


    function adminEditAssignTeacherToClass($id){

         if($this->permissionDeny('edit-assign-teacher-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $all_teachers = $this->teachers->setTeacher()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarm = $this->classarms->find($id);

        $assign_teachers = array();

        foreach($classarm->teachers as $t_s){
                $assign_teachers[] = $t_s->id;
            }

        return view('admin.classarms.edit-assign-teacher', compact('all_teachers', 'classarm', 'assign_teachers'));

    }

    function adminAssignStudentToClass(){

        if($this->permissionDeny('assign-student-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $title = 'Assign Students to Class';

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.assign.student.to.class.submit';

        return view('admin.classarms.pre-assign-student', compact('classes', 'classarms', 'title', 'route'));
    }

    function adminEditStudentAssignToClass(){

        if($this->permissionDeny('remove-assign-student-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $title = 'Remove Students to Class';

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.edit.student.assign.to.class.submit';

        return view('admin.classarms.pre-assign-student', compact('classes', 'classarms', 'title', 'route'));
    }

    function adminAssignStudentToClassSubmit(Request $request){

        if($this->permissionDeny('assign-student-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $stdresult = $this->studentResult->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            $session = $request->input('session');

            $term = $request->input('term');

            $classarm_id = $request->input('classarm_id');

            $class_id = $request->input('class_id');

            $classarms = $this->classarms->find($request->input('classarm_id'));

            $classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

            $classarm_students =  $classarms->students()
                                            ->wherePivot('session','=', $session)
                                            ->wherePivot('term','=', $term)
                                            ->get();

            if(!empty($request->route)){
                $route = $request->route;
            }else{

                $route = 'admin.assign.student.to.next.term.submit';
            }


            if(!empty($request->edit)){

                $edit = $request->edit;

                return view('admin.classarms.post-view-students', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'route', 'edit'));

            }else{

                return view('admin.classarms.post-view-students', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'route'));
            }

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate);
        }

    }

    function adminEditStudentAssignToClassSubmit(Request $request){

        if($this->permissionDeny('remove-assign-student-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $stdresult = $this->studentResult->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            $session = $request->input('session');

            $term = $request->input('term');

            $classarm_id = $request->input('classarm_id');

            $class_id = $request->input('class_id');

            $classarms = $this->classarms->find($request->input('classarm_id'));

            $classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

            $classarm_students =  $classarms->students()
                                            ->wherePivot('session','=', $session)
                                            ->wherePivot('term','=', $term)
                                            ->get();

            $route = 'admin.edit.student.assign.to.class.process';

            $edit = '';


            return view('admin.classarms.post-view-students', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'route', 'edit'));

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate);
        }

    }


    function adminAssignStudentToNextTermClassSubmit(Request $request){

        if($this->permissionDeny('assign-student-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $stdresult = $this->studentResult->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $rules['next_classarm_id'] = 'required|integer';

        $rules['next_class_id'] = 'required|integer';

        $rules['next_session'] = 'required|digits:4';

        $rules['student_id'] = 'required|array|min:1';

        $rules['next_term'] = ['required','regex:/(First|Second|Third)/', 'next_term_class_verification:term,classarm_id,next_classarm_id,session,next_session'];
        

        Input::flash();

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            $session = $request->input('next_session');

            $term = $request->input('next_term');

            $classarm_id = $request->input('next_classarm_id');

            $class_id = $request->input('next_class_id');

            $exist_students_array = array();

            $exist_students = \DB::table('classarm_student')->select('student_id')->whereRaw("`classarm_id` = ".$classarm_id." AND `term` = '".$term."' AND `session` = ".$session )->get();

            foreach($exist_students as $student){
                $exist_students_array[] = $student->student_id;
            }

            $non_exist_students = array_diff($request->input('student_id') , $exist_students_array); 

            if(count($non_exist_students) > 0){
                $classarm_get =  $this->classarms->find($request->input('next_classarm_id'));

                $classarm_get->students()->attach($non_exist_students, ['session' => $request->input('next_session'), 'term' => $request->input('next_term'),'class_id' => $request->input('next_class_id')]);

                flash('You have successfully move '.getClassNameByClassID($request->input('class_id')).' '.getClassArmNameByClassArmID($request->input('classarm_id')).' '.$request->input('term').' '.$request->session.' / '.($request->session + 1).' to '.getClassNameByClassID($request->input('next_class_id')).' '.getClassArmNameByClassArmID($request->input('next_classarm_id')).' '.$request->input('next_term').' '.$request->next_session.' / '.($request->next_session + 1))->success();
            }else{

                flash('You have already move '.getClassNameByClassID($request->input('class_id')).' '.getClassArmNameByClassArmID($request->input('classarm_id')).' '.$request->input('term').' '.$request->session.' / '.($request->session + 1).' to '.getClassNameByClassID($request->input('next_class_id')).' '.getClassArmNameByClassArmID($request->input('next_classarm_id')).' '.$request->input('next_term').' '.$request->next_session.' / '.($request->next_session + 1))->error();
            }
            


            $classarms = $this->classarms->find($classarm_id);

            $classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

            $classarm_students =  $classarms->students()
                                            ->wherePivot('session','=', $session)
                                            ->wherePivot('term','=', $term)
                                            ->get();

            $route = 'admin.assign.student.to.next.term.submit';

            

            return view('admin.classarms.post-view-students', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'route'));


        }else{

            flash('Something is wrong')->error();

            return $this->adminAssignStudentToClassSubmit($request)->withErrors($validate);

        }



    }



    function adminEditStudentAssignToClassProcess( Request $request){

        if($this->permissionDeny('remove-assign-student-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $stdresult = $this->studentResult->setStudentResult();

        $rules = $stdresult::$ruleForSubjects;

        unset($rules['class_arm_id']);

        $rules['classarm_id'] = 'required|integer';

        $rules['student_id'] = 'required|array|min:1';

        Input::flash();

        $validate = Validator::make($request->all(), $rules);

        if($validate->passes()){

            $session = $request->input('session');

            $term = $request->input('term');

            $classarm_id = $request->input('classarm_id');

            $class_id = $request->input('class_id');

            $exist_students_array = array();

            $exist_students = \DB::table('classarm_student')->select('student_id')->whereRaw("`classarm_id` = ".$classarm_id." AND `term` = '".$term."' AND `session` = ".$session." AND `class_id` = ".$class_id )->get();

            foreach($exist_students as $student){
                $exist_students_array[] = $student->student_id;
            }

            $approved_students = array_diff($exist_students_array, $request->input('student_id')); 

            $classarm_get =  $this->classarms->find($classarm_id);

            if(count($approved_students) > 0){

                $classarm_get->students()->wherePivot('session','=', $session)
                                        ->wherePivot('class_id','=', $class_id)
                                        ->wherePivot('term','=', $term)->sync($approved_students, ['session' => $session, 'term' => $term,'class_id' => $class_id]);

                flash('You have successfully Remove Selected Students from '.getClassNameByClassID($request->input('class_id')).' '.getClassArmNameByClassArmID($request->input('classarm_id')).' '.$request->input('term').' '.$request->session.' / '.($request->session + 1))->success();
            }else{

                flash('You have successfully Remove All Students from '.getClassNameByClassID($request->input('class_id')).' '.getClassArmNameByClassArmID($request->input('classarm_id')).' '.$request->input('term').' '.$request->session.' / '.($request->session + 1))->succes();

                $classarm_get->students()->wherePivot('session','=', $session)
                                        ->wherePivot('class_id','=', $class_id)
                                        ->wherePivot('term','=', $term)
                                        ->detach();
            }
            


            $classarms = $this->classarms->find($classarm_id);

            $classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

            $classarm_students =  $classarms->students()
                                            ->wherePivot('session','=', $session)
                                            ->wherePivot('term','=', $term)
                                            ->get();

            $route = 'admin.edit.student.assign.to.class.process';

            $edit = '';

            return view('admin.classarms.post-view-students', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'route', 'edit'));


        }else{

            $request->merge(['route' => 'admin.edit.student.assign.to.class.process', 'edit' => 'edit']);

            flash('Something is wrong')->error();

            return $this->adminAssignStudentToClassSubmit($request)->withErrors($validate);

        }

    }


    function adminClassarmsReAssignViewStudent(){

        $title = 'Class Arm Student Movement';

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $route = 'admin.classarm.reassign.view.students';

        return view('admin.classarms.reassign-get-student', compact('classes', 'classarms', 'title', 'route'));
    }


    function adminClassarmsReAssignViewStudentSubmit(Request $request){

        $validate = Validator::make($request->all(), [
                'session' => 'required',
                'class_id' => 'required',
                'classarm_id' => 'required',
                'term' => 'required'
            ]);

        if($validate->passes()){

            $session = $request->input('session');

            $term = $request->input('term');

            $classarm_id = $request->input('classarm_id');

            $class_id = $request->input('class_id');
            $class_data = $this->classes->find($class_id);
            $class_name = $class_data->class_name;

            $classarms = $this->classarms->find($request->input('classarm_id'));

            $classes = $this->classes->setClass()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

            $other_classarms = $this->classarms->setClassArms()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->where('class_id','=', $class_id)
                                    ->where('id','!=', $classarm_id)
                                    ->get();

            $classarm_students =  $classarms->students()
                                            ->wherePivot('session','=', $session)
                                            ->wherePivot('term','=', $term)
                                            ->get();

            return view('admin.classarms.reassign-view-student', compact('classarm_students','classarms','session', 'class_id', 'classarm_id', 'term', 'classes', 'other_classarms', 'class_name'));

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate);
        }

    }


    public function adminClassarmsReAssignStudentAjaxProcess(Request $request){

        $error = 0;
        $error_msg = '\n\n';

        $school_id = Session::get('admin.school');
        
        if(empty($request->term)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Current Student Term failed authentication';
            $error_msg .= '\n';
        }

        if(empty($request->session)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Current Student Session failed authentication';
            $error_msg .= '\n';
        }

        if(empty($request->class_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Current Student Class failed authentication';
            $error_msg .= '\n';
        }

        if(empty($request->from_classarm_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Current Student Class Arm failed authentication';
            $error_msg .= '\n';
        }

        if(empty($request->to_classarm_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Class Arm must not be blank';
            $error_msg .= '\n';
        }

        if(empty($school_id)){
            $error = $error + 1;
            $error_msg .= ''.$error.': School information failed authentication';
            $error_msg .= '\n';
        }

        if(empty($request->student_ids)){
            $error = $error + 1;
            $error_msg .= ''.$error.': Student(s) selection must not be empty';
            $error_msg .= '\n';
        }

        if(count($request->student_ids) < 1){
            $error = $error + 1;
            $error_msg .= ''.$error.': Student(s) selection must not be blank';
            $error_msg .= '\n';
        }

        if($error == 0){
            $session = $request->session;
            $term = $request->term;
            $class_id = $request->class_id;
            $from_classarm_id = $request->from_classarm_id;
            $to_classarm_id = $request->to_classarm_id;
            $student_ids_count = count($request->student_ids);
            $student_ids_count_s = ($student_ids_count > 1) ? 'students have': 'student has';

            $where_clause = '('.implode(', ', $request->student_ids ).')';

            $resp_count = 0;

            //START:: QUERY

            $affected = DB::update("UPDATE `classarm_student` SET `classarm_id` = ? WHERE `session` = ? AND `classarm_id` = ? AND `term` = ? AND `class_id` = ? AND `student_id` IN ".$where_clause."", [$to_classarm_id, $session, $from_classarm_id, ''.$term.'', $class_id]);
            $resp_count =  ($affected) ? $resp_count+1: $resp_count;
            $affected = false;

            $affected = DB::update("UPDATE `result_vouchers` SET `classarm_id` = ? WHERE `session` = ? AND `classarm_id` = ? AND `term` = ? AND `class_id` = ? AND `student_id` IN ".$where_clause."", [$to_classarm_id, $session, $from_classarm_id, ''.$term.'', $class_id]);
            $resp_count =  ($affected) ? $resp_count+1: $resp_count;
            $affected = false;

            $affected = DB::update("UPDATE `student_results` SET `classarm_id` = ? WHERE `session` = ? AND `classarm_id` = ? AND `term` = ? AND `class_id` = ? AND `student_id` IN ".$where_clause."", [$to_classarm_id, $session, $from_classarm_id, ''.$term.'', $class_id]);
            $resp_count =  ($affected) ? $resp_count+1: $resp_count;
            $affected = false;

            $affected = DB::update("UPDATE `student_comments` SET `classarm_id` = ? WHERE `session` = ? AND `classarm_id` = ? AND `term` = ? AND `class_id` = ? AND `student_id` IN ".$where_clause."", [$to_classarm_id, $session, $from_classarm_id, ''.$term.'', $class_id]);
            $resp_count =  ($affected) ? $resp_count+1: $resp_count;
            $affected = false;

            $affected = DB::update("UPDATE `student_subject_unoffered` SET `classarm_id` = ? WHERE `session` = ? AND `classarm_id` = ? AND `student_id` IN ".$where_clause."", [$to_classarm_id, $session, $from_classarm_id, ''.$term.'', $class_id]);
            $resp_count =  ($affected) ? $resp_count+1: $resp_count;
            $affected = false;

            $affected = DB::update("UPDATE `practical_skills` SET `classarm_id` = ? WHERE `session` = ? AND `classarm_id` = ? AND `term` = ? AND `class_id` = ? AND `student_id` IN ".$where_clause."", [$to_classarm_id, $session, $from_classarm_id, ''.$term.'', $class_id]);
            $resp_count =  ($affected) ? $resp_count+1: $resp_count;
            $affected = false;

            $affected = DB::update("UPDATE `character_attitudes` SET `classarm_id` = ? WHERE `session` = ? AND `classarm_id` = ? AND `term` = ? AND `class_id` = ? AND `student_id` IN ".$where_clause."", [$to_classarm_id, $session, $from_classarm_id, ''.$term.'', $class_id]);
            $resp_count =  ($affected) ? $resp_count+1: $resp_count;
            $affected = false;

            $affected = DB::update("UPDATE `transfers` SET `classarm_id` = ? WHERE `session` = ? AND `classarm_id` = ? AND `term` = ? AND `class_id` = ? AND `student_former_id` IN ".$where_clause."", [$to_classarm_id, $session, $from_classarm_id, ''.$term.'', $class_id]);
            $resp_count =  ($affected) ? $resp_count+1: $resp_count;
            $affected = false;

            //END:: QUERY

            if($resp_count > 0){
                return '{"value" : "'.$student_ids_count.' '.$student_ids_count_s.' been successfully moved to the selected Class Arm", "type" : "okay"}';
            }
            else{
                return '{"value" : "Something went wrong while processing request. Pls try again shortly!", "type" : "error"}';
            }
        }
        else{
            return '{"value" : "All fields are mandatory. Fix the following to continue: '.$error_msg.'", "type" : "error"}';
        }


    }




    /***************  COUNSELLOR ASSIGN TO CLASS ARM ******************/


    function adminAssignCounsellorToClass(){

        if($this->permissionDeny('assign-counsellor-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $all_teachers = $this->teachers->setTeacher()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->orderBy('class_id', 'desc')
                                    ->paginate(20);

        return view('admin.classarms.assign-counsellor', compact('classes', 'classarms', 'all_teachers'));
    }



    function adminAssignCounsellorToClassSubmit(Request $request){

        if($this->permissionDeny('assign-counsellor-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $all_teachers = $this->teachers->setTeacher()
                                    ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classes = $this->classes->setClass()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarms = $this->classarms->setClassArms();

        $validate = Validator::make($request->all(), $classarms::$ruleTeacherAssign);

        if($validate->passes()){

            $classarm = $this->classarms->find($request->class_arm_id);

            $exit_teachers_array = array();

            $exit_teachers = \DB::table('classarm_counsellor')->select('teacher_id')
                                        ->whereRaw('`classarm_id` = '.$request->class_arm_id)
                                        ->get();

            foreach($exit_teachers as $teacher){
                $exit_teachers_array[] = $teacher->teacher_id;
            }

            $assign_teachers = array_diff($request->teachers, $exit_teachers_array);

            if(count($assign_teachers) > 0){

                $classarm->counsellors()->attach($assign_teachers, ['session' => date('Y')]);

                flash('You have successfully assign Counsellor to Class Arm')->success();

                return redirect()->back(); 
            }

            flash('Sorry, you have already assign the Counsellor to the class')->error();

            return redirect()->back()
                            ->withInput();

        }else{

            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }

    } 


    function adminEditAssignCounsellorToClass($id){

        if($this->permissionDeny('edit-assign-counsellor-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $all_teachers = $this->teachers->setTeacher()
                                ->where('school_id', '=', Session::get('admin.school'))
                                    ->get();

        $classarm = $this->classarms->find($id);

        $assign_teachers = array();

        foreach($classarm->counsellors as $t_s){
                $assign_teachers[] = $t_s->id;
            }

        return view('admin.classarms.edit-assign-counsellor', compact('all_teachers', 'classarm', 'assign_teachers'));

    }


    function adminUpdateAssignCounsellorToClass(Request $request, $id){

        if($this->permissionDeny('edit-assign-counsellor-to-classarm')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

        $classarms = $this->classarms->setClassArms();
        
        $validate = Validator::make($request->all(), [
                'class_id' => 'required|integer',
                'class_arm_id' => 'required|integer',
                'teacher' => 'required|integer'
            ]);

        if($validate->passes()){

            $classarm = $this->classarms->find($id);

            $classarm->counsellors()->sync([$request->teacher => ['session' => date('Y')]]);

            flash('You have successfully updated counsellors assign to Class Arm')->success();

            return redirect()->route('admin.assign.counsellor.to.class');   
            
        }else{
            flash('Something is wrong')->error();

            return redirect()->back()
                            ->withErrors($validate)
                            ->withInput();
        }

    }


}
