<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use App\Repositories\NgStatesRepositoryInterface;
use App\UnityExam;
use App\UnityHallAllocation;
use App\ExamsVouchers;
use App\Agent;
use Validator;
use Auth;
use Session;
use Hash;
use Input;

class UnityExamAuthController extends Controller
{
     use AuthenticatesAndRegistersUsers, ThrottlesLogins;


     protected $redirectTo = 'exams/unity/dashboard';

     protected $redirectAfterLogout = 'exams/unity/login-with-exam-number';

     protected $ngstates;

     public function __construct(NgStatesRepositoryInterface $ngstate){
        $this->ngstates = $ngstate;
     	$this->middleware('guest:unity_exam', ['except' => ['logout']]);
     }

     private function getRegNum(){
        $regnum = '15'.rand(11111111, 99999999);

        $count = UnityExam::where('regnum', '=', $regnum)
                            ->count();

        if($count > 0){
            return $this->getRegNum();
        }else{
            return $regnum;
        }
    } 

     public function createStudent(){

        $title = 'Generate Candidate Registration Number';

        return view('exams.unity.generate-exam-number', compact('title'));
     }

     public function storeStudent(Request $request){

        $validate =  Validator::make($request->all(), [
            'exam_type' => 'in:unity_exam',
            'serial_no' => 'required',
            'pin' => 'required|card_validation',
            'auth_code' => 'required|agent_validation'
        ]);

        if($validate->passes()){

            $exam_voucher = ExamsVouchers::where('serial', '=',  $request->input('serial_no'))
                                        ->where('pin', '=',  $request->input('pin'))
                                        ->first();

            $agent = Agent::where('access', $request->input('auth_code'))->first();

            $unity_exam = new UnityExam;

            if($exam_voucher->regnum == NULL){

                $exam_voucher->regnum = $this->getRegNum();

                $exam_voucher->save();

                $unity_exam->create([
                        'serial' => $request->input('serial_no'),
                        'pin' => $request->input('pin'),
                        'regnum' => $exam_voucher->regnum,
                        'agent_id' => $agent->id
                    ]);
            }else{

                $password_checker = $unity_exam->where('serial', '=',  $request->input('serial_no'))
                                    ->where('pin', '=',  $request->input('pin'))
                                    ->first();

                if($password_checker->password != NULL){

                    flash('The card has been used, you can either login with the card or use your Exam Number and Password')->info();

                    return redirect()->route('exam.unity.login.card');
                }

            }

            flash('You have successfully generated Registration Number, Create Candidate Password to Continue Registration')->success();

            return redirect()->route('exam.unity.generate-candidate-password')
                                ->with('auth_code', $request->input('auth_code'))
                                ->with('exam_number' , $exam_voucher->regnum);

        }


        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();

     }


     public function createCandidatePassword(){

            $title = 'Generate Candidate Registration Number';
            if(!Session::has('exam_number')){
                return redirect()->route('exam.unity.generate-exam-number');
            }

            $exam_number = Session::get('exam_number');

            $auth_code = Session::get('auth_code');

            return view('exams.unity.generate-candidate-password', compact('title', 'exam_number', 'auth_code'));

     }


     public function storeCandidatePassword(Request $request){

        $validate =  Validator::make($request->all(), [
            'auth_code' => 'required|agent_validation',
            'exam_number' => 'required|exam_number_exist:unity_exams',
            'password' => 'required|alpha_num|min:6|confirmed',
            'password_confirmation' => 'required'
        ]);

        if($validate->passes()){

            $unity_exam = UnityExam::where('regnum', $request->input('exam_number'))->first();

            $unity_exam->password = Hash::make($request->input('password'));

            $unity_exam->save();

            UnityHallAllocation::create([
                                          'candidate_id' => $unity_exam->id
                                        ]);

            if(Auth::guard('unity_exam')->attempt(['regnum' => $request->input('exam_number'), 'password' => $request->input('password')])) {

                flash('You can continue the Unity Examination Registration')->success();

                return redirect()->route('exam.unity.create');
            }

        }

        flash('Something is wrong')->error();

        $request->session()->flash('exam_number', $request->input('exam_number'));
        $request->session()->flash('auth_code', $request->input('auth_code'));

        return redirect()->back()
                        ->withErrors($validate)
                        ->withInput();


     }


     public function showLoginForm(){

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

     	return view('auth.admin-login', compact('ngstate', 'ngstate_lgas'));
     }

    protected function validateLogin(Request $request){

        $this->validate($request, Admin::$rulesLogin);
    }

    public function login(){

        $title = 'Login Page';

        return view( 'exams.unity.login',compact('title'));

    }


     public function loginPost(Request $request){
        $rules = array('login_type' => ['required', 'regex:(card|regnum)']);

        $validate_one = Validator::make($request->all(), $rules);

        if($validate_one->passes()){

            if($request->input('login_type') == 'card'){
                $rules['exam_type'] = 'required|in:unity_exam';
                $rules['serial_no'] = 'required';
                $rules['pin'] = 'required|card_validation|card_used_status';

                
                $validate_two = Validator::make($request->all(), $rules);

                if($validate_two->passes()){
                $candidate =  UnityExam::where('serial', $request->input('serial_no'))
                                        ->where('serial', $request->input('serial_no'))
                                        ->first();

                   auth('unity_exam')->login($candidate);

                   return redirect()->intended('exams/unity/dashboard');

                }

                flash('Somthing is wrong')->error();

                return redirect()->back()
                                ->withErrors($validate_two)
                                ->withInput();
            }else{

                $rules['regnum'] = 'required';
                $rules['password'] = 'required';

                $credentials = array(
                        'regnum' => $request->input('regnum'),
                        'password' => $request->input('password')
                    );

                $this->validate($request, $rules);

             	$throttles = $this->isUsingThrottlesLoginsTrait();

                if ($throttles && $lockedOut = $this->hasTooManyLoginAttempts($request)) {
                    $this->fireLockoutEvent($request);

                    return $this->sendLockoutResponse($request);
                }

                if (Auth::guard('unity_exam')->attempt($credentials)) {

                    flash('You have successfully login')->success();
                    return $this->handleUserWasAuthenticated($request, $throttles);
                }

                // If the login attempt was unsuccessful we will increment the number of attempts
                // to login and redirect the user back to the login form. Of course, when this
                // user surpasses their maximum number of attempts they will get locked out.
                if ($throttles && ! $lockedOut) {
                    $this->incrementLoginAttempts($request);
                }
                flash('Something is wrong')->error();

                return $this->sendFailedLoginResponse($request)->withInput();
            }

        }

        flash('Something is wrong')->error();

        return redirect()->back()
                        ->withErrors($validate_one)
                        ->withInput();


    }

     public function logout()
    {
        Auth::guard('unity_exam')->logout();

        return redirect()->route('exam.unity.login.exam.number');
    }

}
