<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Support\Str;
use Password;
use Auth;
use Session;

class TeacherPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    protected $redirectTo = '/teacher/dashboard';

    protected $linkRequestView = 'auth.passwords.email-teacher';

    protected $broker = 'teachers';

    protected $guard = 'teacher';

    protected $subject = 'Your Teacher Password Reset Link';

    protected $resetView = 'auth.passwords.reset-teacher';
    /**
     * Create a new password controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest:teacher');
    }

     protected function resetPassword($user, $password)
    {
        $user->forceFill([
            'password' => bcrypt($password),
            'remember_token' => Str::random(60),
        ])->save();

        Session::put('teacher.school',$user->school_id);

        Auth::guard($this->getGuard())->login($user);
    }


}
