<?php

namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\Teacher;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use App\Repositories\NgStatesRepositoryInterface;
use Validator;
use Auth;
use Session;

class TeacherAuthController extends Controller
{
     use AuthenticatesAndRegistersUsers, ThrottlesLogins;


     protected $redirectTo = 'teacher/dashboard';

     protected $redirectAfterLogout = 'teacher/login';

     protected $ngstates;

     public function __construct(NgStatesRepositoryInterface $ngstate){
     	$this->middleware('guest:teacher', ['except' => ['logout']]);
        $this->ngstates = $ngstate;
     }


     public function showLoginForm(){

        $ngstate =  $this->ngstates->find(28);

        $ngstate_lgas = $ngstate->ondo_lga;

     	return view('teacher.login', compact('ngstate', 'ngstate_lgas'));
     }

      protected function validateLogin(Request $request)
    {
        $this->validate($request, Teacher::$rulesLogin);
    }


     public function login(Request $request){

     	$this->validateLogin($request);

     	$throttles = $this->isUsingThrottlesLoginsTrait();

        if ($throttles && $lockedOut = $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if (Auth::guard('teacher')->attempt(['staff_no' => $request->input('staff_id'), 'password' => $request->input('password')])) {
            flash('You have successfully login')->success();
            Session::put('teacher.school', auth('teacher')->user()->school_id);
            return $this->handleUserWasAuthenticated($request, $throttles);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        if ($throttles && ! $lockedOut) {
            $this->incrementLoginAttempts($request);
        }

        flash('Sorry, something wrong')->error();

        return $this->sendFailedLoginResponse($request)->withInput();

     }

     public function logout()
    {
        Auth::guard('teacher')->logout();
        Session::forget('teacher.school');
        return redirect()->route('teacher.login');
    }

}
