<?php
namespace App\Http\Controllers\Auth;

use Illuminate\Http\Request;
use App\SuperAdmin;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use Validator;
use Auth;

class SuperAdminAuthController extends Controller
{
     use AuthenticatesAndRegistersUsers, ThrottlesLogins;


     protected $redirectTo = '/ministry/dashboard';

     protected $redirectAfterLogout = '/ministry/login';

     public function __construct(){
     	$this->middleware('guest:super_admin', ['except' => ['logout']]);
     }


     public function showLoginForm(){
     	return view('super-admin.login');
     }

      protected function validateLogin(Request $request)
    {
        $this->validate($request, SuperAdmin::$rulesLogin);
    }


     public function login(Request $request){

     	$this->validateLogin($request);

     	$throttles = $this->isUsingThrottlesLoginsTrait();

        if ($throttles && $lockedOut = $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if (Auth::guard('super_admin')->attempt(['username' => $request->input('username'), 'password' => $request->input('password')])) {
            if(Auth::guard('super_admin')->user()->login_count >= 5 || Auth::guard('super_admin')->user()->update_level == 1){
                if(Auth::guard('super_admin')->user()->phone == ''){
                    Auth::guard('super_admin')->logout();
                    flash('Account phone number not updated after 5 successful login. Please contact our administrative team @ info@odsgmoe.com')->error();
                    return redirect()->route('super_admin.login');
                }
                
                $digit = substr(Auth::guard('super_admin')->user()->phone, -4);
                if(!isset($request->phone)){
                    $username = $request->username;
                    $password = $request->password;
                    Auth::guard('super_admin')->logout();
                    flash('Verify phone number by confirming the last 4 digits')->warning();
                    return view('super-admin.login', compact('username', 'password'));
                }elseif($request->phone != $digit){
                    Auth::guard('super_admin')->logout();
                    flash('Phone number verification failed')->error();
                    return redirect()->route('super_admin.login');
                }
            }
            
            Auth::guard('super_admin')->user()->update([
                'login_count' => Auth::guard('super_admin')->user()->login_count + 1 
            ]);
            flash('You have successfully login')->success();
            return $this->handleUserWasAuthenticated($request, $throttles);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        if ($throttles && ! $lockedOut) {
            $this->incrementLoginAttempts($request);
        }

        flash('Sorry, something wrong')->error();

        return $this->sendFailedLoginResponse($request)->withInput();

    }

     public function logout()
    {
        Auth::guard('super_admin')->logout();

        return redirect()->route('super_admin.login');
    }

}