<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Agent;

use App\Events\AgentRegister;

use Validator;

class AgencyController extends Controller
{
    public function __construct(){

    }

    public function create(){

    	$title = 'Create Agency';

    	return view('agency.create', compact('title'));

    }

    public function store(Request $request){
    	$validate = Validator::make($request->all(), Agent::$rules);

    	if($validate->passes()){
    		$access = $this->getAgencyAccess();


    		$agent = new Agent;

			$agent->fullname = $request->input('fullname');
			$agent->email = $request->input('email');
			$agent->phone = $request->input('phone');
			$agent->access = $access;

			$agent->save();

			event(new AgentRegister($agent));

    		$message = urlencode("Your Agency Access Code is ".$access);

            prepareSMSGateWay(urlencode('ODSGMOE'), urlencode($request->phone), $message);

    		flash('You have successfully created you account')->success();

    		return redirect()->back();

    	}

    	flash('Somrthing is wrong')->error();

    	return redirect()->back()
    					->withErrors($validate)
    					->withInput();
    }

    private function getAgencyAccess(){

    	$access = 'ONDO'.rand(11111111, 99999999);

    	$check  = Agent::where('access', '=', $access)->count();

    	if($check > 0){
    		$this->getAgencyAccess();
    	}else{
    		return $access;
    	}
    }
}
