<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

use App\Repositories\NgStatesRepositoryInterface;

use App\Repositories\NgStatesLGARepositoryInterface;

use App\Repositories\AdminRepositoryInterface;

use App\Repositories\PermissionRepositoryInterface;

use App\Repositories\StudentRepositoryInterface;

use App\Repositories\ClassRepositoryInterface;

use App\Repositories\ClassArmRepositoryInterface;

use App\Repositories\ResultVoucherRepositoryInterface;

use App\Repositories\StudentResultRepositoryInterface;

use App\Repositories\StudentHouseRepositoryInterface;

use App\Repositories\TeacherRepositoryInterface;

use App\Repositories\SchoolRepositoryInterface;

use Validator;

use Hash;

use Session;

use App\Events\SchoolAdminCreate;

use Gate;

use Auth;

use DB;

use Image;

use App\NgStates;

use App\School;

use App\SchoolSurvey;

use App\Student;

use App\Teacher;

use App\Classes;

use App\Timetable;

use App\TimetablePeriod;

use App\Subject;

use App\Transaction;

use App\Wallet;

use Carbon\Carbon;

use App\StudentIDCardRequest;

use Input;

use Zipper;

use ZipArchive;

use App\DigitalPayment;

use App\Assessment;

use App\AssessmentImage;

class AdminController extends Controller
{
    protected $ngstates;

    protected $ngstate_lga;

	protected $admin;

	protected $permission;

    protected $classes;
    
    protected $result_voucher;

    protected $class_arms;

    protected $school_houses;

	protected $student;

	protected $students;

	protected $teacher;

	protected $schools;

	public function __construct(NgStatesRepositoryInterface $ngstates, ClassRepositoryInterface $classes,ClassArmRepositoryInterface $class_arms, ResultVoucherRepositoryInterface $result_voucher, StudentHouseRepositoryInterface $school_houses, NgStatesLGARepositoryInterface $ngstate_lga, AdminRepositoryInterface $admin, PermissionRepositoryInterface $permission,SchoolRepositoryInterface $schools,StudentRepositoryInterface $student, TeacherRepositoryInterface $teacher){

		$this->middleware('auth:admin');

        $this->ngstates = $ngstates;

        $this->ngstate_lga = $ngstate_lga;

		$this->admin = $admin;

		$this->permission = $permission;

        $this->classes = $classes;

        $this->result_voucher = $result_voucher;

        $this->class_arms = $class_arms;

        $this->school_houses = $school_houses;

        $this->schools = $schools;

        $this->students = $student;

	}


	protected function permissionDeny($ability){
        Auth::shouldUse('admin');
        return Gate::denies($ability);
    }

	public function dashboard(){
	    $title = 'Admin Dashboard';
        $noAutoAd = true;
		return view('admin.dashboard', compact('title', 'noAutoAd'));
		
	}

	public function password(){

		$title = 'Admin Change Password';

		return view('admin.password', compact('title'));

	}

	public function passwordUpdate(Request $request){

		$validate = Validator::make($request->all(), [
						'password' => 'required|alpha_num|min:6|confirmed',
						'password_confirmation' => 'required'
			]);

		if($validate->passes()){
			$admin = $this->admin->find(auth('admin')->id());

			$admin->password = Hash::make($request->password);

			$admin->save();
			
			flash('You have successfully updated the password')->success();

			return redirect()->route('admin.dashboard');
		}

		flash('Something is wrong')->error();

		return redirect()->back()
						->withErrors($validate)
						->withInput();

	}

	public function adminViewSchoolUsers(){

		if($this->permissionDeny('view-user')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		 

		$admins = $this->admin->setAdmin()
							->where('school_id', '=', Session::get('admin.school'))
                            ->orderBy('fullname', 'asc')
							->paginate(50);

		$all_admin = $this->admin->setAdmin()
							->where('school_id', '=', Session::get('admin.school'))
							->get();

		return view('admin.user.view', compact('admins', 'all_admin'));

	}

	public function adminViewSchoolUsersPost(Request $request){

		if($this->permissionDeny('view-user')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		$data = array();

		foreach($request->all() as $key => $value){
            if(!in_array($key, ['_method', '_token'])){
                $data[$key] = $value;
            }
        }
        
        $data['school_id'] = Session::get('admin.school');

 		$admins =  fetchDataTable('admins',$data, 50);

		$all_admin = $this->admin->setAdmin()
							->where('school_id', '=', Session::get('admin.school'))
							->get();

		return view('admin.user.view', compact('admins', 'all_admin'));

	}

	public function postview(Request $request){

	}


	public function userProfile(){
		$title = "Profile Edit";

		//dd(auth('admin')->id());

		$admin =  $this->admin->find(auth('admin')->id());

		return view('admin.user.edit-profile', compact('title', 'admin'));
	}


	public function userEditSchoolResultData(){

		$admin =  $this->admin->find(auth('admin')->id());
		$school_id = $admin->school_id;
    	$school = School::find($school_id);

		return view('admin.user.edit-result-data', compact('title', 'admin', 'school', 'school_id'));
	}

	public function userEditSchoolResultDataSubmit(Request $request){
		$id = $request->school_id;
		$setSchool = $this->schools->find($id);
        
        $validate = Validator::make($request->all(), [
                'next_session_date' => 'required'
            ]);

        if($validate->passes()){

    		$setSchool->next_session_date = $request->input('next_session_date');
    		$setSchool->principal_name = $request->input('principal_name');
    		
             if ($request->hasFile('principal_sign'))
            {
                $image = $request->file('principal_sign');

                $principal_sign_path = "principal_".$id."_".md5(time()).".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(400,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/signatures/'.$principal_sign_path);

               $setSchool->principal_sign = '/images/signatures/'.$principal_sign_path;

            }

            /* if ($request->hasFile('counsellor_sign'))
            {
                $image = $request->file('counsellor_sign');

                $counsellor_sign_path = "counsellor_".$id."_".md5(time()).".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(400,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/signatures/'.$counsellor_sign_path);

               $setSchool->counsellor_sign = '/images/signatures/'.$counsellor_sign_path;
            }*/
            
            $setSchool->save();

    		flash('You have successfully updated school result data')->success();

    		return redirect()->route('admin.dashboard');
    	}
    	else{
	    	flash('Next Resumption date must not be blank.')->error();

	    	return redirect()->back()
	    					->withErrors($validate)
	    					->withInput();
    	}
	}


	public function userProfileEditLogoView(){
		$title = "Profile Edit Logo";
		$admin =  $this->admin->find(auth('admin')->id());
		$school_id = $admin->school_id;
		$ngstate =  NgStates::find(28);
    	$ngstate_lgas = $ngstate->ondo_lga;
    	$school = School::find($school_id);

		return view('admin.user.edit-profile-logo', compact('title', 'admin','ngstate', 'ngstate_lgas', 'school', 'school_id'));
	}



	public function userProfileEditLogo(Request $request){
		$id = $request->school_id;
		$setSchool = $this->schools->find($id);

        $validate = Validator::make($request->all(), $setSchool::$rules);

        if($validate->passes()){


    		$setSchool->update([
    				'name' => $request->input('school'),
    				'state_id' => $request->input('state_id'),
    				'lga_id' => $request->input('lga_id'),
                    'school_category' => $request->input('school_category'),
                    'address' => $request->input('address')
    			]);

             if ($request->hasFile('logo'))
            {
                if ($setSchool->logo != '/images/school_logos/Nigerian-Coat-of-Arm-icon.png') {
                    if(file_exists(public_path(explode('?', ltrim($setSchool->logo, '/'))[0])))
                    {
                        unlink( public_path(explode('?', ltrim($setSchool->logo, '/'))[0]) );
                    }
                }
                $image = $request->file('logo');
                
                $school_name = $request->input('school');
                $school_name = str_replace("/", "-", $school_name);
                $school_name = str_replace("\"", "-", $school_name);

                $school_logo_path = md5(time())."-".$school_name.".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(300,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/school_logos/'.$school_logo_path);

               $setSchool->logo = '/images/school_logos/'.$school_logo_path.'?cache='.time();

               $setSchool->save();

            }

    		flash('You have successfully updated school logo')->success();

    		return redirect()->route('admin.dashboard');
    	}

    	flash('Something is wrong! Be aware that Image width must not be less than 300px.')->error();

    	return redirect()->back()
    					->withErrors($validate)
    					->withInput();
	}



	public function userProfileUpdate(Request $request){

		$validate = Validator::make($request->all(), [
				'fullname' => 'required',
				'email' => 'required|email|unique:admins,email,'.auth('admin')->id(),
		        'phone' => 'required|regex:(234?)|digits:13|unique:admins,phone',
			]);

		if($validate->passes()){
			$admin = $this->admin->find(auth('admin')->id());

			$admin->fullname = $request->fullname;

			$admin->email = $request->email;

			$admin->phone = $request->phone;

			$admin->save();

			flash('You have successfully update profile')->success();

			return redirect()->route('admin.dashboard');

		}

		flash('Something is wrong')->error();
		return redirect()->back()
						->withErrors($validate)
						->withInput();



	}

	public function adminCreateSchoolUsers(){

		if($this->permissionDeny('create-user')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		$permission = $this->permission->setPermission();

		$student_permission = $permission->where('parent_permission', 'student')->get(['id', 'permission']);
		$teacher_permission = $permission->where('parent_permission', 'teacher')->get(['id', 'permission']);
		$class_permission = $permission->where('parent_permission', 'class')->get(['id', 'permission']);
		$classarm_permission = $permission->where('parent_permission', 'classarm')->get(['id', 'permission']);
		$assignment_permission = $permission->where('parent_permission', 'assignment')->get(['id', 'permission']);
		$subject_permission = $permission->where('permission', 'View Subject')->get(['id', 'permission']);
		$user_permission = $permission->where('parent_permission', 'user')->get(['id', 'permission']);
		$result_permission = $permission->where('parent_permission', 'result')->get(['id', 'permission']);
		$remarks_permission = $permission->where('parent_permission', 'remarks')->get(['id', 'permission']);
		$school_house_permission = $permission->where('parent_permission', 'school_house')->get(['id', 'permission']);
		$debtor_permission = $permission->where('parent_permission', 'debtor')->get(['id', 'permission']);
		$transfer_permission = $permission->where('parent_permission', 'transfer')->get(['id', 'permission']);

		return view('admin.user.create', compact('student_permission', 'teacher_permission', 'class_permission', 'classarm_permission', 'assignment_permission', 'subject_permission', 'user_permission', 'result_permission', 'remarks_permission', 'school_house_permission', 'debtor_permission', 'transfer_permission'));

	}

	public function batchCreate(){

	} 

	public function adminRegisterSchoolUsers(Request $request){

		if($this->permissionDeny('create-user')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		$admin = $this->admin->setAdmin();

		unset($admin::$rules['school']);

		$validate =  Validator::make($request->all(), $admin::$rules);

		if($validate->passes()){

			$all_admin = $admin->where('school_id', Session::get('admin.school'))
							   ->get();


			$transfer_checker =  DB::table('admin_permission')
								  ->where('permission_id', 'IN [73, 74, 75] AND ')
								  ->count();
			$admin_user = $admin->create([
							'fullname' => $request->input('fullname'),
							'status' => null !== $request->input('status') ? $request->input('status') : 0,
							'username' => $request->input('username'),
							'email' => $request->input('email'),
							'password' => Hash::make($request->input('password')),
							'phone' => $request->input('phone'),
							'school_id' => Session::get('admin.school')
							]);

			$admin_user->permissions()->attach($request->permissions);

			$message = urlencode("School Account has been created. username = ".$request->username." and Password = ". $request->password.".Check ".$request->email." for more details");

            prepareSMSGateWay(urlencode('Ondo State Educational Ministry'), urlencode($request->phone), $message);

            event(new SchoolAdminCreate($admin_user, $request->input('password')));

			flash('You have successfully created user')->success();

			return redirect()->back();


		}

		flash('Something is wrong')->error();
		return redirect()->back()
						->withErrors($validate)
						->withInput();
	}

	public function batchRegister(Request $request){

	}

	public function adminEditSchoolUser($id){

		if($this->permissionDeny('edit-user')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		$permission = $this->permission->setPermission();

		$admin = $this->admin->find($id);

		$admin_permissions =  array();
        foreach($admin->permissions()->get() as $a_p){
            $admin_permissions[] = $a_p->id;
        }

		$student_permission = $permission->where('parent_permission', 'student')->get(['id', 'permission']);
		$teacher_permission = $permission->where('parent_permission', 'teacher')->get(['id', 'permission']);
		$class_permission = $permission->where('parent_permission', 'class')->get(['id', 'permission']);
		$classarm_permission = $permission->where('parent_permission', 'classarm')->get(['id', 'permission']);
		$assignment_permission = $permission->where('parent_permission', 'assignment')->get(['id', 'permission']);
		$subject_permission = $permission->where('permission', 'View Subject')->get(['id', 'permission']);
		$user_permission = $permission->where('parent_permission', 'user')->get(['id', 'permission']);
		$result_permission = $permission->where('parent_permission', 'result')->get(['id', 'permission']);
		$remarks_permission = $permission->where('parent_permission', 'remarks')->get(['id', 'permission']);
		$school_house_permission = $permission->where('parent_permission', 'school_house')->get(['id', 'permission']);
		$debtor_permission = $permission->where('parent_permission', 'debtor')->get(['id', 'permission']);
		$transfer_permission = $permission->where('parent_permission', 'transfer')->get(['id', 'permission']);

		return view('admin.user.edit', compact('admin','admin_permissions','student_permission', 'teacher_permission', 'class_permission', 'classarm_permission', 'assignment_permission', 'subject_permission', 'user_permission', 'result_permission', 'remarks_permission', 'school_house_permission', 'debtor_permission', 'transfer_permission'));

	}

	public function adminUpdateSchoolUser($id, Request $request){

		if($this->permissionDeny('edit-user')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		$admin_user = $this->admin->setAdmin();

		$admin = $this->admin->find($id);

		unset($admin_user::$rules['school']);

		$admin_user::$rules['password'] = 'sometimes|alpha_num|min:6|confirmed';
        $admin_user::$rules['password_confirmation'] = 'sometimes|min:6';
        $admin_user::$rules['email'] = 'required|email|unique:admins,email,'.$id;
        $admin_user::$rules['username'] = 'required|min:4|unique:admins,username,'.$id;
        $admin_user::$rules['phone'] = 'required|regex:(234?)|digits:13|unique:admins,phone,'.$id;

		$validate =  Validator::make($request->all(), $admin_user::$rules);


		if($validate->passes()){

			if(!empty(array_intersect([73, 74, 75], $request->permissions))){

				$all_school_admin = $admin->where('school_id', Session::get('admin.school'))
								   ->get();

				$admin_range = "(".implode(', ', array_pluck($all_school_admin->toArray(), 'id')).")";


				$transfer_checker =  DB::table('admin_permission')
									  ->where('permission_id', 'IN (73, 74, 75) AND', 'admin_id IN '.$admin_range)
									  ->count();

				if($transfer_checker > 0){

					flash('You can only give one admin (The Principal) transfer permission')->error();

					return redirect()->back()
								->withInput();

				}
			}

			$admin->fullname = $request->input('fullname');
			$admin->status = null !== $request->input('status') ? $request->input('status') : 0;
			$admin->username = $request->input('username');
			$admin->email = $request->input('email');
			$admin->phone = $request->input('phone');
			if(!empty($request->input('password'))){
				$admin->password = Hash::make($request->input('password'));
			}

			$admin->save();

			$admin->permissions()->sync($request->permissions);

			flash('You have successfully updated user')->success();

			return redirect()->route('admin.view.school.users');
			
		}

		flash('Something is wrong')->error();
		return redirect()->back()
						->withErrors($validate)
						->withInput();


	}

	public function adminDeleteSchoolUser($id){

		if($this->permissionDeny('delete-user')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }

		$admin = $this->admin->find($id);
        $fullname = $admin->fullname;
        $admin->permissions()->detach();
        $admin->delete();

        flash('You have successfully deleted '.$fullname)->success();

        return redirect()->route('admin.user.view');
	}


	public function adminEditSchoolLogoAndAddress(){
		$setSchool = $this->schools->setSchool();

    	$validate = Validator::make($request->all(), ['sch']);

    	if($validate->passes()){

    		$school = $setSchool->create([
    				'name' => $request->input('school'),
    				'state_id' => $request->input('state_id'),
    				'lga_id' => $request->input('lga_id'),
                    'address' => $request->input('address')
    			]);

            if ($request->hasFile('logo'))
            {
                // if ($student->schoo != '/images/passports/no_img_da88a72526.gif') {
                //     if(file_exists(public_path(explode('?', ltrim($student->passport, '/'))[0])))
                //     {
                //         unlink( public_path(explode('?', ltrim($student->passport, '/'))[0]) );
                //     }
                // }
                $image = $request->file('logo');
                $school_logo_path = md5(time())."-".$request->input('school').".".$image->getClientOriginalExtension();

                Image::make($image->getRealPath())->resize(300,null, function($constraint)
                {
                    $constraint->aspectRatio();

                })->save(public_path() . '/images/school_logos/'.$school_logo_path);

                $school->logo = '/images/school_logos/'.$school_logo_path.'?cache='.time();

                $school->save();


            }

        		flash('You have successfully created school')->success();

        		return redirect()->route('super_admin.dashboard');
    	}
    	flash('Something is wrong')->error();

    	return redirect()->back()
    					->withErrors($validate)
    					->withInput();
	}

	public function userImageZipUploadView()
	{
		$title = 'Passport batch upload';
		return view('admin.passports', compact('title'));
	} 

	public function userImageZipUploadExtract(Request $request)
	{
		$school = School::find(auth('admin')->user()->school_id);
		$validate = Validator::make($request->all(), [
			'type' => 'required',
			'file' => 'required|mimes:zip,rar'
		]);
		if($request->type == 'teachers'){
			$destination = 'public/images/passports/teachers/'.$school->name.'-'.$school->id.'/';
		}elseif($request->type == 'students'){
			$destination = 'public/images/passports/students/'.$school->name.'-'.$school->id.'/';
		}else{
			$destination = 'public/uploads/passportUploadTypeError';
		}
		$file = $request->file('file');
		if($file){
			$upError = '';
			if($validate->passes()){
				$file = $request->file;
				$filename = 'zip-'.time() . '.' .$file->getClientOriginalExtension(); 
				if($request->file->move('public/uploads/zips', $filename)){
					$file = 'uploads/zips/'.$filename;
					$Path = public_path($file);
					$zip = zip_open($Path);
					if ($zip)
					{
						//extract
						Zipper::make($Path)->extractTo($destination);
						while ($zip_entry = zip_read($zip))
						{
							//store each of the photos to db
							if($request->type == 'students'){
								$pasport = '/images/passports/students/'.$school->name.'-'.$school->id.'/';
								$regnum = explode('.', zip_entry_name($zip_entry));
								if(Student::where('regnum', $regnum[0])->update([
									'passport' => $pasport.zip_entry_name($zip_entry)
								])){
								}else{
									$upError .= 'Passports stored successfuly. But no user found for student with reg-no <strong>"'.$regnum[0].'"</strong><br>';
								}
							}else{
								$pasport = '/images/passports/teacher/'.$school->name.'-'.$school->id.'/';
								$regnum = explode('.', zip_entry_name($zip_entry));
								$itemPic = str_replace('-', '/', $regnum[0]);
								if(Teacher::where('staff_no', $itemPic)->update([
									'passport' => $pasport.zip_entry_name($zip_entry)
								])){
								}else{
									$upError .= 'Passports stored successfuly. But no user found for teacher with staff-no <strong>"'.$regnum[0].'"</strong><br>';
								}
							}
						}
						zip_close($zip);
						if(is_dir(public_path($file))){
							unlink(public_path($file));
						}
						if(empty($upError)){
							flash('Photos uploaded successfully')->success();
							return redirect()->back();
						}else{
							flash($upError)->warning();
							flash('Photos uploaded successfully')->success();
							return redirect()->back();
						}
					}
				}else{
					flash("Could'nt move file")->error();
					return redirect()->back();
				}
			}else{
				flash('Please select a zip file')->error();
				return redirect()->back();
			}
		}else{
			flash('Please upload file')->error();
			return redirect()->back();
		}
	} 

	public function userImageZipUploadAjax()
	{
		$title = 'Passport batch upload';
		return view('admin.passports-async', compact('title'));
	} 

	public function userImageZipUploadAjaxProcess(Request $request)
	{
        $newline = "%";
		$school = School::find(auth('admin')->user()->school_id);
		$validate = Validator::make($request->all(), [
			'type' => 'required',
			'file' => 'required|mimes:zip,rar'
		]);
		if($request->type == 'teachers'){
			$destination = 'public/images/passports/teachers/'.$school->name.'-'.$school->id.'/';
		}elseif($request->type == 'students'){
			$destination = 'public/images/passports/students/'.$school->name.'-'.$school->id.'/';
		}else{
			$destination = 'public/uploads/passportUploadTypeError';
		}
		$file = $request->file('file');
		if($file){
			$upError = '';
			if($validate->passes()){
				$file = $request->file;
				$filename = 'zip-'.time() . '.' .$file->getClientOriginalExtension(); 
				if($request->file->move('public/uploads/zips', $filename)){
					$file = 'uploads/zips/'.$filename;
					$Path = public_path($file);
					$zip = zip_open($Path);
					if ($zip)
					{
						//extract
						Zipper::make($Path)->extractTo($destination);
						while ($zip_entry = zip_read($zip))
						{
							//store each of the photos to db
							if($request->type == 'students'){
								$pasport = '/images/passports/students/'.$school->name.'-'.$school->id.'/';

								$regnum = explode('.', zip_entry_name($zip_entry));

								list($width, $height) = getimagesize(public_path($pasport.zip_entry_name($zip_entry)));

								if($width <= 500 || $height <= 500){		
									if(Student::where('regnum', $regnum[0])->update([
										'passport' => $pasport.zip_entry_name($zip_entry)
									])){
									}else{
										$upError .= 'Passports stored successfuly. But no user found for student with reg-no '.$regnum[0].''.$newline;
									}
								}
								else{
									$upError .= 'Passport photo of Student with reg-no '.$regnum[0].', exceed 500px in either width or height'.$newline;
								}
							}else{
								$pasport = '/images/passports/teacher/'.$school->name.'-'.$school->id.'/';
								$regnum = explode('.', zip_entry_name($zip_entry));

								list($width, $height) = getimagesize(public_path($pasport.zip_entry_name($zip_entry)));

								$itemPic = str_replace('-', '/', $regnum[0]);

								if($width <= 500 || $height <= 500){
									if(Teacher::where('staff_no', $itemPic)->update([
										'passport' => $pasport.zip_entry_name($zip_entry)
									])){
									}else{
										$upError .= 'Passports stored successfuly. But no user found for teacher with staff-no '.$regnum[0].''.$newline;
									}
								}
								else{
									$upError .= 'Passport photo of Teacher with staff-no '.$itemPic.', exceed 500px in either width or height'.$newline;
								}								
							}
						}
						zip_close($zip);
						if(is_dir(public_path($file))){
							unlink(public_path($file));
						}
						if(empty($upError)){
							flash('Photos uploaded successfully...')->success();
							return '{"value" : "Photos uploaded successfully", "type" : "okay"}';
						}else{
							flash($upError)->warning();
							flash('Photos uploaded successfully!!')->success();
							return '{"value" : "Photos uploaded successfully. But you must fix the following: '.$newline.' '.$upError.'", "type" : "okay"}';
						}
					}
				}else{
					flash("Something went wrong while processing file upload. Pls try again shortly!")->error();
					return '{"value" : "Something went wrong while processing file upload. Pls try again shortly!", "type" : "error"}';
				}
			}else{
				flash("You must select a zip file for upload")->error();
				return '{"value" : "You must select a zip file for upload", "type" : "error"}';
			}
		}else{
			flash("You must choose either a ZIP or RAR file for upload")->error();
			return '{"value" : "You must choose either a ZIP or RAR file for upload", "type" : "error"}';
		}
	}


	public function userStatistics()
	{
		$title = 'School Statistics';
		$user =  auth('admin')->user();
		$school = School::find($user->school_id);
	    return view('admin.statistics', compact('title','user','school'));
	}
	public function schoolTimetable(){
		$title = 'School Time-Table';
		$user =  auth('admin')->user();
		$school = School::find($user->school_id);
		if($this->permissionDeny('view-class')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        
        $all_classes = Classes::where('school_id', $user->school_id)->get();

	    return view('admin.timetable.view', compact('title','user','school', 'classes','all_classes'));
    }
    public function schoolTimetableMakeView(Request $request){
		$user =  auth('admin')->user();
		$school = School::find($user->school_id);
		if(isset($request->class_id) && !empty($request->class_id)){
			$class = Classes::find($request->class_id);
			session()->put('class_id', $request->class_id);
		}else{
			$class = Classes::find(session()->get('class_id'));
		}

		$timetable = Timetable::where('school_id', $school->id)->where('class_id', $class->id)->get();
		if($timetable->count() > 0){
			$title = 'Edit School Time-Table For '.$class->class_name;
		}else{
			$title = 'Create School Time-Table For '.$class->class_name;
			$timetable = Timetable::create([
				'school_id' => $school->id,
				'class_id' => $class->id,
				'admin_id' => $user->id,
			]);
		}
		$className = $class->class_name;
		$classCode = $className[0].$className[1];
		$subjects = Subject::where('class_category', 'like', $classCode. '%')->get();
		return view('admin.timetable.timetable-create', compact('title','user','school', 'class', 'timetable', 'subjects'));
	}
    public function schoolTimetableMake(Request $request){
		$user =  auth('admin')->user();
		$school = School::find($user->school_id);
		$class = Classes::find(session()->get('class_id'));
		session()->put('class_id', $class->id);
		$timetable = Timetable::where('school_id', $school->id)->where('class_id', $class->id)->get();
		
		$className = $class->class_name;
		$classCode = $className[0].$className[1];
		$subjects = Subject::where('class_category', 'like', $classCode. '%')->get();
		$title = 'Edit School Time-Table For '.$class->class_name;
		if(TimetablePeriod::create($request->all())){
			flash('Periods added successfully')->success();
			return back();
		}else{
			flash('Periods failed to create please try again')->error();
			return back();
		}
	}
	public function schoolTimetableDelete(Request $request){
		$timetable = Timetable::find($request->timetable_id);
		if($timetable->deleteAll()){
			$class = Classes::find(session()->get('class_id'))->class_name;
			flash('Time-table for '.$class.' deleted')->success();
			return redirect()->route('admin.school.timetable');

		}else{
			flash('Failed to delete table')->error();
			return back();
		}
	}
	public function schoolTimetableEditView($id){
		$timetable = Timetable::find($id);
		$class= Classes::find(session()->get('class_id'));
		session()->put('class_id', $class->id);
		$title = 'Edit time-table for '.$class->class_name;
		
		$className = $class->class_name;
		$classCode = $className[0].$className[1];
		$subjects = Subject::where('class_category', 'like', $classCode. '%')->get();
		return view('admin.timetable.timetable-edit', compact('title','timetable','subjects'));
	}
	public function schoolTimetableEdit(Request $request){
		if(TimetablePeriod::find($request->id)->update($request->all())){
			flash('Period edited successfully')->success();
			return back();
		}else{
			flash('Failed to edit period')->error();
			return back();
		}
	}
	public function schoolTimetableEditDelete(Request $request){
		if(TimetablePeriod::find($request->id)->delete()){
			flash('Period deleted successfully')->success();
			return back();
		}else{
			flash('Failed to delete period')->error();
			return back();
		}
	}
    public function schoolTimetablePrint(Request $request){
		$user =  auth('admin')->user();
		$school = School::find($user->school_id);
		if(isset($request->class_id) && !empty($request->class_id)){
			$class = Classes::find($request->class_id);
			session()->put('class_id', $request->class_id);
		}else{
			$class = Classes::find(session()->get('class_id'));
		}

		$timetable = Timetable::where('school_id', $school->id)->where('class_id', $class->id)->get();
		if($timetable->count() > 0){
			$title = 'School Time-Table For '.$class->class_name;
		}else{
			flash('No time-table found for '.$class->class_name)->error();
			return back();
		}

		return view('admin.timetable.timetable-print', compact('title','user','school', 'class', 'timetable'));
	}
	
	
	public function quickSearch(Request $request){
		$user =  auth('admin')->user();
		$school = School::find($user->school_id);
		if ($request->search_type == 'student') {
			$data = array();
			$req_keyword = $request->keyword;
			/*$students = Student::where('surname', 'like', '%' .$request->keyword. '%')
					->orWhere('firstname', 'like', '%' .$request->keyword. '%')
					->orWhere('middlename', 'like', '%' .$request->keyword. '%')
					->where('school_id',  $school->id)->get();*/
			$students = Student::where('school_id',  $school->id)
								->where(function($query) use ($req_keyword){
								            $query->where('surname', 'like', '%' .$req_keyword. '%');
								            $query->orWhere('firstname', 'like', '%' .$req_keyword. '%');
								            $query->orWhere('middlename', 'like', '%' .$req_keyword. '%');
								      })
								->get();

			foreach ($students as $student) {
				$classarm_student = DB::table('classarm_student')->where('student_id', $student->id)->first();
				error_reporting(0);
				$data[] = [
					'id' => $student->id,
					'name' => $student->surname.' '.$student->firstname.' '.$student->middlename,
					'regnum' => $student->regnum,
					'gender' => $student->gender,
					'class' => DB::table('classes')->where('id', $classarm_student->class_id)->first()->class_name,
					'class_arm' => DB::table('class_arms')->where('id', $classarm_student->classarm_id)->first()->class_arm,
					'session' => $student->session
				];
			}
			return response()->json($data);
		}elseif ($request->search_type == 'teacher') {
			$data = array();
			$req_keyword = $request->keyword;
			/*$teachers = Teacher::where('surname', 'like', '%' .$request->keyword. '%')
					->orWhere('firstname', 'like', '%' .$request->keyword. '%')
					->orWhere('middlename', 'like', '%' .$request->keyword. '%')
					->where('school_id',  $school->id)->get();*/

			$teachers = Teacher::where('school_id',  $school->id)
								->where(function($query) use ($req_keyword){
								            $query->where('surname', 'like', '%' .$req_keyword. '%');
								            $query->orWhere('firstname', 'like', '%' .$req_keyword. '%');
								            $query->orWhere('middlename', 'like', '%' .$req_keyword. '%');
								      })
								->get();
								
			foreach ($teachers as $teacher) {
				error_reporting(0);
				$data[] = [
					'id' => $teacher->id,
					'name' => $teacher->surname.' '.$teacher->firstname.' '.$teacher->middlename,
					'staff_num' => $teacher->staff_no,
					'qualification' => $teacher->qualification,
					'gender' => $teacher->gender,
					'email' => $teacher->email,
					'phone' => $teacher->phone,
				];
			}
			return response()->json($data);
		}else{
			return response()->json(array([
				'error' => 'please select search type'
			]));
		}
	}
	
	public function schoolTransactionsView(Request $request){
	    $title = 'School Transactions History';
	    $user =  auth('admin')->user();
		$school = School::find($user->school_id);
		if(isset($request->filter) && $request->filter != ''){
		    $date = $request->filter;
		    if($date == 'today'){
                $time = Carbon::yesterday();
            }elseif($date == 'yesterday'){
                $time = date("Y-m-d", strtotime( '-2 days' ) );
            }elseif($date == 'this_week'){
                $time = date("Y-m-d", strtotime( '-8 days' ) );
            }elseif($date == 'this_month'){
                $currentMonth = date('m');
                $time = Carbon::now()->subMonth()->month;
            }else{
                $time = '';
            }
            
	        $transactions = Transaction::where('school_id', $school->id)->whereDate('created_at', '>', $time)->orderBy('id', 'desc')->paginate(30);
		}else{
	        $transactions = Transaction::where('school_id', $school->id)->orderBy('id', 'desc')->paginate(30);
		}
	    $wallet = Wallet::find($school->wallet_id);
	    return view('admin.transactions.view', compact('title', 'transactions', 'wallet'));
	}
	
	public function schoolWalletView(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        
	    $title = 'School Wallet';
	    $user =  auth('admin')->user();
        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
		$school = School::find($user->school_id);
		$wallet = [];
		if(count($school->wallet) > 0){
		    $wallet = $school->wallet;
		}
		
	    return view('admin.wallet.index', compact('title', 'user', 'school', 'wallet', 'classes', 'class_arms'));
	}
	
	public function schoolPaymentVerify(Request $request){
	    $user =  auth('admin')->user();
		$school = School::find($user->school_id);
	    $amount = DB::table('payment_items')->first()->cost;
	    $student_id = $request->student_id;
	    $wallet = $school->wallet;
	    $balance = $wallet->available_balance;
	    foreach($student_id as $id){
	       $student =  Student::find($id);
	       $student_current_class = DB::table('classarm_student')
                                ->where('student_id', $student->id)
                                ->orderBy('session', 'desc')
                                ->first();
	        if($balance >= 1){
	            $payment = DigitalPayment::where('student_id', $student->id)->get()->first();
	            if($payment){
	                $payment->is_verified = true;
	                $payment->save();
	                
	                flash('Opps...'.$student->firstname.' was verified '.$payment->created_at->diffForHumans())->warning();
	            }else{
	               // make scratch card
	               $voucher = $this->result_voucher->setResultVoucher();
	               $insert = array();
	               list($pin1, $pin2, $pin3, $pin4) = $this->getRandomVoucher(1);
	               $pin = $pin1 . $pin2 . $pin3 . $pin4;
	               $serial = $this->getSerialNumber();
                    $insert[] = array(
                        'pin1' => $pin1,
                        'pin2' => $pin2,
                        'pin3' => $pin3,
                        'pin4' => $pin4,
                        'pin' => $pin,
                       'serial' => $serial
                    );
                    $voucher->insert($insert);
                
                    // update card
                    $result_vouchers = $this->result_voucher->setResultVoucher()->where('serial','=', $serial)
                    ->where('pin','=',  $pin)
                    ->first();
                    
                    $result_vouchers->student_id = $student->id;
                    $result_vouchers->classarm_id = $student_current_class->classarm_id;
                    $result_vouchers->class_id = $student_current_class->class_id;
                    $result_vouchers->session = $student_current_class->session;
                    $result_vouchers->term = $request->term;
                    $result_vouchers->save();
	                
	                $balance = $balance - $amount;
        	        $wallet->available_balance = $wallet->available_balance - $amount;
        	        $wallet->account_balance = $wallet->account_balance - $amount;
        	        $wallet->save();
        	        
	                DigitalPayment::create([
	                   'student_id' => $student->id,
	                   'is_verified' => true,
	                   'session' => $student_current_class->session
	                ]);
        	        
        	        flash('Payment for '.$student->firstname.' was successfull')->success();
	            }
	        }else{
	            flash('Payment for '.$student->firstname.' was not successfull. Insufficient balance')->error();
	        }
	    }
		return back();
	}
	
	public function schoolStudentSearch(Request $request){
	     if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return response()->json('Permission Denied', 400);
        }

        $validate = Validator::make($request->all(), [
            'class_id' => 'required',
            'session' => 'required',
            'class_arm_id' => 'required',
            'term' => 'required'
        ]);

        if($validate->passes()){

            $data = [];

            foreach($request->all() as $key => $value){
                if(!in_array($key, ['_method', '_token'])){
                    $data[$key] = $value;
                }
            }
    
            $data['school_id'] = Session::get('admin.school');
    
            $classes = $this->classes->setClass()
                                    ->where('school_id', Session::get('admin.school'))
                                    ->get();
    
            $class_arms = $this->class_arms->setClassArms()
                                    ->where('school_id', Session::get('admin.school'))
                                    ->get();
    
            $school_houses = $this->school_houses->setSchoolHouse()
                                    ->where('school_id', Session::get('admin.school'))
                                    ->get();
    
            $class_arm_id = $this->class_arms->find($request->input('class_arm_id'));

            $students = $class_arm_id->students()
                                    ->wherePivot('session', $request->session)
                                    ->wherePivot('term', $request->term)
                                    ->wherePivot('class_id', $request->class_id)
                                    //->paginate(5);
                                    ->get();
    
            return response()->json($students, 200);
            // return view('admin.students.post-view', compact('classes', 'class_arms', 'students', 'data', 'school_houses'));
        }
        
        return response()->json('Opss...failed to get student', 400);
	}
	
	public function schoolStudentRecieptSearch(Request $request){
	    if($request->type == 'single'){
	        $reciepts = array();
    	    if($studentReciept = Student::where('regnum', $request->student_number)->get()->first()){
    	        $payment = DigitalPayment::where('student_id', $studentReciept->id)
											->where('is_verified', true)
											->get()->first();
                if($payment){
                    $reciepts[] = $studentReciept;
        		    flash('Reciept available')->success();
	                return view('admin.wallet.reciepts', compact('user', 'school', 'wallet', 'reciepts'));
                }
        		flash('Reciept not available')->error();
	           return view('admin.wallet.reciepts', compact('user', 'school', 'wallet', 'reciepts'));
    	    }else{
        		flash('Student not found')->error();
	           return view('admin.wallet.reciepts', compact('user', 'school', 'wallet', 'reciepts'));
    	    }
	    }else{
	        $reciepts = array();
	        $user =  auth('admin')->user();
    		$school = School::find($user->school_id);
    	    $amount = DB::table('payment_items')->first()->cost;
    	    $student_id = $request->student_id;
    	    $wallet = $school->wallet;
    	    $balance = $wallet->available_balance;
    	    foreach($student_id as $id){
    	       $student =  Student::find($id);
                $payment = DigitalPayment::where('student_id', $student->id)->get()->first();
                if($payment){
                    $reciepts[] = $student;
                }else{
        	        flash('Payment reciept for '.$student->firstname.' is not available')->error();
                }
    	    }
	       return view('admin.wallet.reciepts', compact('user', 'school', 'wallet', 'reciepts'));
	    }
	}
	
	private function getRandomVoucher($iteration)
    {
         $pin1 = rand(1111,9999);
         $pin2 = rand(1111,9999);
         $pin3 = rand(1111,9999);
         $pin4 = rand(1111,9999);
         
         
         $usedPins = $this->result_voucher->setResultVoucher()->where('pin1', $pin1)
                                ->where('pin2', $pin2)
                                ->where('pin3', $pin3)
                                ->where('pin4', $pin4)->get();
                                
         if ($usedPins->count() > 0)
         {
             return $this->getRandomVoucher($iteration);
             
         }
         else
         { 
            return array($pin1, $pin2, $pin3, $pin4);
         }
           
    }

    private function getSerialNumber(){
     	$serial = 'SN'.rand(11111111, 99999999);

     	$usedPins = $this->result_voucher->setResultVoucher()
                                ->where('serial', $serial)->get();
                                
         if ($usedPins->count() > 0)
         {
             return $this->getSerialNumber();
             
         }
         else
         { 
            return $serial;
         }
    }
	
	public function schoolIdCardRequestView(){
        if($this->permissionDeny('view-student')){
            $title = 'Permission Deny';
            return view('errors.401', compact('title'));
        }
        
	    $title = 'School ID Card';
	    $user =  auth('admin')->user();
        $classes = $this->classes->setClass()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
        $class_arms = $this->class_arms->setClassArms()
                                ->where('school_id', Session::get('admin.school'))
                                ->get();
		$school = School::find($user->school_id);
		$wallet = [];
		if(count($school->wallet) > 0){
		    $wallet = $school->wallet;
		}
		
		if($school->logo == '/images/school_logos/Nigerian-Coat-of-Arm-icon.png' || $school->logo == '' || $school->logo == null){
		    flash('Please upload school logo to access this feature')->error();
			return back();
		}
		
	    return view('admin.id-cards.index', compact('title', 'user', 'school', 'wallet', 'classes', 'class_arms'));
	}
	
	public function schoolIdCardRequestAction(Request $request){
	   // return $request->all();
	    if($request->type == 'create'){
	        $user =  auth('admin')->user();
    		$school = School::find($user->school_id);
    	    $student_id = $request->student_id;
    	    $counter = 0;
    	    foreach($student_id as $id){
    	        $student =  Student::find($id);
                // check if id card is available
                if($created = StudentIDCardRequest::where('student_id', $student->id)->where('school_id', $school->id)->get()->first()){
                    $status = 'pending';
                    if($created->is_verified == true){
                        $status = 'verified';
                    }
                    flash('A '.$status.' id card request was already made '.$created->created_at->diffForHumans().' for '.$student->surname.' '.$student->firstname)->warning();
                }else{
                    // check if student has paid
                    if(DigitalPayment::where('student_id', $student->id)->where('is_verified', true)->get()->first()){
                        // else create the pending request if passport is available
                        if($student->passport == '/images/passports/no_img_da88a72526.gif' || $student->passport == '' || $student->passport == null){
                		    flash('Could not create id card request for '.$student->surname.' '.$student->firstname.'. Please upload student passport')->error();
                		}else{
                		    StudentIDCardRequest::create([
                		        'school_id' => $school->id,
                		        'student_id' => $student->id,
                		        'admin_id' => $user->id    
                		    ]);
                		    flash('ID card request for '.$student->surname.' '.$student->firstname.' has been sent!')->success();
                            $counter++;
                		}
                    }else{
                        flash($student->surname.' '.$student->firstname.' has not made the digital payment')->error();
                    }
                }
    	    }
    	    
    	    if($counter > 0){
                $message = urlencode(ucfirst($school->name)." made ".$counter." ID Card Request just now");
                prepareSMSGateWay(urlencode('ODSGMOE'), urlencode(2348053081549), $message);
    	    }
            
    	    return back();
	    }elseif($request->type == 'cancle'){
	        $user =  auth('admin')->user();
    		$school = School::find($user->school_id);
    	    $student_id = $request->student_id;
    	    foreach($student_id as $id){
    	        $student =  Student::find($id);
                // check if id card is available
                if($created = StudentIDCardRequest::where('student_id', $student->id)->where('school_id', $school->id)->get()->first()){
                    $created->delete(); 
                    flash('ID card request for '.$student->surname.' '.$student->firstname.' has been cancled!')->success();
                }else{
                    flash('Could not cancle id card request for '.$student->surname.' '.$student->firstname)->error();
                }
    	    }
    	    return back();
	    }else{
	        flash('Unknown action???')->error();
	        return back();
	    }
	}
	
	public function annualAssetView(){
	    $title = 'Annual Assessment';
        $user =  auth('admin')->user();
		$school = School::find($user->school_id);
	    return view('admin.annual-asset.index', compact('title', 'user', 'school'));
	}
	
	public function annualAssetAction(Request $request){
        $user =  auth('admin')->user();
		$school = School::find($user->school_id);
	    if($request->type == 'create'){
			$session = $request->session;
            if ($request->hasFile('file'))
            {
            	// delete if available
            	$destination = 'uploads/docs/'.$school->name.$school->id;
            	$file_path = $session.'.doc';
            	$doc_path = $destination.'/'.$file_path;
                if(file_exists(public_path($doc_path))){
                    unlink(public_path($doc_path));
                }
                $doc = $request->file('file');
                if($doc->move(public_path($destination), $file_path)){
                    if($assessment = Assessment::where('school_id', $school->id)->where('session', $session)->get()->first()){
                        $assessment->update([
                            'path' => $doc_path    
                        ]);
                    }else{
                        Assessment::create([
                            'school_id' => $school->id,
                            'session' => $session,
                            'path' => $doc_path
                        ]);
                    }
	            	flash('You have successfully saved your assessment for '.$session)->success();
	                return back(); 
	            }else{
	            	flash('Opps! we could not save your assessment. Please try again')->error();
	                return back(); 
	            }
            }else{
            	flash('Please attach doc file')->error();
            	return back();
            }
	    }elseif($request->type == 'delete'){
	        // delete if available
	        $destination = 'uploads/docs/'.$school->name.$school->id;
        	$file_path = $request->session.'.doc';
        	$doc_path = $destination.'/'.$file_path;
            if(file_exists(public_path($doc_path))){
                unlink(public_path($doc_path));
                if($assessment = Assessment::where('school_id', $school->id)->where('session', $session)->get()->first()){
                    $assessment->delete();
                }
            	flash('You have successfully deleted your assessment for '.$request->session)->success();
                return back(); 
            }else{
            	flash('Opps! we could not delete your assessment. Please try again')->error();
                return back(); 
            }  
	    }elseif($request->type == 'attach'){
	        if($request->hasfile('path')){
                $this->validate($request, [
                    'path' => 'required',
                    'path.*' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048'
                ]);
                foreach($request->file('path') as $image)
                {
                    $name = time().'.'.$image->getClientOriginalExtension();
                    $image->move(public_path('/uploads/docs/'.$school->name.$school->id.'/'.$request->session.'-images'), $name);  
                    $data[] = $name; 
                    AssessmentImage::create([
                        'assessment_id' => $request->assessment_id,
                        'path' => '/uploads/docs/'.$school->name.$school->id.'/'.$request->session.'-images/'.$name
                    ]);
                }
                return response()->json($data, 200);
            }else{
                return response()->json([], 400);
            }
	    }elseif($request->type == 'delete_image'){
	        if($img = AssessmentImage::find($request->id)){
	            $doc_path = public_path($img->path);
	            if(file_exists(public_path($doc_path))){
                    unlink(public_path($doc_path));
                }
                
                $img->delete();
                flash('Image deleted successfully');
                return back();
                
	        }else{
    	        flash('Image not found')->error();
                return back();
	        }
	    }else{
	        flash('Unknown action!')->error();
            return back();
	    }
	}
	
	public function annualAssetDocPreView($session){
        $user =  auth('admin')->user();
		$school = School::find($user->school_id);
	    return view('admin.annual-asset.doc-preview', compact('session', 'school', 'user'));
	}
	
	public function schoolSurvey($session){
	    $title = 'School Survey';
        $user =  auth('admin')->user();
		$school = School::find($user->school_id);
		$survey = SchoolSurvey::where('school_id', $school->id)->where('session', $session)->get()->first();
		
		if($survey){
	        return view('admin.survey', compact('title', 'school', 'user', 'survey', 'session'));
		}else{
	        return view('admin.survey', compact('title', 'school', 'user', 'session'));
		}
	}
    
    public function schoolSurveyView($session){
	    $title = 'School Survey Preview';
        $user =  auth('admin')->user();
		$school = School::find($user->school_id);
        $survey = SchoolSurvey::where('school_id', $school->id)->where('session', $session)->get()->first();
        
		if($survey){
	        return view('admin.survey-view', compact('title', 'school', 'user', 'survey', 'session'));
		}else{
	        return view('admin.survey-view', compact('title', 'school', 'user', 'session'));
		}
    }
	
	public function schoolSurveySave(Request $request){
        $user =  auth('admin')->user();
		$school = School::find($user->school_id);
		$survey = SchoolSurvey::where('school_id', $school->id)->where('session', $request->session)->get()->first();
		
		if($survey){
		    $survey->update($request->all());
		}else{
		    SchoolSurvey::create($request->all());
		}
		
		flash('Survey Updated')->success();
		return back();
	}
}