<?php

namespace App\Exceptions;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Session\TokenMismatchException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that should not be reported.
     *
     * @var array
     */
    protected $dontReport = [
        AuthorizationException::class,
        HttpException::class,
        ValidationException::class,
    ];

    /**
     * Report or log an exception.
     *
     * This is a great spot to send exceptions to Sentry, Bugsnag, etc.
     *
     * @param  \Exception  $e
     * @return void
     */
    public function report(Exception $e)
    {
        parent::report($e);
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Exception  $e
     * @return \Illuminate\Http\Response
     */
    public function render($request, Exception $e)
    {
        // overview exception
        if($request->is('overview-app') || $request->is('overview-app/*')){
            return view('overview-app.load-error');
        }
        
        // result exception
        if($request->is('result-app') || $request->is('result-app/*')){
            return parent::render($request, $e);
            // return view('result-app.load-error');
        }
        
        if($e instanceof ModelNotFoundException){
            abort(404);
        }elseif($this->isHttpException($e)){
            return $this->renderHttpException($e);
        }elseif($e instanceof TokenMismatchException){
            flash('Sorry, You session has expired, but it has been renewed again')->error();
            
            return redirect()->back()->withInput($request->except('_token'));
        }else{
            return parent::render($request, $e);
        }
    }
}
