<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Classes extends Model
{
    protected $table = 'classes';

    protected $fillable = ['class_name', 'school_id'];

    public static $rules = [
    	'class_name' => 'required'
    ];

    public function present_classes_for_display($classes){
        $classes_options = '';
        foreach($classes as $class){
             $classes_options .= '<div class="item" data-value="'.$class->id.'">'.$class->class_name.'</div>';
         }
         return $classes_options;
    }

    public function class_arms(){

    	return $this->hasMany('App\ClassArms', 'class_id');

    }

    public function student(){

    	return $this->hasMany('App\Student', 'class_id');

    }

    
}
